CREATE DATABASE /*!32312 IF NOT EXISTS*/ `signage` /*!40100 DEFAULT CHARACTER SET utf8 */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `signage`;

--
-- データベース: `signage`
--

-- --------------------------------------------------------

--
-- テーブルの構造 `DeviceTbl`
--

CREATE TABLE `DeviceTbl` (
`num` int NOT NULL AUTO_INCREMENT COMMENT '番号（ユニーク）',
`device_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'デバイスID（ユニーク・建物OSから取得）',
`du_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT 'ユニークID（デバイスタイプ+デバイスID）',
`device_num` int DEFAULT NULL COMMENT 'デバイスの表示番号',
`tenant_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'デバイスが設置されているテナントID',
`field_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'フィールドID',
`name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'デバイス名',
`x_pos` int NOT NULL COMMENT 'デバイスのX座標',
`y_pos` int NOT NULL COMMENT 'デバイスのY座標',
`type` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'デバイス種別',
`status` int NOT NULL COMMENT '状態\r\n0：なし\r\n1：正常',
PRIMARY KEY (`num`),
KEY `device_id_index` (`device_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1439 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- テーブルの構造 `TenantTbl`
--
CREATE TABLE `TenantTbl` (
`num` int NOT NULL AUTO_INCREMENT COMMENT '番号（ユニーク）',
`id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'テナントID（ユニーク）',
`name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'テナント名',
`addr` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '拠点の住所',
`lat` double(8,6) NOT NULL COMMENT '緯度',
`lon` double(9,6) NOT NULL COMMENT '経度',
`status` tinyint NOT NULL COMMENT '状態\r\n0：なし\r\n1：正常',
PRIMARY KEY (`num`),
KEY `tenant_id_index` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='テナント情報テーブル';

-- --------------------------------------------------------
