CREATE DATABASE /*!32312 IF NOT EXISTS*/ `super_appli` /*!40100 DEFAULT CHARACTER SET utf8 */ /*!80016 DEFAULT ENCRYPTION='N' */;

USE `super_appli`;

--
-- データベース: `super_appli`
--

-- --------------------------------------------------------

--
-- テーブルの構造 `AdminTbl`
--

CREATE TABLE `AdminTbl` (
  `num` int NOT NULL COMMENT '番号（ユニーク）',
  `admin_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '管理者ID',
  `tenant_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '拠点名（テナント名）',
  `email` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'メールアドレス',
  `name` varchar(48) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '名前',
  `pass` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'パスワード',
  `authorize` int NOT NULL COMMENT '管理者権限',
  `last_login` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '最終ログインタイムスタンプ',
  `login_count` int NOT NULL DEFAULT '0' COMMENT 'ログイン回数',
  `error_count` int NOT NULL DEFAULT '0' COMMENT 'ログインエラー回数',
  `status` tinyint NOT NULL COMMENT 'アカウント状態\r\n0：なし\r\n1：正常'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='ユーザー情報テーブル';

-- --------------------------------------------------------

--
-- テーブルの構造 `APISettingTbl`
--

CREATE TABLE `APISettingTbl` (
  `num` int NOT NULL COMMENT '番号（ユニーク）',
  `tenant_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'テナントID（ユニーク）',
  `domein` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '第三者API接続用のドメイン',
  `key_grant_type` varchar(48) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '第三者API接続用のキータイプ',
  `username` varchar(11) NOT NULL COMMENT '第三者API接続用のユーザー名',
  `key_password` varchar(48) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '第三者API接続用のパスワード',
  `key_clientid` varchar(48) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '第三者API接続用のキークライアントID',
  `secret_key` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '第三者API接続用のシークレットコード',
  `status` tinyint NOT NULL COMMENT '状態\r\n0：なし\r\n1：正常'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='テナント情報テーブル';

-- --------------------------------------------------------

--
-- テーブルの構造 `AutoLoginTbl`
--

CREATE TABLE `AutoLoginTbl` (
  `num` int NOT NULL COMMENT '番号（ユニーク）',
  `user_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ユーザーID',
  `token` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `registrated_time` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='自動ログインテーブル';

-- --------------------------------------------------------

--
-- テーブルの構造 `CronCycle`
--

CREATE TABLE `CronCycle` (
  `num` int NOT NULL COMMENT '番号',
  `tenant_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'テナントID',
  `cycle_news` int NOT NULL COMMENT '定期実行周期（ニュース）',
  `cycle_weather` int NOT NULL COMMENT '定期実行周期（天気）',
  `cycle_device` int NOT NULL COMMENT '定期実行周期（デバイス）',
  `last-update` datetime NOT NULL COMMENT '最終更新タイムスタンプ'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='各ユーザーのウィジェット利用管理';

-- --------------------------------------------------------

--
-- テーブルの構造 `DeviceGroupTbl`
--

CREATE TABLE `DeviceGroupTbl` (
  `num` int NOT NULL COMMENT '番号（ユニーク）',
  `group_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'グループID',
  `field_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'フィールドID',
  `tenant_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '拠点ID',
  `group_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'デバイスグループ名',
  `belong_device` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'グループ所属デバイス',
  `x_pos` double(7,3) NOT NULL COMMENT 'フィールドのX座標',
  `y_pos` double(7,3) NOT NULL COMMENT 'フィールドのY座標',
  `width` double(7,3) NOT NULL COMMENT 'フィールドの横幅',
  `height` double(7,3) NOT NULL COMMENT 'フィールドの縦幅',
  `status` tinyint NOT NULL COMMENT '状態\r\n0：なし\r\n1：正常',
  `last-update` datetime NOT NULL COMMENT '最終更新タイムスタンプ'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='テナント情報テーブル';

-- --------------------------------------------------------

--
-- テーブルの構造 `FieldTbl`
--

CREATE TABLE `FieldTbl` (
  `num` int NOT NULL COMMENT '番号（ユニーク）',
  `field_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'フィールドID',
  `tenant_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '拠点ID',
  `field_name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'フィールド名',
  `belong_device` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'フィールド所属デバイス',
  `x_pos` double(7,3) NOT NULL COMMENT 'フィールドのX座標',
  `y_pos` double(7,3) NOT NULL COMMENT 'フィールドのY座標',
  `width` double(7,3) NOT NULL COMMENT 'フィールドの横幅',
  `height` double(7,3) NOT NULL COMMENT 'フィールドの縦幅',
  `status` tinyint NOT NULL COMMENT '状態\r\n0：なし\r\n1：正常',
  `last-update` datetime NOT NULL COMMENT '最終更新タイムスタンプ'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='テナント情報テーブル';

-- --------------------------------------------------------

--
-- テーブルの構造 `FileTbl`
--

CREATE TABLE `FileTbl` (
  `num` int NOT NULL COMMENT '番号',
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ファイルID（ユニーク）',
  `file_data` longblob NOT NULL COMMENT 'ファイルデータ（BLOB形式）',
  `type` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ファイル種別',
  `status` tinyint NOT NULL COMMENT 'ファイル状態 0：仮登録、1：正常'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- テーブルの構造 `TenantTbl`
--

CREATE TABLE `TenantTbl` (
  `num` int NOT NULL COMMENT '番号（ユニーク）',
  `id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'テナントID（ユニーク）',
  `name` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'テナント名',
  `addr` varchar(1000) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '拠点の住所',
  `lat` double(8,6) NOT NULL COMMENT '緯度',
  `lon` double(9,6) NOT NULL COMMENT '経度',
  `status` tinyint NOT NULL COMMENT '状態\r\n0：なし\r\n1：正常'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='テナント情報テーブル';

-- --------------------------------------------------------

--
-- テーブルの構造 `TenantWidgetControl`
--

CREATE TABLE `TenantWidgetControl` (
  `num` int NOT NULL COMMENT '番号',
  `tenant_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'テナントID',
  `flag_json` varchar(3000) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '各ウィジェット利用状態（シリアル化）',
  `last-update` datetime NOT NULL COMMENT '最終更新タイムスタンプ'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='各ユーザーのウィジェット利用管理';

-- --------------------------------------------------------

--
-- テーブルの構造 `UserTbl`
--

CREATE TABLE `UserTbl` (
  `num` int NOT NULL COMMENT '番号（ユニーク）',
  `user_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ユーザーID（ユニーク）',
  `tenant_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '拠点名（テナント名）',
  `uuid` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'UUID',
  `name` varchar(48) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '名前',
  `user_number` int NOT NULL COMMENT '社員番号',
  `department` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '役職',
  `organization` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '所属組織',
  `tag_id` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'タグID',
  `gender` int NOT NULL COMMENT '性別',
  `device_authorize` varchar(20000) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL COMMENT 'デバイス操作権限',
  `pass` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'パスワード',
  `last_login` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '最終ログインタイムスタンプ',
  `login_count` int NOT NULL DEFAULT '0' COMMENT 'ログイン回数',
  `error_count` int NOT NULL DEFAULT '0' COMMENT 'ログインエラー回数',
  `status` tinyint NOT NULL COMMENT 'アカウント状態\r\n0：なし\r\n1：正常'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='ユーザー情報テーブル';

-- --------------------------------------------------------

--
-- テーブルの構造 `UserWidgetControl`
--

CREATE TABLE `UserWidgetControl` (
  `num` int NOT NULL COMMENT '番号',
  `user_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ユーザーID',
  `flag_json` varchar(5000) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '各ウィジェット利用状態（シリアル化）',
  `last-update` datetime NOT NULL COMMENT '最終更新タイムスタンプ'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='各ユーザーのウィジェット利用管理';

-- --------------------------------------------------------

--
-- テーブルの構造 `WidgetSetting`
--

CREATE TABLE `WidgetSetting` (
  `num` int NOT NULL,
  `widget_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ウィジェットID（ユニーク）',
  `setting_json` json NOT NULL COMMENT '設定情報JSON'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- テーブルの構造 `WidgetTbl`
--

CREATE TABLE `WidgetTbl` (
  `num` int NOT NULL COMMENT '番号',
  `widget_id` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ウィジェットID',
  `sub_widget` int NOT NULL COMMENT 'サブウィジェットかどうかのフラグ',
  `widget_name` varchar(256) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ウィジェット名称',
  `widget_type` varchar(48) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ウィジェット種別',
  `widget_info` varchar(512) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ウィジェット説明',
  `registrated_time` datetime NOT NULL COMMENT '登録日時'
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='ウィジェット管理テーブル';

-- --------------------------------------------------------

--
-- テーブルの構造 `DeviceFunctionTbl`
-- AUTO_INCREMENTはファンクションの数分増えていく
--

CREATE TABLE `DeviceFunctionTbl` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `device_type` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'デバイスタイプ',
  `device_function` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'デバイスのファンクション',
  `description` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '情報',
  `unit` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT '単位',
  `value_type` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci COMMENT 'htmlのタイプ
  ・設定できるファンクションの場合
    checkbox: チェックボックスでの表示
    selectbox: セレクトボックスでの表示
    range: 範囲コントロールでの表示
  ・設定できないファンクションの場合
    status: 状態表示
    measure: 計測・計量表示
  上記以外はnullにする。(Device.Info.Descriptionなど)',
  `device_values` json COMMENT '数値で表現される状態の判別を行うためのJSON
  EX.
  JSON_OBJECT("0","OFF","1","ON")
  JSON_OBJECT("0","冷房","1","暖房","2","自動")',
  `step_value` float COMMENT '数値を設定する時のstep値(設定した値分ずつクリックするたびに上がる)',
  `visibility` tinyint(1) NOT NULL COMMENT '表示可否
  0: 非表示
  1: 表示',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='DeviceFunctionTbl';

-- --------------------------------------------------------

--
-- テーブルの構造 `DeviceAlarmTbl`
--

CREATE TABLE `DeviceAlarmTbl` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `devicefunctiontbl_id` int NOT NULL COMMENT 'デバイスファンクションテーブルのID',
  `device_id` int NOT NULL COMMENT 'デバイスID',
  `alarm_type` tinyint(1) NOT NULL COMMENT '警報種別
    0: 軽警報
    1: 中警報
    2: 重警報',
  PRIMARY KEY (`id`),
  FOREIGN KEY `device_function_index` (`devicefunctiontbl_id`) REFERENCES `DeviceFunctionTbl` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='DeviceAlarmTbl';

-- --------------------------------------------------------

--
-- テーブルの構造 `NotificationTbl`
--

CREATE TABLE `NotificationTbl` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '番号（ユニーク）',
  `tenant_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'テナントID',
  `user_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ユーザID',
  `title` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'タイトル',
  `description` varchar(2000) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '内容',
  `datetime` datetime NOT NULL COMMENT '登録日時',
  `deletetime` datetime NOT NULL COMMENT '削除日時',
  PRIMARY KEY (`id`),
  FOREIGN KEY `tenant_id_index` (`tenant_id`) REFERENCES `TenantTbl` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY `user_id_index` (`user_id`) REFERENCES `UserTbl` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='共通お知らせテーブル';

-- --------------------------------------------------------

--
-- テーブルの構造 `NumberPlateNotificationTbl`
--
CREATE TABLE `NumberPlateNotificationTbl` (
  `id` int NOT NULL AUTO_INCREMENT COMMENT '番号（ユニーク）',
  `tenant_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'テナントID',
  `user_id` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'ユーザID',
  `title` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT 'タイトル',
  `description` varchar(2000) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '内容',
  `datetime` datetime NOT NULL COMMENT '登録日時',
  `deletetime` datetime NOT NULL COMMENT '削除日時',
  PRIMARY KEY (`id`),
  FOREIGN KEY `tenant_id_index` (`tenant_id`) REFERENCES `TenantTbl` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  FOREIGN KEY `user_id_index` (`user_id`) REFERENCES `UserTbl` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='ナンバープレートお知らせテーブル';

-- --------------------------------------------------------

--
-- ダンプしたテーブルのインデックス
--

--
-- テーブルのインデックス `AdminTbl`
--
ALTER TABLE `AdminTbl`
  ADD PRIMARY KEY (`num`),
  ADD KEY `user_id_index` (`admin_id`);

--
-- テーブルのインデックス `APISettingTbl`
--
ALTER TABLE `APISettingTbl`
  ADD PRIMARY KEY (`num`),
  ADD KEY `tenant_id_index` (`tenant_id`);

--
-- テーブルのインデックス `AutoLoginTbl`
--
ALTER TABLE `AutoLoginTbl`
  ADD PRIMARY KEY (`num`),
  ADD KEY `user_id_index` (`user_id`);

--
-- テーブルのインデックス `CronCycle`
--
ALTER TABLE `CronCycle`
  ADD PRIMARY KEY (`num`);

--
-- テーブルのインデックス `FieldTbl`
--
ALTER TABLE `FieldTbl`
  ADD PRIMARY KEY (`num`),
  ADD KEY `tenant_id_index` (`field_id`);

--
-- テーブルのインデックス `FileTbl`
--
ALTER TABLE `FileTbl`
  ADD PRIMARY KEY (`num`);

--
-- テーブルのインデックス `TenantTbl`
--
ALTER TABLE `TenantTbl`
  ADD PRIMARY KEY (`num`),
  ADD KEY `tenant_id_index` (`id`);

--
-- テーブルのインデックス `TenantWidgetControl`
--
ALTER TABLE `TenantWidgetControl`
  ADD PRIMARY KEY (`num`),
  ADD KEY `user_id_index` (`tenant_id`);

--
-- テーブルのインデックス `UserTbl`
--
ALTER TABLE `UserTbl`
  ADD PRIMARY KEY (`num`),
  ADD KEY `user_id_index` (`user_id`);

--
-- テーブルのインデックス `UserWidgetControl`
--
ALTER TABLE `UserWidgetControl`
  ADD PRIMARY KEY (`num`),
  ADD KEY `user_id_index` (`user_id`);

--
-- テーブルのインデックス `WidgetSetting`
--
ALTER TABLE `WidgetSetting`
  ADD PRIMARY KEY (`num`);

--
-- テーブルのインデックス `WidgetTbl`
--
ALTER TABLE `WidgetTbl`
  ADD PRIMARY KEY (`num`),
  ADD KEY `widget_id_index` (`widget_id`);

--
-- ダンプしたテーブルのAUTO_INCREMENT
--

--
-- テーブルのAUTO_INCREMENT `AdminTbl`
--
ALTER TABLE `AdminTbl`
  MODIFY `num` int NOT NULL AUTO_INCREMENT COMMENT '番号（ユニーク）', AUTO_INCREMENT=13;

--
-- テーブルのAUTO_INCREMENT `APISettingTbl`
--
ALTER TABLE `APISettingTbl`
  MODIFY `num` int NOT NULL AUTO_INCREMENT COMMENT '番号（ユニーク）', AUTO_INCREMENT=11;

--
-- テーブルのAUTO_INCREMENT `AutoLoginTbl`
--
ALTER TABLE `AutoLoginTbl`
  MODIFY `num` int NOT NULL AUTO_INCREMENT COMMENT '番号（ユニーク）', AUTO_INCREMENT=1604;

--
-- テーブルのAUTO_INCREMENT `CronCycle`
--
ALTER TABLE `CronCycle`
  MODIFY `num` int NOT NULL AUTO_INCREMENT COMMENT '番号';

--
-- テーブルのAUTO_INCREMENT `FieldTbl`
--
ALTER TABLE `FieldTbl`
  MODIFY `num` int NOT NULL AUTO_INCREMENT COMMENT '番号（ユニーク）', AUTO_INCREMENT=58;

--
-- テーブルのAUTO_INCREMENT `FileTbl`
--
ALTER TABLE `FileTbl`
  MODIFY `num` int NOT NULL AUTO_INCREMENT COMMENT '番号', AUTO_INCREMENT=33;

--
-- テーブルのAUTO_INCREMENT `TenantTbl`
--
ALTER TABLE `TenantTbl`
  MODIFY `num` int NOT NULL AUTO_INCREMENT COMMENT '番号（ユニーク）', AUTO_INCREMENT=14;

--
-- テーブルのAUTO_INCREMENT `TenantWidgetControl`
--
ALTER TABLE `TenantWidgetControl`
  MODIFY `num` int NOT NULL AUTO_INCREMENT COMMENT '番号', AUTO_INCREMENT=10;

--
-- テーブルのAUTO_INCREMENT `UserTbl`
--
ALTER TABLE `UserTbl`
  MODIFY `num` int NOT NULL AUTO_INCREMENT COMMENT '番号（ユニーク）', AUTO_INCREMENT=74;

--
-- テーブルのAUTO_INCREMENT `UserWidgetControl`
--
ALTER TABLE `UserWidgetControl`
  MODIFY `num` int NOT NULL AUTO_INCREMENT COMMENT '番号', AUTO_INCREMENT=40;

--
-- テーブルのAUTO_INCREMENT `WidgetSetting`
--
ALTER TABLE `WidgetSetting`
  MODIFY `num` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=27;

--
-- テーブルのAUTO_INCREMENT `WidgetTbl`
--
ALTER TABLE `WidgetTbl`
  MODIFY `num` int NOT NULL AUTO_INCREMENT COMMENT '番号', AUTO_INCREMENT=42;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
