<?php

require("core/construct.php");
require(CORE_PATH."functions.php");
require(CORE_PATH."session_check.php");

try{
        
    require_once(AD_MDL_PATH."model.php");
    $adMDL = new admModel($sdb, $link);
    
    require_once(SN_MDL_PATH."model.php");
    $sgMDL = new sngModel($sdb, $link);


    $POST = filterPost();

    if(!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest') {
        throw new Exception('not ajax');
    }
    
    $tenant_id = $POST['tenant'];
    
    
    $DeviceList_user = [];
    
    if($_SESSION['admin']['authorize'] == ACCOUNT_AUTHOR_OWNER){
        if($tenant_id != ""){
            $d_row = $sgMDL->GetDeviceTblByTenantID($tenant_id);
        }else{
//             $d_row = $sgMDL->GetDeviceTbl();
        }
    }else{
        
        
        $d_row = $sgMDL->GetDeviceTblByTenantID($tenant_id);
    }
    
    
    if($d_row){
        foreach($d_row as $dK => $dV){
            $DeviceList_user[$dV['du_id']]['name'] = $dV['name'];
            $DeviceList_user[$dV['du_id']]['id'] = $dV['device_id'];
            $DeviceList_user[$dV['du_id']]['f_id'] = $dV['field_id'];
            $DeviceList_user[$dV['du_id']]['type'] = $dV['type'];
            $DeviceList_user[$dV['du_id']]['t_id'] = $dV['tenant_id'];
        }
    }


$devicelist_dom = "";

foreach($DeviceList_user as $dvc_id => $dvc_data){

$devicelist_dom .= <<<EOM
            <tr>
                <td>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" name="device_authorize[]" id="DeviceAuth_{$dvc_id}" value="{$dvc_id}">
                    </div>
                </td>
                <td><label class="form-check-label" for="DeviceAuth_{$dvc_id}">{$dvc_data['name']}</label></td>
                <td>{$dvc_data['f_id']}</td>
                <td>{$dvc_data['type']}</td>
                <td>{$dvc_data['t_id']}</td>
            </tr>
EOM;

}

$dom = <<<EOM
<div class="table-wrapper">
    
    <div class="row">

        <div class="col-12 mt10">
            <button id="AllCheckBtn" class="btn btn-sm btn-light btn-outline-secondary" type="button">すべて選択</button>
            <button id="AllUnCheckBtn" class="btn btn-sm btn-light btn-outline-secondary" type="button">すべて選択解除</button>
        </div>
    </div>
    <table id="DeviceAuthorizeListTable" class="table d-none">
        <thead class="thead-dark">
            <tr>
                <th class="th_chk" scope="col">チェック</th>
                <th class="th_dname" scope="col">デバイス名</th>
                <th class="th_flr" scope="col">エリア</th>
                <th class="th_dtype" scope="col">デバイス種別</th>
                <th class="th_tenant" scope="col">テナント</th>
            </tr>
        </thead>
        <tbody>
{$devicelist_dom}
        </tbody>
    </table>
</div>
EOM;


    $ret = [
        'state' => 'success',
        'html' => $dom,
    ];

    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);


}catch(Exception $e){

    $ret = [
        'state' => 'error',
        'msg' => $e->getMessage(),
    ];

    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
}
?>