<?php

require("core/construct.php");
require(CORE_PATH."functions.php");
require(CORE_PATH."session_check.php");


try{
    require_once(AD_MDL_PATH."model.php");
    $adMDL = new admModel($sdb, $link);

    require_once(SN_MDL_PATH."model.php");
    $sgMDL = new sngModel($sdb, $link);

    $POST = filterPost();

    if(!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest') {
        throw new Exception('not ajax');
    }

    $UserList = [];

    $tenant_id = $POST['tenant'];
    if($tenant_id != ""){
        $u_row = $adMDL->GetUserListByTenantIDList($tenant_id);
        if($u_row){
            foreach($u_row as $uK => $uV){
                $UserList[$uV['user_id']]['name'] = $uV['name'];
                $UserList[$uV['user_id']]['user_id'] = $uV['user_id'];
                $UserList[$uV['user_id']]['tenant_id'] = $uV['tenant_id'];
                $UserList[$uV['user_id']]['tenant_name'] = $uV['tenant_name'];
            }
        }
    }

$userlist_dom = "";

foreach($UserList as $usr_id => $usr_data){

$userlist_dom .= <<<EOM
            <tr>
                <td>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="checkbox" name="user_table[]" id="TenantList_{$usr_id}" value="{$usr_data['tenant_id']}:{$usr_data['user_id']}">
                    </div>
                </td>
                <td>{$usr_data['tenant_name']}</td>
                <td>{$usr_data['user_id']}</td>
                <td>{$usr_data['name']}</td>
                <td style="display:none;">{$usr_data['tenant_id']}</td>
            </tr>
EOM;
}

$dom = <<<EOM
<div class="table-wrapper">
    
    <div class="row">

        <div class="col-12 mt10">
            <button id="UserAllCheckBtn" class="user btn btn-sm btn-light btn-outline-secondary" type="button">すべて選択</button>
            <button id="UserAllUnCheckBtn" class="user btn btn-sm btn-light btn-outline-secondary" type="button">すべて選択解除</button>
        </div>
    </div>
    <table id="NotificationUserListTable" class="table d-none">
        <thead class="thead-dark">
            <tr>
                <th class="th_chk" scope="col">チェック</th>
                <th class="th_tname" scope="col">テナント名</th>
                <th class="th_yid" scope="col">ユーザーID</th>
                <th class="th_yname" scope="col">ユーザー名</th>
                <th hidden class="th_yname" scope="col">テナントID</th>
            </tr>
        </thead>
        <tbody>
{$userlist_dom}
        </tbody>
    </table>
</div>
EOM;

    $ret = [
        'state' => 'success',
        'html' => $dom,
    ];
    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
}catch(Exception $e){
    $ret = [
        'state' => 'error',
        'msg' => $e->getMessage(),
    ];
    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
}

?>
