<?
/**
 * テナント管理画面
 */
require("core/construct.php");

require(CORE_PATH."basic.php");
require(CORE_PATH."functions.php");
require(CORE_PATH."session_check.php");
require(CORE_PATH."authorize.php");
require_once(__DIR__."/util/utils.php");


//権限チェック
if(!in_array($Authorize, [ACCOUNT_AUTHOR_OWNER])){
    header( 'Location: ' . 'no_authorize.php');
    exit;
}

require(AD_MDL_PATH."model.php");
$adMDL = new admModel($sdb, $link);

require_once(SN_MDL_PATH."model.php");
$sgMDL = new sngModel($sdb, $link);

require_once(SP_MDL_PATH."model.php");
$sapMDL = new sappModel($sdb, $link);

$TenantList = $adMDL->GetTenantList();
$APIList = $adMDL->GetAPISettingList();
// var_dump($APIList);exit;

$page = "api.php";

$GET = filterGet();
$POST = filterPost();

$isEdit = False;
$isRegist = False;

$login_user = $_SESSION['admin']['admin_id'];

try{


    if(isset($GET['m']))
    {
        $mes = GetMsgDecode($GET['m']);
    }

    if(isset($_GET['c']))
    {

        switch($_GET['c'])
        {
            case 'n':
                
                $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'API設定情報登録フォーム'));
                $isRegist = True;
                break;

            case 'regist':

                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }

                $APIInfo = $adMDL->GetAPISettingData($POST['tenant_id']);
                if($APIInfo) throw new Exception("指定されたテナントのAPI設定情報は既に登録されています。");

                if(trim($POST['domein']) === "") throw new Exception("API接続用ドメインを入力してください。");
//                 if(preg_match('/^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])$/', $POST['domein']) == 0) throw new Exception("IP形式で入力してください。");

                if(trim($POST['key_grant_type']) === "") throw new Exception("API接続用キータイプを入力してください。");
                if(mb_strlen($POST['key_grant_type']) > 48) throw new Exception("API接続用キータイプは48文字以内です。");

                if(trim($POST['username']) === "") throw new Exception("API接続用ユーザーネームを入力してください。");
                if(preg_match('/^[0-9]{1,11}$/', $POST['username']) == 0) throw new Exception("API接続用ユーザーネームは整数でのみ入力可能です。");

                if(trim($POST['key_password']) === "") throw new Exception("API接続用パスワードを入力してください。");
//                 if(preg_match('/^[a-zA-Z0-9_]+$/', $POST['key_password']) == 0) throw new Exception("API接続用パスワードは半角英数字と「_」（アンダーバー）でのみ入力可能です。");

                if(trim($POST['key_clientid']) === "") throw new Exception("API接続用キークライアントIDを入力してください。");
                if(preg_match('/^[a-zA-Z0-9_]+$/', $POST['key_clientid']) == 0) throw new Exception("API接続用キークライアントIDは半角英数字と「_」（アンダーバー）でのみ入力可能です。");

                if(trim($POST['secret_key']) === "") throw new Exception("API接続用シークレットコードを入力してください。");
                if(preg_match('/^[a-zA-Z0-9-]+$/', $POST['secret_key']) == 0) throw new Exception("API接続用シークレットコードは半角英数字と「-」（ハイフン）でのみ入力可能です。");


                $prm = [
                    'tenant_id' => $POST['tenant_id'],
                    'domein' => $POST['domein'],
                    'key_grant_type' => $POST['key_grant_type'],
                    'username' => $POST['username'],
                    'key_password' => $POST['key_password'],
                    'key_clientid' => $POST['key_clientid'],
                    'secret_key' => $POST['secret_key'],
                ];

                $ins_ret = $adMDL->InsertAPISettingData($prm);
                if(!$ins_ret) throw new Exception("API設定情報の登録が失敗しました。");

                $mes = GetMsgEncode("API設定情報を登録しました。");
                $log_data = $prm;
                $log_data['key_password'] = '******';
                $log_data['secret_key'] = '******';
                $log->info("Successful API settings registration.",array('file' => __FILE__, 'userId' => $login_user, 'data' => $log_data));
                header( 'Location: ' . $page.'?m='.$mes);
                exit;

                break;

            case 'e':
                if(!isset($GET['id'])) throw new Exception("テナントIDが指定されていません。");

                $edit_id = $GET['id'];

                $APIInfo = $adMDL->GetAPISettingData($edit_id);
                if(!$APIInfo) throw new Exception("指定されたテナントのAPI設定は存在しません。");

                $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'API設定情報編集フォーム', 'editId' => $edit_id));
                $isEdit = True;
                break;

            case 'edit':

                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }

                if(!isset($GET['id'])) throw new Exception("テナントIDが指定されていません。");

                $edit_id = $GET['id'];

                $APIInfo = $adMDL->GetAPISettingData($edit_id);
                if(!$APIInfo) throw new Exception("指定されたテナントのAPI設定は存在しません。");


                if(trim($POST['domein']) === "") throw new Exception("API接続用ドメインを入力してください。");
//                 if(preg_match('/^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])$/', $POST['domein']) == 0) throw new Exception("IP形式で入力してください。");

                if(trim($POST['key_grant_type']) === "") throw new Exception("API接続用キータイプを入力してください。");
                if(mb_strlen($POST['key_grant_type']) > 48) throw new Exception("API接続用キータイプは48文字以内です。");

                if(trim($POST['username']) === "") throw new Exception("API接続用ユーザーネームを入力してください。");
                if(preg_match('/^[0-9]{1,11}$/', $POST['username']) == 0) throw new Exception("API接続用ユーザーネームは整数でのみ入力可能です。");

                if(trim($POST['key_password']) === "") throw new Exception("API接続用パスワードを入力してください。");
//                 if(preg_match('/^[a-zA-Z0-9_]+$/', $POST['key_password']) == 0) throw new Exception("API接続用パスワードは半角英数字と「_」（アンダーバー）でのみ入力可能です。");

                if(trim($POST['key_clientid']) === "") throw new Exception("API接続用キークライアントIDを入力してください。");
                if(preg_match('/^[a-zA-Z0-9_]+$/', $POST['key_clientid']) == 0) throw new Exception("API接続用キークライアントIDは半角英数字と「_」（アンダーバー）でのみ入力可能です。");

                if(trim($POST['secret_key']) === "") throw new Exception("API接続用シークレットコードを入力してください。");
                if(preg_match('/^[a-zA-Z0-9-]+$/', $POST['secret_key']) == 0) throw new Exception("API接続用シークレットコードは半角英数字と「-」（ハイフン）でのみ入力可能です。");

                $prm = [
                    'tenant_id' => $edit_id,
                    'domein' => $POST['domein'],
                    'key_grant_type' => $POST['key_grant_type'],
                    'username' => $POST['username'],
                    'key_password' => $POST['key_password'],
                    'key_clientid' => $POST['key_clientid'],
                    'secret_key' => $POST['secret_key'],
                ];

                $up_ret = $adMDL->UpdateAPISettingData($prm);
                if(!$up_ret) throw new Exception("API設定情報の更新が失敗しました。");

                $mes = GetMsgEncode("API設定テナント情報を更新しました。");
                $log_data = $prm;
                $log_data['key_password'] = '******';
                $log_data['secret_key'] = '******';
                $log->info("Successful API settings update.",array('file' => __FILE__, 'userId' => $login_user, 'data' => $log_data));
                header( 'Location: ' . $page.'?m='.$mes);
                exit;

                break;

            case 'd':
                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }

                if(!isset($POST['id'])) throw new Exception("テナントIDが指定されていません。");

                $delete_id = $POST['id'];

                $del_ret = $adMDL->DeleteAPISettingData($delete_id);
                if(!$del_ret) throw new Exception("API設定情報の削除に失敗しました。");

                $mes = GetMsgEncode("API設定情報を削除しました。");
                $log->info("Successful API settings delete.",array('file' => __FILE__, 'userId' => $login_user, 'deleteId' => $delete_id));
                header( 'Location: ' . $page.'?m='.$mes);
                exit;

                break;
        }
    } else {
        $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'API設定一覧リスト'));
    }
}catch(Exception $e){
    $mes = GetMsgEncode($e->getMessage());
    // 確認
    $log->info($e);
    $log->info("Failed to API operation.", array('file' => __FILE__, 'userId' => $login_user, 'message' => $e->getMessage()));
    header( 'Location: ' . $page.'?m='.$mes.'&err');
    exit;
}

// var_dump($DeviceList);

$msg_stt = (isset($GET['err']))? "danger" : "success";
$message_tag = ($mes != '')?'<div class="alert alert-'.$msg_stt.'" role="alert">'.$mes.'</div>':'';

$required_tag = '<span class="badge badge-danger">必須</span>';
$page_title = "管理画面　API設定情報管理";

$onetime_token = createToken();

include(PARTS_PATH."header.php");

?>
    <body>
        <div id="Wrap">

        <? include(PARTS_PATH.'header-nav.php'); ?>
            <div class="wrapper">

                <? include(PARTS_PATH.'sidemenu.php'); ?>
                <main class="">

                    <div class="container grid">

                        <nav class="page-header">
                            <div class="container-fluid">
                                <div class="navbar-wrapper">
                                    <h2><span class="svg-wrap mr10"><svg class="img-fluid"><use xlink:href="./asset/img/marker.svg#Marker"></use></svg></span>API設定情報管理</h2>
                                </div>
                            </div>
                        </nav>
                    
                        <?=$message_tag ?>

                        <?php if($isEdit): ?>

                        <section id="EditAPISetting" class="page-contents">
                            <div><h3>API設定情報編集フォーム</h3></div>
                            <div class="card-wrapper">
                                <form action="<?=$page ?>?c=edit&id=<?=h($edit_id) ?>" method="POST">
                                    <input type="hidden" name="one_time_token" value="<?=$onetime_token?>"/>


                                    <div class="form-group row">
                                        <div class="col-3">登録テナント</div>

                                        <div class="col-5 plr0">
                                        <?php
                                        $t_index = getHashKey($TenantList, 'id', $APIInfo['tenant_id']);
//                                      echo $TenantList[$t_index]['name'].' ('.$APIInfo['tenant_id'].')';
//                                      echo $TenantList[$t_index]['name'];
                                        echo $APIInfo['tenant_id'];
                                        ?>
                                        </div>

                                        <div class="d-inline-block col-4"></div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">API接続用ドメイン <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="domein" id="Domein" placeholder="ドメイン" value="<?=h($APIInfo['domein']) ?>" required/>
                                        <div class="d-inline-block col-4">API接続に使用するドメインを入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">API接続用キータイプ <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="key_grant_type" id="KeyGrantType" placeholder="キータイプ名" value="<?=h($APIInfo['key_grant_type']) ?>" required/>
                                        <div class="d-inline-block col-4">API接続に使用するキータイプ名を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">API接続用ユーザー名 <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="username" id="UserName" placeholder="ユーザー名" value="<?=h($APIInfo['username']) ?>" required/>
                                        <div class="d-inline-block col-4">API接続に使用するユーザー名を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">API接続用パスワード <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="key_password" id="KeyPassword" placeholder="パスワード" value="<?=h($APIInfo['key_password']) ?>" required/>
                                        <div class="d-inline-block col-4">API接続に使用するパスワードを入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">API接続用キークライアントID <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="key_clientid" id="KeyClient" placeholder="キークライアントID" value="<?=h($APIInfo['key_clientid']) ?>" required/>
                                        <div class="d-inline-block col-4">API接続に使用するキークライアントIDを入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">API接続用シークレットキー <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="secret_key" id="SecretKey" placeholder="シークレットキー" value="<?=h($APIInfo['secret_key']) ?>" required/>
                                        <div class="d-inline-block col-4">API接続に使用するシークレットキーを入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="tcenter">
                                        <button type="submit" class="btn btn-primary">更新</button>
                                        <a href="<?=$page ?>" class="btn btn-default btn-outline-dark">キャンセル</a>
                                    </div>

                                </form>
                            </div>
                        </section>


                        <?php elseif($isRegist): ?>


                        <section id="RegistAPISetting" class="page-contents">
                            <div><h3>API設定情報登録フォーム</h3></div>
                            <div class="card-wrapper">
                                <form action="<?=$page ?>?c=regist" method="POST">
                                    <input type="hidden" name="one_time_token" value="<?=$onetime_token?>"/>


                                    <div class="form-group row">
                                        <div class="col-3">登録テナント <?=$required_tag ?></div>

                                        <div class="col-5 plr0">
                                        <?php if($TenantList): ?>
                                        <select name="tenant_id" id="TenantID" class="form-control">
                                            <?php foreach($TenantList as $tlK => $tlV):
                                            $t_selected = ($APIInfo['tenant_id'] == $tlV['id'])?"selected":""; ?>
                                                <option value="<?=h($tlV['id']) ?>" <?=$t_selected ?>><?=h($tlV['name']) ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <?php else: ?>

                                        ※テナントが登録されていません

                                        <?php endif; ?>
                                        </div>

                                        <div class="d-inline-block col-4">APIを設定するテナントを選択してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">API接続用ドメイン <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="domein" id="Domein" placeholder="ドメイン" value="" required/>
                                        <div class="d-inline-block col-4">API接続に使用するドメインを入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">API接続用キータイプ <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="key_grant_type" id="KeyGrantType" placeholder="キータイプ名" value="" required/>
                                        <div class="d-inline-block col-4">API接続に使用するキータイプ名を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">API接続用ユーザー名 <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="username" id="UserName" placeholder="ユーザー名" value="" required/>
                                        <div class="d-inline-block col-4">API接続に使用するユーザー名を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">API接続用パスワード <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="key_password" id="KeyPassword" placeholder="パスワード" value="" required/>
                                        <div class="d-inline-block col-4">API接続に使用するパスワードを入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">API接続用キークライアントID <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="key_clientid" id="KeyClient" placeholder="キークライアントID" value="" required/>
                                        <div class="d-inline-block col-4">API接続に使用するキークライアントIDを入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">API接続用シークレットキー <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="secret_key" id="SecretKey" placeholder="シークレットキー" value="" required/>
                                        <div class="d-inline-block col-4">API接続に使用するシークレットキーを入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="tcenter">
                                        <button type="submit" class="btn btn-primary">登録</button>
                                        <a href="<?=$page ?>" class="btn btn-default btn-outline-dark">キャンセル</a>
                                    </div>

                                </form>
                            </div>
                        </section>

                        <?php else: ?>

                        <section id="APIManage" class="page-contents">
                            <div><h3>API設定一覧リスト</h3></div>
                            <div class="card-wrapper">
                                <div class="adduser-wrapper">
                                    <a href="<?=$page ?>?c=n" class="btn btn-primary btn-sm">新規API設定</a>
                                </div>
                                <div class="table-wrapper">
                                    <table id="APISettingListTable" class="table">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th class="th_num" scope="col">#</th>
                                                <th class="th_tenantid" scope="col">テナントID</th>
                                                <th class="th_domein" scope="col">ドメイン</th>
                                                <th class="th_granttype" scope="col">キータイプ</th>
                                                <th class="th_username" scope="col">ユーザー名</th>
                                                <th class="th_keypass" scope="col">パスワード</th>
                                                <th class="th_keycliid" scope="col">キークライアントID</th>
                                                <th class="th_secretkey" scope="col">シークレットコード</th>
                                                <th class="th_status" scope="col">ステータス</th>
                                                <th class="th_control" scope="col">操作</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <?php foreach($APIList as $aplK => $aplV):
                                        switch($aplV['status']){
                                            case ACCOUNT_STATUS_LOCK:
                                                $status = "ロック";
                                                break;
                                            case ACCOUNT_STATUS_OK:
                                                $status = "通常";
                                                break;
                                        }
                                        ?>
                                            <tr>
                                                <td><?=h($aplV['num']) ?></td>
                                                <td><?=h($aplV['tenant_id']) ?></td>
                                                <td><?=h($aplV['domein']) ?></td>
                                                <td><?=h($aplV['key_grant_type']) ?></td>
                                                <td><?=h($aplV['username']) ?></td>
                                                <td><?=h($aplV['key_password']) ?></td>
                                                <td><?=h($aplV['key_clientid']) ?></td>
                                                <td><?=h($aplV['secret_key']) ?></td>
                                                <td><?=$status ?></td>
                                                <td>
                                                    <a href="<?=$page ?>?c=e&id=<?=h($aplV['tenant_id']) ?>" class="btn btn-sm btn-primary">編集</a>
                                                    <button class="btn btn-sm btn-danger" data-toggle="modal" data-target="#modal-tenantdelete" data-whatever="<?=$aplV['tenant_id']?>">削除</button>
                                                </td>
                                            </tr>
                                        <?php endforeach;?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                        </section>

                        <?php endif; ?>
                        
                    </div>
                </main>
            </div>
        <? //include(PARTS_PATH.'footer.php'); ?>
        </div>
    </body>
    <!-- /container -->


    <!-- モーダル　テナント情報削除 -->
    <div class="modal fade" id="modal-tenantdelete" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-label">テナント情報削除</h4>
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>このテナント情報を削除しますか？</p>
                    <form id="user_delete" action="<?=$page?>?c=d" method="post">
                        <input type="hidden" name="one_time_token" value="<?=$onetime_token ?>"/>
                        <div class="form-group">
                            <label for="recipient-name" class="form-control-label">テナントID:</label>
                            <input type="text" class="form-control" id="DeleteTenantID" name="id" readonly="readonly" required>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-danger">削除する</button>
                            <button type="cancel" class="btn btn-default btn-outline-dark" data-dismiss="modal">中止</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <script>
        $(function(){

            $('#modal-tenantdelete').on('show.bs.modal', function(event) {
                var recipient = $(event.relatedTarget).data('whatever');
                $(this).find('.modal-body #DeleteTenantID').val(recipient);
            });


            // datatableの設定を変更
            $("#APISettingListTable").DataTable({
                searching: false,
                info: false,
                lengthChange: false,
                columnDefs: [
                      { "targets": 0, "width": '5%'},
                      { "targets": 1, "width": '10%'},
                      { "targets": 2, "width": '13%'},
                      { "targets": 3, "width": '11%'},
                      { "targets": 4, "width": '11%'},
                      { "targets": 5, "width": '12%'},
                      { "targets": 6, "width": '10%'},
                      { "targets": 7, "width": '10%'},
                      { "targets": 8, "width": '10%'},
                      { "targets": 9, "width": '18%', "orderable": false},
//                    { "targets": 7, "width": '18%',"orderable": false},
                    ],
            });

        });
    </script>

</html>