/**
 * ユーザー管理画面
 */

// チェックされたテナントからユーザ情報取得
function changeTenantID(){
	const elements = document.getElementsByName("TenantList");
	let tenant_check_list = [];
	for (let i=0; i<elements.length; i++){
		if (elements[i].checked){
			tenant_check_list.push(elements[i].value);
		}
	}
	ajax_UserTable(tenant_check_list);
}

// ユーザリスト変更
function ajax_UserTable(tenant_list){
	var data = new Object();
	data.tenant = tenant_list;
	$.ajax({
		url: 'ajax_notificationtable.php',
		type: 'POST',
		data: data,
	}).done(function(result) {
		// console.log(result);
		if (result.state == 'success'){
			$('#NotificationUserListTable').dataTable().fnDestroy();
			$('#AjaxNotificationWrap').html(result.html);
			$('#NotificationUserListTable').removeClass('d-none');
			$("#NotificationUserListTable").DataTable({
				order: [[1, 'asc'],[2, 'asc']],
				searching: false,
				info: false,
				lengthChange: false,
				paging: false,
				scrollX: false,
				scrollY: "50vh",
				columnDefs: [
					{ "targets": 0, "width": '20%', "orderable": false},
					{ "targets": 1, "width": '30%'},
					{ "targets": 2, "width": '25%'},
					{ "targets": 3, "width": '30%'},
				],
			});
		} else {
			alert('ユーザーの読み込みに失敗しました。');
		}
	}).fail(function() {
		alert('ユーザーの読み込みに失敗しました。');
	}).always(function(result) {

	});
}

// 特殊文字確認
function removeEmoji(register_text) {
	var ranges = [
		'\ud83c[\udf00-\udfff]',
		'\ud83d[\udc00-\ude4f]',
		'\ud83d[\ude80-\udeff]',
		'\ud7c9[\ude00-\udeff]',
		'[\u2600-\u27BF]'
	];
	before_conversion_text = register_text;
	var reg = new RegExp(ranges.join('|'), 'g');
	after_conversion_text = register_text.replace(reg, '');
	if(before_conversion_text != after_conversion_text){
		return true;
	}
	return false;
}

// Base64エンコード
function Base64Encode(text) {
	let utf8str = String.fromCharCode.apply(null, new TextEncoder().encode(text));
	return btoa(utf8str);
}

// URLエンコード
function urlEncode(base64_text) {
	return encodeURIComponent(base64_text);
}

$(function(){
		// お知らせ新規登録
		$('#FormNotificationRegist').submit(function(){
			let Form = new Object();
			Form.registtitle = $(this).find('#RegistTitle');
			Form.registdescription = $(this).find('#RegistDescription');
			var datepick = $(this).find('#datepicker').val();
			var timePick = $(this).find('#timePicker').val();
			// バリデーションチェック
			if(Form.registtitle.val().trim().length == 0){
				alert('タイトルを入力してください。');
				return false;
			}
			if(Form.registtitle.val().length > 50){
				alert('入力可能なタイトルは50文字までです。');
				return false;
			}
			// 特殊文字を登録できないようにする
			if(removeEmoji(Form.registtitle.val())){
				alert('タイトルに特殊文字は使用できません。');
				return false;
			}
			if(Form.registdescription.val().trim().length == 0){
				alert('内容を入力してください。');
				return false;
			}
			if(Form.registdescription.val().length > 2000){
				alert('入力可能な内容は2000文字までです。');
				return false;
			}
			if(removeEmoji(Form.registdescription.val())){
				alert('内容に特殊文字は使用できません。');
				return false;
			}
			var deletedatetime = datepick + " " + timePick;
			if(deletedatetime.trim() != ""){
				// 過去の日時がチェック
				var date_now = new Date(Date.now());
				var date_register = new Date(deletedatetime);
				if(!(date_now < date_register)){
					alert('削除日時を現在日時より先の日時で入力してください。');
					return false;
				}
				if(deletedatetime.length < 15){
					alert('削除日時を入力してください。');
					return false;
				}
			}

			// テナントが１つも登録されていない場合の処理
			if(document.FormNotificationRegist.TenantList == undefined){
				alert("お知らせを登録できるテナントはありません。");
				return false;
			}
			// テナント名チェック確認
			// 選択されているか否かを判定する変数
			var flag_tenant = false;
			// チェックされたテナントが2個以上の時
			if(document.FormNotificationRegist.TenantList.length){
				for(var i = 0; i < document.FormNotificationRegist.TenantList.length; i++){
					// i番目のチェックボックスがチェックされているかを判定
					if(document.FormNotificationRegist.TenantList[i].checked){
						flag_tenant = true;
					}
				}
			}else{
			// チェックされたテナントが1個の時
				if(document.FormNotificationRegist.TenantList.checked){
					flag_tenant = true;
				}
			}
			// テナント名が選択されていない場合の処理
			if (!flag_tenant) {
				alert("テナント名が選択されていません。");
				return false;
			}
			
			// ユーザーが１つも登録されていない場合の処理
			if(document.getElementsByName("user_table[]").length == 0){
				alert("お知らせを登録できるユーザーはありません。");
				return false;
			}
			
			// ユーザ名チェック確認
			// 選択されているか否かを判定する変数
			var flag_user = false;
			
			if(document.getElementsByName("user_table[]").length > 0){
				for(var i = 0; i < document.getElementsByName("user_table[]").length; i++){
					// i番目のチェックボックスがチェックされているかを判定
					if(document.getElementsByName("user_table[]")[i].checked){
						flag_user = true;
					}
				}
			}
			// 何も選択されていない場合の処理
			if (!flag_user) {
				alert("ユーザー名が選択されていません。");
				return false;
			}
		});

		// datatableの設定を変更
		$("#NotificationListTable").DataTable({
			order: [[0, 'desc']],
			searching: false,
			info: false,
			lengthChange: false,
			columnDefs: [
				{ "targets": 0, "width": '5%'},
				{ "targets": 1, "width": '30%'},
				{ "targets": 2, "width": '48%'},
				{ "targets": 3, "width": '10%'},
				{ "targets": 4, "width": '7%'},
				],
		});

		// datatableの設定を変更
		$("#NotificationTenantListTable").DataTable({
			order:[1, 'asc'],
			searching: false,
			info: false,
			lengthChange: false,
			paging: false,
			scrollX: false,
			scrollY: "18vh",
			columnDefs: [
				{ "targets": 0, "width": '19%', "orderable": false},
				{ "targets": 1, "width": '81%'},
			],
		});

		// datatableの設定を変更
		$("#NotificationUserListTable").DataTable({
			searching: false,
			info: false,
			lengthChange: false,
			paging: false,
			scrollX: false,
			scrollY: "50vh",
			columnDefs: [
				{ "targets": 0, "width": '20%', "orderable": false},
				{ "targets": 1, "width": '30%'},
				{ "targets": 2, "width": '25%'},
				{ "targets": 3, "width": '30%'},
			],
		});

	$('#modal-notificationdelete').on('show.bs.modal', function(event){
		var recipient = $(event.relatedTarget).data('whatever');
		$(this).find('.modal-body #DeleteNotificationTitle').val(recipient);
		var id = $(event.relatedTarget).data('delid');
		$(this).find('.modal-body #DeleteNotificationID').val(id);
	});

	$('#modal-notificationdetail').on('show.bs.modal', function(event){
		var detailtitle = $(event.relatedTarget).data('title');
		$(this).find('.modal-body #DetailNotificationTitle').val(detailtitle);
		var detaildescription = $(event.relatedTarget).data('description');
		$(this).find('.modal-body #DetailNotificationDescription').val(detaildescription);
		var detaildeletetime = $(event.relatedTarget).data('deletetime');
		$(this).find('.modal-body #DetailNotificationDeletetime').val(detaildeletetime);
		var detailtenantname = $(event.relatedTarget).data('tenantname');
		$(this).find('.modal-body #DetailNotificationTenantname').val(detailtenantname);
		var detailuserid = $(event.relatedTarget).data('userid');
		$(this).find('.modal-body #DetailNotificationUserid').val(detailuserid);
		var detailusername = $(event.relatedTarget).data('username');
		$(this).find('.modal-body #DetailNotificationUsername').val(detailusername);
	});

	$('body').on('click', 'button#TenantAllCheckBtn', () =>{
		$('#NotificationTenantListTable tr td input:checkbox').each((i,v) =>{
			$(v).prop('checked', true);
		});
		changeTenantID();
	});

	$('body').on('click', 'button#TenantAllUnCheckBtn', () =>{
		$('#NotificationTenantListTable tr td input:checkbox').each((i,v) =>{
			$(v).prop('checked', false);
		});
		changeTenantID();
	});

	$('body').on('click', 'button#UserAllCheckBtn', () =>{
		$('#NotificationUserListTable tr td input:checkbox').each((i,v) =>{
			$(v).prop('checked', true);
		});
	});

	$('body').on('click', 'button#UserAllUnCheckBtn', () =>{
		$('#NotificationUserListTable tr td input:checkbox').each((i,v) =>{
			$(v).prop('checked', false);
		});
	});


	$('[name=TenantList]').on('change', function(i,e){
		changeTenantID();
	});

});
