/**
 * ユーザー管理画面
 */

// チェックされたテナントからユーザ情報取得
function changeTenantID(){
	const elements = document.getElementsByName("TenantList");
	let tenant_check_list = [];
	for (let i=0; i<elements.length; i++){
		if (elements[i].checked){
			tenant_check_list.push(elements[i].value);
		}
	}
	ajax_UserTable(tenant_check_list);
}

// ユーザリスト変更
function ajax_UserTable(tenant_list){
	var data = new Object();
	data.tenant = tenant_list;
	$.ajax({
		url: 'ajax_numberplatetable.php',
		type: 'POST',
		data: data,
	}).done(function(result) {
		if (result.state == 'success'){
			$('#NumberplateUserListTable').dataTable().fnDestroy();
			$('#AjaxNumberplateWrap').html(result.html);
			$('#NumberplateUserListTable').removeClass('d-none');
			$("#NumberplateUserListTable").DataTable({
				order: [[1, 'asc'],[2, 'asc']],
				searching: false,
				info: false,
				lengthChange: false,
				paging: false,
				scrollX: false,
				scrollY: "50vh",
				columnDefs: [
					{ "targets": 0, "width": '20%', "orderable": false},
					{ "targets": 1, "width": '30%'},
					{ "targets": 2, "width": '25%'},
					{ "targets": 3, "width": '30%'},
				],
			});
		} else {
			alert('ユーザーの読み込みに失敗しました。');
		}
	}).fail(function() {
		alert('ユーザーの読み込みに失敗しました。');
	}).always(function(result) {

	});
}

$(function(){
		// ナンバープレート新規登録
		$('#FormNumberplateRegist').submit(function(){
			let Form = new Object();
			Form.registnumber = $(this).find('#RegistNumber');
			// バリデーションチェック
			if(!(Form.registnumber.val().match(/^[0-9]+$/) && (Form.registnumber.val().length == 4))){
				alert('4文字の半角数字で入力してください。');
				return false;
			}

			// テナントが１つも登録されていない場合の処理
			if(document.FormNumberplateRegist.TenantList == undefined){
				alert("ナンバープレートを登録できるテナントはありません。");
				return false;
			}
			// テナント名チェック確認
			// 選択されているか否かを判定する変数
			var flag_tenant = false;
			// チェックされたテナントが2個以上の時
			if(document.FormNumberplateRegist.TenantList.length){
				for(var i = 0; i < document.FormNumberplateRegist.TenantList.length; i++){
					// i番目のチェックボックスがチェックされているかを判定
					if(document.FormNumberplateRegist.TenantList[i].checked){
						flag_tenant = true;
					}
				}
			}else{
			// チェックされたテナントが1個の時
				if(document.FormNumberplateRegist.TenantList.checked){
					flag_tenant = true;
				}
			}
			// テナント名が選択されていない場合の処理
			if (!flag_tenant) {
				alert("テナント名が選択されていません。");
				return false;
			}
			
			// ユーザーが１つも登録されていない場合の処理
			if(document.getElementsByName("user_table[]").length == 0){
				alert("ナンバープレートを登録できるユーザーはありません。");
				return false;
			}
			
			// ユーザ名チェック確認
			// 選択されているか否かを判定する変数
			var flag_user = false;
			
			if(document.getElementsByName("user_table[]").length > 0){
				for(var i = 0; i < document.getElementsByName("user_table[]").length; i++){
					// i番目のチェックボックスがチェックされているかを判定
					if(document.getElementsByName("user_table[]")[i].checked){
						flag_user = true;
					}
				}
			}
			// 何も選択されていない場合の処理
			if (!flag_user) {
				alert("ユーザー名が選択されていません。");
				return false;
			}
		});
		
		// datatableの設定を変更
		$("#NumberplateListTable").DataTable({
			order: [[0, 'desc']],
			searching: false,
			info: false,
			lengthChange: false,
			columnDefs: [
				{ "targets": 0, "width": '5%'},
				{ "targets": 1, "width": '20%'},
				{ "targets": 2, "width": '25%'},
				{ "targets": 3, "width": '25%'},
				{ "targets": 4, "width": '18%'},
				{ "targets": 5, "width": '7%'},
				],
		});

		// datatableの設定を変更
		$("#NumberplateCameraListTable").DataTable({
			order: [[0, 'desc']],
			searching: false,
			info: false,
			lengthChange: false,
			paging: false,
			columnDefs: [
				{ "targets": 0, "width": '5%'},
				{ "targets": 1, "width": '20%'},
				{ "targets": 2, "width": '18%'},
				{ "targets": 3, "width": '17%'},
				{ "targets": 4, "width": '20%'},
				{ "targets": 5, "width": '20%'},
				],
		});

		// datatableの設定を変更
		$("#NumberplateTenantListTable").DataTable({
			order:[1, 'asc'],
			searching: false,
			info: false,
			lengthChange: false,
			paging: false,
			scrollX: false,
			scrollY: "18vh",
			columnDefs: [
				{ "targets": 0, "width": '19%', "orderable": false},
				{ "targets": 1, "width": '81%'},
			],
		});

		// datatableの設定を変更
		$("#NumberplateUserListTable").DataTable({
			searching: false,
			info: false,
			lengthChange: false,
			paging: false,
			scrollX: false,
			scrollY: "50vh",
			columnDefs: [
				{ "targets": 0, "width": '20%', "orderable": false},
				{ "targets": 1, "width": '30%'},
				{ "targets": 2, "width": '25%'},
				{ "targets": 3, "width": '30%'},
			],
		});

	$('#modal-numberplatedelete').on('show.bs.modal', function(event){
		var delnumber = $(event.relatedTarget).data('delnumber');
		$(this).find('.modal-body #DeleteNumberplate').val(delnumber);
		var deluser = $(event.relatedTarget).data('deluser');
		$(this).find('.modal-body #DeleteNumberplateUser').val(deluser);
		var delid = $(event.relatedTarget).data('delid');
		$(this).find('.modal-body #DeleteNumberplateID').val(delid);
	});

	$('body').on('click', 'button#TenantAllCheckBtn', () =>{
		$('#NumberplateTenantListTable tr td input:checkbox').each((i,v) =>{
			$(v).prop('checked', true);
		});
		changeTenantID();
	});

	$('body').on('click', 'button#TenantAllUnCheckBtn', () =>{
		$('#NumberplateTenantListTable tr td input:checkbox').each((i,v) =>{
			$(v).prop('checked', false);
		});
		changeTenantID();
	});

	$('body').on('click', 'button#UserAllCheckBtn', () =>{
		$('#NumberplateUserListTable tr td input:checkbox').each((i,v) =>{
			$(v).prop('checked', true);
		});
	});

	$('body').on('click', 'button#UserAllUnCheckBtn', () =>{
		$('#NumberplateUserListTable tr td input:checkbox').each((i,v) =>{
			$(v).prop('checked', false);
		});
	});


	$('[name=TenantList]').on('change', function(i,e){
		changeTenantID();
	});

});
