/**
 * リアルタイム時刻表示
 */

$(function(){
	//1秒ごとに実行
	setInterval('showClock()',1000);
});

function showClock(){
	var nowTime = new Date(); //  現在日時を得る
	var nowYear = nowTime.getFullYear(); // 年を抜き出す
	var nowMonth = nowTime.getMonth(); // 月を抜き出す
	var nowDate = nowTime.getDate(); // 日を抜き出す
	var nowHour = nowTime.getHours(); // 時を抜き出す
	var nowMin  = nowTime.getMinutes(); // 分を抜き出す
	var nowSec  = nowTime.getSeconds(); // 秒を抜き出す
	nowMonth++;

	$('#NowDateTime').find('.ndt_years').text(zeroPadding(nowYear,4));
	$('#NowDateTime').find('.ndt_months').text(zeroPadding(nowMonth,2));
	$('#NowDateTime').find('.ndt_days').text(zeroPadding(nowDate,2));
	$('#NowDateTime').find('.ndt_hours').text(zeroPadding(nowHour,2));
	$('#NowDateTime').find('.ndt_minutes').text(zeroPadding(nowMin,2));
	$('#NowDateTime').find('.ndt_seconds').text(zeroPadding(nowSec,2));
}

function zeroPadding(num,length){
    return ('0000000000' + num).slice(-length);
}
