/**
 * ユーザー管理画面
 */

$(function(){

	
		//フォームバリデーション（新規登録）
        $('form#FormUserRegist').submit(function(){
            let Form = new Object();

        	Form.userid = $(this).find('#UserID');
        	Form.usernum = $(this).find('#UserNum');
        	Form.name = $(this).find('#Name');
        	Form.uuid = $(this).find('#UUID');
        	Form.organize = $(this).find('#Organization');
        	Form.department = $(this).find('#Department');
        	Form.password = $(this).find('#Password');
        	Form.confpass = $(this).find('#Confpass');
        	Form.tenant = $(this).find('#TenantID');

			if(Form.userid.val().trim() != ""){
				if(Form.userid.val().match(/^[a-zA-Z0-9_.+-]+$/) == null){
					alert('入力可能なユーザーIDは記号込み（_.+-）の半角英数字のみです。');
					return false;
				}
				if(Form.userid.val().length > 32){
					alert('入力可能なユーザーIDは32文字までです。');
					return false;
				}
			}
			if(Form.usernum.val().trim() != ""){
				if(Form.usernum.val().length > 10){
					alert('入力可能な社員番号は半角数字10桁までです。');
					return false;
				}
			}
			if(Form.name.val().trim() != ""){
				if(Form.name.val().length > 48){
					alert('入力可能なユーザー名は48文字までです。');
					return false;
				}
			}
			if(Form.uuid.val().trim() != ""){
				if(Form.uuid.val().length > 256){
					alert('入力可能なUUIDは256文字までです。');
					return false;
				}
				if(Form.uuid.val().match(/^[a-zA-Z0-9_.+-]+@([a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]*\.)+[a-zA-Z]{2,}$/) == null){
					alert('UUIDが正しいメールアドレスの形式ではありません。');
					return false;
				}
			}
			if(Form.organize.val().trim() != ""){
				if(Form.organize.val().length > 512){
					alert('入力可能な所属組織名は512文字までです。');
					return false;
				}
			}
			if(Form.department.val().trim() != ""){
				if(Form.department.val().length > 512){
					alert('入力可能な役職名は512文字までです。');
					return false;
				}
			}
			if(Form.password.val().trim() != ""){

				if(Form.password.val().length < 8){
					alert('パスワードは8文字以上入力してください。');
					return false;
				}
				if(Form.password.val() != Form.confpass.val()){
					alert('確認用パスワードが一致しません。');
					return false;
				}
			}
			if(Form.tenant.val().trim() == ""){
				alert('登録テナントが選択されていません。');
				return false;
			}

        });

        
		//フォームバリデーション（編集）
        $('form#FormUserEdit').submit(function(){
            let Form = new Object();

        	Form.usernum = $(this).find('#UserNum');
        	Form.name = $(this).find('#Name');
        	Form.uuid = $(this).find('#UUID');
        	Form.organize = $(this).find('#Organization');
        	Form.department = $(this).find('#Department');
        	Form.password = $(this).find('#Password');
        	Form.confpass = $(this).find('#Confpass');
        	Form.tenant = $(this).find('#TenantID');
//         	if($(this).find('[name="device_authorize[]"]').length > 0){
//                 var da_arr = [];
//         		$(this).find('[name="device_authorize[]"]').each(function(i, e){
//             		if($(e).prop('checked')) da_arr.push($(e).val());
//         		});
//         		Form.authorize = da_arr;
//         	}
			if(Form.usernum.val().trim() != ""){
				if(Form.usernum.val().length > 10){
					alert('入力可能な社員番号は半角数字10桁までです。');
//					CreateAlert('社員番号は半角数字10桁となっております。');
					return false;
				}
			}
			if(Form.name.val().trim() != ""){
				if(Form.name.val().length > 48){
					alert('入力可能なユーザー名は48文字までです。');
					return false;
				}
			}
			if(Form.uuid.val().trim() != ""){
				if(Form.uuid.val().length > 256){
					alert('入力可能なUUIDは256文字までです。');
					return false;
				}
				if(Form.uuid.val().match(/^[a-zA-Z0-9_.+-]+@([a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]*\.)+[a-zA-Z]{2,}$/) == null){
					alert('UUIDが正しいメールアドレスの形式ではありません。');
					return false;
				}
			}
			if(Form.organize.val().trim() != ""){
				if(Form.organize.val().length > 512){
					alert('入力可能な役職名は512文字までです。');
					return false;
				}
			}
			if(Form.department.val().trim() != ""){
				if(Form.department.val().length > 512){
					alert('入力可能な所属組織名は512文字までです。');
					return false;
				}
			}
			if(Form.password.val().trim() != ""){

				if(Form.password.val().length < 8){
					alert('パスワードは8文字以上入力してください。');
					return false;
				}
				if(Form.password.val() != Form.confpass.val()){
					alert('確認用パスワードが一致しません。');
					return false;
				}
			}
			if(Form.tenant.val().trim() == ""){
				alert('登録テナントが選択されていません。');
				return false;
			}

        });



//             function CreateAlert(msg){
//             	$('.alert-wrap').empty().append('<div class="alert alert-danger">'+msg+'</div>');
//             }

        $('#modal-userdelete').on('show.bs.modal', function(event) {
            var recipient = $(event.relatedTarget).data('whatever');
            $(this).find('.modal-body #DeleteUserID').val(recipient);
            var num = $(event.relatedTarget).data('delnum');
            $(this).find('.modal-body #DeleteUserNum').val(num);
        });


        // datatableの設定を変更
        $("#UserListTable").DataTable({
        	searching: false,
        	info: false,
        	lengthChange: false,
        	columnDefs: [
          		  { "targets": 0, "width": '5%'},
        		  { "targets": 1, "width": '10%'},
        		  { "targets": 2, "width": '10%'},
        		  { "targets": 3, "width": '10%'},
        		  { "targets": 4, "width": '16%'},
        		  { "targets": 5, "width": '28%'},
        		  { "targets": 6, "width": '13%'},
        		  { "targets": 7, "width": '8%',"orderable": false},
        		],
        });

        // datatableの設定を変更
        var daList = $("#DeviceAuthorizeListTable").DataTable({
        	searching: false,
        	info: false,
        	lengthChange: false,
        	paging: false,
			scrollX: false,
        	scrollY: "50vh",
        	columnDefs: [
          		  { "targets": 0, "width": '18%', "orderable": false},
        		  { "targets": 1, "width": '35%'},
        		  { "targets": 2, "width": '16%'},
        		  { "targets": 3, "width": '16%'},
        		  { "targets": 4, "width": '15%', "visible": false},
        		],
        });

    	$('#TenantID').on('change', function(i,e){
    		var tid = $(this).val();
       	 	ajax_DeviceTable(tid);
//    		var regexStr = (tid != "")?''+tid+'':'';
////     		var cid = $(this).val();
////    		s.replaceAll(p, 'abc')
////    	 	$table = $('#dataTableComp').DataTable();
////    		 	//検索します。
//    	 	daList.columns(4).search(regexStr).draw();
//       	 	console.log(regexStr);
       	 	
    	});

        $('body').on('click', 'button#AllCheckBtn', () => {
        	console.log($(this));
        	$('#DeviceAuthorizeListTable tr td input:checkbox').each((i,v) => {
        		$(v).prop('checked', true);
        	});
        });
        
        $('body').on('click', 'button#AllUnCheckBtn', () => {
        	$('#DeviceAuthorizeListTable tr td input:checkbox').each((i,v) => {
        		$(v).prop('checked', false);
        	});
        });

        $('#selectArea').on('change', function(){
            var sVal = $(this).val();
            var cell = daList.cell( $(this).closest('td') );
            daList.search(sVal).draw();
//                 console.log(sVal);
            console.log(daList.rows([1]).data(1));
//                 cell.data(sVal).draw();
        });

        $('#csvUploadConfBtn').on('click', function(){
//             	var file = $('input[type=file]').prop('files')[0];
        	// アップロード

			var fd = new FormData($('#CSVRegistConfirmForm').get(0));
//             	var fd = new FormData();
//             	fd.append($(this).attr('name'), file);
//             	console.log(fd);

            $.ajax({
                url: 'parts/usercsv_confirm.php',
                type: 'POST',
                data: fd,
                processData: false, // jQueryがデータを処理しないよう指定
                contentType: false  // jQueryがcontentTypeを設定しないよう指定
            }).done(function(result) {
            	// 実行中
            }).fail(function() {
                // 失敗
                $('#result').html('失敗');
            }).always(function(result) {
                console.log(result);
                // 完了
                if (result.state == 'success') {
                	$('#result').html('成功');

					$('#CSVConfirmFailedMsg').addClass('d-none');
                	$('#CSVConfirmTableWrap').html(result.html);
                	$("#CSVConfirmTable").DataTable({
                    	searching: false,
                    	info: false,
                    	lengthChange: false,
                    	columnDefs: [
                      		  { "targets": 0, "width": '5%'},
                    		  { "targets": 1, "width": '10%'},
                    		  { "targets": 2, "width": '10%'},
                    		  { "targets": 3, "width": '10%'},
                    		  { "targets": 4, "width": '12%'},
                    		  { "targets": 5, "width": '12%'},
                    		  { "targets": 6, "width": '13%'},
                    		  { "targets": 7, "width": '10%'},
                    		  { "targets": 8, "width": '10%'},
                    		  { "targets": 9, "width": '8%'},
                    		],
                    });
					$('#CSVConfirmTableWrap').removeClass('d-none');
					if(result.count > 0){
						$('#csvUploadSubmitBtn').prop('disabled', false);
					}
                } else {
                    if(result.msg != ""){
						$('#CSVConfirmTableWrap').addClass('d-none');
						$('#CSVConfirmFailedMsg').find('.alert').text(result.msg);
						$('#CSVConfirmFailedMsg').removeClass('d-none');
                    }
                	$('#result').html('失敗');
                }
            });
        });


        function ajax_DeviceTable(tid){

			var data = new Object();
			data.tenant = tid;
//			console.log(data);
            $.ajax({
                url: 'ajax_devicetable.php',
                type: 'POST',
                data: data,
//                processData: false, // jQueryがデータを処理しないよう指定
//                contentType: false  // jQueryがcontentTypeを設定しないよう指定
            }).done(function(result) {
            	// 実行中

//                console.log(result);
                // 完了
                if (result.state == 'success') {
                	
                	$('#AjaxDevicetableWrap').html(result.html);

					$('#DeviceAuthorizeListTable').removeClass('d-none');
					
                	$("#DeviceAuthorizeListTable").DataTable({
	                	searching: false,
	                	info: false,
	                	lengthChange: false,
	                	paging: false,
	        			scrollX: false,
	                	scrollY: "50vh",
	                	columnDefs: [
                  		  { "targets": 0, "width": '18%', "orderable": false},
                		  { "targets": 1, "width": '35%'},
                		  { "targets": 2, "width": '16%'},
                		  { "targets": 3, "width": '16%'},
                		  { "targets": 4, "width": '15%', "visible": false},
                		],
                	});

                } else {

                	alert('デバイスリストの読み込みに失敗しました。');
                }
            }).fail(function() {
                // 失敗
//                    $('#result').html('失敗');
            	alert('デバイスリストの読み込みに失敗しました。');
            }).always(function(result) {
            	
            });
        }
    });