<?
/**
 * CSV一括読込
 * @_FILES アップロードしたCSVデータ
 * @targetFolder CSVをアップロードするディレクトリのパス
 * @readDataLimit 読込可能なデータ件数
 * @filename アップロードファイルのname
 * return @csv_arr 出力CSVデータ
 */

// if(is_null($VAL)){
//     require(CORE_PATH."validation.php");
//     $VAL = new formValidation();
// }


//POSTでアップロードされたファイルの保存場所、読み込み指定をします。
if(is_uploaded_file($_FILES[$filename]["tmp_name"])){
    $tempFile = $_FILES[$filename]['tmp_name'];
    $targetPath = DOCROOT . $targetFolder;
    $targetFile = rtrim($targetPath,'/') . '/' . $_FILES[$filename]['name'];
    // Validate the file type
    $fileTypes = array('csv','txt');// File extensions
    $fileParts = pathinfo($_FILES[$filename]['name']);
    if (in_array($fileParts['extension'],$fileTypes)) {
        move_uploaded_file($tempFile,$targetFile);//アップロードされたファイルを移動する
        // 処理
        $num = 0;//処理件数
        $errNum = 0;//エラー件数
        $overlapNum = 0;//重複件数



        setlocale(LC_ALL, 'ja_JP.UTF-8');
        $data = file_get_contents($targetFile);
        //mb_language("Japanese”);//言語指定
        $encode = mb_detect_encoding($data,'sjis-win, UTF-8');
        switch($encode){
            case 'SJIS-win':
                $data = mb_convert_encoding($data, 'UTF-8', 'sjis-win');//文字コード変換
                break;
            case 'UTF-8':
                break;

        }
        $temp = tmpfile();
        $meta = stream_get_meta_data($temp);

        fwrite($temp, $data);//一時ファイル作成
        rewind($temp);


        $file = new SplFileObject($meta['uri']);
        $file->setFlags(SplFileObject::DROP_NEW_LINE | SplFileObject::READ_AHEAD | SplFileObject::SKIP_EMPTY | SplFileObject::READ_CSV);
        $file->setCsvControl(',', '"');

        $err_list = [];
        switch($filename){

            case 'user_list':
                $title = 'ユーザー一括登録';
                $csv_arr = array();
                $arr = array();
                $header = [
                    'num' => '',
                    'user_id' => '',
                    'tenant_id' => '',
                    'uuid' => '',
                    'name' => '',
                    'user_number' => '',
                    'department' => '',
                    'organization' => '',
                    'device_authorize' => '',
                    'status' => '',
                ];
                $i=0;
                $n=1;

                if(count($file) > $readDataLimit) throw new Exception("一括登録可能な件数を超えています。");

                foreach($file as $line) {
                    if($i == 0){
                        //ヘッダーは無視する
                        ++$i;
                        continue;
                    }

                    ++$i;
                    //                     if(count($header) != count($line)) continue;

                    $t = new Datetime();
                    $arr = $header;
                    $row = $adMDL->CheckUserData($line[1]);
                    if($row || !is_null($row)){

                        $name = $line[2];
                        if(trim($name) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }
                        if(mb_strlen($name) > 48) {
                            $err_list[] = err_output($i);
                            continue;
                        }

                        $user_number = $line[3];

                        $tenant_id = $line[4];
                        if(trim($tenant_id) === "") {
                            $err_list[] = err_output($i);
                            continue;
                        }
                        if(mb_strlen($tenant_id) > 32) {
                            $err_list[] = err_output($i);
                            continue;
                        }
                        $t_row = $adMDL->GetTenantData($tenant_id);
                        if(!$t_row || is_null($t_row)) {
                            $err_list[] = err_output($i);
                            continue;
                        }
                        if($_SESSION['admin']['authorize']*1 != ACCOUNT_AUTHOR_OWNER){
                            if($row['tenant_id'] != $_SESSION['admin']['tenant_id']){
                                $err_list[] = err_output($i);
                                continue;
                            }
                        }

                        //バリデーション
                        $uuid = $line[5];
                        if(trim($uuid) !== ""){
                            if(mb_strlen($uuid) > 256){
                                $err_list[] = err_output($i);
                                continue;
                            }
                            if(!validateMailAddress($uuid)){
                                $err_list[] = err_output($i);
                                continue;
                            }
                        }

                        $department = $line[6];
                        if(trim($department) !== ""){
                            if(mb_strlen($department) > 512){
                                $err_list[] = err_output($i);
                                continue;
                            }
                        }


                        $organization = $line[7];
                        if(trim($organization) !== ""){
                            if(mb_strlen($organization) > 512){
                                $err_list[] = err_output($i);
                                continue;
                            }
                        }

                        $device_authorize = $line[8];
                        if(trim($device_authorize) !== "" && $device_authorize != "NULL"){
                            if(mb_strlen($device_authorize) > 100000){
                                $err_list[] = err_output($i);
                                continue;
                            }
                        }else{
                            $device_authorize = "";
                        }

                        if($line[9] != ""){
                            $options = [ 'cost' => 8, 'salt' =>  $user_magic_code];
                            $setpass = password_hash($line[9], PASSWORD_DEFAULT);
                        }else{
                            $setpass = $row['pass'];
                        }

                        $arr = [
                            'num' => $row['num'],
                            'user_id' => $row['user_id'],
                            'tenant_id' => $row['tenant_id'],
                            'uuid' => $uuid,
                            'name' => $name,
                            'user_number' => $user_number,
                            'department' => $department,
                            'organization' => $organization,
                            'device_authorize' => $device_authorize,
                            'pass' => $setpass,
                            'last_login' => $t->format("Y-m-d H:i:s"),
                            'login_count' => $row['login_count'],
                            'error_count' => $row['error_count'],
                            'status' => $row['status'],
                            'type' => 'update',
                        ];

                        $csv_arr[] = $arr;

                    }else{

                        //新規
                        $user_id = $line[1];

                        if(trim($user_id) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }
                        if(mb_strlen($user_id) > 32){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        $name = $line[2];
                        if(trim($name) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }
                        if(mb_strlen($name) > 48){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        $user_number = $line[3];

                        $tenant_id = $line[4];
                        if(trim($tenant_id) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }
                        if(mb_strlen($tenant_id) > 32){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        $t_row = $adMDL->GetTenantData($tenant_id);
                        if(!$t_row || is_null($t_row)){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        if($_SESSION['admin']['authorize']*1 != ACCOUNT_AUTHOR_OWNER){
                            if($t_row['id'] != $_SESSION['admin']['tenant_id']){
                                $err_list[] = err_output($i);
                                continue;
                            }
                        }

                        $uuid = $line[5];
                        if(trim($uuid) !== ""){
                            if(mb_strlen($uuid) > 256){
                                $err_list[] = err_output($i);
                                continue;
                            }
                            if(!validateMailAddress($uuid)){
                                $err_list[] = err_output($i);
                                continue;
                            }

                            //UUID（メールアドレス）の重複チェック
                            $already_ret = $adMDL->CheckUUIDDuplicate($uuid);
                            if(count($already_ret) > 0){
                                $err_list[] = err_output($i);
                                continue;
                            }
                        }

                        $department = $line[6];
                        if(trim($department) !== ""){
                            if(mb_strlen($department) > 512){
                                $err_list[] = err_output($i);
                                continue;
                            }
                        }

                        $organization = $line[7];
                        if(trim($organization) !== ""){
                            if(mb_strlen($organization) > 512){
                                $err_list[] = err_output($i);
                                continue;
                            }
                        }

                        $device_authorize = $line[8];
                        if(trim($device_authorize) !== "" && $device_authorize != "NULL"){
                            if(mb_strlen($device_authorize) > 100000){
                                $err_list[] = err_output($i);
                                continue;
                            }
                        }else{
                            $device_authorize = "";
                        }

                        $pass = $line[9];
                        if(trim($pass) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        $options = [ 'cost' => 8, 'salt' =>  $user_magic_code];
                        $setpass = password_hash($pass, PASSWORD_DEFAULT);

                        $arr = [
                            'num' => NULL,
                            'user_id' => $user_id,
                            'tenant_id' => $tenant_id,
                            'uuid' => $uuid,
                            'name' => $name,
                            'user_number' => 0,
                            'department' => $department,
                            'organization' => $organization,
                            'device_authorize' => $device_authorize,
                            'pass' => $setpass,
                            'last_login' => $t->format("Y-m-d H:i:s"),
                            'login_count' => 0,
                            'error_count' => 0,
                            'status' => 1,
                            'type' => '',
                        ];

                        ++$n;

                        $csv_arr[] = $arr;
                    }
                }
                break;

            case 'device_list':
                if(isset($GET['d']))$device_type = $GET['d'];

                $title = 'デバイス一括登録';
                $csv_arr = array();
                $arr = array();
                $header = [
                    'num' => '',
                    'device_id' => '',
                    'du_id' => '',
                    'device_num' => '',
                    'tenant_id' => '',
                    'field_id' => '',
                    'name' => '',
                    'x_pos' => '',
                    'y_pos' => '',
                    'type' => '',
                    'status' => '',
                ];
                $i=0;
                $n=1;

                if(count($file) > $readDataLimit) throw new Exception("一括登録可能な件数を超えています。");

                foreach($file as $line) {

                    if($i == 0){
                        //ヘッダーは無視する
                        ++$i;
                        continue;
                    }
                    ++$i;

                    $t = new Datetime();
                    $arr = $header;


                    $row = $sgMDL->GetDeviceTblByDeviceID($line[1]);

                    if($row || !is_null($row)){


                        $name = $line[6];
                        if(trim($name) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }
                        if(mb_strlen($name) > 48){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        $device_id = $line[1];
                        if(trim($device_id) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }
                        if(preg_match('/^[0-9a-zA-Z\-_]{1,32}$/', $device_id) == 0){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        $du_id = $line[2];
                        if(trim($du_id) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        $tenant_id = $line[4];
                        if(trim($tenant_id) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }
                        $t_row = $adMDL->GetTenantData($tenant_id);
                        if(!$t_row || is_null($t_row)){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        if($_SESSION['admin']['authorize']*1 != ACCOUNT_AUTHOR_OWNER){
                            if($tenant_id != $_SESSION['admin']['tenant_id']){
                                $err_list[] = err_output($i);
                                continue;
                            }
                        }

                        //エリアID
                        $field_id = $line[5];
                        if(trim($field_id) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        if(!isset($FieldIDList[$field_id])){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        $device_num = $line[3];
                        if(trim($device_num) !== "" && preg_match('/^[0-9]*$/', $device_num) == 0){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        $name = $line[6];
                        if(trim($name) === "" || mb_strlen($name) > 128){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        $x_pos = $line[7];
                        if(trim($x_pos) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        $y_pos = $line[8];
                        if(trim($y_pos) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        $type = $line[9];
                        if(trim($type) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }
                        if($device_type !== $type){
                            $err_list[] = err_output($i);
                            continue;
                        }



                        $arr = [
                            'num' => $row['num'],
                            'device_id' => $row['device_id'],
                            'du_id' => $du_id,
                            'tenant_id' => $tenant_id,
                            'field_id' => $field_id,
                            'name' => $name,
                            'x_pos' => $x_pos,
                            'y_pos' => $y_pos,
                            'type' => $type,
                            'status' => $row['status'],
                            'stt' => 'update',
                        ];


                        $csv_arr[] = $arr;

                    }else{

                        $device_id = $line[1];
                        if(trim($device_id) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }
                        if(preg_match('/^[0-9a-zA-Z\-_]{1,32}$/', $device_id) == 0){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        $du_id = $line[2];
                        if(trim($du_id) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }


                        $device_num = $line[3];
                        if(trim($device_num) !== "" && preg_match('/^[0-9]*$/', $device_num) == 0){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        $tenant_id = $line[4];
                        if(trim($tenant_id) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }
                        $t_row = $adMDL->GetTenantData($tenant_id);
                        if(!$t_row || is_null($t_row)){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        if($_SESSION['admin']['authorize']*1 != ACCOUNT_AUTHOR_OWNER){
                            if($tenant_id != $_SESSION['admin']['tenant_id']){
                                $err_list[] = err_output($i);
                                continue;
                            }
                        }

                        $field_id = $line[5];
                        if(trim($field_id) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }
                        //エリアID

                        $name = $line[6];
                        if(trim($name) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }
                        if(trim($name) === "" || mb_strlen($name) > 128){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        $x_pos = $line[7];
                        if(trim($x_pos) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        $y_pos = $line[8];
                        if(trim($y_pos) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        $type = $line[9];
                        if(trim($type) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }
                        if($device_type !== $type){
                            $err_list[] = err_output($i);
                            continue;
                        }


                        $arr = [
                            'num' => NULL,
                            'device_id' => $device_id,
                            'du_id' => $du_id,
                            'tenant_id' => $tenant_id,
                            'field_id' => $field_id,
                            'name' => $name,
                            'x_pos' => $x_pos,
                            'y_pos' => $y_pos,
                            'type' => $type,
                            'status' => 1,
                            'stt' => '',
                        ];
                        ++$n;

                        $csv_arr[] = $arr;
                    }

                }

                break;


            case 'area_list':

                $title = 'エリア一括登録';
                $csv_arr = array();
                $arr = array();
                $header = [
                    'num' => '',
                    'field_id' => '',
                    'tenant_id' => '',
                    'field_name' => '',
                    'belong_device' => '',
                    'x_pos' => '',
                    'y_pos' => '',
                    'width' => '',
                    'height' => '',
                    'status' => '',
                    'last-update' => '',
                ];
                $i=0;
                $n=1;

                if(count($file) > $readDataLimit) throw new Exception("一括登録可能な件数を超えています。");

                foreach($file as $line) {
                    if($i == 0){
                        //ヘッダーは無視する
                        ++$i;
                        continue;
                    }
                    ++$i;

                    $t = new Datetime();
                    $arr = $header;

                    $row = $adMDL->GetFieldData($line[1]);
                    if($row || !is_null($row)){

                        $tenant_id = $line[2];
                        if(trim($tenant_id) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }
                        $t_row = $adMDL->GetTenantData($tenant_id);
                        if(!$t_row || is_null($t_row)){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        if($_SESSION['admin']['authorize']*1 != ACCOUNT_AUTHOR_OWNER){
                            if($tenant_id != $_SESSION['admin']['tenant_id']){
                                $err_list[] = err_output($i);
                                continue;
                            }
                        }

                        $field_name = $line[3];
                        if(trim($field_name) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }
                        if(mb_strlen($field_name) > 48){
                            $err_list[] = err_output($i);
                            continue;
                        }


                        $x_pos = $line[5];
                        if(trim($x_pos) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        $y_pos = $line[6];
                        if(trim($y_pos) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        $width= $line[7];
//                         if(trim($width) === "") continue;

                        $height = $line[8];
//                         if(trim($y_pos) === "") continue;

//                         $last_update = $t->format("Y-m-d H:i:s");

                        $arr = [
                            'num' => $row['num'],
                            'field_id' => $row['field_id'],
                            'tenant_id' => $tenant_id,
                            'field_name' => $field_name,
                            'belong_device' => '',
                            'x_pos' => $x_pos,
                            'y_pos' => $y_pos,
                            'width' => $width,
                            'height' => $height,
                            'status' => $row['status'],
                            'last-update' => $row['last-update'],
                            'stt' => 'update',
                        ];


                        $csv_arr[] = $arr;

                    }else{
                        $t = new Datetime();
                        $field_id = $line[1];
                        $tenant_id = $line[2];
                        $field_name = $line[3];
                        $x_pos = $line[4];
                        $y_pos = $line[5];
                        $area_width = $line[6];
                        $area_height = $line[7];

                        if (!validateField($field_id, 32) || !preg_match('/^[0-9a-zA-Z\-_]{1,32}$/', $field_id)) {
                            $err_list[] = err_output($i);
                            continue;
                        }
                        if(trim($tenant_id) === ""){
                            $err_list[] = err_output($i);
                            continue;
                        }

                        $t_row = $adMDL->GetTenantData($tenant_id);

                        if (!$t_row || is_null($t_row)) {
                            $err_list[] = err_output($i);
                            continue;
                        } elseif ($_SESSION['admin']['authorize'] * 1 != ACCOUNT_AUTHOR_OWNER && $tenant_id != $_SESSION['admin']['tenant_id']) {
                            $err_list[] = err_output($i);
                            continue;
                        }

                        if (!validateField($field_name, 128)) {
                            $err_list[] = err_output($i);
                            continue;
                        }

                        if (!validateField($x_pos, 0, true) || !validateField($y_pos, 0, true) || !validateField($area_width, 0, true) || !validateField($area_height, 0, true)) {
                            $err_list[] = err_output($i);
                            continue;
                        }

                        $arr = [
                            'num' => NULL,
                            'field_id' => $field_id,
                            'tenant_id' => $tenant_id,
                            'field_name' => $field_name,
                            'belong_device' => '',
                            'x_pos' => $x_pos,
                            'y_pos' => $y_pos,
                            'width' => $area_width,
                            'height' => $area_height,
                            'status' => 1,
                            'last-update' => $t->format("Y-m-d H:i:s"),
                            'stt' => '',
                        ];

                        ++$n;

                        $csv_arr[] = $arr;
                    }
                }
                break;
        }

        fclose($temp);//一時ファイル削除
        $file = null;//SplFileObject破棄
        unlink($targetFile);//アップロードファイル削除

    } else {
        throw new Exception("ファイルタイプがCSV形式ではありません");
    }

}else {
    throw new Exception("ファイルがアップロードされていません");
}

function err_output($i){
    return $i."行目のデータに不備があります。";
}

/**
 * エリアの値を検証
 *
 * @param mixed $value 検証対象の値
 * @param int $maxLength 文字列の最大長（デフォルトは0で制限なし）
 * @param bool $numeric 数値の場合に true を指定
 * @return bool true: バリデーションOK, false: バリデーションNG
 */
function validateField($value, $maxLength = 0, $numeric = false) {
    if (trim($value) === "" || ($maxLength > 0 && mb_strlen($value) > $maxLength) || ($numeric && !is_numeric($value))) {
        return false;
    }
    return true;
}

?>
