<?php

define("UPLOADDATA_TYPE_BANNER",10);
define("UPLOADDATA_TYPE_IMG",20);
define("UPLOADDATA_TYPE_PDF",30);
define("UPLOADDATA_STATUS_PRE",0);
define("UPLOADDATA_STATUS_UP",1);

$SetErrArr = array(
    UPLOADDATA_TYPE_BANNER => "link_cms",
    UPLOADDATA_TYPE_IMG => "",
    UPLOADDATA_TYPE_PDF => ""
);

// $upload_max_filesize = UPLOAD_MAX_FILESIZE;//50MB
if (isset($POST))
{

    try{
        switch($ajax_from)
        {
            case "link_cms":
                $setCode = UPLOADDATA_TYPE_BANNER;
                break;
            case "file":
                $setCode = UPLOADDATA_TYPE_IMG;
                break;
        }




        if(isset($_FILES['filename']) && !empty($_FILES['filename']) && $_FILES['filename']['name'] != ""){

            if(!isset($_FILES['filename']['error']) || !is_int($_FILES['filename']['error'])){
                throw new RuntimeException('パラメータが不正です', $setCode);
            }
            // $_FILES['filename']['error'] の値を確認
            switch ($_FILES['filename']['error']) {
                case UPLOAD_ERR_OK: // OK
                    break;
                case UPLOAD_ERR_NO_FILE:   // ファイル未選択
                    throw new RuntimeException('ファイルが選択されていません', $setCode);
                case UPLOAD_ERR_INI_SIZE:  // php.ini定義の最大サイズ超過
                case UPLOAD_ERR_FORM_SIZE: // フォーム定義の最大サイズ超過 (設定した場合のみ)
                    throw new RuntimeException('ファイルサイズが大きすぎます', $setCode);
                default:
                    throw new RuntimeException('その他のエラーが発生しました', $setCode);
            }

            if($_FILES["filename"]["size"] > UPLOAD_MAX_FILESIZE){
                throw new RuntimeException('ファイルサイズが大きすぎます。', $setCode);
            }


            //ファイル種別判定
            switch($setCode){
                case UPLOADDATA_TYPE_BANNER:

                    //画像のみ許容
                    $search_arr = array(
                        image_type_to_mime_type(IMAGETYPE_GIF),
                        image_type_to_mime_type(IMAGETYPE_JPEG),
                        image_type_to_mime_type(IMAGETYPE_PNG),
                    );


                    // $_FILES['priority_pdf_data']['mime']の値はブラウザ側で偽装可能なので
                    // MIMEタイプに対応する拡張子を自前で取得する
                    if ($ext = array_search( mime_content_type($_FILES['filename']['tmp_name']),$search_arr, TRUE) === FALSE)
                    {
                        throw new RuntimeException('ファイル形式が不正です。', $setCode);
                    }

                    $file_type = "img";

                    //画像のサイズチェック
                    $width = 400;
                    $height = 80;
                    $size = getimagesize($_FILES['filename']['tmp_name']);
//                     var_dump($size);
                    if($size[0] > $width || $size[1] > $height){
                        throw new RuntimeException('画像のサイズが大きすぎます。', $setCode);
                    }

                    break;
            }



            $fp = fopen($_FILES['filename']['tmp_name'], "rb");
            if(!$fp)throw new RuntimeException("アップロードしたファイルを開けませんでした。".$_FILES['filename']['tmp_name'],$setCode);


            // バイナリデータ
            $filedat = fread($fp, filesize($_FILES['filename']['tmp_name']));

            //             $imgdat = addslashes($imgdat);
            fclose($fp);
            $t = new Datetime();

            $file_id = "FILE_".$t->getTimestamp();

            $Prm = array(
                'id' => $file_id,
                'file_data' => $filedat,
                'type' => $file_type,
            );
            $up_ret = $adMDL->InsertFileDataForPreUpload($Prm);

            if(!$up_ret){
                throw new RuntimeException('ファイルのアップロードに失敗しました。', $setCode);
            }


        }else{
            $_SESSION['filename'] = array();
            throw new RuntimeException('画像ファイルがアップロードされていません。', $setCode);
        }

    }catch(RuntimeException $e){
        throw new Exception($e->getMessage(), $e->getCode());
//         $code = $e->getCode();
//         $mes = urlencode(base64_encode($e->getMessage()));
//         header( 'Location: ' . '../'.$SetErrArr[$code].'?m='.$mes.'&err');
        exit;
    }

}
else
{
    echo "パラメータエラーです";
}

