<?

// 日付変換
// パラメータ 0:今日 1:明日 2:明後日
function date_henkan($d)
{
    if($d == 0)
    {
        $today = date("n/j");
        $youbi = date("w");
    }
    else
    {
        $d = '+'.$d.' day';
        $today = date("n/j",strtotime($d ));
        $youbi = date("w",strtotime($d ));
    }
    switch($youbi)
    {
        case 0: $today = $today.'(日)';
                break;
        case 1: $today = $today.'(月)';
                break;
        case 2: $today = $today.'(火)';
                break;
        case 3: $today = $today.'(水)';
                break;
        case 4: $today = $today.'(木)';
                break;
        case 5: $today = $today.'(金)';
                break;
        case 6: $today = $today.'(土)';
                break;
    }
    return($today);
}
function holiday_check($d)
{
    return TRUE;
}


function h($str){
    return htmlspecialchars($str);
}
function pre($mixed = null) {
    echo '<pre>';
    var_dump($mixed);
    echo '</pre>';
    return null;
}

function time_format_simple($time){
    //例：　24:00
    $hour = (int)floor($time / 100);
    $minute = (int)floor($time % 100);

    $ret = $hour.':'.sprintf('%02d', $minute);
    return $ret;
}

function DatetimeFormat($time, $day = null){
    if(is_null($day)){
        $d = new Datetime();
        $set_date = $d->format("Y/m/d");
//      $set_date = date('Ymd',time());
    }else{
        //Ymd
        $set_date = $day;
    }

    $t = intval($time);
    $t2 = $t % 100;
    $t1 = floor($t / 100);
    if($t2 === 0) $t3 = '00'; else $t3 = (string)$t2;
//  var_dump($set_date." ".$t1.":".$t3);exit;
    $tm = new Datetime($set_date." ".$t1.":".$t3);
    $rtn = $tm->format("Y/m/d G:i:s");
//  $rtn = date('G:i',strtotime($set_date.sprintf('%04d',$time)));
    return $rtn;
}

function getDatetimeTimestamp($time){
    $t = new Datetime($time);
    $rtn = $t->getTimestamp();
    return $rtn;
}


//one time tokenによる画面制御機構の作成
function createToken(){
    //セッションIDを取得
    $session_id = session_id();
    if($session_id == ""){
        return false;
    }
    //UNIX現在時刻を取得
    $time = time();
    //セッションIDとUNIX現在時刻を結合し、SHA1形式でハッシュ化し、ワンタイムトークン作成
    $token = sha1($session_id.$time);
    //セッションと返り値にワンタイムトークンを格納
    $_SESSION['one_time_token'] = $token;
    return $token;
}

//csrf tokenによる画面制御機構の作成
function createCsrfToken(){
    //セッションIDを取得
    $session_id = session_id();
    if($session_id == ""){
        return false;
    }
    //UNIX現在時刻を取得
    $time = time();
    //セッションIDとUNIX現在時刻を結合し、SHA1形式でハッシュ化し、ワンタイムトークン作成
    $token = sha1($session_id.$time);
    //セッションと返り値にワンタイムトークンを格納
    $_SESSION['csrf_token'] = $token;
    return $token;
}

function checkToken($token){
    //セッションにワンタイムトークンがあるかどうか確認
    if(!isset($_SESSION['one_time_token']))return false;
    $s_token = $_SESSION['one_time_token'];

    //ワンタイムトークンセッションを初期化&消去する
    $_SESSION['one_time_token'] = '';
    unset($_SESSION['one_time_token']);

    //$tokenの値とセッションのトークンの値が一致するかどうかを確認
    //一致したらTRUE、それ以外ならFALSEを返す
    return (strcmp($token,$s_token) === 0);
}

function checkCsrfToken($token){
    //セッションにワンタイムトークンがあるかどうか確認
    if(!isset($_SESSION['csrf_token']))return false;
    $s_token = $_SESSION['csrf_token'];

    //ワンタイムトークンセッションを初期化&消去する
    $_SESSION['csrf_token'] = '';
    unset($_SESSION['csrf_token']);

    //$tokenの値とセッションのトークンの値が一致するかどうかを確認
    //一致したらTRUE、それ以外ならFALSEを返す
    return (strcmp($token,$s_token) === 0);
}


function get_token() {
    $TOKEN_LENGTH = 16;//16*2=32桁
    $bytes = openssl_random_pseudo_bytes($TOKEN_LENGTH);
    return bin2hex($bytes);
}

function filterPost(){
    $POST = array();
    foreach($_POST as $pk => $pv){
        if(!is_array($pv)){
            $POST[$pk] = filter_input(INPUT_POST,$pk,FILTER_DEFAULT );
            //             $POST[$pk] = filter_input(INPUT_POST,$pk,FILTER_SANITIZE_SPECIAL_CHARS );
        }else{
            $POST[$pk] = filter_input(INPUT_POST,$pk,FILTER_DEFAULT ,FILTER_REQUIRE_ARRAY);
            //             $POST[$pk] = filter_input(INPUT_POST,$pk,FILTER_SANITIZE_SPECIAL_CHARS ,FILTER_REQUIRE_ARRAY);
        }
    }
    return $POST;
}

function filterGet(){
    $GET = array();
    foreach($_GET as $gk => $gv){
        if(!is_array($gv)){
            $GET[$gk] = filter_input(INPUT_GET,$gk,FILTER_DEFAULT);
            //             $GET[$gk] = filter_input(INPUT_GET,$gk,FILTER_SANITIZE_SPECIAL_CHARS);

        }else{
            $GET[$gk] = filter_input(INPUT_GET,$gk,FILTER_DEFAULT, FILTER_REQUIRE_ARRAY);
            //             $GET[$gk] = filter_input(INPUT_GET,$gk,FILTER_SANITIZE_SPECIAL_CHARS,FILTER_REQUIRE_ARRAY);
        }
    }
    return $GET;
}

function checkMailAddressMulti($txt){
    $flg = true;

    // 改行コード \r、\n、\r\n の3種を区別せず配列化
    $arr = preg_split("/\R/", $txt);
    // 各要素の空白除去
    array_walk_recursive($arr, 'trim');
    // 文字列長が0の要素を除去
    $arr = array_filter($arr, 'strlen');
    // インデックスを振り直す
    $arr = array_merge($arr);

    foreach($arr as $aK => $aV){
        if(!validateMailAddress($aV)){
            $flg = false;
            break;
        }
    }

    return $flg;
}


function TrimNoticeMailList($txt){
    // 改行コード \r、\n、\r\n の3種を区別せず配列化
    $arr = preg_split("/\R/", $txt);
    // 各要素の空白除去
    array_walk_recursive($arr, 'trim');
    // 文字列長が0の要素を除去
    $arr = array_filter($arr, 'strlen');
    // インデックスを振り直す
    $arr = array_merge($arr);
    return $arr;
}


function validateMailAddress($mail){
    $pattern = "/^[a-zA-Z0-9.!#$%&'*+\/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\.[a-zA-Z0-9-]+)*$/";
    return preg_match($pattern, $mail );
}


function func_multisort($arr, $tkey, $sort){


    // foreachで1つずつ値を取り出す
    foreach ($arr as $key => $value) {
        $id[$key] = $value[$tkey];
    }

    // array_multisortで'id'の列を昇順に並び替える
    array_multisort($id, $sort, $arr);

    return $arr;
}

function getHashMaxKey($hash,$keyName){
    $maxNumber = 0;
    $maxKey = 0;
    for ($i = 0, $len = count($hash); $i < $len; $i++) {
        if (!$hash[$i][$keyName]) continue;

        if ($hash[$i][$keyName] > $maxNumber) {
            $maxNumber = $hash[$i][$keyName];
            $maxKey = $i;
        }
    }
    return $maxKey;
}

function getHashKey($hash, $keyName, $value){

    $getKey = False;
    for ($i = 0, $len = count($hash); $i < $len; $i++) {
        if (!$hash[$i][$keyName]) continue;
//         var_dump($hash[$i][$keyName], '---', $value);
        if ($hash[$i][$keyName] === $value) {
            $getKey = $i;
        }
    }
    return $getKey;
}

function GetWeatherForID($id){
    $weather = "none";
    switch(true){
        case preg_match('/^(800)$/', $id):
            $weather = 'sunny';
            break;
        case preg_match('/^(80)[1-9]{1}$/', $id):
            $weather = 'cloudy';
            break;
        case preg_match('/^(3)[0-9]{2}$/', $id):
        case preg_match('/^(7)[0-9]{2}$/', $id):
            $weather = 'misty';
            break;
        case preg_match('/^(6)[0-9]{2}$/', $id):
            $weather = 'snowy';
            break;
        case preg_match('/^(5)[0-9]{2}$/', $id):
        case preg_match('/^(2)[0-9]{2}$/', $id):
            $weather = 'rainy';
            break;
    }
    return $weather;
}

function GetDeviceTypeList(){
    $list = [
        'camera',
        'light',
        'aircon',
    ];
    return $list;
}


function GetMsgEncode($msg){
    return urlencode(base64_encode($msg));
}

function GetMsgEncodeNotUrlEnc($msg){
    return base64_encode($msg);
}
function GetMsgDecode($encmsg){
    return base64_decode($encmsg);
}

function TransDeviceUniqId($type, $id){
    $ret = "";
    switch($type){
        case DEVICE_TYPE_AIRCON_DCU:
            $ret = "DCU".$id;
            break;
        case DEVICE_TYPE_AIRCON_FCU:
            $ret = "FCU".$id;
            break;
        case DEVICE_TYPE_AIRCON_BULK_FCU:
            $ret = "BLKFCU".$id;
            break;
        case DEVICE_TYPE_AIRCON_AHU:
            $ret = "AHU".$id;
            break;
        case DEVICE_TYPE_AIRCON_OHU:
            $ret = "OHU".$id;
            break;
        case DEVICE_TYPE_CAMERA:
            $ret = "CMR".$id;
            break;
        case DEVICE_TYPE_LIGHT:
            $ret = "LGT".$id;
            break;
        case DEVICE_TYPE_TOILET:
            $ret = "TLT".$id;
            break;
        default:
            $ret = FALSE;
            break;
    }
    return $ret;
}

function sendGmail($client, $info) {
    $data = "";
    $data .= "From:".$info['from_addr']."\n";
    $data .= "To:".$info['email']."\n";
    $subject = mb_convert_encoding( $info['subject'], "JIS", "UTF-8" );
    $subject = "Subject: =?ISO-2022-JP?B?" . base64_encode($subject) . "?=";
    $data .= $subject."\n";
    $data .= "\n"; // ヘッダーと本文を区切る空行
    $data .= $info['body'];
    try {
        $data = GetMsgEncodeNotUrlEnc($data); //base64エンコード
        $service = new Google_Service_Gmail($client);
        $msg = new Google_Service_Gmail_Message();
        $msg->setRaw($data);
        $result = $service->users_messages->send('me', $msg);

    } catch (Exception $e) {
        $Err = json_decode($e->getMessage());

        http_response_code($Err->error->code);
        $result = $Err;
    }
    return $result;
}


function checkPassword($password)
{
    // LESS 短いパスワード
    $less_flg = FALSE;
    $length = strlen($password);
    if ($length < 8) {
        $less_flg = TRUE;
    }

    // WARK 弱いパスワード
    $weak_flg = FALSE;
    if (! $less_flg) {
        // 連続したパターン  11111111 12121212 123123123
        if (preg_match('/^([0-9a-z]{1,3})\1+$/i', $password)) {
            $weak_flg = TRUE;
        } elseif (preg_match('/^[0-9]+$/', $password)) {
            $num_flg = TRUE;

            // 連続した数字 12345678 98765432
            for ($i = 0; $i < $length; $i++) {
                $num[$i] = substr($password, $i, 1);
                if ($i > 0) {
                    $diff[$i] = $num[$i] - $num[$i - 1];
                    if ($i > 1) {
                        if ($diff[$i] != $diff[$i - 1]) {
                            $num_flg = FALSE;
                            break;
                        }
                    }
                }
            }
            if ($num_flg) {
                $weak_flg = TRUE;
            }
        } elseif (preg_match('/^[a-z]+$/i', $password)) {
            $alpha_flg = TRUE;

            // 連続したアルファベット abcdefgh zxywvuts
            for ($i = 0; $i < $length; $i++) {
                $dec[$i] = hexdec(substr($password, $i, 1));
                if ($i > 0) {
                    $diff[$i] = $dec[$i] - $dec[$i - 1];
                    if ($i > 1) {
                        if ($diff[$i] != $diff[$i - 1]) {
                            $alpha_flg = FALSE;
                            break;
                        }
                    }
                }
            }
            if ($alpha_flg) {
                $weak_flg = TRUE;
            }
        }
        if (! $weak_flg) {
            // 指定のキーワードにマッチ
            $ng_password = array('password', 'qwertyui');
            foreach ($ng_password as $ngPassVal) {
                if ($password == $ngPassVal) {
                    $weak_flg = TRUE;
                    break;
                }
            }
        }
    }

    // STRONG 強いパスワード
    $strong_flg = FALSE;
    if (! $less_flg && ! $weak_flg) {
        // 英数混在 10文字以上 a1b2c3d4e5 abcde12345
        if (preg_match('/^(?=.*[0-9])(?=.*[a-z])[0-9a-zA-Z]{8,20}$/i', $password)) {
            $strong_flg = TRUE;
        }
    }

    return array($less_flg, $weak_flg, $strong_flg);
}


/**
 * ディレクトリをコピーする
 *
 * @param  string $dir     コピー元ディレクトリ
 * @param  string $new_dir コピー先ディレクトリ
 * @return void
 */
function copy_dir($dir, $new_dir)
{

    $dir     = rtrim($dir, '/').'/';
    $new_dir = rtrim($new_dir, '/').'/';
    // コピー元ディレクトリが存在すればコピーを行う
    if (is_dir($dir)) {
        // コピー先ディレクトリが存在しなければ作成する
        if (!is_dir($new_dir)) {
        
        //    $mask = umask();  //事前のマスク値を退避
        //      umask(000);  //マスクを無効にする
        mkdir($new_dir, 0777, true); //マスクが無効になっているので全てのディレクトリが0777になる
        //      umask($mask);  //マスク値をもとに戻す
            chmod($new_dir, 0777);
        }
        
        // ディレクトリを開く
        if ($handle = opendir($dir)) {
            // ディレクトリ内のファイルを取得する
            while (false !== ($file = readdir($handle))) {
                if ($file === '.' || $file === '..') {
                    continue;
                }
                // 下の階層にディレクトリが存在する場合は再帰処理を行う
                if (is_dir($dir.$file)) {
                    copy_dir($dir.$file, $new_dir.$file);
                } else {
                    copy($dir.$file, $new_dir.$file);
                }
            }
            closedir($handle);
        }
    }
}

/**
 * 再帰的にディレクトリを削除する。
 * @param string $dir ディレクトリ名（フルパス）
 */
function removeDir( $dir ) {
    
    $cnt = 0;
    
    $handle = opendir($dir);
    if (!$handle) {
        return ;
    }
    
    while (false !== ($item = readdir($handle))) {
        if ($item === "." || $item === "..") {
            continue;
        }
        
        $path = $dir . DS . $item;
        
        if (is_dir($path)) {
            // 再帰的に削除
            $cnt = $cnt + removeDir($path);
        }
        else {
            // ファイルを削除
            unlink($path);
        }
    }
    closedir($handle);
    
    // ディレクトリを削除
    if (!rmdir($dir)) {
        return ;
    }
}

?>