<?php
/**
 * formValidation
 * フォームのバリデーションチェックを行うクラス（途中）
 */
class formValidation{

//     public $Process;
    public $Checkflag;
    public $Msg;


    // コンストラクター
    public function __construct()
    {
        $this->Checkflag = TRUE;
        $this->Msg = array();
    }


    /**
     * UserID
     * ユーザーIDチェック
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function UserID($val, $length, $required = NULL){
        try{

             //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("ユーザーIDが入力されていません。");
            }

            //桁数を超えていないか
            $this->maxlengthCheck($length,$val);
            if(!$this->Checkflag){
                throw new Exception("ユーザーIDは".$length."文字までです。");
            }

            //値の形式が正しい物かどうか
            $this->pregmatchCheck("/^[a-zA-Z0-9_.+-]+$/",$val);
            if(!$this->Checkflag){
                throw new Exception("入力可能なユーザーIDは記号込み（_.+-）の半角英数字のみです。");
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }


    /**
     * UserNum
     * 社員番号チェック
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function UserNum($val, $length, $required = NULL){
        try{

             //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("社員番号が入力されていません。");
            }

            if(!empty($val)){
                //桁数を超えていないか
                $this->maxlengthCheck($length,$val);
                if(!$this->Checkflag){
                    throw new Exception("社員番号は".$length."文字までです。");
                }

                //値の形式が正しい物かどうか
                $this->pregmatchCheck("/^[\d]+$/",$val);
                if(!$this->Checkflag){
                    throw new Exception("入力可能な社員番号は半角数字のみです。");
                }
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }

    /**
     * AdminID
     * 管理者IDチェック
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function AdminID($val, $length, $required = NULL){
        try{

             //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("管理者IDが入力されていません。");
            }
//             //桁数を超えていないか
//             $this->maxlengthCheck($length,$val);
//             if(!$this->Checkflag){
//                 throw new Exception("管理者IDの桁数は".$length."文字までです。");
//             }

            //値の形式が正しい物かどうか
            $this->pregmatchCheck("/^[a-zA-Z\d]{5,20}$/",$val);
            if(!$this->Checkflag){
                throw new Exception("管理者IDは20文字以下の長さで、記号を含まない半角英数字（大文字小文字）のみ使用可能です。");
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }

    /**
     * UserMail
     * メールアドレスチェック
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function UserMail($val, $length, $required = NULL){
        try{

             //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("メールアドレスが入力されていません。");
            }

            //桁数を超えていないか
            $this->maxlengthCheck($length,$val);
            if(!$this->Checkflag){
                throw new Exception("メールアドレスの桁数は".$length."文字までです。");
            }

            //値の形式が正しい物かどうか
            $this->pregmatchCheck("/^[a-zA-Z0-9_.+-]+@([a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]*\.)+[a-zA-Z]{2,}$/u",$val);
            if(!$this->Checkflag){
                throw new Exception("メールアドレスが正しいメールアドレスの形式ではありません。");
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }

    /**
     * UUID
     * UUIDチェック
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function UUID($val, $length, $required = NULL){
        try{

             //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("UUIDが入力されていません。");
            }

            if(!empty($val)){
                //桁数を超えていないか
                $this->maxlengthCheck($length,$val);
                if(!$this->Checkflag){
                    throw new Exception("入力可能なUUIDは".$length."文字までです。");
                }

                //値の形式が正しい物かどうか
                $this->pregmatchCheck("/^[a-zA-Z0-9_.+-]+@([a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]*\.)+[a-zA-Z]{2,}$/u",$val);
                if(!$this->Checkflag){
                    throw new Exception("UUIDが正しいメールアドレスの形式ではありません。");
                }
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }

    /**
     * Password
     * パスワードチェック
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function Password($val, $length, $required = NULL){
        try{

             //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("パスワードが入力されていません。");
            }

            //桁数を超えていないか
            $this->maxlengthCheck($length,$val);
            if(!$this->Checkflag){
                throw new Exception("入力可能なパスワードは".$length."文字までです。");
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }

    /**
     * TagId
     * タグIDチェック
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function TagId($val, $length, $required = FALSE){
        try{

            if($required) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("タグIDが入力されていません。");
            }

            if(!empty($val)){
                $this->maxlengthCheck($length,$val);
                if(!$this->Checkflag){
                    throw new Exception("タグIDは".$length."文字までです。");
                }

                //値の形式が正しい物かどうか
                // $this->pregmatchCheck("/^[\d]+$/",$val);
                // if(!$this->Checkflag){
                //     throw new Exception("入力可能なタグIDは------のみです。");
                // }
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }

    /**
     * AdminMail
     * メールアドレスチェック
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function AdminMail($val, $length, $required = NULL){
        try{

             //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("メールアドレスが入力されていません。");
            }

            //桁数を超えていないか
            $this->maxlengthCheck($length,$val);
            if(!$this->Checkflag){
                throw new Exception("メールアドレスの桁数は".$length."文字までです。");
            }

            //値の形式が正しい物かどうか
            $this->pregmatchCheck("/^[a-zA-Z0-9_.+-]+@([a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]*\.)+[a-zA-Z]{2,}$/u",$val);
            if(!$this->Checkflag){
                throw new Exception("メールアドレスが正しいメールアドレスの形式ではありません。");
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }


    /**
     * UserName
     * ユーザー名チェック
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function UserName($val, $length, $required = NULL){
        try{

             //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("ユーザー名が入力されていません。");
            }

            //桁数を超えていないか
            $this->maxlengthCheck($length,$val);
            if(!$this->Checkflag){
                throw new Exception("入力可能なユーザー名は".$length."文字までです。");
            }
//             if(!empty($val)){

//             }

//             //値の形式が正しい物かどうか
//             $this->pregmatchCheck("/^[a-zA-Z0-9_.+-]+@([a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]*\.)+[a-zA-Z]{2,}$/u",$val);
//             if(!$this->Checkflag){
//                 throw new Exception("メールアドレスが正しいメールアドレスの形式ではありません。");
//             }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }


    /**
     * Organize
     * 所属組織名チェック
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function Organize($val, $length, $required = NULL){
        try{

             //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("所属組織名が入力されていません。");
            }

            if(!empty($val)){

                //桁数を超えていないか
                $this->maxlengthCheck($length,$val);
                if(!$this->Checkflag){
                    throw new Exception("入力可能な所属組織名は".$length."文字までです。");
                }
            }

//             //値の形式が正しい物かどうか
//             $this->pregmatchCheck("/^[a-zA-Z0-9_.+-]+@([a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]*\.)+[a-zA-Z]{2,}$/u",$val);
//             if(!$this->Checkflag){
//                 throw new Exception("メールアドレスが正しいメールアドレスの形式ではありません。");
//             }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }


    /**
     * Department
     * 役職名チェック
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function Department($val, $length, $required = NULL){
        try{

             //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("役職名が入力されていません。");
            }

            if(!empty($val)){

                //桁数を超えていないか
                $this->maxlengthCheck($length,$val);
                if(!$this->Checkflag){
                    throw new Exception("入力可能な役職名は".$length."文字までです。");
                }
            }

//             //値の形式が正しい物かどうか
//             $this->pregmatchCheck("/^[a-zA-Z0-9_.+-]+@([a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]*\.)+[a-zA-Z]{2,}$/u",$val);
//             if(!$this->Checkflag){
//                 throw new Exception("メールアドレスが正しいメールアドレスの形式ではありません。");
//             }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }


    /**
     * AdminName
     * 管理者名チェック
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function AdminName($val, $length, $required = NULL){
        try{

             //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("管理者名が入力されていません。");
            }

            //桁数を超えていないか
            $this->maxlengthCheck($length,$val);
            if(!$this->Checkflag){
                throw new Exception("管理者名の桁数は".$length."文字までです。");
            }

//             //値の形式が正しい物かどうか
//             $this->pregmatchCheck("/^[a-zA-Z0-9_.+-]+@([a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]*\.)+[a-zA-Z]{2,}$/u",$val);
//             if(!$this->Checkflag){
//                 throw new Exception("メールアドレスが正しいメールアドレスの形式ではありません。");
//             }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }

    /**
     * TenantID
     * テナントIDチェック
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function TenantID($val, $length, $required = NULL){
        try{

             //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("テナントIDが入力されていません。");
            }

            //桁数を超えていないか
            $this->maxlengthCheck($length,$val);
            if(!$this->Checkflag){
                throw new Exception("テナントIDの桁数は".$length."文字までです。");
            }

            //値の形式が正しい物かどうか
            $this->pregmatchCheck("/^T[0-9]{16}$/",$val);
            if(!$this->Checkflag){
                throw new Exception("テナントIDが正しい形式ではありません。");
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }

    /**
     * TenantID_Many
     * テナントIDチェック（単体）
     * @param array $valarr
     * @param int $length
     * @param boolian $required
     */
    public function TenantID_Many($valarr, $length, $required = NULL){
        try{
            foreach($valarr as $V){
                $this->TenantID($V,$length);
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }


    /**
     * CompanyID
     * 組織コードチェック（単体）
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function CompanyID($val, $length, $required = NULL){
        try{

             //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("組織コードが入力されていません。");
            }

            //桁数を超えていないか
            $this->maxlengthCheck($length,$val);
            if(!$this->Checkflag){
                throw new Exception("組織コードの桁数は".$length."文字までです。");
            }

            //値の形式が正しい物かどうか
            $this->pregmatchCheck("/^[a-zA-Z\d]+$/",$val);
            if(!$this->Checkflag){
                throw new Exception("組織コードは記号を含まない半角英数字（大文字小文字）のみ使用可能です。");
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }


    /**
     * CompanyID_Many
     * 組織コードチェック（単体）
     * @param array $valarr
     * @param int $length
     * @param boolian $required
     */
    public function CompanyID_Many($valarr, $length, $required = NULL){
        try{
            foreach($valarr as $V){
                $this->CompanyID($V,$length);
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }



    /**
     * Tell
     * 電話番号チェック
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function Tell($val, $length, $required = NULL){
        try{

             //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("電話番号が入力されていません。");
            }

            if(!empty($val)){
                //桁数を超えていないか
                $this->maxlengthCheck($length,$val);
                if(!$this->Checkflag){
                    throw new Exception("電話番号の桁数は".$length."文字までです。");
                }

                //値の形式が正しい物かどうか
                $this->pregmatchCheck("/^[\d-]+$/",$val);
                if(!$this->Checkflag){
                    throw new Exception("電話番号は半角数字のみ使用可能です。");
                }
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }


    /**
     * CellPhone
     * 携帯電話番号チェック
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function CellPhone($val, $length, $required = NULL){
        try{

             //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("携帯電話番号が入力されていません。");
            }

            if(!empty($val)){
                //桁数を超えていないか
                $this->maxlengthCheck($length,$val);
                if(!$this->Checkflag){
                    throw new Exception("携帯電話番号の桁数は".$length."文字までです。");
                }

                //値の形式が正しい物かどうか
                $this->pregmatchCheck("/^[\d-]+$/",$val);
                if(!$this->Checkflag){
                    throw new Exception("携帯電話番号は半角数字のみ使用可能です。");
                }
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }



    /**
     * AccessAuth
     * 権限チェック（管理者）
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function AccessAuth($val, $length, $required = NULL){
        try{

            //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("権限が入力されていません。");
            }

//             //桁数を超えていないか
//             $this->maxlengthCheck($length,$val);
//             if(!$this->Checkflag){
//                 throw new Exception("権限の桁数は".$length."文字までです。");
//             }

            //値の形式が正しい物かどうか
            $this->pregmatchCheck("/^[1-5]{1}$/",$val);
            if(!$this->Checkflag){
                throw new Exception("権限は半角数字1文字のみ使用可能です。");
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }



    /**
     * CompanyName
     * 組織名チェック
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function CompanyName($val, $length, $required = NULL){
        try{

            //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("組織名が入力されていません。");
            }

            //桁数を超えていないか
            $this->maxlengthCheck($length,$val);
            if(!$this->Checkflag){
                throw new Exception("組織名の桁数は".$length."文字までです。");
            }

            //             //値の形式が正しい物かどうか
            //             $this->pregmatchCheck("/^[a-zA-Z0-9_.+-]+@([a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]*\.)+[a-zA-Z]{2,}$/u",$val);
            //             if(!$this->Checkflag){
            //                 throw new Exception("メールアドレスが正しいメールアドレスの形式ではありません。");
            //             }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }


    /**
     * SignageTitle
     * 組織名チェック
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function SignageTitle($val, $length, $required = NULL){
        try{

            //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("会議名が入力されていません。");
            }

            //桁数を超えていないか
            $this->maxlengthCheck($length,$val);
            if(!$this->Checkflag){
                throw new Exception("会議名の桁数は".$length."文字までです。");
            }

            //             //値の形式が正しい物かどうか
            //             $this->pregmatchCheck("/^[a-zA-Z0-9_.+-]+@([a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]*\.)+[a-zA-Z]{2,}$/u",$val);
            //             if(!$this->Checkflag){
            //                 throw new Exception("メールアドレスが正しいメールアドレスの形式ではありません。");
            //             }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }


    /**
     * MailFrom
     * メール送信元チェック
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function MailFrom($val, $length, $required = NULL){
        try{

            //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("メール送信元が入力されていません。");
            }

            //桁数を超えていないか
            $this->maxlengthCheck($length,$val);
            if(!$this->Checkflag){
                throw new Exception("メール送信元の桁数は".$length."文字までです。");
            }

            //メールアドレスの形式が正しい物かどうか
            $this->MailPattern($val);
            if(!$this->Checkflag){
                throw new Exception("送信元メールアドレスが正しいメールアドレスの形式ではありません。");
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }


    /**
     * MailSubject
     * メールタイトルチェック
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function MailSubject($val, $length, $required = NULL){
        try{

            //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("メールタイトルが入力されていません。");
            }

            //桁数を超えていないか
            $this->maxlengthCheck($length,$val);
            if(!$this->Checkflag){
                throw new Exception("メールタイトルの桁数は".$length."文字までです。");
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }

    /**
     * MailHead
     * メールヘッダー文章チェック
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function MailHead($val, $length, $required = NULL){
        try{

            //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("メールヘッダーが入力されていません。");
            }

            //桁数を超えていないか
            $this->maxlengthCheck($length,$val);
            if(!$this->Checkflag){
                throw new Exception("メールヘッダーの桁数は".$length."文字までです。");
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }



    /**
     * MailBody
     * メール本文チェック
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function MailBody($val, $length, $required = NULL){
        try{

            //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("メール本文が入力されていません。");
            }

            //桁数を超えていないか
            $this->maxlengthCheck($length,$val);
            if(!$this->Checkflag){
                throw new Exception("メール本文の桁数は".$length."文字までです。");
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }

    /**
     * MailFoot
     * メールフッターチェック
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function MailFoot($val, $length, $required = NULL){
        try{

            //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("メールフッターが入力されていません。");
            }

            //桁数を超えていないか
            $this->maxlengthCheck($length,$val);
            if(!$this->Checkflag){
                throw new Exception("メールフッターの桁数は".$length."文字までです。");
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }


    /**
     * MailBCC
     * BCCチェック
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function MailBCC($val, $length, $required = NULL){
        try{

            //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("BCCが入力されていません。");
            }

            if($val != ""){
                //桁数を超えていないか
                $this->maxlengthCheck($length,$val);
                if(!$this->Checkflag){
                    throw new Exception("BCCの桁数は".$length."文字までです。");
                }

                //メールアドレスの形式が正しい物かどうか
                $this->MailPattern($val);
                if(!$this->Checkflag){
                    throw new Exception("BCCが正しいメールアドレスの形式ではありません。");
                }
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }


    /**
     * InfoTitle
     * お知らせタイトル
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function InfoTitle($val, $length, $required = NULL){
        try{

            //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("お知らせタイトルが入力されていません。");
            }

            if($val != ""){
                //桁数を超えていないか
                $this->maxlengthCheck($length,$val);
                if(!$this->Checkflag){
                    throw new Exception("お知らせタイトルの桁数は".$length."文字までです。");
                }

            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }


    /**
     * InfoContent
     * お知らせ本文
     * @param string $val
     * @param int $length
     * @param boolian $required
     */
    public function InfoContent($val, $length, $required = NULL){
        try{

            //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("お知らせ本文が入力されていません。");
            }

            if($val != ""){
                //桁数を超えていないか
                $this->maxlengthCheck($length,$val);
                if(!$this->Checkflag){
                    throw new Exception("お知らせ本文の桁数は".$length."文字までです。");
                }

            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }


    /**
     * Years
     * 祝日年次
     * @param string $val
     */
    public function Years($val){
        try{

            if($val != ""){

                //値の形式が正しい物かどうか
                $this->pregmatchCheck("/^[\d]{4}$/",$val);
                if(!$this->Checkflag){
                    throw new Exception("設定可能な年次は半角数字4桁です。");
                }

                //正しい日付かどうか
                $this->dateCheck($val.'0101');
                if(!$this->Checkflag){
                    throw new Exception("正しい年次ではありません。");
                }

            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }


    /**
     * Holiday
     * 祝日
     * @param string $val
     */
    public function Holiday($val){
        try{

            if($val != ""){
                //桁数を超えていないか
                $this->dateCheck($val);
                if(!$this->Checkflag){
                    throw new Exception("正しい日付ではありません。");
                }
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }


    /**
     * PCMode
     * パスワード設定モード
     * @param string $val
     */
    public function PCMode($val, $length, $required = NULL){
        try{

            //空欄かどうか
            if(!is_null($required)) $this->emptyCheck($val);
            if(!$this->Checkflag){
                throw new Exception("パスワード更新モードが選択されていません。");
            }

            //値の形式が正しい物かどうか
            $this->pregmatchCheck("/^[\d]{1}$/",$val);

            if(!$this->Checkflag){
                throw new Exception("設定可能な数値は半角数字1桁です。");
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }



    /**
     * PCLifeCycle
     * パスワード設定モード
     * @param string $val
     */
    public function PCLifeCycle($val, $length, $required = NULL){
        try{

            if($val != ""){

                //空欄かどうか
                if(!is_null($required)) $this->emptyCheck($val);
                if(!$this->Checkflag){
                    throw new Exception("パスワード更新サイクルが選択されていません。");
                }
                //値の形式が正しい物かどうか
                $this->pregmatchCheck("/^[\d]{1,11}$/",$val);
                if(!$this->Checkflag){
                    throw new Exception("設定可能な数値は半角数字です。");
                }
            }

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
    }


    private function emptyCheck($val){
        if($val === false || $val === null || $val === '' || $val === array()){
            $this->Checkflag = FALSE;
//             $this->Msg[] = "empty.";
        }
    }

    private function byteCheck($len,$val){
        if(strlen($val) > $len){
            $this->Checkflag = FALSE;
//             $this->Msg[] = "byte over.";
        }
    }

    private function maxlengthCheck($len,$val){
        if(mb_strlen($val) > $len){
            $this->Checkflag = FALSE;
//             $this->Msg[] = "length over.";
        }
    }

    private function pregmatchCheck($pattern,$val){
        if(!preg_match($pattern, $val)){
            $this->Checkflag = FALSE;
//             $this->Msg[] = "match failed.";
        }
    }

    private function dateCheck($date){
        $y = substr($date, 0, 4);
        $m = substr($date, 4, 2);
        $d = substr($date, 6, 2);

        if(checkdate($m, $d, $y) === false){
            $this->Checkflag = FALSE;
        }
    }


    private function MailPattern($val){
        $pattern = "/^[a-zA-Z0-9_.+-]+@([a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]*\.)+[a-zA-Z]{2,}$/u";
        $this->pregmatchCheck($pattern, $val);
    }
}

?>
