<?
/**
 * デバイス管理画面
 */
require("core/construct.php");

require(CORE_PATH."basic.php");
require(CORE_PATH."functions.php");
require(CORE_PATH."session_check.php");
require(CORE_PATH."authorize.php");

require_once(AD_MDL_PATH."model.php");
$adMDL = new admModel($sdb, $link);

require_once(SN_MDL_PATH."model.php");
$sgMDL = new sngModel($sdb, $link);

// //　ログインユーザー情報
$DeviceList = $sgMDL->GetDeviceTbl();
$page = "device.php";

$DeviceTypeList = GetDeviceTypeList();

$TenantList = $adMDL->GetTenantList();
$FieldList = $adMDL->GetFieldList();

$GET = filterGet();
$POST = filterPost();

$isEdit = False;
$isRegist = False;

try{


    if(isset($GET['m']))
    {
        $mes = GetMsgDecode($GET['m']);
    }

    if(isset($_GET['c']))
    {

        switch($_GET['c'])
        {
            case 'n':

                $isRegist = True;
                break;

            case 'regist':

                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }

                if(trim($POST['device_id']) === "") throw new Exception("デバイスIDを入力してください。");
                if(preg_match('/^[0-9a-zA-Z\-_]{1,32}$/', $POST['device_id']) == 0) throw new Exception("デバイスIDは32文字以内の半角英数字で入力してください。");

                if(trim($POST['tenant_id']) === "") throw new Exception("テナントを選択してください。");

                if(trim($POST['field_id']) === "") throw new Exception("エリアを選択してください。");

                if(trim($POST['device_num']) !== "" && preg_match('/^[0-9]*$/', $POST['device_num']) == 0) throw new Exception("デバイス番号は半角数字で入力してください。");

                if(trim($POST['name']) === "") throw new Exception("デバイス名を入力してください。");
                if(mb_strlen($POST['name']) > 128) throw new Exception("デバイス名は128文字以内です。");

                if(trim($POST['x_pos']) === "") throw new Exception("エリアX座標を入力してください。");
                if(trim($POST['y_pos']) === "") throw new Exception("エリアY座標を入力してください。");

                if(trim($POST['type']) === "") throw new Exception("デバイス種別を入力してください。");


                $prm = [
                    'device_id' => $POST['device_id'],
                    'du_id' => TransDeviceUniqId($POST['type'],$POST['device_id']),
                    'device_num' => $POST['device_num'],
                    'tenant_id' => $POST['tenant_id'],
                    'field_id' => $POST['field_id'],
                    'name' => $POST['name'],
                    'x_pos' => $POST['x_pos'],
                    'y_pos' => $POST['y_pos'],
                    'type' => $POST['type'],
                ];

                $ins_ret = $sgMDL->InsertDeviceData($prm);
                if(!$ins_ret) throw new Exception("デバイス情報の登録が失敗しました。");

                $mes = GetMsgEncode("デバイス情報を登録しました。");
                header( 'Location: ' . $page.'?m='.$mes);
                exit;

                break;

            case 'e':
                if(!isset($GET['id'])) throw new Exception("デバイスIDが指定されていません。");

                $edit_id = $GET['id'];

                $DeviceInfo = $sgMDL->GetDeviceTblByDeviceUniqID($edit_id);
                if(!$DeviceInfo) throw new Exception("指定されたデバイスは存在しません。");

                $isEdit = True;
                break;

            case 'edit':

                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }

                if(!isset($GET['id'])) throw new Exception("デバイスユニークIDが指定されていません。");
                $edit_id = $GET['id'];

                $DeviceInfo = $sgMDL->GetDeviceTblByDeviceUniqID($edit_id);
                if(!$DeviceInfo) throw new Exception("指定されたデバイスは存在しません。");

                if(trim($POST['tenant_id']) === "") throw new Exception("テナントを選択してください。");

                if(trim($POST['field_id']) === "") throw new Exception("エリアを選択してください。");

                if(trim($POST['device_num']) !== "" && preg_match('/^[0-9]*$/', $POST['device_num']) == 0) throw new Exception("デバイス番号は半角数字で入力してください。");

                if(trim($POST['name']) === "") throw new Exception("デバイス名を入力してください。");
                if(mb_strlen($POST['name']) > 128) throw new Exception("デバイス名は128文字以内です。");

                if(trim($POST['x_pos']) === "") throw new Exception("エリアX座標を入力してください。");
                if(trim($POST['y_pos']) === "") throw new Exception("エリアY座標を入力してください。");

//                 if(trim($POST['type']) === "") throw new Exception("デバイス種別を入力してください。");


                $prm = [
                    'device_num' => $POST['device_num'],
                    'tenant_id' => $POST['tenant_id'],
                    'field_id' => $POST['field_id'],
                    'name' => $POST['name'],
                    'x_pos' => $POST['x_pos'],
                    'y_pos' => $POST['y_pos'],
                    'type' => $DeviceInfo['type'],
                    'du_id' => $edit_id,
                ];

                $up_ret = $sgMDL->UpdateDeviceData($prm);
                if(!$up_ret) throw new Exception("デバイス情報の更新が失敗しました。");

                $mes = GetMsgEncode("デバイス情報を更新しました。");
                header( 'Location: ' . $page.'?m='.$mes);
                exit;

                break;

            case 'd':
                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }

                if(!isset($POST['du_id'])) throw new Exception("デバイスユニークIDが指定されていません。");

                $du_id = $POST['du_id'];

                $del_ret = $sgMDL->DeleteDeviceData($du_id);
                if(!$del_ret) throw new Exception("デバイス情報の削除に失敗しました。");

                $mes = GetMsgEncode("デバイス情報を削除しました。");
                header( 'Location: ' . $page.'?m='.$mes);
                exit;

                break;
        }
    }
}catch(Exception $e){
    $mes = GetMsgEncode($e->getMessage());
    header( 'Location: ' . $page.'?m='.$mes.'&err');
    exit;
}

// var_dump($DeviceList);

$msg_stt = (isset($GET['err']))? "danger" : "success";
$message_tag = ($mes != '')?'<div class="alert alert-'.$msg_stt.'" role="alert">'.$mes.'</div>':'';

$required_tag = '<span class="badge badge-danger">必須</span>';
$page_title = "管理画面　デバイス情報管理";

$onetime_token = createToken();

include(PARTS_PATH."header.php");


?>
    <body>
        <div id="Wrap">

        <? include(PARTS_PATH.'header-nav.php'); ?>
            <div class="wrapper">

                <? include(PARTS_PATH.'sidemenu.php'); ?>
                <main class="">

                    <div class="container grid">

                        <nav class="page-header">
                            <div class="container-fluid">
                                <div class="navbar-wrapper">
                                    <h2><span class="svg-wrap mr10"><svg class="img-fluid"><use xlink:href="./asset/img/setting.svg#Setting"></use></svg></span>デバイス情報管理</h2>
                                </div>
                            </div>
                        </nav>

                        <?=$message_tag ?>


                        <?php if($isEdit): ?>

                        <section id="EditTenant" class="page-contents">
                            <div><h3>デバイス情報編集フォーム</h3></div>
                            <div class="card-wrapper">
                                <form action="<?=$page ?>?c=edit&id=<?=h($edit_id) ?>" method="POST">
                                    <input type="hidden" name="one_time_token" value="<?=$onetime_token?>"/>

                                    <div class="form-group row">
                                        <div class="col-3">デバイスID <?=$required_tag ?></div>
                                        <div class="col-5"><?=h($DeviceInfo['device_id']) ?></div>
                                        <div class="d-inline-block col-4"></div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">登録テナント <?=$required_tag ?></div>

                                        <div class="col-5">
                                        <?php if($TenantList): ?>
                                        <select name="tenant_id" id="TenantID" class="form-control">
                                            <?php foreach($TenantList as $tlK => $tlV):
                                            $t_selected = ($DeviceInfo['tenant_id'] == $tlV['id'])?"selected":""; ?>
                                                <option value="<?=h($tlV['id']) ?>" <?=$t_selected ?>><?=h($tlV['name']) ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <?php else: ?>

                                        ※テナントが登録されていません

                                        <?php endif; ?>
                                        </div>

                                        <div class="d-inline-block col-4">ユーザーを登録するテナントを選択してください。</div>
                                    </div>

                                    <hr />


                                    <div class="form-group row">
                                        <div class="col-3">エリア選択 <?=$required_tag ?></div>

                                        <div class="col-5">
                                        <?php if($FieldList): ?>
                                        <select name="field_id" id="FieldID" class="form-control">
                                            <?php foreach($FieldList as $flK => $flV):
                                            $f_selected = ($DeviceInfo['field_id'] == $flV['field_id'])?"selected":""; ?>
                                                <option value="<?=h($flV['field_id']) ?>" <?=$f_selected ?>><?=h($flV['field_name']) ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <?php else: ?>

                                        ※エリアが登録されていません

                                        <?php endif; ?>
                                        </div>

                                        <div class="d-inline-block col-4">デバイスが設置されているエリアを選択してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">デバイス表示番号</div>
                                        <input class="form-control col-5" type="text" name="device_num" id="DeviceNum" placeholder="デバイス表示番号" value="<?=h($DeviceInfo['device_num']) ?>"/>
                                        <div class="d-inline-block col-4">デバイスを表示する番号を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">デバイス名 <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="name" id="Name" placeholder="デバイスの名前" value="<?=h($DeviceInfo['name']) ?>" required/>
                                        <div class="d-inline-block col-4">デバイス名を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">デバイス設置位置　X座標</div>
                                        <input class="form-control col-5" type="number" step="0.001" name="x_pos" id="Xpos" placeholder="0" value="<?=h($DeviceInfo['x_pos']) ?>" required/>
                                        <div class="d-inline-block col-4">デバイスのX座標を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">デバイス設置位置　Y座標</div>
                                        <input class="form-control col-5" type="number" step="0.001" name="y_pos" id="Ypos" placeholder="0" value="<?=h($DeviceInfo['y_pos']) ?>" required/>
                                        <div class="d-inline-block col-4">デバイスのY座標を入力してください。</div>
                                    </div>

                                    <hr />

<!--


                                    <div class="form-group row">
                                        <div class="col-3">デバイス種別</div>

                                        <div class="col-5">
                                        <?php foreach($DeviceTypeList as $dtlK => $dtlV):
                                        $checked = ($DeviceInfo['type'] == $dtlV)?"checked":"";
                                        ?>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="type" id="Type<?=$dtlK ?>" value="<?=$dtlV ?>" <?=$checked ?>/>
                                                <label class="form-check-label" for="Type<?=$dtlK ?>">
                                                    <?=h($dtlV) ?>
                                                </label>
                                            </div>
                                        <?php endforeach; ?>
                                        </div>

                                        <div class="d-inline-block col-4">デバイスの種類を選択してください。</div>
                                    </div>

                                    <hr />
 -->

                                    <div class="tcenter">
                                        <button type="submit" class="btn btn-primary">更新</button>
                                        <a href="<?=$page ?>" class="btn btn-default btn-outline-dark">キャンセル</a>
                                    </div>

                                </form>
                            </div>
                        </section>


                        <?php elseif($isRegist): ?>


                        <section id="RegistUser" class="page-contents">
                            <div><h3>デバイス情報登録フォーム</h3></div>
                            <div class="card-wrapper">
                                <form action="<?=$page ?>?c=regist" method="POST">
                                    <input type="hidden" name="one_time_token" value="<?=$onetime_token?>"/>

                                    <div class="form-group row">
                                        <div class="col-3">デバイスID <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="device_id" id="DeviceID" placeholder="デバイスID" value="" required/>
                                        <div class="d-inline-block col-4">デバイスIDを入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">登録テナント <?=$required_tag ?></div>

                                        <div class="col-5">
                                        <?php if($TenantList): ?>
                                        <select name="tenant_id" id="TenantID" class="form-control">
                                            <?php foreach($TenantList as $tlK => $tlV):　?>
                                                <option value="<?=h($tlV['id']) ?>"><?=h($tlV['name']) ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <?php else: ?>

                                        ※テナントが登録されていません

                                        <?php endif; ?>
                                        </div>

                                        <div class="d-inline-block col-4">ユーザーを登録するテナントを選択してください。</div>
                                    </div>

                                    <hr />


                                    <div class="form-group row">
                                        <div class="col-3">エリア選択 <?=$required_tag ?></div>

                                        <div class="col-5">
                                        <?php if($FieldList): ?>
                                        <select name="field_id" id="FieldID" class="form-control">
                                            <?php foreach($FieldList as $flK => $flV):　?>
                                                <option value="<?=h($flV['field_id']) ?>"><?=h($flV['field_name']) ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <?php else: ?>

                                        ※エリアが登録されていません

                                        <?php endif; ?>
                                        </div>

                                        <div class="d-inline-block col-4">デバイスが設置されているエリアを選択してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">デバイス表示番号</div>
                                        <input class="form-control col-5" type="text" name="device_num" id="DeviceNum" placeholder="デバイス表示番号" value=""/>
                                        <div class="d-inline-block col-4">デバイスを表示する番号を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">デバイス名 <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="name" id="Name" placeholder="デバイスの名前" value="" required/>
                                        <div class="d-inline-block col-4">デバイス名を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">デバイス設置位置　X座標</div>
                                        <input class="form-control col-5" type="number" step="0.001" name="x_pos" id="Xpos" placeholder="0" value="" required/>
                                        <div class="d-inline-block col-4">デバイスのX座標を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">デバイス設置位置　Y座標</div>
                                        <input class="form-control col-5" type="number" step="0.001" name="y_pos" id="Ypos" placeholder="0" value="" required/>
                                        <div class="d-inline-block col-4">デバイスのY座標を入力してください。</div>
                                    </div>

                                    <hr />


                                    <div class="form-group row">
                                        <div class="col-3">デバイス種別</div>

                                        <div class="col-5">
                                        <?php foreach($DeviceTypeList as $dtlK => $dtlV): ?>
                                            <div class="form-check">
                                                <input class="form-check-input" type="radio" name="type" id="Type<?=$dtlK ?>" value="<?=$dtlV ?>"/>
                                                <label class="form-check-label" for="Type<?=$dtlK ?>">
                                                    <?=h($dtlV) ?>
                                                </label>
                                            </div>
                                        <?php endforeach; ?>
                                        </div>

                                        <div class="d-inline-block col-4">デバイスの種類を選択してください。</div>
                                    </div>

                                    <hr />

                                    <div class="tcenter">
                                        <button type="submit" class="btn btn-primary">登録</button>
                                        <a href="<?=$page ?>" class="btn btn-default btn-outline-dark">キャンセル</a>
                                    </div>

                                </form>
                            </div>
                        </section>

                        <?php else: ?>

                        <section id="TenantManage" class="page-contents">
                            <div><h3>デバイス一覧リスト</h3></div>
                            <div class="card-wrapper">
                                <div class="adduser-wrapper　">
                                    <a href="<?=$page ?>?c=n" class="btn btn-primary btn-sm">新規デバイス登録</a>
                                </div>
                                <div class="table-wrapper">
                                    <table id="TenantListTable" class="table">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th class="th_num" scope="col">#</th>
                                                <th class="th_deviceid" scope="col">デバイスID</th>
                                                <th class="th_duid" scope="col">デバイスユニークID</th>
                                                <th class="th_tenantid" scope="col">テナントID</th>
                                                <th class="th_fieldid" scope="col">エリアID</th>
                                                <th class="th_devicename" scope="col">デバイス名</th>
                                                <th class="th_type" scope="col">デバイス種別</th>
                                                <th class="th_status" scope="col">ステータス</th>
                                                <th class="th_control" scope="col">操作</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <?php foreach($DeviceList as $dlK => $dlV):
                                        switch($dlV['status']){
                                            case ACCOUNT_STATUS_LOCK:
                                                $status = "ロック";
                                                break;
                                            case ACCOUNT_STATUS_OK:
                                                $status = "通常";
                                                break;
                                        }
                                        ?>
                                            <tr>
                                                <td><?=h($dlV['num']) ?></td>
                                                <td><?=h($dlV['device_id']) ?></td>
                                                <td><?=h($dlV['du_id']) ?></td>
                                                <td><?=h($dlV['tenant_id']) ?></td>
                                                <td><?=h($dlV['field_id']) ?></td>
                                                <td><?=h($dlV['name']) ?></td>
                                                <td><?=h($dlV['type']) ?></td>
                                                <td><?=$status ?></td>
                                                <td>
                                                    <a href="<?=$page ?>?c=e&id=<?=h($dlV['du_id']) ?>" class="btn btn-sm btn-primary">編集</a>
                                                    <button class="btn btn-sm btn-danger" data-toggle="modal" data-target="#modal-tenantdelete" data-whatever="<?=$dlV['du_id']?>">削除</button>
                                                </td>
                                            </tr>
                                        <?php endforeach;?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                        </section>

                        <?php endif; ?>
                    </div>
                </main>
            </div>
        <? //include(PARTS_PATH.'footer.php'); ?>
        </div>
    </body>
    <!-- /container -->


    <!-- モーダル　デバイス情報削除 -->
    <div class="modal fade" id="modal-tenantdelete" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-label">デバイス情報削除</h4>
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>このデバイス情報を削除しますか？</p>
                    <form id="user_delete" action="<?=$page?>?c=d" method="post">
                        <input type="hidden" name="one_time_token" value="<?=$onetime_token ?>"/>
                        <div class="form-group">
                            <label for="recipient-name" class="form-control-label">デバイスID:</label>
                            <input type="text" class="form-control" id="DeleteTenantID" name="du_id" readonly="readonly" required>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-danger">削除する</button>
                            <button type="cancel" class="btn btn-default btn-outline-dark" data-dismiss="modal">中止</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <script>
        $(function(){

            $('#modal-tenantdelete').on('show.bs.modal', function(event) {
                var recipient = $(event.relatedTarget).data('whatever');
                $(this).find('.modal-body #DeleteTenantID').val(recipient);
            });


            // datatableの設定を変更
            $("#TenantListTable").DataTable({
                searching: false,
                info: false,
                lengthChange: false,
                columnDefs: [
                      { "targets": 0, "width": '5%'},
                      { "targets": 1, "width": '6%'},
                      { "targets": 2, "width": '8%'},
                      { "targets": 3, "width": '13%'},
                      { "targets": 4, "width": '15%'},
                      { "targets": 5, "width": '18%'},
                      { "targets": 6, "width": '15%'},
                      { "targets": 7, "width": '13%'},
                      { "targets": 8, "width": '17%',"orderable": false},
                    ],
            });
        });
    </script>

</html>