<?
/**
 * デバイス管理画面
 */
require("core/construct.php");

require(CORE_PATH."basic.php");
require(CORE_PATH."functions.php");
require(CORE_PATH."session_check.php");
require(CORE_PATH."authorize.php");

require_once(AD_MDL_PATH."model.php");
$adMDL = new admModel($sdb, $link);

require_once(SN_MDL_PATH."model.php");
$sgMDL = new sngModel($sdb, $link);

require_once(__DIR__."/util/utils.php");

$device_type = DEVICE_TYPE_LIGHT;

// //　ログインユーザー情報
$DeviceList = [];
$d_row = $sgMDL->GetDeviceTblForDeviceType($device_type);
if($d_row){
    foreach($d_row as $dK => $dV){
        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
            if($dV['tenant_id'] != $_SESSION['admin']['tenant_id']){
                continue;
            }
        }
        $DeviceList[] = $dV;
        if(!in_array($dV['field_id'],$FieldList)) $FieldList[] = $dV['field_id'];
    }

}

$FieldList = [];
$FieldNameList = [];
$a_row = $adMDL->GetFieldList();
if($a_row){
    foreach($a_row as $aV){

        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
            if($aV['tenant_id'] != $_SESSION['admin']['tenant_id']){
                continue;
            }
        }
        $FieldList[] = $aV;
        $FieldNameList[$aV['field_id']] = $aV['field_name'];
    }
}
$page = "device_light.php";

// $DeviceTypeList = GetDeviceTypeList();

$TenantList=[];
$t_row = $adMDL->GetTenantList();
if($t_row){
    foreach($t_row as $tK => $tV){
        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
            if($tV['id'] != $_SESSION['admin']['tenant_id']){
                continue;
            }
        }
        $TenantList[] = $tV;
    }
}

$GET = filterGet();
$POST = filterPost();

$isEdit = False;
$isRegist = False;
$isView = False;
$isCSVRegist = False;

$login_user = $_SESSION['admin']['admin_id'];

try{


    if(isset($GET['m']))
    {
        $mes = GetMsgDecode($GET['m']);
    }

    if(isset($_GET['c']))
    {

        switch($_GET['c'])
        {
            case 'v':
                if(!isset($GET['id'])) throw new Exception("デバイスIDが指定されていません。");

                $edit_id = $GET['id'];

                $DeviceInfo = $sgMDL->GetDeviceTblByDeviceUniqID($edit_id);
                if(!$DeviceInfo) throw new Exception("指定されたデバイスは存在しません。");

                $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => '照明デバイス情報', 'editId' => $edit_id));
                $isView = True;
                break;

            case 'n':
                if(!CheckAuthorize($Authorize, [ACCOUNT_AUTHOR_OWNER, ACCOUNT_AUTHOR_BUILDING])) throw new Exception("操作に必要な権限がありません。");
                $isRegist = True;

                $FieldList = [];
                $a_row = $adMDL->GetFieldList();
                if($a_row){
                    foreach($a_row as $aV){

                        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
                            if($aV['tenant_id'] != $_SESSION['admin']['tenant_id']){
                                continue;
                            }
                        }
                        $FieldList[] = $aV;
                    }
                }

                $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => '照明デバイス情報登録フォーム'));
                break;

            case 'regist':
                if(!CheckAuthorize($Authorize, [ACCOUNT_AUTHOR_OWNER, ACCOUNT_AUTHOR_BUILDING])) throw new Exception("操作に必要な権限がありません。");

                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }

                if(trim($POST['device_id']) === "") throw new Exception("デバイスIDを入力してください。");
                if(preg_match('/^[0-9a-zA-Z\-_]{1,32}$/', $POST['device_id']) == 0) throw new Exception("デバイスIDは32文字以内の半角英数字で入力してください。");

                if(trim($POST['tenant_id']) === "") throw new Exception("テナントを選択してください。");

                if(trim($POST['field_id']) === "") throw new Exception("エリアを選択してください。");

                if(trim($POST['device_num']) !== "" && preg_match('/^[0-9]*$/', $POST['device_num']) == 0) throw new Exception("デバイス番号は半角数字で入力してください。");

                if(trim($POST['name']) === "") throw new Exception("デバイス名を入力してください。");
                if(mb_strlen($POST['name']) > 128) throw new Exception("デバイス名は128文字以内です。");

                if(trim($POST['x_pos']) === "") throw new Exception("エリアX座標を入力してください。");
                if(trim($POST['y_pos']) === "") throw new Exception("エリアY座標を入力してください。");

                if(trim($POST['type']) === "") throw new Exception("デバイス種別を入力してください。");


                $prm = [
                    'device_id' => $POST['device_id'],
                    'du_id' => TransDeviceUniqId($POST['type'],$POST['device_id']),
                    'device_num' => $POST['device_num'],
                    'tenant_id' => $POST['tenant_id'],
                    'field_id' => $POST['field_id'],
                    'name' => $POST['name'],
                    'x_pos' => $POST['x_pos'],
                    'y_pos' => $POST['y_pos'],
                    'type' => $POST['type'],
                ];

                $ins_ret = $sgMDL->InsertDeviceData($prm);
                if(!$ins_ret) throw new Exception("デバイス情報の登録が失敗しました。");

                $log->info("Successful device registration.",array('file' => __FILE__, 'userId' => $login_user, 'data' => $prm));
                $mes = GetMsgEncode("デバイス情報を登録しました。");
                header( 'Location: ' . $page.'?m='.$mes);
                exit;

                break;


            case 'csv':
                if(!CheckAuthorize($Authorize, [ACCOUNT_AUTHOR_OWNER, ACCOUNT_AUTHOR_BUILDING])) throw new Exception("操作に必要な権限がありません。");

                $TenantList=[];
                $t_row = $adMDL->GetTenantList();
                if($t_row){
                    foreach($t_row as $tK => $tV){
                        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
                            if($tV['id'] != $_SESSION['admin']['tenant_id']){
                                continue;
                            }
                        }
                        $TenantList[] = $tV;
                    }
                }

                $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'CSV一括登録フォーム'));
                $isCSVRegist = True;
                break;

            case 'csv_regist':
                if(!CheckAuthorize($Authorize, [ACCOUNT_AUTHOR_OWNER, ACCOUNT_AUTHOR_BUILDING])) throw new Exception("操作に必要な権限がありません。");
                $targetFolder = 'admin/tmp'; //アップロード先フォルダを指定します。
                $readDataLimit = 100; //読み込みデータ限界
                $filename = 'device_list';

                $FieldIDList = [];
                $a_row = $adMDL->GetFieldList();
                if($a_row){
                    foreach($a_row as $aV){
                        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
                            if($aV['tenant_id'] != $_SESSION['admin']['tenant_id']){
                                continue;
                            }
                        }
                        $FieldIDList[$aV['field_id']] = $aV;
                    }
                }

                require(CORE_PATH."csv_input.php");

                $data = $csv_arr;
                $ins_ret = $sgMDL->InsertCSVMultiDeviceData($data);
                if(!$ins_ret) throw new Exception("デバイスの一括登録・編集に失敗しました。");

                $log->info("Successful CSV bulk registration.",array('file' => __FILE__, 'userId' => $login_user, 'data' => $data));
                $mes = GetMsgEncode("デバイスの一括登録・編集が完了しました。");
                header( 'Location: ' . $page.'?m='.$mes);
                exit;

                break;

            case 'e':
                if(!CheckAuthorize($Authorize, [ACCOUNT_AUTHOR_OWNER, ACCOUNT_AUTHOR_BUILDING])) throw new Exception("操作に必要な権限がありません。");

                if(!isset($GET['id'])) throw new Exception("デバイスIDが指定されていません。");

                $edit_id = $GET['id'];

                $DeviceInfo = $sgMDL->GetDeviceTblByDeviceUniqID($edit_id);
                if(!$DeviceInfo) throw new Exception("指定されたデバイスは存在しません。");

                $FieldList = [];
                $a_row = $adMDL->GetFieldList();
                if($a_row){
                    foreach($a_row as $aV){

                        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
                            if($aV['tenant_id'] != $_SESSION['admin']['tenant_id']){
                                continue;
                            }
                        }
                        $FieldList[] = $aV;
                    }
                }

                $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => '照明デバイス情報編集フォーム', 'editId' => $edit_id));
                $isEdit = True;
                break;

            case 'edit':
                if(!CheckAuthorize($Authorize, [ACCOUNT_AUTHOR_OWNER, ACCOUNT_AUTHOR_BUILDING])) throw new Exception("操作に必要な権限がありません。");

                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }

                if(!isset($GET['id'])) throw new Exception("デバイスユニークIDが指定されていません。");
                $edit_id = $GET['id'];

                $DeviceInfo = $sgMDL->GetDeviceTblByDeviceUniqID($edit_id);
                if(!$DeviceInfo) throw new Exception("指定されたデバイスは存在しません。");

                if(trim($POST['tenant_id']) === "") throw new Exception("テナントを選択してください。");

                if(trim($POST['field_id']) === "") throw new Exception("エリアを選択してください。");

                if(trim($POST['device_num']) !== "" && preg_match('/^[0-9]*$/', $POST['device_num']) == 0) throw new Exception("デバイス番号は半角数字で入力してください。");

                if(trim($POST['name']) === "") throw new Exception("デバイス名を入力してください。");
                if(mb_strlen($POST['name']) > 128) throw new Exception("デバイス名は128文字以内です。");

                if(trim($POST['x_pos']) === "") throw new Exception("エリアX座標を入力してください。");
                if(trim($POST['y_pos']) === "") throw new Exception("エリアY座標を入力してください。");

//                 if(trim($POST['type']) === "") throw new Exception("デバイス種別を入力してください。");


                $prm = [
                    'device_num' => $POST['device_num'],
                    'tenant_id' => $POST['tenant_id'],
                    'field_id' => $POST['field_id'],
                    'name' => $POST['name'],
                    'x_pos' => $POST['x_pos'],
                    'y_pos' => $POST['y_pos'],
                    'type' => $DeviceInfo['type'],
                    'du_id' => $edit_id,
                ];

                $up_ret = $sgMDL->UpdateDeviceData($prm);
                if(!$up_ret) throw new Exception("デバイス情報の更新が失敗しました。");

                $log->info("Successful device update.",array('file' => __FILE__, 'userId' => $login_user, 'data' => $prm));
                $mes = GetMsgEncode("デバイス情報を更新しました。");
                header( 'Location: ' . $page.'?m='.$mes);
                exit;

                break;

            case 'd':
                if(!CheckAuthorize($Authorize, [ACCOUNT_AUTHOR_OWNER, ACCOUNT_AUTHOR_BUILDING])) throw new Exception("操作に必要な権限がありません。");

                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }

                if(!isset($POST['num'])) throw new Exception("デバイス番号が指定されていません。");

                $num = $POST['num'];

                $del_ret = $sgMDL->DeleteDeviceData($num);
                if(!$del_ret) throw new Exception("デバイス情報の削除に失敗しました。");

                $log->info("Successful device delete.",array('file' => __FILE__, 'userId' => $login_user, 'deleteNum' => $num));
                $mes = GetMsgEncode("デバイス情報を削除しました。");
                header( 'Location: ' . $page.'?m='.$mes);
                exit;

                break;
        }
    } else {
        $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => '照明デバイス一覧リスト'));
    }
}catch(Exception $e){
    $mes = GetMsgEncode($e->getMessage());
    // 確認
    $log->info($e);
    $log->info("Failed to device operation.", array('file' => __FILE__, 'userId' => $login_user, 'message' => $e->getMessage()));
    header( 'Location: ' . $page.'?m='.$mes.'&err');
    exit;
}

// var_dump($DeviceList);

$msg_stt = (isset($GET['err']))? "danger" : "success";
$message_tag = ($mes != '')?'<div class="alert alert-'.$msg_stt.'" role="alert">'.$mes.'</div>':'';

$required_tag = '<span class="badge badge-danger">必須</span>';
$page_title = "管理画面　デバイス情報管理　照明";

$onetime_token = createToken();

include(PARTS_PATH."header.php");


?>
    <body>
        <div id="Wrap">

        <? include(PARTS_PATH.'header-nav.php'); ?>
            <div class="wrapper">

                <? include(PARTS_PATH.'sidemenu.php'); ?>
                <main class="">

                    <div class="container grid">

                        <nav class="page-header">
                            <div class="container-fluid">
                                <div class="navbar-wrapper">
                                    <h2><span class="svg-wrap mr10"><svg class="img-fluid"><use xlink:href="./asset/img/setting.svg#Setting"></use></svg></span>デバイス情報管理</h2>
                                </div>
                            </div>
                        </nav>

                        <?=$message_tag ?>


                        <?php if($isEdit): ?>

                        <section id="EditTenant" class="page-contents">
                            <div><h3>照明デバイス情報編集フォーム</h3></div>
                            <div class="card-wrapper">
                                <form action="<?=$page ?>?c=edit&id=<?=h($edit_id) ?>" method="POST">
                                    <input type="hidden" name="one_time_token" value="<?=$onetime_token?>"/>

                                    <div class="form-group row">
                                        <div class="col-3">デバイスID <?=$required_tag ?></div>
                                        <div class="col-5"><?=h($DeviceInfo['device_id']) ?></div>
                                        <div class="d-inline-block col-4"></div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">デバイスユニークID</div>
                                        <div class="col-9"><?=h($DeviceInfo['du_id']) ?></div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">登録テナント <?=$required_tag ?></div>

                                        <div class="col-5">
                                        <?php if($TenantList): ?>
                                        <select name="tenant_id" id="TenantID" class="form-control">
                                            <?php foreach($TenantList as $tlK => $tlV):
                                            $t_selected = ($DeviceInfo['tenant_id'] == $tlV['id'])?"selected":""; ?>
                                                <option value="<?=h($tlV['id']) ?>" <?=$t_selected ?>><?=h($tlV['name']) ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <?php else: ?>

                                        ※テナントが登録されていません

                                        <?php endif; ?>
                                        </div>

                                        <div class="d-inline-block col-4">ユーザーを登録するテナントを選択してください。</div>
                                    </div>

                                    <hr />


                                    <div class="form-group row">
                                        <div class="col-3">エリア選択 <?=$required_tag ?></div>

                                        <div class="col-5">
                                        <?php if($FieldList): ?>
                                        <select name="field_id" id="FieldID" class="form-control">
                                            <?php foreach($FieldList as $flK => $flV):
                                            $f_selected = ($DeviceInfo['field_id'] == $flV['field_id'])?"selected":""; ?>
                                                <option value="<?=h($flV['field_id']) ?>" <?=$f_selected ?>><?=h($flV['field_name']) ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <?php else: ?>

                                        ※エリアが登録されていません

                                        <?php endif; ?>
                                        </div>

                                        <div class="d-inline-block col-4">デバイスが設置されているエリアを選択してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">デバイス表示番号</div>
                                        <input class="form-control col-5" type="text" name="device_num" id="DeviceNum" placeholder="デバイス表示番号" value="<?=h($DeviceInfo['device_num']) ?>"/>
                                        <div class="d-inline-block col-4">デバイスを表示する番号を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">デバイス名 <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="name" id="Name" placeholder="デバイスの名前" value="<?=h($DeviceInfo['name']) ?>" required/>
                                        <div class="d-inline-block col-4">デバイス名を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">デバイス設置位置　X座標</div>
                                        <input class="form-control col-5" type="number" step="0.001" name="x_pos" id="Xpos" placeholder="0" value="<?=h($DeviceInfo['x_pos']) ?>" required/>
                                        <div class="d-inline-block col-4">デバイスのX座標を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">デバイス設置位置　Y座標</div>
                                        <input class="form-control col-5" type="number" step="0.001" name="y_pos" id="Ypos" placeholder="0" value="<?=h($DeviceInfo['y_pos']) ?>" required/>
                                        <div class="d-inline-block col-4">デバイスのY座標を入力してください。</div>
                                    </div>

                                    <hr />
<!--                                     <input type="hidden" name="type" value="$device_type"/> -->


                                    <div class="tcenter">
                                        <button type="submit" class="btn btn-primary">更新</button>
                                        <a href="<?=$page ?>" class="btn btn-default btn-outline-dark">キャンセル</a>
                                    </div>

                                </form>
                            </div>
                        </section>


                        <?php elseif($isRegist): ?>


                        <section id="RegistUser" class="page-contents">
                            <div><h3>照明デバイス情報登録フォーム</h3></div>
                            <div class="card-wrapper">
                                <form action="<?=$page ?>?c=regist" method="POST">
                                    <input type="hidden" name="one_time_token" value="<?=$onetime_token?>"/>

                                    <div class="form-group row">
                                        <div class="col-3">デバイスID <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="device_id" id="DeviceID" placeholder="デバイスID" value="" required/>
                                        <div class="d-inline-block col-4">デバイスIDを入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">登録テナント <?=$required_tag ?></div>

                                        <div class="col-5">
                                        <?php if($TenantList): ?>
                                        <select name="tenant_id" id="TenantID" class="form-control">
                                            <?php foreach($TenantList as $tlK => $tlV):　?>
                                                <option value="<?=h($tlV['id']) ?>"><?=h($tlV['name']) ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <?php else: ?>

                                        ※テナントが登録されていません

                                        <?php endif; ?>
                                        </div>

                                        <div class="d-inline-block col-4">ユーザーを登録するテナントを選択してください。</div>
                                    </div>

                                    <hr />


                                    <div class="form-group row">
                                        <div class="col-3">エリア選択 <?=$required_tag ?></div>

                                        <div class="col-5">
                                        <?php if($FieldList): ?>
                                        <select name="field_id" id="FieldID" class="form-control">
                                            <?php foreach($FieldList as $flK => $flV):　?>
                                                <option value="<?=h($flV['field_id']) ?>"><?=h($flV['field_name']) ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <?php else: ?>

                                        ※エリアが登録されていません

                                        <?php endif; ?>
                                        </div>

                                        <div class="d-inline-block col-4">デバイスが設置されているエリアを選択してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">デバイス表示番号</div>
                                        <input class="form-control col-5" type="text" name="device_num" id="DeviceNum" placeholder="デバイス表示番号" value=""/>
                                        <div class="d-inline-block col-4">デバイスを表示する番号を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">デバイス名 <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="name" id="Name" placeholder="デバイスの名前" value="" required/>
                                        <div class="d-inline-block col-4">デバイス名を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">デバイス設置位置　X座標</div>
                                        <input class="form-control col-5" type="number" step="0.001" name="x_pos" id="Xpos" placeholder="0" value="" required/>
                                        <div class="d-inline-block col-4">デバイスのX座標を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">デバイス設置位置　Y座標</div>
                                        <input class="form-control col-5" type="number" step="0.001" name="y_pos" id="Ypos" placeholder="0" value="" required/>
                                        <div class="d-inline-block col-4">デバイスのY座標を入力してください。</div>
                                    </div>

                                    <input type="hidden" name="type" value="<?=$device_type ?>"/>

                                    <hr />

                                    <div class="tcenter">
                                        <button type="submit" class="btn btn-primary">登録</button>
                                        <a href="<?=$page ?>" class="btn btn-default btn-outline-dark">キャンセル</a>
                                    </div>

                                </form>
                            </div>
                        </section>

                        <?php elseif($isView): ?>

                        <section id="RegistUser" class="page-contents">
                            <div><h3>照明デバイス情報</h3></div>
                            <div class="card-wrapper">
                                <form action="<?=$page ?>?c=regist" method="POST">
                                    <input type="hidden" name="one_time_token" value="<?=$onetime_token?>"/>

                                    <div class="form-group row">
                                        <div class="col-3">デバイスID</div>
                                        <div class="col-9"><?=h($DeviceInfo['device_id']) ?></div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">デバイスユニークID</div>
                                        <div class="col-9"><?=h($DeviceInfo['du_id']) ?></div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">登録テナント</div>
                                        <div class="col-9"><?=h($DeviceInfo['tenant_id']) ?></div>

                                    </div>

                                    <hr />


                                    <div class="form-group row">
                                        <div class="col-3">エリア選択 </div>
                                        <div class="col-9"><?=h($DeviceInfo['field_id']) ?></div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">デバイス表示番号</div>
                                        <div class="col-9"><?=h($DeviceInfo['device_num']) ?></div>

                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">デバイス名</div>
                                        <div class="col-9"><?=h($DeviceInfo['name']) ?></div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">デバイス設置位置　X座標</div>
                                        <div class="col-9"><?=h($DeviceInfo['x_pos']) ?></div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">デバイス設置位置　Y座標</div>
                                        <div class="col-9"><?=h($DeviceInfo['y_pos']) ?></div>
                                    </div>


                                    <hr />

                                    <div class="tcenter">
                                        <a href="<?=$page ?>" class="btn btn-default btn-outline-dark">閉じる</a>
                                    </div>

                                </form>
                            </div>
                        </section>

                        <?php elseif($isCSVRegist): ?>


                        <section id="CSVRegistDevice" class="page-contents">
                            <div><h3>CSV一括登録フォーム</h3></div>
                            <div class="card-wrapper">

                                <div class="form-group">

                                    <form id="CSVRegistConfirmForm" action="<?=$page ?>?c=csv_regist" method="POST" enctype="multipart/form-data" class="clearfix">
                                        <input type="hidden" name="one_time_token" value="<?=$onetime_token?>" />

                                            <div class="">
                                                <div class="clearfix">CSVアップロード <i class="fa fa-file" aria-hidden="true"></i>
                                                    <div class="row mlr0">

                                                        <label class="col-7 plr0 d-block mt10" for="InputFile">
                                                            <input type="file" name="device_list" id="InputCSVDevice"/>
                                                        </label>
                                                        <div class="col-5">
                                                            <button id="csvUploadConfBtn" class="btn btn-primary" type="button">
                                                                CSV内容を確認する
                                                            </button>
                                                        </div>

                                                    </div>
                                                </div>

                                                <small class="">※一括登録できる最大データ件数は100件です</small>
                                            </div>

                                        <hr />

                                        <div id="CSVConfirmTableWrap" class="d-none">
                                        </div>

                                        <div id="CSVConfirmFailedMsg" class="d-none">
                                            <div class="alert alert-danger" role="alert"></div>
                                        </div>

                                        <div class="tcenter">
                                            <button id="csvUploadSubmitBtn" class="btn btn-primary" type="submit" disabled>
                                                CSVを登録する
                                            </button>
                                            <a href="<?=$page ?>" class="btn btn-default btn-outline-dark">キャンセル</a>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </section>

                        <?php else: ?>

                        <section id="DeviceManage" class="page-contents">
                            <div><h3>照明デバイス一覧リスト</h3></div>
                            <div class="card-wrapper">

                                <?php if(CheckAuthorize($Authorize, [ACCOUNT_AUTHOR_OWNER, ACCOUNT_AUTHOR_BUILDING])): ?>
                                <div class="adduser-wrapper　">
                                    <a href="<?=$page ?>?c=n" class="btn btn-primary btn-sm">新規デバイス登録</a>
                                    <a href="<?=$page ?>?c=csv" class="btn btn-info btn-sm">CSV一括登録</a>
                                    <form class="d-inline" action="parts/csv_output.php" method="POST">
                                        <input type="hidden" name="file_name" value="デバイスリスト"/>
                                        <input type="hidden" name="tbl_name" value="DeviceTbl"/>
                                        <input type="hidden" name="dtype" value="<?=$device_type ?>" />
                                        <button type="submit" class="btn btn-success btn-sm">デバイス一覧CSV出力</button>
                                    </form>
                                </div>
                                <?php endif; ?>
                                <div class="table-wrapper">
                                    <table id="CameraDeviceListTable" class="table">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th class="th_num" scope="col">#</th>
                                                <th class="th_deviceid" scope="col">デバイスID</th>
                                                <th class="th_duid" scope="col">デバイスユニークID</th>
                                                <th class="th_tenantid" scope="col">テナントID</th>
                                                <th class="th_fieldid" scope="col">エリアID</th>
                                                <th class="th_devicename" scope="col">デバイス名</th>
                                                <th class="th_status" scope="col">ステータス</th>
                                                <th class="th_control" scope="col">操作</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <?php foreach($DeviceList as $dlK => $dlV):
                                        switch($dlV['status']){
                                            case ACCOUNT_STATUS_LOCK:
                                                $status = "ロック";
                                                break;
                                            case ACCOUNT_STATUS_OK:
                                                $status = "通常";
                                                break;
                                        }
                                        ?>
                                            <tr>
                                                <td><?=h($dlV['num']) ?></td>
                                                <td><?=h($dlV['device_id']) ?></td>
                                                <td><?=h($dlV['du_id']) ?></td>
                                                <td><?=h($dlV['tenant_id']) ?></td>
                                                <td><?=h($FieldNameList[$dlV['field_id']]) ?></td>
                                                <td><?=h($dlV['name']) ?></td>
                                                <td><?=$status ?></td>

                                                <td>
                                                    <a href="<?=$page ?>?c=v&id=<?=h($dlV['du_id']) ?>" class="btn btn-sm btn-success">表示</a>
                                                    <?php if(CheckAuthorize($Authorize, [ACCOUNT_AUTHOR_OWNER, ACCOUNT_AUTHOR_BUILDING])): ?>
                                                    <a href="<?=$page ?>?c=e&id=<?=h($dlV['du_id']) ?>" class="btn btn-sm btn-primary">編集</a>
                                                    <button class="btn btn-sm btn-danger" data-toggle="modal" data-target="#modal-devicedelete" data-whatever="<?=$dlV['num']?>" data-name="<?=$dlV['name']?>">削除</button>

                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach;?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                        </section>

                        <?php endif; ?>
                    </div>
                </main>
            </div>
        <? //include(PARTS_PATH.'footer.php'); ?>
        </div>
    </body>
    <!-- /container -->


    <!-- モーダル　デバイス情報削除 -->
    <div class="modal fade" id="modal-devicedelete" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-label">照明デバイス情報削除</h4>
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>この照明デバイス情報を削除しますか？</p>
                    <form id="user_delete" action="<?=$page?>?c=d" method="post">
                        <input type="hidden" name="one_time_token" value="<?=$onetime_token ?>"/>
                        <div class="form-group">
                            <label for="recipient-name" class="form-control-label">照明デバイス:</label>
                            <input type="text" class="form-control" id="DeleteDeviceName" name="name" readonly="readonly" required>
                            <input type="hidden" id="DeleteDevicNum" name="num" >
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-danger">削除する</button>
                            <button type="cancel" class="btn btn-default btn-outline-dark" data-dismiss="modal">中止</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <script>
        $(function(){

            $('#modal-devicedelete').on('show.bs.modal', function(event) {
                var recipient = $(event.relatedTarget).data('whatever');
                var name = $(event.relatedTarget).data('name');
                $(this).find('.modal-body #DeleteDevicNum').val(recipient);
                $(this).find('.modal-body #DeleteDeviceName').val(name);
            });


            // datatableの設定を変更
            $("#CameraDeviceListTable").DataTable({
                searching: false,
                info: false,
                lengthChange: false,
                columnDefs: [
                      { "targets": 0, "width": '5%'},
                      { "targets": 1, "width": '12%'},
                      { "targets": 2, "width": '12%'},
                      { "targets": 3, "width": '12%'},
                      { "targets": 4, "width": '12%'},
                      { "targets": 5, "width": 'auto'},
                      { "targets": 6, "width": '10%'},
                      { "targets": 7, "width": '15%',"orderable": false},

                    ],
            });


            $('#csvUploadConfBtn').on('click', function(){
                // アップロード

                var fd = new FormData($('#CSVRegistConfirmForm').get(0));


                $.ajax({
                    url: 'parts/devicecsv_confirm.php?d=<?=$device_type ?>',
                    type: 'POST',
                    data: fd,
                    processData: false, // jQueryがデータを処理しないよう指定
                    contentType: false  // jQueryがcontentTypeを設定しないよう指定
                }).done(function(result) {
                    // 実行中
                }).fail(function() {
                    // 失敗
                    $('#result').html('失敗');
                }).always(function(result) {
//                     console.log(result);
                    // 完了
                    if (result.state == 'success') {
                        $('#result').html('成功');

                        $('#CSVConfirmFailedMsg').addClass('d-none');
                        $('#CSVConfirmTableWrap').html(result.html);
                        $("#CSVConfirmTable").DataTable({
                            searching: false,
                            info: false,
                            lengthChange: false,
                            columnDefs: [
                                  { "targets": 0, "width": '5%'},
                                  { "targets": 1, "width": '10%'},
                                  { "targets": 2, "width": '10%'},
                                  { "targets": 3, "width": '10%'},
                                  { "targets": 4, "width": '12%'},
                                  { "targets": 5, "width": 'auto'},
                                  { "targets": 6, "width": '13%'},
                                  { "targets": 7, "width": '10%'},
                                  { "targets": 8, "width": '10%'},
                                  { "targets": 9, "width": '10%'},
                                  { "targets": 10, "width": '10%'},
                                ],
                        });
                        $('#CSVConfirmTableWrap').removeClass('d-none');
                        if(result.count > 0){
                            $('#csvUploadSubmitBtn').prop('disabled', false);
                        }
                    } else {
                        if(result.msg != ""){
                            $('#CSVConfirmTableWrap').addClass('d-none');
                            $('#CSVConfirmFailedMsg').find('.alert').text(result.msg);
                            $('#CSVConfirmFailedMsg').removeClass('d-none');
                        }
                        $('#result').html('失敗');
                    }
                });
            });
        });
    </script>

</html>