<?
/**
 * エリア管理画面
 */
require("core/construct.php");

require(CORE_PATH."basic.php");
require(CORE_PATH."functions.php");
require(CORE_PATH."session_check.php");
require(CORE_PATH."authorize.php");
require_once(__DIR__."/util/utils.php");

require_once(AD_MDL_PATH."model.php");
$adMDL = new admModel($sdb, $link);

require_once(SN_MDL_PATH."model.php");
$sgMDL = new sngModel($sdb, $link);

// //　ログインユーザー情報
//$AreaList = $adMDL->GetFieldList();
$a_row = $adMDL->GetFieldList();
if($a_row){
    foreach($a_row as $aK => $aV){
        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
            if($aV['tenant_id'] != $_SESSION['admin']['tenant_id']){
                continue;
            }
        }
        $AreaList[] = $aV;
    }
}


$page = "field.php";

$GET = filterGet();
$POST = filterPost();

$isEdit = False;
$isRegist = False;
$isCSVRegist = False;

$login_user = $_SESSION['admin']['admin_id'];

try{
    $DeviceList = [];
    $d_row = $sgMDL->GetDeviceTbl();
    if($d_row){
        foreach($d_row as $dK => $dV){
            $DeviceList[$dV['device_id']] = $dV['name'];
        }
    }

    if(isset($GET['m']))
    {
        $mes = GetMsgDecode($GET['m']);
    }

    if(isset($_GET['c']))
    {

        switch($_GET['c'])
        {
            case 'n':
                $TenantList=[];
                $t_row = $adMDL->GetTenantList();
                if($t_row){
                    foreach($t_row as $tK => $tV){
                        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
                            if($tV['id'] != $_SESSION['admin']['tenant_id']){
                                continue;
                            }
                        }
                        $TenantList[] = $tV;
                    }
                }

//                 $DeviceTypeList = GetDeviceTypeList();

                $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'エリア情報登録フォーム'));
                $isRegist = True;
                break;

            case 'regist':

                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }


                if(trim($POST['field_id']) === "") throw new Exception("エリアIDを入力してください。");
                if(preg_match('/^[0-9a-zA-Z\-_]{1,32}$/', $POST['field_id']) == 0) throw new Exception("エリアIDは32文字以内の半角英数字で入力してください。");


                $AreaInfo = $adMDL->GetFieldData($POST['field_id']);
                if($AreaInfo) throw new Exception("入力されたエリアIDは既に存在するため使用できません。");

                if(trim($POST['tenant_id']) === "") throw new Exception("テナントを選択してください。");

                if(trim($POST['field_name']) === "") throw new Exception("エリア名を入力してください。");
                if(mb_strlen($POST['field_name']) > 128) throw new Exception("エリア名は128文字以内です。");


//                 if(trim($POST['x_pos']) === "") throw new Exception("エリアX座標を入力してください。");
//                 if(trim($POST['y_pos']) === "") throw new Exception("エリアY座標を入力してください。");
//                 if(trim($POST['width']) === "") throw new Exception("エリア横幅を入力してください。");
//                 if(trim($POST['height']) === "") throw new Exception("エリア縦幅を入力してください。");

                $t = new Datetime();

                $prm = [
                    'field_id' => $POST['field_id'],
                    'tenant_id' => $POST['tenant_id'],
                    'field_name' => $POST['field_name'],
                    'belong_device' => "",
                    'x_pos' => $POST['x_pos'],
                    'y_pos' => $POST['y_pos'],
                    'width' => $POST['width'],
                    'height' => $POST['height'],
                    'last-update' => $t->format("Y-m-d H:i:s"),
                ];

                $ins_ret = $adMDL->InsertFieldData($prm);
                if(!$ins_ret) throw new Exception("エリア情報の登録が失敗しました。");

                $mes = GetMsgEncode("エリア情報を登録しました。");
                $log->info("Successful area registration.",array('file' => __FILE__, 'userId' => $login_user, 'data' => $prm));
                header( 'Location: ' . $page.'?m='.$mes);
                exit;

                break;

            case 'csv':
                if(!CheckAuthorize($Authorize, [ACCOUNT_AUTHOR_OWNER, ACCOUNT_AUTHOR_BUILDING])) throw new Exception("操作に必要な権限がありません。");
                $TenantList = $adMDL->GetTenantList();
                $isCSVRegist = True;
                $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'CSV一括登録フォーム'));
                break;

            case 'csv_regist':
                if(!CheckAuthorize($Authorize, [ACCOUNT_AUTHOR_OWNER, ACCOUNT_AUTHOR_BUILDING])) throw new Exception("操作に必要な権限がありません。");
                $targetFolder = 'admin/tmp'; //アップロード先フォルダを指定します。
                $readDataLimit = 100; //読み込みデータ限界
                $filename = 'area_list';

                require(CORE_PATH."csv_input.php");

                $data = $csv_arr;
                $ins_ret = $adMDL->InsertCSVMultiAreaData($data);
                if(!$ins_ret) throw new Exception("エリアの一括登録に失敗しました。");

                $mes = GetMsgEncode("エリアの一括登録が完了しました。");
                $log->info("Successful CSV bulk registration",array('file' => __FILE__, 'userId' => $login_user, 'data' => $data));
                header( 'Location: ' . $page.'?m='.$mes);
                exit;

                break;

            case 'e':
                if(!isset($GET['id'])) throw new Exception("エリアIDが指定されていません。");

                $edit_id = $GET['id'];

                $AreaInfo = $adMDL->GetFieldData($edit_id);
                if(!$AreaInfo) throw new Exception("指定されたエリアは存在しません。");

                $TenantList=[];
                $t_row = $adMDL->GetTenantList();
                if($t_row){
                    foreach($t_row as $tK => $tV){
                        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
                            if($tV['id'] != $_SESSION['admin']['tenant_id']){
                                continue;
                            }
                        }
                        $TenantList[] = $tV;
                    }
                }

//                 $BelongDeviceArr = explode(',', $AreaInfo['belong_device']);

                $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'エリア情報編集フォーム', 'editId' => $edit_id));
                $isEdit = True;
                break;

            case 'edit':

                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }

                if(!isset($GET['id'])) throw new Exception("エリアIDが指定されていません。");

                $edit_id = $GET['id'];

                $AreaInfo = $adMDL->GetFieldData($edit_id);
                if(!$AreaInfo) throw new Exception("指定されたエリアは存在しません。");

                if(trim($POST['tenant_id']) === "") throw new Exception("テナントを選択してください。");

                if(trim($POST['field_name']) === "") throw new Exception("エリア名を入力してください。");
                if(mb_strlen($POST['field_name']) > 128) throw new Exception("エリア名は128文字以内です。");


//                 if(trim($POST['x_pos']) === "") throw new Exception("エリアX座標を入力してください。");
//                 if(trim($POST['y_pos']) === "") throw new Exception("エリアY座標を入力してください。");
//                 if(trim($POST['width']) === "") throw new Exception("エリア横幅を入力してください。");
//                 if(trim($POST['height']) === "") throw new Exception("エリア縦幅を入力してください。");


                $t = new Datetime();

                $prm = [
                    'field_id' => $edit_id,
                    'tenant_id' => $POST['tenant_id'],
                    'field_name' => $POST['field_name'],
                    'belong_device' => "",
                    'x_pos' => $POST['x_pos'],
                    'y_pos' => $POST['y_pos'],
                    'width' => $POST['width'],
                    'height' => $POST['height'],
                    'last-update' => $t->format("Y-m-d H:i:s"),
                ];

                $up_ret = $adMDL->UpdateFieldData($prm);
                if(!$up_ret) throw new Exception("エリア情報の更新が失敗しました。");

                $log->info("Successful area update.",array('file' => __FILE__, 'userId' => $login_user, 'data' => $prm));
                $mes = GetMsgEncode("エリア情報を更新しました。");
                header( 'Location: ' . $page.'?m='.$mes);
                exit;

                break;

            case 'd':
                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }

                if(!isset($POST['field_id'])) throw new Exception("エリアIDが指定されていません。");

                $delete_id = $POST['field_id'];

                $del_ret = $adMDL->DeleteFieldData($delete_id);
                if(!$del_ret) throw new Exception("エリア情報の削除に失敗しました。");

                $log->info("Successful area delete.",array('file' => __FILE__, 'userId' => $login_user, 'deleteId' => $delete_id));
                $mes = GetMsgEncode("エリア情報を削除しました。");
                header( 'Location: ' . $page.'?m='.$mes);
                exit;

                break;
        }
    } else {
        $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'エリア一覧リスト'));
    }
}catch(Exception $e){
    $mes = GetMsgEncode($e->getMessage());
    // 確認
    $log->info($e);
    $log->info("Failed to field operation.", array('file' => __FILE__, 'userId' => $login_user, 'message' => $e->getMessage()));
    header( 'Location: ' . $page.'?m='.$mes.'&err');
    exit;
}

// var_dump($DeviceList);

$msg_stt = (isset($GET['err']))? "danger" : "success";
$message_tag = ($mes != '')?'<div class="alert alert-'.$msg_stt.'" role="alert">'.$mes.'</div>':'';

$required_tag = '<span class="badge badge-danger">必須</span>';
$page_title = "管理画面　エリア情報管理";

$onetime_token = createToken();

include(PARTS_PATH."header.php");


?>
    <body>
        <div id="Wrap">

        <? include(PARTS_PATH.'header-nav.php'); ?>
            <div class="wrapper">

                <? include(PARTS_PATH.'sidemenu.php'); ?>
                <main class="">

                    <div class="container grid">

                        <nav class="page-header">
                            <div class="container-fluid">
                                <div class="navbar-wrapper">
                                    <h2><span class="svg-wrap mr10"><svg class="img-fluid"><use xlink:href="./asset/img/building.svg#Building"></use></svg></span>エリア情報管理</h2>
                                </div>
                            </div>
                        </nav>

                        <?=$message_tag ?>


                        <?php if($isEdit): ?>

                        <section id="EditTenant" class="page-contents">
                            <div><h3>エリア情報編集フォーム</h3></div>
                            <div class="card-wrapper">
                                <form action="<?=$page ?>?c=edit&id=<?=h($edit_id) ?>" method="POST">
                                    <input type="hidden" name="one_time_token" value="<?=$onetime_token?>"/>
                                    <div class="form-group row">
                                        <div class="col-3">エリアID</div>
                                        <div class="col-5"><?=h($AreaInfo['field_id']) ?></div>
                                        <div class="d-inline-block col-4"></div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">登録テナント <?=$required_tag ?></div>

                                        <div class="col-5">
                                            <?php if($TenantList): ?>
                                            <select name="tenant_id" id="TenantID" class="form-control">
                                                <?php foreach($TenantList as $tlK => $tlV):
                                                $selected = ($AreaInfo['tenant_id'] == $tlV['id'])?"selected":"";
                                                ?>
                                                    <option value="<?=h($tlV['id']) ?>" <?=$selected ?>><?=h($tlV['name']) ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <?php else: ?>

                                            ※テナントが登録されていません

                                            <?php endif; ?>
                                        </div>

                                        <div class="d-inline-block col-4">エリアが所属するテナントを選択してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">エリア名 <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="field_name" id="AreaName" placeholder="エリアの名前" value="<?=h($AreaInfo['field_name']) ?>" maxlength="128" required/>
                                        <div class="d-inline-block col-4">エリア名を入力してください。</div>
                                    </div>

                                    <hr />



                                    <div class="form-group row">
                                        <div class="col-3">エリアのX座標</div>
                                        <input class="form-control col-5" type="number" step="0.001" name="x_pos" id="Xpos" placeholder="0" value="<?=h($AreaInfo['x_pos']) ?>"/>
                                        <div class="d-inline-block col-4">エリアのX座標を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">エリアのY座標</div>
                                        <input class="form-control col-5" type="number" step="0.001" name="y_pos" id="Ypos" placeholder="0" value="<?=h($AreaInfo['y_pos']) ?>"/>
                                        <div class="d-inline-block col-4">エリアのY座標を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">エリアの横幅</div>
                                        <input class="form-control col-5" type="number" step="0.001" name="width" id="Width" placeholder="0" value="<?=h($AreaInfo['width']) ?>"/>
                                        <div class="d-inline-block col-4">エリアの横幅を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">エリアの縦幅</div>
                                        <input class="form-control col-5" type="number" step="0.001" name="height" id="Height" placeholder="0" value="<?=h($AreaInfo['height']) ?>"/>
                                        <div class="d-inline-block col-4">エリアの縦幅を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="tcenter">
                                        <button type="submit" class="btn btn-primary">更新</button>
                                        <a href="<?=$page ?>" class="btn btn-default btn-outline-dark">キャンセル</a>
                                    </div>

                                </form>
                            </div>
                        </section>


                        <?php elseif($isRegist): ?>


                        <section id="RegistUser" class="page-contents">
                            <div><h3>エリア情報登録フォーム</h3></div>
                            <div class="card-wrapper">
                                <form action="<?=$page ?>?c=regist" method="POST">
                                    <input type="hidden" name="one_time_token" value="<?=$onetime_token?>"/>

                                    <div class="form-group row">
                                        <div class="col-3">エリアID <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="field_id" id="AreaID" placeholder="エリアID" value="" maxlength="32" required/>
                                        <div class="d-inline-block col-4">エリアIDを入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">登録テナント <?=$required_tag ?></div>

                                        <div class="col-5">
                                            <?php if($TenantList): ?>
                                            <select name="tenant_id" id="TenantID" class="form-control">
                                                <?php foreach($TenantList as $tlK => $tlV):　?>
                                                    <option value="<?=h($tlV['id']) ?>"><?=h($tlV['name']) ?></option>
                                                <?php endforeach; ?>
                                            </select>
                                            <?php else: ?>

                                            ※テナントが登録されていません

                                            <?php endif; ?>
                                        </div>

                                        <div class="d-inline-block col-4">エリアが所属するテナントを選択してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">エリア名 <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="field_name" id="AreaName" placeholder="エリアの名前" value="" maxlength="128" required/>
                                        <div class="d-inline-block col-4">エリア名を入力してください。</div>
                                    </div>

                                    <hr />


                                    <div class="form-group row">
                                        <div class="col-3">エリアのX座標 <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="number" step="0.001" name="x_pos" id="Xpos" placeholder="0" value=""/>
                                        <div class="d-inline-block col-4">エリアのX座標を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">エリアのY座標</div>
                                        <input class="form-control col-5" type="number" step="0.001" name="y_pos" id="Ypos" placeholder="0" value=""/>
                                        <div class="d-inline-block col-4">エリアのY座標を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">エリアの横幅</div>
                                        <input class="form-control col-5" type="number" step="0.001" name="width" id="Width" placeholder="0" value=""/>
                                        <div class="d-inline-block col-4">エリアの横幅を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
                                        <div class="col-3">エリアの縦幅</div>
                                        <input class="form-control col-5" type="number" step="0.001" name="height" id="Height" placeholder="0" value=""/>
                                        <div class="d-inline-block col-4">エリアの縦幅を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="tcenter">
                                        <button type="submit" class="btn btn-primary">登録</button>
                                        <a href="<?=$page ?>" class="btn btn-default btn-outline-dark">キャンセル</a>
                                    </div>

                                </form>
                            </div>
                        </section>


                        <?php elseif($isCSVRegist): ?>


                        <section id="CSVRegistDevice" class="page-contents">
                            <div><h3>CSV一括登録フォーム</h3></div>
                            <div class="card-wrapper">

                                <div class="form-group">

                                    <form id="CSVRegistConfirmForm" action="<?=$page ?>?c=csv_regist" method="POST" enctype="multipart/form-data" class="clearfix">
                                        <input type="hidden" name="one_time_token" value="<?=$onetime_token?>" />

                                            <div class="">
                                                <div class="clearfix">CSVアップロード <i class="fa fa-file" aria-hidden="true"></i>
                                                    <div class="row mlr0">

                                                        <label class="col-7 plr0 d-block mt10" for="InputFile">
                                                            <input type="file" name="area_list" id="InputCSVArea"/>
                                                        </label>
                                                        <div class="col-5">
                                                            <button id="csvUploadConfBtn" class="btn btn-primary" type="button">
                                                                CSV内容を確認する
                                                            </button>
                                                        </div>

                                                    </div>
                                                </div>

                                                <small class="">※一括登録できる最大データ件数は100件です</small>
                                            </div>

                                        <hr />

                                        <div id="CSVConfirmTableWrap" class="d-none">
                                        </div>

                                        <div id="CSVConfirmFailedMsg" class="d-none">
                                            <div class="alert alert-danger" role="alert"></div>
                                        </div>

                                        <div class="tcenter">
                                            <button id="csvUploadSubmitBtn" class="btn btn-primary" type="submit" disabled>
                                                CSVを登録する
                                            </button>
                                            <a href="<?=$page ?>" class="btn btn-default btn-outline-dark">キャンセル</a>
                                        </div>
                                    </form>
                                </div>

                            </div>
                        </section>

                        <?php else: ?>

                        <section id="FielfManage" class="page-contents">
                            <div><h3>エリア一覧リスト</h3></div>
                            <div class="card-wrapper">

                                <div class="addarea-wrapper　">
                                    <a href="<?=$page ?>?c=n" class="btn btn-primary btn-sm">新規エリア登録</a>
                                    <a href="<?=$page ?>?c=csv" class="btn btn-info btn-sm">CSV一括登録</a>
                                    <form class="d-inline" action="parts/csv_output.php" method="POST">
                                        <input type="hidden" name="file_name" value="エリアリスト"/>
                                        <input type="hidden" name="tbl_name" value="FieldTbl"/>
                                        <button type="submit" class="btn btn-success btn-sm">エリア一覧CSV出力</button>
                                    </form>
                                </div>

                                <div class="table-wrapper">
                                    <table id="AreaListTable" class="table">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th class="th_num" scope="col">#</th>
                                                <th class="th_fieldid" scope="col">エリアID</th>
                                                <th class="th_fieldname" scope="col">エリア名</th>
                                                <th class="th_status" scope="col">ステータス</th>
                                                <th class="th_control" scope="col">操作</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <?php if($AreaList): ?>
                                        <?php foreach($AreaList as $flK => $flV):
                                        switch($flV['status']){
                                            case ACCOUNT_STATUS_LOCK:
                                                $status = "ロック";
                                                break;
                                            case ACCOUNT_STATUS_OK:
                                                $status = "通常";
                                                break;
                                        }
                                        ?>
                                            <tr>
                                                <td><?=h($flV['num']) ?></td>
                                                <td><?=h($flV['field_id']) ?></td>
                                                <td><?=h($flV['field_name']) ?></td>
                                                <td><?=$status ?></td>
                                                <td>
                                                    <a href="<?=$page ?>?c=e&id=<?=h($flV['field_id']) ?>" class="btn btn-sm btn-primary">編集</a>
                                                    <button class="btn btn-sm btn-danger" data-toggle="modal" data-target="#modal-fielddelete" data-whatever="<?=$flV['field_id']?>">削除</button>
                                                </td>
                                            </tr>
                                        <?php endforeach;?>
                                        <?php else: ?>
                                        <tr><td class="tcenter" colspan="6">エリアが登録されていません。</td></tr>
                                        <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>

                        </section>

                        <?php endif; ?>
                    </div>
                </main>
            </div>
        <? //include(PARTS_PATH.'footer.php'); ?>
        </div>
    </body>
    <!-- /container -->


    <!-- モーダル　エリア情報削除 -->
    <div class="modal fade" id="modal-fielddelete" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-label">エリア情報削除</h4>
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>このエリア情報を削除しますか？</p>
                    <form id="user_delete" action="<?=$page?>?c=d" method="post">
                        <input type="hidden" name="one_time_token" value="<?=$onetime_token ?>"/>
                        <div class="form-group">
                            <label for="recipient-name" class="form-control-label">エリアID:</label>
                            <input type="text" class="form-control" id="DeleteAreaID" name="field_id" readonly="readonly" required>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-danger">削除する</button>
                            <button type="cancel" class="btn btn-default btn-outline-dark" data-dismiss="modal">中止</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <script>
        $(function(){

            $('#modal-fielddelete').on('show.bs.modal', function(event) {
                var recipient = $(event.relatedTarget).data('whatever');
                $(this).find('.modal-body #DeleteAreaID').val(recipient);
            });


            // datatableの設定を変更
            $("#AreaListTable").DataTable({
                searching: false,
                info: false,
                lengthChange: false,
                columnDefs: [
                    { "targets": 0, "width": '5%'},
                    { "targets": 1, "width": '15%'},
                    { "targets": 2, "width": '50%'},
                    // { "targets": 3, "width": '30%'},
                    { "targets": 3, "width": '12%'},
                    { "targets": 4, "width": '18%',"orderable": false},
                ],
            });



            $('#csvUploadConfBtn').on('click', function(){
                // SCV一括アップロード

                var fd = new FormData($('#CSVRegistConfirmForm').get(0));


                $.ajax({
                    url: 'parts/areacsv_confirm.php',
                    type: 'POST',
                    data: fd,
                    processData: false, // jQueryがデータを処理しないよう指定
                    contentType: false  // jQueryがcontentTypeを設定しないよう指定
                }).done(function(result) {
                    // 実行中
                }).fail(function() {
                    // 失敗
                    $('#result').html('失敗');
                }).always(function(result) {
//                     console.log(result);
                    // 完了
                    if (result.state == 'success') {
                        $('#result').html('成功');

                        $('#CSVConfirmFailedMsg').addClass('d-none');
                        $('#CSVConfirmTableWrap').html(result.html);
                        $("#CSVConfirmTable").DataTable({
                            searching: false,
                            info: false,
                            lengthChange: false,
                            columnDefs: [
                                { "targets": 0, "width": '5%'},
                                { "targets": 1, "width": '10%'},
                                { "targets": 2, "width": '10%'},
                                { "targets": 3, "width": '10%'},
                                { "targets": 4, "width": '12%'},
                                { "targets": 5, "width": 'auto'},
                                { "targets": 6, "width": '13%'},
                                { "targets": 7, "width": '10%'},
                                { "targets": 8, "width": '10%'},
                                { "targets": 9, "width": '10%'},
                                { "targets": 10, "width": '10%'},
                            ],
                        });
                        $('#CSVConfirmTableWrap').removeClass('d-none');
                        if(result.count > 0){
                            $('#csvUploadSubmitBtn').prop('disabled', false);
                        }
                    } else {
                        if(result.msg != ""){
                            $('#CSVConfirmTableWrap').addClass('d-none');
                            $('#CSVConfirmFailedMsg').find('.alert').text(result.msg);
                            $('#CSVConfirmFailedMsg').removeClass('d-none');
                        }
                        $('#result').html('失敗');
                    }
                });
            });

        });
    </script>

</html>