<?
/**
 * 共有リンク管理画面
 */
require("core/construct.php");

require(CORE_PATH."basic.php");
require(CORE_PATH."functions.php");
require(CORE_PATH."session_check.php");
require(CORE_PATH."authorize.php");

require_once(AD_MDL_PATH."model.php");
$adMDL = new admModel($sdb, $link);

require_once(SN_MDL_PATH."model.php");
$sgMDL = new sngModel($sdb, $link);

require(CORE_PATH."validation.php");
$VAL = new formValidation();

require_once(__DIR__."/util/utils.php");

$LinkWidgetInitial = "Link_";

//共有リンクウィジェットのテンプレートディレクトリのパス
$temp_dir = ADMIN_ROOT."link_cms_dir".DS."default".DS;
//スーパーアプリのウィジェットディレクトリのパス
$widget_dir = SUPER_APPLI_ROOT."widget".DS;


$LinkWidgetID = "";
// $LinkWidgetIDList = ['Link_00000001','Link_00000002'];

// 共有リンク情報
//$AreaList = $adMDL->GetFieldList();
$LinkWidgetList = [];
$w_row = $adMDL->GetWidgetListForMultiType([WIDGET_TYPE_LINK_1, WIDGET_TYPE_LINK_2]);
// $w_row = $adMDL->GetWidgetListForMultiType([WIDGET_TYPE_LINK_1, WIDGET_TYPE_LINK_2, WIDGET_TYPE_LINK_3, WIDGET_TYPE_LINK_4]);

if($w_row){
    foreach($w_row as $lK => $lV){
        $LinkWidgetList[] = $lV;
        if(preg_match('/(?<=Link_)\d{8}/', $lV['widget_id'], $match)) $LinkWidgetIDList[] = $match[0]*1;
    }
}


$TenantList = [];
$t_row = $adMDL->GetTenantList();
if($t_row){
    foreach($t_row as $tK => $tV){
        $TenantList[$tV['id']] = $tV;
    }
}


// var_dump($LinkWidgetList);exit;

$WidgetTypeArr = [
    WIDGET_TYPE_LINK_1 => WIDGET_TYPE_LINK_1_NAME,
    WIDGET_TYPE_LINK_2 => WIDGET_TYPE_LINK_2_NAME,
    //     WIDGET_TYPE_LINK_3 => WIDGET_TYPE_LINK_3_NAME,
//     WIDGET_TYPE_LINK_4 => WIDGET_TYPE_LINK_4_NAME,
];

$page = "link_cms.php";

$GET = filterGet();
$POST = filterPost();

$isEdit = False;
$isRegist = False;
$isCSVRegist = False;

$login_user = $_SESSION['admin']['admin_id'];

try{
    
    
    if(isset($GET['m']))
    {
        $mes = GetMsgDecode($GET['m']);
    }
    
    if(isset($_GET['c']))
    {
        
        switch($_GET['c'])
        {
            case 'test':
                //共有リンクウィジェットのソースコード一式登録
                $widget_dir .= 'TestWidget'.DS;
                //var_dump($temp_dir);
                //var_dump(copy_dir($temp_dir, $widget_dir));
                
                exit;
                break;
            case 'n':
                if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER) throw new Exception("共有リンクウィジェット新規登録画面はシステム管理者のみアクセス可能です。");
                $TenantList=[];
                $t_row = $adMDL->GetTenantList();
                if($t_row){
                    foreach($t_row as $tK => $tV){
                        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
                            if($tV['id'] != $_SESSION['admin']['tenant_id']){
                                continue;
                            }
                        }
                        $TenantList[] = $tV;
                    }
                }
                
                $numbering = 1; //共有リンクウィジェットの自動採番番号
                if(!empty($LinkWidgetIDList)){
                    //共有リンクウィジェットIDで自動採番番号が一番大きいIDを取得し、最大値より1大きいIDで登録する
                    foreach($LinkWidgetIDList as $lwdV){
                        if($numbering < $lwdV) $numbering = $lwdV;
                        // 				        if(preg_match('/(?<='.$LinkWidgetInitial.')\d{8}/', $lwdV, $match)){
                        // 				            $checknum = $match[0]*1;
                        // 				            if($numbering < $checknum) $numbering = $checknum;
                        // 				        }
                    }
                    $numbering++;
                }
                
                $newid = $LinkWidgetInitial.sprintf('%08d',$numbering);
                //                 $DeviceTypeList = GetDeviceTypeList();
                
                $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => '共有リンク登録フォーム'));
                $isRegist = True;
                break;
                
                
            case 'regist':
                
                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    //if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }
                
                if(trim($POST['widget_id']) === "") throw new Exception("共有リンクウィジェットIDを入力してください。");
                if(preg_match('/^[0-9a-zA-Z\-_]{1,256}$/', $POST['widget_id']) == 0) throw new Exception("共有リンクウィジェットIDは256文字以内の半角英数字で入力してください。");
                
                
                //ウィジェットID重複チェック
                $WidgetInfo = $adMDL->GetWidgetDataByID($POST['widget_id']);
                if($WidgetInfo) throw new Exception("入力された共有リンクウィジェットIDは既に存在するため使用できません。");
                
                
                if(trim($POST['widget_name']) === "") throw new Exception("共有リンクウィジェット名を入力してください。");
                if(mb_strlen($POST['widget_name']) > 256) throw new Exception("共有リンクウィジェット名は256文字以内です。");
                
                if(trim($POST['widget_info']) !== ""){
                    if(mb_strlen($POST['widget_info']) > 512) throw new Exception("共有リンクウィジェット説明は512文字以内です。");
                }
                
                if(!isset($POST['widget_type'])) throw new Exception("共有リンクウィジェット種別を選択してください。");
                
                //ウィジェット設定
                $setting_json = [];
                
                if(trim($POST['banner']) !== ""){
                    if(!preg_match('/(?<='.$LinkWidgetInitial.')\d{8}/', $POST['banner']) == 0) throw new Exception("リンク画像の形式が正しくありません。");
                    $setting_json['banner'] = $POST['banner'];
                }
                
                if(trim($POST['memo']) !== ""){
                    if(mb_strlen($POST['memo']) > 1000) throw new Exception("共有リンクウィジェットメモは1000文字以内です。");
                    $setting_json['memo'] = $POST['memo'];
                }
                
                
                if(in_array($POST['widget_type'],[WIDGET_TYPE_LINK_1,WIDGET_TYPE_LINK_2])){
                    $setting_json['tenant'] = $POST['tenant'];
                    
                    if($POST['widget_type'] === WIDGET_TYPE_LINK_2){
                        foreach($POST['tenant_setlink'] as $tenantK => $setlinkV){
                            
                            if(isset($POST['tenant_setlink'][$tenantK])){
                                if($POST['tenant'][$tenantK] == "on"){
                                    if(mb_strlen($setlinkV) > 1000) throw new Exception("リンクURLは1000文字以内です。");
                                    if(!preg_match('/^(http|https):\/\/([A-Z0-9][A-Z0-9_-]*(?:\.[A-Z0-9][A-Z0-9_-]*)+):?(\d+)?\/?/i', $setlinkV)) throw new Exception("リンクURLの形式が正しい形式ではありません。");
                                }
                                
                            }
                        }
                        
                        $setting_json['tenant_setlink'] = $POST['tenant_setlink'];
                    }
                }
                
                //                 if(in_array($POST['widget_type'],[WIDGET_TYPE_LINK_3,WIDGET_TYPE_LINK_4])){
                //                     $setting_json['view_type'] = $POST['view_type'];
                
                //                     if($POST['widget_type'] === WIDGET_TYPE_LINK_3){
                //                         $setting_json['notice_tenant'] = $POST['notice_tenant'];
                //                     }
                //                 }
                
                //                 if(in_array($POST['widget_type'],[WIDGET_TYPE_LINK_1,WIDGET_TYPE_LINK_3,WIDGET_TYPE_LINK_4])){
                if(in_array($POST['widget_type'],[WIDGET_TYPE_LINK_1])){
                    if(isset($POST['link_url'])){
                        if(mb_strlen($POST['link_url']) > 1000) throw new Exception("個別URLは1000文字以内です。");
                        if(!preg_match('/^(http|https):\/\/([A-Z0-9][A-Z0-9_-]*(?:\.[A-Z0-9][A-Z0-9_-]*)+):?(\d+)?\/?/i', $POST['link_url'])) throw new Exception("個別URLの形式が正しい形式ではありません。");
                    }
                    $setting_json['link_url'] = $POST['link_url'];
                }
                
                // 表示画像
                if(trim($POST['banner']) === "") throw new Exception("表示画像を選択してください。");

                //ウィジェットの表示非表示フラグ
                $setting_json['widget_viewset'] = $POST['widget_viewset'];
                
                
                
                $t = new Datetime();
                $prm = [
                    'widget_id' => $POST['widget_id'],
                    'widget_name' => $POST['widget_name'],
                    'sub_widget' => 0,
                    'widget_type' => $POST['widget_type'],
                    'widget_info' => $POST['widget_info'],
                    'registrated_time' => $t->format("Y-m-d H:i:s"),
                ];
                
                $ins_ret = $adMDL->InsertWidgetData($prm);
                if(!$ins_ret) throw new Exception("共有リンク情報の登録が失敗しました。");
                
                
                //画像を本登録
                $upd_ret = $adMDL->UpdateFileDataStatusByIDForUpload($POST['banner']);
                
                //仮登録画像の削除
                $del_ret = $adMDL->DeleteFileDataForPreUpload($POST['banner'], 'img');
                
                
                //ウィジェット設定情報の登録
                $ws_row = $adMDL->GetWidgetSettingByID($POST['widget_id']);
                if($ws_row) throw new Exception("既にウィジェット設定が登録されています。");
                
                $ws_prm = [
                    'widget_id' => $POST['widget_id'],
                    'setting_json' => json_encode($setting_json),
                ];
                
                $ins_ws_ret = $adMDL->InsertWidgetSetting($ws_prm);
                if(!$ins_ws_ret) throw new Exception("ウィジェット設定の登録が失敗しました。");
                
                
                if($setting_json['tenant']){
                    
                    foreach($setting_json['tenant'] as $tlK => $tlV){
                        
                        //ウィジェット使用テナント設定
                        $tw_row = $adMDL->GetTenantWidgetSettingListForTenantID($tlK);
                        $t_json = json_decode($tw_row['flag_json'], TRUE);
                        $widget_use = (is_array($t_json['widget_use']))?$t_json['widget_use']:[];
                        $widget_use = array_filter($widget_use);//NULL削除
                        $widget_use = array_unique($widget_use);//重複削除
                        
                        switch($tlV){
                            case 'on':
                                if(!in_array($POST['widget_id'], $t_json['widget_use'])){
                                    $widget_use[] = $POST['widget_id'];
                                }
                                break;
                                
                            case 'off':
                                if(in_array($POST['widget_id'], $widget_use)){
                                    $d_index = array_search($POST['widget_id'], $widget_use);
                                    unset($widget_use[$d_index]);
                                }
                                break;
                        }
                        
                        $t_json['widget_use'] = $widget_use;
                        $tw_upd_ret = $adMDL->UpdateTenantWidgetSettingDataForWidgetUse($tlK, json_encode($t_json));
                    }
                }
                
                $log->info("Successful link registration.",array('file' => __FILE__, 'userId' => $login_user, 'data' => $prm));
                $mes = GetMsgEncode("共有リンク情報を登録しました。");
                header( 'Location: ' . $page.'?m='.$mes);
                exit;
                
                break;
                
                
            case 'e':
                if(!isset($GET['id'])) throw new Exception("共有リンクウィジェットIDが指定されていません。");
                
                $edit_id = $GET['id'];
                
                $WidgetInfo = $adMDL->GetWidgetDataByNum($edit_id);
                if(!$WidgetInfo) throw new Exception("指定された共有リンクウィジェットは存在しません。");
                
                $ws_row = $adMDL->GetWidgetSettingByID($WidgetInfo['widget_id']);
                $WidgetSetting = json_decode($ws_row['setting_json'], TRUE);
                //                 var_dump($WidgetSetting);
                $TenantList=[];
                $t_row = $adMDL->GetTenantList();
                if($t_row){
                    foreach($t_row as $tK => $tV){
                        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
                            if($tV['id'] != $_SESSION['admin']['tenant_id']){
                                continue;
                            }
                        }
                        $TenantList[] = $tV;
                    }
                }

                $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => '共有リンク情報編集フォーム', 'editId' => $edit_id));
                $isEdit = True;
                break;
                
            case 'edit':
                
                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    //                      if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }
                
                if(!isset($GET['id'])) throw new Exception("共有リンクウィジェットIDが指定されていません。");
                
                $edit_id = $GET['id'];
                
                $WidgetInfo = $adMDL->GetWidgetDataByNum($edit_id);
                if(!$WidgetInfo) throw new Exception("指定された共有リンクウィジェットは存在しません。");
                
                
                
                if(trim($POST['widget_name']) === "") throw new Exception("共有リンクウィジェット名を入力してください。");
                if(mb_strlen($POST['widget_name']) > 256) throw new Exception("共有リンクウィジェット名は256文字以内です。");
                
                if(trim($POST['widget_info']) !== ""){
                    if(mb_strlen($POST['widget_info']) > 512) throw new Exception("共有リンクウィジェット説明は512文字以内です。");
                }
                
                if($_SESSION['admin']['authorize'] == ACCOUNT_AUTHOR_OWNER){
                    
                    if(!isset($POST['widget_type'])) throw new Exception("共有リンクウィジェット種別を選択してください。");
                }
                
                //ウィジェット設定
                $setting_json = [];
                
                if(trim($POST['banner']) !== ""){
                    if(!preg_match('/(?<='.$LinkWidgetInitial.')\d{8}/', $POST['banner']) == 0) throw new Exception("リンク画像の形式が正しくありません。");
                    $setting_json['banner'] = $POST['banner'];
                } else {
                    throw new Exception("表示画像を選択してください。");
                }
                
                if(trim($POST['memo']) !== ""){
                    if(mb_strlen($POST['memo']) > 1000) throw new Exception("共有リンクウィジェットメモは1000文字以内です。");
                    $setting_json['memo'] = $POST['memo'];
                }
                
                
                if(in_array($POST['widget_type'],[WIDGET_TYPE_LINK_1,WIDGET_TYPE_LINK_2])){
                    $setting_json['tenant'] = $POST['tenant'];
                    
                    if($POST['widget_type'] === WIDGET_TYPE_LINK_2){
                        foreach($POST['tenant_setlink'] as $tenantK => $setlinkV){
                            
                            if(isset($POST['tenant_setlink'][$tenantK])){
                                if($POST['tenant'][$tenantK] == "on"){
                                    if(mb_strlen($setlinkV) > 1000) throw new Exception("リンクURLは1000文字以内です。");
                                    if(!preg_match('/^(http|https):\/\/([A-Z0-9][A-Z0-9_-]*(?:\.[A-Z0-9][A-Z0-9_-]*)+):?(\d+)?\/?/i', $setlinkV)) throw new Exception("リンクURLの形式が正しい形式ではありません。");
                                }
                                
                            }
                        }
                        
                        $setting_json['tenant_setlink'] = $POST['tenant_setlink'];
                    }
                }
                
                //                 if(in_array($POST['widget_type'],[WIDGET_TYPE_LINK_3,WIDGET_TYPE_LINK_4])){
                //                     $setting_json['view_type'] = $POST['view_type'];
                
                //                     if($POST['widget_type'] === WIDGET_TYPE_LINK_3){
                //                         $setting_json['notice_tenant'] = $POST['notice_tenant'];
                //                     }
                //                 }
                
                if(in_array($POST['widget_type'],[WIDGET_TYPE_LINK_1,WIDGET_TYPE_LINK_3,WIDGET_TYPE_LINK_4])){
                    if(isset($POST['link_url'])){
                        if(mb_strlen($POST['link_url']) > 1000) throw new Exception("リンクURLは1000文字以内です。");
                        if(!preg_match('/^(http|https):\/\/([A-Z0-9][A-Z0-9_-]*(?:\.[A-Z0-9][A-Z0-9_-]*)+):?(\d+)?\/?/i', $POST['link_url'])) throw new Exception("リンクURLの形式が正しい形式ではありません。");
                    }
                    $setting_json['link_url'] = $POST['link_url'];
                }
                
                
                //ウィジェットの表示非表示フラグ
                $setting_json['widget_viewset'] = ($POST['widget_viewset'] != "")?$POST['widget_viewset']:'off';
                
                
                $t = new Datetime();
                $prm = [
                    'widget_id' => $WidgetInfo['widget_id'],
                    'widget_name' => $POST['widget_name'],
                    'widget_info' => $POST['widget_info'],
                    'sub_widget' => 0,
                    'registrated_time' => $t->format("Y-m-d H:i:s"),
                ];
                
                $up_ret = $adMDL->UpdateWidgetData($prm);
                if(!$up_ret) throw new Exception("共有リンク情報の登録が失敗しました。");
                
                
                //画像の変更があった場合、画像を登録
                $wsd_row = $adMDL->GetWidgetSettingByID($WidgetInfo['widget_id']);
                $wsd_json = json_decode($wsd_row['setting_json'], TRUE);
                
                if($wsd_json['banner'] != $POST['banner']){
                    $upd_ret = $adMDL->UpdateFileDataStatusByIDForUpload($POST['banner']);
                }
                //仮登録画像の削除
                $del_ret = $adMDL->DeleteFileDataForPreUpload($POST['banner'], 'img');
                
                
                $ws_prm = [
                    'widget_id' => $WidgetInfo['widget_id'],
                    'setting_json' => json_encode($setting_json),
                ];
                
                //ウィジェット設定情報の登録・更新
                $ws_row = $adMDL->GetWidgetSettingByID($WidgetInfo['widget_id']);
                if($ws_row){
                    $upd_ws_ret = $adMDL->UpdateWidgetSetting($ws_prm);
                    if(!$upd_ws_ret) throw new Exception("ウィジェット設定の更新が失敗しました。");
                    
                }else{
                    //存在しなければ登録
                    $ins_ws_ret = $adMDL->InsertWidgetSetting($ws_prm);
                    if(!$ins_ws_ret) throw new Exception("ウィジェット設定の登録が失敗しました。");
                }
                
                
                if($setting_json['tenant']){
                    
                    foreach($setting_json['tenant'] as $tlK => $tlV){
                        
                        //ウィジェット使用テナント設定
                        $tw_row = $adMDL->GetTenantWidgetSettingListForTenantID($tlK);
                        $t_json = json_decode($tw_row['flag_json'], TRUE);
                        $widget_use = (is_array($t_json['widget_use']))?$t_json['widget_use']:[];
                        $widget_use = array_filter($widget_use);//NULL削除
                        $widget_use = array_unique($widget_use);//重複削除
                        
                        switch($tlV){
                            case 'on':
                                if(!in_array($WidgetInfo['widget_id'], $t_json['widget_use'])){
                                    $widget_use[] = $WidgetInfo['widget_id'];
                                }
                                break;
                                
                            case 'off':
                                if(in_array($WidgetInfo['widget_id'], $widget_use)){
                                    $d_index = array_search($WidgetInfo['widget_id'], $widget_use);
                                    unset($widget_use[$d_index]);
                                }
                                break;
                        }
                        
                        $t_json['widget_use'] = $widget_use;
                        $tw_upd_ret = $adMDL->UpdateTenantWidgetSettingDataForWidgetUse($tlK, json_encode($t_json));
                        
                    }
                }
                $log->info("Successful link update.",array('file' => __FILE__, 'userId' => $login_user, 'data' => $prm));
                $mes = GetMsgEncode("共有リンク情報を更新しました。");
                header( 'Location: ' . $page.'?m='.$mes);
                exit;
                
                break;
                
            case 'd':
                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }
                
                if(!isset($POST['num'])) throw new Exception("共有リンクウィジェットIDが指定されていません。");
                
                $del_num = $POST['num'];
                
                $WidgetInfo = $adMDL->GetWidgetDataByNum($del_num);
                if(!$WidgetInfo) throw new Exception("指定された共有リンクウィジェットは存在しません。");
                
                
                $del_ret = $adMDL->DeleteWidgetDataByNum($del_num);
                if(!$del_ret) throw new Exception("共有リンク情報の削除に失敗しました。");
                
                //ウィジェット設定情報の削除
                $del_ws_ret = $adMDL->DeleteWidgetSettingById($WidgetInfo['widget_id']);
                if(!$del_ws_ret) throw new Exception("ウィジェット設定の削除に失敗しました。");
                
                $log->info("Successful link delete.",array('file' => __FILE__, 'userId' => $login_user, 'deleteId' => $WidgetInfo['widget_id']));
                $mes = GetMsgEncode("共有リンク情報を削除しました。");
                header( 'Location: ' . $page.'?m='.$mes);
                exit;
                
                break;
        }
    } else {
        $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => '共通リンク一覧リスト'));
    }
}catch(Exception $e){
    $mes = GetMsgEncode($e->getMessage());
    // 確認
    $log->info($e);
    $log->info("Failed to link operation.", array('file' => __FILE__, 'userId' => $login_user, 'message' => $e->getMessage()));
    header( 'Location: ' . $page.'?m='.$mes.'&err');
    exit;
}

$wsList = [];
$ws_ret = $adMDL->GetWidgetSettingList();
if($ws_ret){
    foreach($ws_ret as $wsK => $wsV){
        $wsList[$wsV['widget_id']] = $wsV;
    }
}
// var_dump($wsList);

$msg_stt = (isset($GET['err']))? "danger" : "success";
$message_tag = ($mes != '')?'<div class="alert alert-'.$msg_stt.'" role="alert">'.$mes.'</div>':'';

$required_tag = '<span class="badge badge-danger">必須</span>';
$page_title = "管理画面　共有リンク管理";

$onetime_token = createToken();

include(PARTS_PATH."header.php");


?>

<style>
#RegistLinkWidget .empty_img,
#EditLinkWidget .empty_img{
    padding: 10px 20px;
    background: #fafafa;
    border: 3px dotted #ccc;
    color: #666;
}
#HideBanner {
    position: absolute;
    width: 0px;
    height: 0px;
    opacity: 0;
    left: 50%;
    bottom: 0;
    pointer-events: none;
}
</style>
    <body>
        <div id="Wrap">

        <? include(PARTS_PATH.'header-nav.php'); ?>
        	<div class="wrapper">

        		<? include(PARTS_PATH.'sidemenu.php'); ?>
        		<main class="">

            	    <div class="container grid">

						<nav class="page-header">
							<div class="container-fluid">
								<div class="navbar-wrapper">
									<h2><span class="svg-wrap mr10"><svg class="img-fluid"><use xlink:href="./asset/img/building.svg#Building"></use></svg></span>共有リンク情報管理</h2>
								</div>
							</div>
						</nav>

						<?=$message_tag ?>

						<?php if($isEdit): ?>

						<section id="EditTenant" class="page-contents">
							<div><h3>共有リンク情報編集フォーム</h3></div>
                            <div class="card-wrapper">
                                <form action="<?=$page ?>?c=edit&id=<?=h($edit_id) ?>" method="POST">
									<input type="hidden" name="one_time_token" value="<?=$onetime_token?>"/>
									<input type="hidden" name="widget_viewset" value="<?=$WidgetSetting['widget_viewset'] ?>"/>

    								<div class="form-group row">
    									<div class="col-3">共有リンクウィジェットID</div>
										<div class="col-5"><?=$WidgetInfo['widget_id'] ?></div>
                                        <div class="d-inline-block col-4">作成する共有リンクウィジェットに割り振られるウィジェットIDです。（自動採番）</div>
                                    </div>

                                    <hr />

    								<div class="form-group row">
    									<div class="col-3">共有リンクウィジェット名 <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="widget_name" id="WidgetName" placeholder="共有リンクの名前" value="<?=$WidgetInfo['widget_name'] ?>" maxlength="128" required />
                                        <div class="d-inline-block col-4">共有リンクウィジェット名を入力してください。</div>
                                    </div>

                                    <hr />

    								<div class="form-group row">
    									<div class="col-3">共有リンク情報 </div>
    									<textarea class="form-control col-5" name="widget_info" id="WidgetInfo" cols="30" rows="3" placeholder="共有リンク情報"><?=$WidgetInfo['widget_info'] ?></textarea>
                                        <div class="d-inline-block col-4">共有リンク情報を入力してください。</div>
                                    </div>

                                    <hr />


								<?php if($_SESSION['admin']['authorize'] == ACCOUNT_AUTHOR_OWNER): ?>
    								<div class="form-group row">
    									<div class="col-3">ウィジェット種別 <?=$required_tag ?></div>
    									<div class="col-5">
											<input type="hidden" name="notice_tenant" value="<?=$WidgetSetting['notice_tenant'] ?>"/>
        									<?php
        									foreach($WidgetTypeArr as $wtK => $wtV){
        									    $checked =($WidgetInfo['widget_type'] == $wtK)?"checked":"";
        									    echo '<div class="form-check mb10">';
        									    echo '<label for="WidgetType_'.$wtK.'" class="form-check-label"><input type="radio" name="widget_type" id="WidgetType_'.$wtK.'" class="form-check-input" value="'.$wtK.'" '.$checked.'/>'.$wtV.'</label>';

//         									    if($wtK === WIDGET_TYPE_LINK_4){
//         									        echo '<div class="widget-type_option"><button type="button" class="mt10 mb10 btn-sm btn-primary" data-toggle="modal" data-target="#modal-tenantselect">告知テナント選択</button><div class="select_tenantlist">指定なし</div></div>';
//         									    }

        									    echo '</div>';
        									}
        									?>
    									</div>
    									<div class="d-inline-block col-4">共有リンク情報を入力してください。</div>
                                    </div>

                                    <hr />

								<?php endif; ?>


    								<div class="form-group row" style="display:none;" data-widget-check="on" data-widget-type="<?=WIDGET_TYPE_LINK_1.','.WIDGET_TYPE_LINK_3.','.WIDGET_TYPE_LINK_4 ?>">
    									<div class="col-3">URL <?=$required_tag ?></div>
    									<div class="col-5">
        									<p class="mb10"><input class="form-control" type="text" name="link_url" id="LinkUrl" placeholder="URL" value="<?=$WidgetSetting['link_url'] ?>" maxlength="1000" required/></p>
        									<p><a href="<?=$WidgetSetting['link_url'] ?>" target="_blank" id="UrlCheckLink" class="btn btn-primary">サイト確認</a></p>
    									</div>

                                        <div class="d-inline-block col-4">リンクに設定するURLを入力してください。</div>
                                        <hr class="col-12" />
                                    </div>


    								<div class="form-group row" >
    									<div class="col-3">表示画像 <?=$required_tag ?></div>
    									<div class="col-5 row">
                                            <div class="col-8">
                                                <div class="img-wrap">
                                                    <img class="img-fluid" src="./parts/img_get.php?id=<?=$WidgetSetting['banner'] ?>">
                                                </div>
                                                <input type="" id="HideBanner" name="banner" value="<?=$WidgetSetting['banner'] ?>" required
                                                    oninvalid="this.setCustomValidity('画像を選択してください。')"
                                                    oninput="this.setCustomValidity('')"/>
                                            </div>
    										<div class="input-group col-4">
                                              <div class="custom-file">
                                                <input type="file" class="d-none" id="inputImageFile">
                                                <label class="btn btn-primary" for="inputImageFile" aria-describedby="inputGroupFileAddon">画像選択</label>
                                              </div>
                                            </div>
                                          <div id="uploader-status" class="col-12"></div>

    									</div>
                                        <div class="d-inline-block col-4">リンクを設定する画像をアップロードしてください。<br />（幅400px、高さ80px以内、GIF、PNG、JPEG形式のみ）</div>
                                    </div>

                                    <hr />


    								<div class="form-group row" style="display:none;" data-widget-check="on" data-widget-type="<?=WIDGET_TYPE_LINK_3.','.WIDGET_TYPE_LINK_4 ?>">
    									<div class="col-3">表示種別</div>
    									<div class="col-5">
    									<?php
    									$viewtype1_flg = "";
    									$viewtype2_flg = "";
    									switch($WidgetSetting['view_type']){
    									    case '1':
    									        $viewtype1_flg = "checked";
    									        break;
    									    case '2':
    									        $viewtype2_flg = "checked";
    									        break;
    									}

    									?>
                                            <div class="form-check mb10">
                                            	<label for="ViewType1" class="form-check-label"><input type="radio" name="view_type" id="ViewType1" class="form-check-input" value="1" <?=$viewtype1_flg ?>/>自テナントのみ表示</label>
                                            </div>
                                            <div class="form-check">
                                            	<label for="ViewType2" class="form-check-label"><input type="radio" name="view_type" id="ViewType2" class="form-check-input" value="2" <?=$viewtype2_flg ?>/>他テナントにも表示</label>
                                            </div>
    									</div>
    									<div class="d-inline-block col-4">共有リンク情報を入力してください。</div>
                                        <hr class="col-12" />
                                    </div>


    								<div class="form-group row" style="display:none;" data-widget-check="on" data-widget-type="<?=WIDGET_TYPE_LINK_2 ?>">
    									<div class="col-3">表示設定（個別URL設定）</div>

    									<div class="col-5">
    									<?php if(!empty($TenantList)): ?>
    									<table class="table">
    										<thead class="thead-dark">
    											<tr>
    												<th class="th_view">表示可否</th>
    												<th class="th_tenant">テナント名</th>
    												<th class="th_url">URL設定 <?=$required_tag ?></th>
    											</tr>
    										</thead>
    										<tbody>
            									<?php foreach($TenantList as $tlK => $tlV):
            									$btn_u_e = ($WidgetSetting['tenant'][$tlV['id']] == "on")?"active":"";
            									$btn_u_d = ($WidgetSetting['tenant'][$tlV['id']] == "off")?"active":"";
            									$tenant_u_flg_on = ($WidgetSetting['tenant'][$tlV['id']] == "on")?"checked":"";
            									$tenant_u_flg_off = ($WidgetSetting['tenant'][$tlV['id']] == "off")?"checked":"";


            									?>

        										<tr>
        											<td>
            											<div class="btn-group btn-group-toggle" data-toggle="buttons">
                                                          <label class="btn btn-sm btn-outline-success <?=$btn_u_e ?>">
                                                            <input type="radio" name="tenant[<?=$tlV['id'] ?>]" id="ViewSetting_e_<?=$tlK ?>" value="on" autocomplete="off" <?=$tenant_u_flg_on ?>> 表示
                                                          </label>
                                                          <label class="btn btn-sm btn-outline-secondary <?=$btn_u_d ?>">
                                                            <input type="radio" name="tenant[<?=$tlV['id'] ?>]" id="ViewSetting_d_<?=$tlK ?>" value="off" autocomplete="off" <?=$tenant_u_flg_off ?>> 非表示
                                                          </label>
                                                        </div>
        											</td>
        											<td><?=$tlV['name'] ?></td>
        											<td>
        												<input class="form-control" type="text" name="tenant_setlink[<?=$tlV['id'] ?>]" id="TenantSetLink_<?=$tlK ?>" placeholder="個別URL" value="<?=$WidgetSetting['tenant_setlink'][$tlV['id']] ?>" maxlength="1000" required/>
        												<a href="<?=$WidgetSetting['tenant_setlink'][$tlV['id']] ?>" target="_blank" id="TenantCheckLink_<?=$tlK ?>" class="btn btn-sm btn-primary">サイト確認</a>
        											</td>
        										</tr>

            									<?php endforeach; ?>
    										</tbody>
    									</table>
    									<?php endif; ?>
    									</div>

                                        <div class="d-inline-block col-4">ウィジェットの表示設定と個別URLを設定してください。</div>
                                        <hr class="col-12" />
                                    </div>


    								<div class="form-group row" style="display:none;" data-widget-check="on" data-widget-type="<?=WIDGET_TYPE_LINK_1.','.WIDGET_TYPE_LINK_3.','.WIDGET_TYPE_LINK_4 ?>">
    									<div class="col-3">表示設定</div>

    									<div class="col-5">
    									<?php if(!empty($TenantList)): ?>
    									<table class="table">
    										<thead class="thead-dark">
    											<tr>
    												<th class="th_view">表示可否</th>
    												<th class="th_tenant">テナント名</th>
    											</tr>
    										</thead>
    										<tbody>
            									<?php foreach($TenantList as $tlK => $tlV):
            									$btn_e = ($WidgetSetting['tenant'][$tlV['id']] == "on")?"active":"";
            									$btn_d = ($WidgetSetting['tenant'][$tlV['id']] == "off")?"active":"";
            									$tenant_flg_on = ($WidgetSetting['tenant'][$tlV['id']] == "on")?"checked":"";
            									$tenant_flg_off = ($WidgetSetting['tenant'][$tlV['id']] == "off")?"checked":"";

            									?>

        										<tr>
        											<td>
            											<div class="btn-group btn-group-toggle" data-toggle="buttons">
                                                          <label class="btn btn-sm btn-outline-success <?=$btn_e ?>">
                                                            <input type="radio" name="tenant[<?=$tlV['id'] ?>]" id="ViewSetting_e_<?=$tlK ?>" value="on" autocomplete="off" <?=$tenant_flg_on ?>> 表示
                                                          </label>
                                                          <label class="btn btn-sm btn-outline-secondary <?=$btn_d ?>">
                                                            <input type="radio" name="tenant[<?=$tlV['id'] ?>]" id="ViewSetting_d_<?=$tlK ?>" value="off" autocomplete="off" <?=$tenant_flg_off ?>> 非表示
                                                          </label>
                                                        </div>
        											</td>
        											<td><?=$tlV['name'] ?></td>
    											</tr>

            									<?php endforeach; ?>
    										</tbody>
    									</table>
    									<?php endif; ?>
    									</div>

                                        <div class="d-inline-block col-4">ウィジェットの表示設定を設定してください。</div>
                                        <hr class="col-12" />
                                    </div>


    								<div class="form-group row">
    									<div class="col-3">メモ</div>
    									<textarea class="form-control col-5" name="memo" id="Memo" cols="30" rows="4" placeholder="メモ"><?=$WidgetSetting['memo'] ?></textarea>
                                        <div class="d-inline-block col-4">メモ情報を入力してください。</div>
                                    </div>

                                    <hr />



                                    <div class="tcenter">
                                    	<button type="submit" class="btn btn-primary">更新</button>
                                    	<a href="<?=$page ?>" class="btn btn-default btn-outline-dark">キャンセル</a>
                                    </div>

                                </form>
                            </div>
						</section>


						<?php elseif($isRegist): ?>


						<section id="RegistLinkWidget" class="page-contents">
							<div><h3>共有リンク登録フォーム</h3></div>
                            <div class="card-wrapper">
                                <form action="<?=$page ?>?c=regist" method="POST">
									<input type="hidden" name="one_time_token" value="<?=$onetime_token?>"/>
									<input type="hidden" name="widget_id" value="<?=$newid?>"/>
									<input type="hidden" name="widget_viewset" value="off"/>

    								<div class="form-group row">
    									<div class="col-3">共有リンクウィジェットID</div>
										<div class="col-5"><?=$newid ?></div>
                                        <div class="d-inline-block col-4">作成する共有リンクウィジェットに割り振られるウィジェットIDです。（自動採番）</div>
                                    </div>

                                    <hr />

    								<div class="form-group row">
    									<div class="col-3">共有リンクウィジェット名 <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="widget_name" id="WidgetName" placeholder="共有リンクの名前" value="" maxlength="128" required/>
                                        <div class="d-inline-block col-4">共有リンクウィジェット名を入力してください。</div>
                                    </div>

                                    <hr />

    								<div class="form-group row">
    									<div class="col-3">共有リンク情報 </div>
    									<textarea class="form-control col-5" name="widget_info" id="WidgetInfo" cols="30" rows="3" placeholder="共有リンク情報"></textarea>
                                        <div class="d-inline-block col-4">共有リンク情報を入力してください。</div>
                                    </div>

                                    <hr />

    								<div class="form-group row">
    									<div class="col-3">ウィジェット種別 <?=$required_tag ?></div>
    									<div class="col-5">
											<input type="hidden" name="notice_tenant" value=""/>
        									<?php

        									foreach($WidgetTypeArr as $wtK => $wtV){
        									    $checked =("link_1" == $wtK)?"checked":"";
        									    echo '<div class="form-check mb10">';
        									    echo '<label for="WidgetType_'.$wtK.'" class="form-check-label"><input type="radio" name="widget_type" id="WidgetType_'.$wtK.'" class="form-check-input" value="'.$wtK.'" '.$checked.'/>'.$wtV.'</label>';

//         									    if($wtK === WIDGET_TYPE_LINK_4){
//         									        echo '<div class="widget-type_option"><button type="button" class="mt10 mb10 btn-sm btn-primary" data-toggle="modal" data-target="#modal-tenantselect">告知テナント選択</button><div class="select_tenantlist">指定なし</div></div>';
//         									    }

        									    echo '</div>';
        									}
        									?>
    									</div>
    									<div class="d-inline-block col-4">共有リンク情報を入力してください。</div>
                                    </div>

                                    <hr />


    								<div class="form-group row" style="display:none;" data-widget-check="on" data-widget-type="<?=WIDGET_TYPE_LINK_1.','.WIDGET_TYPE_LINK_3.','.WIDGET_TYPE_LINK_4 ?>">
    									<div class="col-3">URL <?=$required_tag ?></div>
    									<div class="col-5">
        									<p class="mb10"><input class="form-control" type="text" name="link_url" id="LinkUrl" placeholder="URL" value="" maxlength="1000" required/></p>
        									<p><a href="" target="_blank" id="UrlCheckLink" class="btn btn-primary">サイト確認</a></p>
    									</div>

                                        <div class="d-inline-block col-4">リンクに設定するURLを入力してください。</div>
                                        <hr class="col-12" />
                                    </div>


    								<div class="form-group row" >
    									<div class="col-3">表示画像 <?=$required_tag ?></div>
    									<div class="col-5 row">
                                            <div class="col-8">
                                                <div class="img-wrap">
                                                    <div class="empty_img">ここに画像が表示されます。</div>
                                                </div>
                                                <input type="" id="HideBanner" name="banner" required
                                                    oninvalid="this.setCustomValidity('画像を選択してください。')"
                                                    oninput="this.setCustomValidity('')"/>
                                            </div>
    										<div class="input-group col-4">
                                              <div class="custom-file">
                                                <input type="file" class="d-none" id="inputImageFile">
                                                <label class="btn btn-primary" for="inputImageFile" aria-describedby="inputGroupFileAddon">画像選択</label>
                                              </div>
                                            </div>
                                          <div id="uploader-status" class="col-12"></div>

    									</div>
                                        <div class="d-inline-block col-4">リンクを設定する画像をアップロードしてください。<br />（幅400px、高さ80px以内、GIF、PNG、JPEG形式のみ）</div>
                                    </div>

                                    <hr />


    								<div class="form-group row" style="display:none;" data-widget-check="on" data-widget-type="<?=WIDGET_TYPE_LINK_3.','.WIDGET_TYPE_LINK_4 ?>">
    									<div class="col-3">表示種別</div>
    									<div class="col-5">
                                            <div class="form-check mb10">
                                            	<label for="ViewType1" class="form-check-label"><input type="radio" name="view_type" id="ViewType1" class="form-check-input" value="1"/>自テナントのみ表示</label>
                                            </div>
                                            <div class="form-check">
                                            	<label for="ViewType2" class="form-check-label"><input type="radio" name="view_type" id="ViewType2" class="form-check-input" value="2"/>他テナントにも表示</label>
                                            </div>
    									</div>
    									<div class="d-inline-block col-4">共有リンク情報を入力してください。</div>
                                        <hr class="col-12" />
                                    </div>


    								<div class="form-group row" style="display:none;" data-widget-check="on" data-widget-type="<?=WIDGET_TYPE_LINK_2 ?>">
    									<div class="col-3">表示設定（個別URL設定）</div>

    									<div class="col-5">
    									<?php if(!empty($TenantList)): ?>
    									<table class="table">
    										<thead class="thead-dark">
    											<tr>
    												<th class="th_view">表示可否</th>
    												<th class="th_tenant">テナント名</th>
    												<th class="th_url">URL設定 <?=$required_tag ?></th>
    											</tr>
    										</thead>
    										<tbody>
            									<?php foreach($TenantList as $tlK => $tlV): ?>

        										<tr>
        											<td>
            											<div class="btn-group btn-group-toggle" data-toggle="buttons">
                                                          <label class="btn btn-sm btn-outline-success active">
                                                            <input type="radio" name="tenant[<?=$tlV['id'] ?>]" id="ViewSetting_e_<?=$tlK ?>" value="on" autocomplete="off" checked> 表示
                                                          </label>
                                                          <label class="btn btn-sm btn-outline-secondary">
                                                            <input type="radio" name="tenant[<?=$tlV['id'] ?>]" id="ViewSetting_d_<?=$tlK ?>" value="off" autocomplete="off"> 非表示
                                                          </label>
                                                        </div>
        											</td>
        											<td><?=$tlV['name'] ?></td>
        											<td><input class="form-control" type="text" name="tenant_setlink[<?=$tlV['id'] ?>]" id="TenantSetLink" placeholder="個別URL" value="" maxlength="1000" required/></td>
        										</tr>

            									<?php endforeach; ?>
    										</tbody>
    									</table>
    									<?php endif; ?>
    									</div>

                                        <div class="d-inline-block col-4">ウィジェットの表示設定と個別URLを設定してください。</div>
                                        <hr class="col-12" />
                                    </div>


    								<div class="form-group row" style="display:none;" data-widget-check="on" data-widget-type="<?=WIDGET_TYPE_LINK_1.','.WIDGET_TYPE_LINK_3.','.WIDGET_TYPE_LINK_4 ?>">
    									<div class="col-3">表示設定</div>

    									<div class="col-5">
    									<?php if(!empty($TenantList)): ?>
    									<table class="table">
    										<thead class="thead-dark">
    											<tr>
    												<th class="th_view">表示可否</th>
    												<th class="th_tenant">テナント名</th>
    											</tr>
    										</thead>
    										<tbody>
            									<?php foreach($TenantList as $tlK => $tlV): ?>

        										<tr>
        											<td>
            											<div class="btn-group btn-group-toggle" data-toggle="buttons">
                                                          <label class="btn btn-sm btn-outline-success active">
                                                            <input type="radio" name="tenant[<?=$tlV['id'] ?>]" id="ViewSetting_e_<?=$tlK ?>" value="on" autocomplete="off" checked> 表示
                                                          </label>
                                                          <label class="btn btn-sm btn-outline-secondary">
                                                            <input type="radio" name="tenant[<?=$tlV['id'] ?>]" id="ViewSetting_d_<?=$tlK ?>" value="off" autocomplete="off"> 非表示
                                                          </label>
                                                        </div>
        											</td>
        											<td><?=$tlV['name'] ?></td>
    											</tr>

            									<?php endforeach; ?>
    										</tbody>
    									</table>
    									<?php endif; ?>
    									</div>

                                        <div class="d-inline-block col-4">ウィジェットの表示設定を設定してください。</div>
                                        <hr class="col-12" />
                                    </div>


    								<div class="form-group row">
    									<div class="col-3">メモ</div>
    									<textarea class="form-control col-5" name="memo" id="Memo" cols="30" rows="4" placeholder="メモ"></textarea>
                                        <div class="d-inline-block col-4">メモ情報を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="tcenter">
                                    	<button type="submit" class="btn btn-primary">登録</button>
                                    	<a href="<?=$page ?>" class="btn btn-default btn-outline-dark">キャンセル</a>
                                    </div>

                                </form>
                            </div>
						</section>


						<?php else: ?>

						<section id="LinkWidgetManage" class="page-contents">
							<div><h3>共通リンク一覧リスト</h3></div>
							<div class="card-wrapper">

								<?php if($_SESSION['admin']['authorize'] == ACCOUNT_AUTHOR_OWNER): ?>
    								<div class="controlarea-wrapper">
    									<a href="<?=$page ?>?c=n" class="btn btn-primary btn-sm">新規共有リンク登録</a>
    								</div>
								<?php endif; ?>

    							<div class="table-wrapper">
    								<table id="LinkWidgetListTable" class="table">
    									<thead class="thead-dark">
        									<tr>
        										<th class="th_num" scope="col">#</th>
        										<th class="th_fieldid" scope="col">共有リンクウィジェットID</th>
        										<th class="th_fieldname" scope="col">共有リンクウィジェット名</th>
        										<th class="th_type" scope="col">リンク種別</th>
<!--         										<th class="th_status" scope="col">公開ステータス</th> -->
        										<th class="th_control" scope="col">操作</th>
        									</tr>
    									</thead>
    									<tbody>
    									<?php if($LinkWidgetList): ?>
    									<?php foreach($LinkWidgetList as $lK => $lV): ?>
                                            <tr>
                                            	<td><?=h($lV['num']) ?></td>
                                            	<td><?=h($lV['widget_id']) ?></td>
                                            	<td><?=h($lV['widget_name']) ?></td>
                                            	<td><?=$WidgetTypeArr[$lV['widget_type']] ?></td>
                                            	<!-- <td>
                                            	<?php
                                            	$wsJson = json_decode($wsList[$lV['widget_id']]['setting_json'],TRUE);

                                        	    $is_viewset_e = "";
                                        	    $is_viewset_d = "";
                                        	    $is_active_e = "";
                                        	    $is_active_d = "";
                                            	if($wsJson['widget_viewset'] == 'on'){
                                            	    $is_viewset_e = "checked";
                                            	    $is_active_e = "active";
                                            	}else{
                                            	    $is_viewset_d = "checked";
                                            	    $is_active_d = "active";
                                            	}

                                            	?>
        											<div class="btn-group btn-group-toggle" data-toggle="buttons">
                                                      <label class="btn btn-sm btn-outline-success <?=$is_active_e ?>">
                                                        <input type="radio" name="stt[<?=$lK ?>]" id="ViewSetting_e_<?=$lK ?>" value="on" <?=$is_viewset_e ?> data-widget-id="<?=h($lV['widget_id']) ?>"> 表示
                                                      </label>
                                                      <label class="btn btn-sm btn-outline-secondary <?=$is_active_d ?>">
                                                        <input type="radio" name="stt[<?=$lK ?>]" id="ViewSetting_d_<?=$lK ?>" value="off" <?=$is_viewset_d ?> data-widget-id="<?=h($lV['widget_id']) ?>"> 非表示
                                                      </label>
                                                    </div>
                                            	</td> -->
                                            	<td>
                                            		<a href="<?=$page ?>?c=e&id=<?=h($lV['num']) ?>" class="btn btn-sm btn-primary">編集</a>
                                            		<button class="btn btn-sm btn-danger" data-toggle="modal" data-target="#modal-widgetdelete" data-delnum="<?=h($lV['num'])?>" data-widget-name="<?=h($lV['widget_name'])?>">削除</button>
                                            	</td>
                                            </tr>
                                        <?php endforeach;?>
                                        <?php else: ?>
                                        <tr><td class="tcenter" colspan="6">共有リンクが登録されていません。</td></tr>
                                        <?php endif; ?>
    									</tbody>
    								</table>
    							</div>
							</div>

						</section>

						<?php endif; ?>
                    </div>
        		</main>
            </div>
		<? //include(PARTS_PATH.'footer.php'); ?>
        </div>
	</body>
    <!-- /container -->


    <!-- モーダル　テナント選択 -->
    <div class="modal fade" id="modal-tenantselect" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-label">告知テナント選択</h4>
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">

					<?php foreach($TenantList as $tlK => $tlV): ?>

                    <div class="form-check mb10">
                      <input class="form-check-input" name="notice_tenant_tmp[]" type="checkbox" id="Tenant_<?=$tlK ?>" value="<?=$tlV['id'] ?>" data-tenantname="<?=$tlV['name'] ?>">
                      <label class="form-check-label" for="Tenant_<?=$tlK ?>"><?=$tlV['name'] ?></label>
                    </div>

					<?php endforeach; ?>
                </div>

                <div class="modal-footer">
                    <button id="SelectTenantBtn" type="button" class="btn btn-primary" data-dismiss="modal">OK</button>
                    <button type="cancel" class="btn btn-default btn-outline-dark" data-dismiss="modal">キャンセル</button>
                </div>
            </div>
        </div>
    </div>


    <!-- モーダル　共有リンク削除 -->
    <div class="modal fade" id="modal-widgetdelete" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-label">共有リンク情報削除</h4>
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>この共有リンク情報を削除しますか？</p>
                    <form id="user_delete" action="<?=$page?>?c=d" method="post">
                        <input type="hidden" name="one_time_token" value="<?=$onetime_token ?>"/>
                        <input type="hidden" id="DeleteWidgetNum" name="num" value=""/>
                        <div class="form-group">
                            <label for="recipient-name" class="form-control-label">共有リンクウィジェット名:</label>
                            <input type="text" class="form-control" id="DeleteWidgetName" readonly="readonly">
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-danger">削除する</button>
                            <button type="cancel" class="btn btn-default btn-outline-dark" data-dismiss="modal">中止</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <script>

    const wtype_1 = '<?=WIDGET_TYPE_LINK_1 ?>';
    const wtype_2 = '<?=WIDGET_TYPE_LINK_2 ?>';

    $(function(){
		//URLリンクチェック
        $('#LinkUrl').on('change',function(){
        	var link = $(this).val();
        	$('#UrlCheckLink').attr('href', link);
        });

        $('#modal-widgetdelete').on('show.bs.modal', function(event) {
            var delnum = $(event.relatedTarget).data('delnum');
            var w_name = $(event.relatedTarget).data('widget-name');
            $(this).find('.modal-body #DeleteWidgetNum').val(delnum);
            $(this).find('.modal-body #DeleteWidgetName').val(w_name);
        });


        // datatableの設定を変更
        $("#LinkWidgetListTable").DataTable({
        	searching: false,
        	info: false,
        	lengthChange: false,
        	columnDefs: [
        		  { "targets": 0, "width": '10%'},
        		  { "targets": 1, "width": '20%'},
        		  { "targets": 2, "width": '37%'},
//         		  { "targets": 3, "width": '30%'},
        		  { "targets": 3, "width": '15%'},
        		  { "targets": 4, "width": '18%',"orderable": false},
        		],
        });


        $('#inputImageFile').on('change', function(){
        	file_upload($(this));
        });

        //テナント種別によるフォーム内容切り替え
		var widget_check = $('[data-widget-check="on"]');
		widget_check.each(function(i,e){
        	$(e).hide();
        });



// 		$('.widget-type_option').hide();

		$('input[name="widget_type"]').each(function(){

			if($(this).prop('checked')){
				FormPartsSwitch($(this));
			}

		});

        $('input[name="widget_type"]').on('change', function(e){
            var targ = e.target;
        	FormPartsSwitch(targ);
        });


        function FormPartsSwitch(targ){
			var select_type = targ;
// 	        if($(select_type).val() == wtype_4){
// 	        	$('.widget-type_option').show();
// 	        }else{
// 	    		$('.widget-type_option').hide();
// 	        }
    		$('.widget-type_option').hide();

			widget_check.each(function(i,e){
	        	$(e).hide();
                $(e).find('input[type="text"]').each(function(i,element) {
                    $(element).prop('disabled', true);
                });
				let data_wtype = $(e).data('widget-type').split(',');
				let ret = data_wtype.indexOf($(select_type).val());
				if(ret >= 0){
					$(e).show();
                    $(e).find('input[type="text"]').each(function(i,element) {
                        $(element).prop('disabled', false);
                    });
				}
// 				console.log(ret);
	        });
        }

        $('#SelectTenantBtn').on('click', function(e) {
            //モーダルの選択内容を取得
            var check = $(e.target).closest('.modal-content').find('input[name="notice_tenant_tmp[]"]:checked');
            var selecttenant = new Object;
            selecttenant.id = [];
            selecttenant.name = [];
            check.each(function(i,e){
            	selecttenant.id.push($(e).val());
            	selecttenant.name.push($(e).data('tenantname'));
            });
//                 console.log(selecttenant);

            //選択されたテナント名を表示
            var tenant_txt = "選択なし";
            if(selecttenant.id.length > 0){
            	tenant_txt = selecttenant.name.join(', ');
            }
            $('.select_tenantlist').text(tenant_txt);


            //フォーム内に選択内容を反映
            $('input.notice_tenant').val(selecttenant.id.join(','));

        });


        $('input[id^="ViewSetting_"]').on('change',function(){
			let stt = $(this).val();
			let wid = $(this).data('widget-id');
			ChangeWidgetViewStatus(stt, wid);
        });

        function ChangeWidgetViewStatus(stt, wid){

			let data = {
				'stt':stt,
				'wid':wid,
			};
        	// 送信先
        	var sendUrl = "./ajax_changewidgetviewstt.php";
        	var postData = {
        		url:sendUrl,
        		type:"POST",
        		data:data,
        	};

        	$.ajax(postData).done(function(response, textStatus, jqXHR){
//         		form_disabled(false);
        		if(response.state == "success"){
            		console.log(wid+'の表示切替完了');
//             		$('.page-header').after('<div class="alert alert-success" role="alert">'+wid+'の表示切替が完了しました。</div>');


        		}else{
        			var errmsg;
                    if(response.msg == "" || response.msg == undefined){
                    	errmsg = "NG.";
                    }else{
                    	errmsg = response.msg;
                    }
            		console.log(errmsg);
//                     $('.page-header').after('<div class="alert alert-danger" role="alert">'+errmsg+'</div>');

        		}


        	}).fail(function(XMLHttpRequest,jqXHR, textStatus, errorThrown){
        		console.log(XMLHttpRequest);
//         		$("#uploader-status").html(file_upload_msg("アップロードに失敗しました。", "danger"));
        	});
        }


		//ファイルアップロードAJAX
        function file_upload(obj)
        {
        	$("#uploader-status").empty();
        	$('#HideBanner').val("");

        	// 送信先
        	var sendUrl = "./ajax_imgupload.php";
        	var fd = new FormData();
        	if (obj.val()!== ''){
        		fd.append("filename",obj.prop("files")[0]);
        	}else{
        		$("#uploader-status").html(file_upload_msg("ファイルを選択してください。", "danger"));
        		return;
        	}

        	var postData = {
        		url:sendUrl,
        		type:"POST",
//         		dataType:"text",
        		data:fd,
        		processData:false,
        		contentType:false,
        		beforeSend:function(){
        			form_disabled(true);

        			$("#uploader-status").html(file_upload_msg("アップロード中…", "muted"));
        		}
        	};

        	$.ajax(postData).done(function(response, textStatus, jqXHR){
        		form_disabled(false);
        		if(response.state == "success"){
            		$("#uploader-status").html(file_upload_msg("アップロードが完了しました。", "success"));
            		$('.img-wrap').empty().append('<img class="img-fluid" src="./parts/img_get.php?id='+response.id+'">');
            		$('#HideBanner').val(response.id);
                    $('#HideBanner').get(0).setCustomValidity('');

        		}else{
        			var errmsg;
                    if(response.msg == "" || response.msg == undefined){
                    	errmsg = "NG.";
                    }else{
                    	errmsg = response.msg;
                    }
            		$("#uploader-status").html(file_upload_msg(errmsg, "danger"));
                    $('.img-wrap').empty();
                    $('#HideBanner').get(0).setCustomValidity('画像を選択してください。');

        		}
//         		$("#uploader-status").text(data);

        		// ファイル選択をクリアする
        		obj.val("");
        	}).fail(function(XMLHttpRequest,jqXHR, textStatus, errorThrown){
        		console.log(XMLHttpRequest);
        		$("#uploader-status").html(file_upload_msg("アップロードに失敗しました。", "danger"));
        	});
        }

        function form_disabled(value)
        {
        	$("#inputImageFile").prop("disabled",value);
        	$("#upload-btn").prop("disabled",value);
        }

        //テキスト表示（スタイル付き）
        function file_upload_msg(txt, type){
            switch(type){
                case 'danger':
                case 'success':
                case 'muted':
                    break;
                default:
                    return false;
                    break;
            }

            var msg = "<p class=\"text-"+type+"\">"+txt+"</p>";
			return msg;
        }

    });



    </script>

</html>