<?
/**
 * 入退室ログ画面
 */
require("core/construct.php");

require(CORE_PATH."basic.php");
require(CORE_PATH."functions.php");
require(CORE_PATH."session_check.php");
require(CORE_PATH."authorize.php");

require_once(AD_MDL_PATH."model.php");
$adMDL = new admModel($sdb, $link);

require_once(SN_MDL_PATH."model.php");
$sgMDL = new sngModel($sdb, $link);

require_once(SP_MDL_PATH."model.php");
$sapMDL = new sappModel($sdb, $link);


$page = "log.php";

$GET = filterGet();
$POST = filterPost();

$t = new Datetime();
// $isEdit = False;
// $isRegist = False;
$mes_flg = 0;

try{

    if($_SESSION['admin']['authorize'] == ACCOUNT_AUTHOR_OWNER){
        $tenant_id = $POST['tenant_id'];
    }elseif($_SESSION['admin']['authorize'] == ACCOUNT_AUTHOR_TENANT){
        $tenant_id = $_SESSION['admin']['tenant_id'];
    }



    if(isset($GET['m']))
    {
        $mes = GetMsgDecode($GET['m']);
        $mes_flg = 1;
    }

    if(isset($_GET['c']))
    {
        $mes_flg = 0;
        switch($_GET['c'])
        {

            case 'log':

                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
//                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }

                // 第三者APIからsitename(toyosu6)を取得
                require(SIGNAGE_ROOT."api.php");
                $API = new Api($tenant_id);
                $res = $API->GetTenantName();
                $sitename = $res->Data->{'General.SiteList'}[0];


                #####################################
                # DX-Coreオンプレから入退室ログデータ取得
                #####################################
                $arrayx = array();
                $array = $API->GetEntryExitLog($sitename, $tenant_id, $POST['log_start_date']);
                $json_count = count($array);

                #####################################
                # CSV出力
                #####################################
                $fname = 'Content-Disposition: attachment; filename='.$tenant_id.'_'.$POST['log_start_date'].'.csv';
                header("Content-Type: application/octet-stream");
                header($fname);

                #####################################
                # 一行目を出力
                #####################################
                $Csv = "";
                $csv_header = [
                    'floor',
                    'section_name',
                    'transit_content',
                    'transit_date',
                    'transit_time',
                    'transit_factor',
                    'personal_number',
                    'personal_name',
                    'affiliation_number',
                    'affiliation_name1',
                    'terminal_type_name',
                ];

                $csv_header = array_map('csv_encode_log', $csv_header);
                $Csv .= implode(",",$csv_header);
                $Csv .= "\n";

                if($json_count){
                    foreach($array->Data->datalist as $tK => $tV){
                        $Csv .= csv_encode_log($tV->floor).",";
                        $Csv .= csv_encode_log($tV->section_name).",";
                        $Csv .= csv_encode_log($tV->transit_content).",";
                        $Csv .= csv_encode_log($tV->transit_date).",";
                        $Csv .= csv_encode_log($tV->transit_time).",";
                        $Csv .= csv_encode_log($tV->transit_factor).",";
                        $Csv .= csv_encode_log($tV->personal_number).",";
                        $Csv .= csv_encode_log($tV->personal_name).",";
                        $Csv .= csv_encode_log($tV->affiliation_number).",";
                        $Csv .= csv_encode_log($tV->affiliation_name1).",";
                        $Csv .= csv_encode_log($tV->terminal_type_name).",";
                        $Csv .= "\n";
                    }
                }

                echo $Csv;
                #####################################
                # CSV出力
                #####################################

                exit;

        }
    }
}catch(Exception $e){
    $mes = GetMsgEncode($e->getMessage());
    header( 'Location: ' . $page.'?m='.$mes.'&err');
    exit;
}

$TenantList = [];
$t_row = $adMDL->GetTenantList();
if($t_row){
    foreach($t_row as $tK => $tV){
        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
            if($tV['id'] != $_SESSION['admin']['tenant_id']){
                continue;
            }
        }
        $TenantList[] = $tV;
    }
}

$msg_stt = (isset($GET['err']))? "danger" : "success";
$message_tag = ($mes != '')?'<div class="alert alert-'.$msg_stt.'" role="alert">'.$mes.'</div>':'';

$required_tag = '<span class="badge badge-danger">必須</span>';
$page_title = "管理画面　入退室ログ管理";

$onetime_token = createToken();

include(PARTS_PATH."header.php");

function csv_encode_log($data){
    $data = str_replace(",", '，', $data);
    $data = str_replace(array("\r\n", "\r", "\n"), '', $data);
    $enc =  mb_convert_encoding($data,"SJIS-win","auto");
    return $enc;
}

?>

    <body>
        <div id="Wrap">

        <? include(PARTS_PATH.'header-nav.php'); ?>
        	<div class="wrapper">

        		<? include(PARTS_PATH.'sidemenu.php'); ?>
        		<main class="">

            	    <div class="container grid">

						<nav class="page-header">
							<div class="container-fluid">
								<div class="navbar-wrapper">
									<h2><span class="svg-wrap mr10"><svg class="img-fluid"><use xlink:href="./asset/img/setting.svg#Setting"></use></svg></span>入退室ログ管理</h2>
								</div>
							</div>
						</nav>

                        <?php if($mes_flg==1): ?>
                        <script>
                            alert('<?=$mes ?>');
                        </script>
                        <?php
                            header( 'Location: ' . $page);
                        endif; ?>

						<section id="EditWidget" class="page-contents">
							<div><h3>入退室ログデータ取得</h3></div>
                            <div class="card-wrapper">
                                <form action="<?=$page ?>?c=log" method="POST">
									<input type="hidden" name="one_time_token" value="<?=$onetime_token?>"/>


    								<div class="form-group row">
    									
    									<?php if($_SESSION['admin']['authorize'] == ACCOUNT_AUTHOR_OWNER): ?>
    									<div class="col-4">

        									<div class="col-10 mb10">入退室ログ取得テナント <?=$required_tag ?></div>

    										<div class="col-10">
    										<?php if($TenantList): ?>
        									<select name="tenant_id" id="TenantID" class="form-control mb10">
        										<option value="">テナントを選択してください。</option>
    											<?php foreach($TenantList as $tlK => $tlV):
    											$selected = ($UserInfo['tenant_id'] == $tlV['id'])?"selected":"";
    											?>
    												<option value="<?=h($tlV['id']) ?>" <?=$selected ?>><?=h($tlV['name']) ?></option>
    											<?php endforeach; ?>
        									</select>
    										<?php else: ?>

    										※テナントが登録されていません

    										<?php endif; ?>
    										</div>

                                            <div class="d-inline-block col-10">入退室ログを取得するテナントを選択してください。</div>
    									</div>
    									<?php endif; ?>
    									

    									<div class="col-4">
    										<label class="" for="LogStartDate">日付指定 <?=$required_tag ?></label>
											<input class="form-control mb10" type="text" name="log_start_date" id="LogStartDate" placeholder="<?=$t->format("Y-m-d") ?>" value="<?=$t->format("Y-m-d") ?>"/>
                                            <div class="d-inline-block col-10">30日前までのログが取得可能です。</div>
										</div>

                                    </div>

                                    <hr />

    								<div class="form-group row">
                                        <div class="d-inline-block col-9">
                                        	<button type="submit" class="btn btn-primary">ログ取得</button>
                                        </div>
                                    </div>


                                </form>
                            </div>
						</section>

                    </div>
        		</main>
            </div>
		<? //include(PARTS_PATH.'footer.php'); ?>
        </div>
	</body>
    <!-- /container -->


    <!-- モーダル　ウィジェット情報削除 -->
    <div class="modal fade" id="modal-widgetdelete" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-label">ウィジェット情報削除</h4>
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>このウィジェット情報を削除しますか？</p>
                    <form id="user_delete" action="<?=$page?>?c=d" method="post">
                        <input type="hidden" name="one_time_token" value="<?=$onetime_token ?>"/>
                        <div class="form-group">
                            <label for="recipient-name" class="form-control-label">ウィジェットID:</label>
                            <input type="text" class="form-control" id="DeleteWidgetID" name="widget_id" readonly="readonly" required>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-danger">削除する</button>
                            <button type="cancel" class="btn btn-default btn-outline-dark" data-dismiss="modal">中止</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>



	<link rel="stylesheet" type="text/css" href="<?=ASSET_PATH ?>bootstrap-datepicker-1.9.0-dist/css/bootstrap-datepicker3.css">
    <script src="<?=ASSET_PATH ?>bootstrap-datepicker-1.9.0-dist/js/bootstrap-datepicker.min.js"></script>
    <script src="<?=ASSET_PATH ?>bootstrap-datepicker-1.9.0-dist/locales/bootstrap-datepicker.ja.min.js"></script>

    <script>
        $(function(){

            $('#LogStartDate').datepicker({
				language: "ja",
                format: 'yyyy-mm-dd',
                todayHighlight: true,  // デフォルト
                orientation: 'bottom',
            });
        });
    </script>

</html>