<?
/**
 * 入退室ログ画面
 */
require("core/construct.php");

require(CORE_PATH."basic.php");
require(CORE_PATH."functions.php");
require(CORE_PATH."session_check.php");
require(CORE_PATH."authorize.php");

require_once(AD_MDL_PATH."model.php");
$adMDL = new admModel($sdb, $link);

require_once(SN_MDL_PATH."model.php");
$sgMDL = new sngModel($sdb, $link);

require_once(SP_MDL_PATH."model.php");
$sapMDL = new sappModel($sdb, $link);


$page = "log_modal.php";

$GET = filterGet();
$POST = filterPost();

$t = new Datetime();
$tb1 = new Datetime();
$tb1 = $tb1->modify('-1 day');
// $isEdit = False;
// $isRegist = False;
$mes_flg = 0;

try{

    if($_SESSION['admin']['authorize'] == ACCOUNT_AUTHOR_OWNER){
        $tenant_id = $POST['tenant_id'];
    }elseif($_SESSION['admin']['authorize'] == ACCOUNT_AUTHOR_TENANT){
        $tenant_id = $_SESSION['admin']['tenant_id'];
    }



    if(isset($GET['m']))
    {
        $mes = GetMsgDecode($GET['m']);
        $mes_flg = 1;
    }

    if(isset($_GET['c']))
    {
        $mes_flg = 0;
        switch($_GET['c'])
        {

            case 'log':

                // 第三者APIからsitename(toyosu6)を取得
                require(SIGNAGE_ROOT."api.php");
                $API = new Api($tenant_id);
                $res = $API->GetTenantName();
                $sitename = $res->Data->{'General.SiteList'}[0];


                // DX-Coreオンプレから入退室ログデータ取得
                $array = array();
                $array = $API->GetEntryExitLog($sitename, $tenant_id, $POST['log_start_date']);
                $json_count = count($array);

                // CSV出力
                $fname = 'Content-Disposition: attachment; filename='.$tenant_id.'_'.$POST['log_start_date'].'.csv';
                header("Content-Type: application/octet-stream");
                header($fname);

                // 一行目を出力
                $Csv = "";
                $csv_header = [
                    'floor',
                    'section_name',
                    'transit_content',
                    'transit_date',
                    'transit_time',
                    'transit_factor',
                    'personal_number',
                    'personal_name',
                    'affiliation_number',
                    'affiliation_name1',
                    'terminal_type_name',
                ];

                $csv_header = array_map('csv_encode_log', $csv_header);
                $Csv .= implode(",",$csv_header);
                $Csv .= "\n";

                if($json_count){
                    foreach($array->Data->datalist as $tK => $tV){
                        $Csv .= csv_encode_log($tV->floor).",";
                        $Csv .= csv_encode_log($tV->section_name).",";
                        $Csv .= csv_encode_log($tV->transit_content).",";
                        $Csv .= csv_encode_log($tV->transit_date).",";
                        $Csv .= csv_encode_log($tV->transit_time).",";
                        $Csv .= csv_encode_log($tV->transit_factor).",";
                        $Csv .= csv_encode_log($tV->personal_number).",";
                        $Csv .= csv_encode_log($tV->personal_name).",";
                        $Csv .= csv_encode_log($tV->affiliation_number).",";
                        $Csv .= csv_encode_log($tV->affiliation_name1).",";
                        $Csv .= csv_encode_log($tV->terminal_type_name).",";
                        $Csv .= "\n";
                    }
                }

                // CSVダウンロード
                echo $Csv;

                exit;

        }
    }
}catch(Exception $e){
    header("HTTP/1.1 404 Resouce not found");
//    $mes = GetMsgEncode($e->getMessage());
//    header( 'Location: ' . $page.'?m='.$mes.'&err');
    exit;
}

$TenantList = [];
$t_row = $adMDL->GetTenantList();
if($t_row){
    foreach($t_row as $tK => $tV){
        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
            if($tV['id'] != $_SESSION['admin']['tenant_id']){
                continue;
            }
        }
        $TenantList[] = $tV;
    }
}

$msg_stt = (isset($GET['err']))? "danger" : "success";
$message_tag = ($mes != '')?'<div class="alert alert-'.$msg_stt.'" role="alert">'.$mes.'</div>':'';

$required_tag = '<span class="badge badge-danger">必須</span>';
$page_title = "管理画面　入退室ログ管理";

$onetime_token = createToken();

include(PARTS_PATH."header.php");

function csv_encode_log($data){
    $data = str_replace(",", '，', $data);
    $data = str_replace(array("\r\n", "\r", "\n"), '', $data);
    $enc =  mb_convert_encoding($data,"SJIS-win","auto");
    return $enc;
}

?>

    <body>
        <div id="Wrap">

        <? include(PARTS_PATH.'header-nav.php'); ?>
        	<div class="wrapper">

        		<? include(PARTS_PATH.'sidemenu.php'); ?>
        		<main class="">

            	    <div class="container grid">

						<nav class="page-header">
							<div class="container-fluid">
								<div class="navbar-wrapper">
									<h2><span class="svg-wrap mr10"><svg class="img-fluid"><use xlink:href="./asset/img/setting.svg#Setting"></use></svg></span>入退室ログ管理</h2>
								</div>
							</div>
						</nav>

                        <?php if($mes_flg==1): ?>
                        <script>
                            alert('<?=$mes ?>');
                        </script>
                        <?php
                            header( 'Location: ' . $page);
                        endif; ?>

						<section id="EditWidget" class="page-contents">
							<div><h3>入退室ログデータ取得</h3></div>
                            <div class="card-wrapper">
<!--                                <form action="--><?//=$page ?><!--?c=log" method="POST">-->
									<input type="hidden" name="one_time_token" value="<?=$onetime_token?>"/>
    								<div class="form-group row">

    									<?php if($_SESSION['admin']['authorize'] == ACCOUNT_AUTHOR_OWNER): ?>
    									<div class="col-4 row">

        									<div class="col-10 mb10">入退室ログ取得テナント <?=$required_tag ?></div>

    										<div class="col-10">
    										<?php if($TenantList): ?>
        									<select name="tenant_id" id="TenantID" class="form-control mb10">
        										<option value="">テナントを選択してください。</option>
    											<?php foreach($TenantList as $tlK => $tlV):
    											$selected = ($UserInfo['tenant_id'] == $tlV['id'])?"selected":"";
    											?>
    												<option value="<?=h($tlV['id']) ?>" <?=$selected ?>><?=h($tlV['name']) ?></option>
    											<?php endforeach; ?>
        									</select>
    										<?php else: ?>

    										※テナントが登録されていません

    										<?php endif; ?>
    										</div>

                                            <div class="d-inline-block col-10">入退室ログを取得するテナントを選択してください。</div>
    									</div>
                                        <?php else: ?>
                                            <input type="hidden" name="tenant_id" id="TenantID" value="<?=$tenant_id?>"/>
    									<?php endif; ?>
    									

    									<div class="col-4">
    										<label class="" for="LogStartDate">日付指定 <?=$required_tag ?></label>
											<input class="form-control mb10" type="text" name="log_start_date" id="LogStartDate" placeholder="<?=$tb1->format("Y-m-d") ?>" value="<?=$tb1->format("Y-m-d") ?>"/>
                                            <div class="d-inline-block">30日前から前日までのログが取得可能です。</div>
										</div>

<!--                                    </div>-->

                                    <hr />

<!--    								<div class="form-group row">-->
                                        <div class="d-inline-block col-9">
                                            <br/>
                                           <button class="btn btn-primary" data-toggle="modal" data-target="#modal-getlog">ログ取得</button>
<!--                                            <a class="btn btn-primary" href="#" role="button" data-toggle="modal" data-target="#modal-getlog"  data-tenantid="--><?//=$tlV['id']?><!--" data-logstartdate="--><?//=$t->format("Y-m-d") ?><!--">ログ取得</a>-->
                                        </div>
                                    </div>


<!--                                </form>-->
                            </div>
						</section>

                    </div>
        		</main>
            </div>
		<? //include(PARTS_PATH.'footer.php'); ?>
        </div>
	</body>
    <!-- /container -->

    <!-- モーダル　ログ取得 -->
    <div class="modal fade" id="modal-getlog" tabindex="-1" data-backdrop="static">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-label">入退室ログ取得中</h4>
                </div>
                <div class="modal-body text-center">
                    <img src="asset/img/loading.gif" alt="loading.gif" />
                </div>
            </div>
        </div>
    </div>



	<link rel="stylesheet" type="text/css" href="<?=ASSET_PATH ?>bootstrap-datepicker-1.9.0-dist/css/bootstrap-datepicker3.css">
    <script src="<?=ASSET_PATH ?>bootstrap-datepicker-1.9.0-dist/js/bootstrap-datepicker.min.js"></script>
    <script src="<?=ASSET_PATH ?>bootstrap-datepicker-1.9.0-dist/locales/bootstrap-datepicker.ja.min.js"></script>

    <script>
        $(function(){

            $('#LogStartDate').datepicker({
				language: "ja",
                format: 'yyyy-mm-dd',
                todayHighlight: true,  // デフォルト
                orientation: 'bottom',
                startDate: '-30d',
                endDate: '-1d'
            });

            $('#modal-getlog').on('shown.bs.modal', function(event) {

                try{
                var tenant_id = document.getElementById('TenantID').value;
                var log_start_date = document.getElementById('LogStartDate').value;
                    console.log('tenant_id : '+tenant_id);
                console.log('log_start_date : '+log_start_date);

                    if(!tenant_id){
                        throw new Error('テナントを選択してください。');
                    }
                //パラメータ作成
                var fd = new FormData();
                fd.append('tenant_id',tenant_id);
                fd.append('log_start_date',log_start_date);

                var request = new XMLHttpRequest();
                    var server_address = "./log_modal.php?c=log";
                request.open('POST', server_address , true);
                request.responseType = 'blob';
                request.onload = function (oEvent) {
                    // ダウンロード完了後の処理を定義する
                    var blob = request.response;
                    var objectURL = window.URL.createObjectURL(blob);
                    // リンク（<a>要素）を生成し、JavaScriptからクリックする
                    var link = document.createElement("a");
                    document.body.appendChild(link);
                    link.href = objectURL;
                    link.download = tenant_id+'_'+log_start_date+'.csv';
                    link.click();
                    document.body.removeChild(link);
                }


                    request.send(fd);

                request.onreadystatechange = function() {
                        try{
                            if (request.status == 404) {
                                console.log('request.status : '+request.status);
                                throw new Error('DX-Coreに登録されているテナントを選択してください。');
                            }
                        } catch (e) {
                            $('#modal-getlog').modal('hide');
                            alert(e.message);
                        }

                    if (request.readyState == 4 && request.status == 200) {
		                console.log('request.readyState : '+request.readyState);
		                console.log('request.status : '+request.status);
                            $('#modal-getlog').modal('toggle');
                        }
                    }
                } catch(e) {
                        $('#modal-getlog').modal('hide');
                    alert(e.message);
                    }
            });
















            /* post */
            function post(path, params, method='post') {
                const form = document.createElement('form');
                form.method = method;
                form.action = path;

                for (const key in params) {
                    if (params.hasOwnProperty(key)) {
                        const hiddenField = document.createElement('input');
                        hiddenField.type = 'hidden';
                        hiddenField.name = key;
                        hiddenField.value = params[key];

                        form.appendChild(hiddenField);
                    }
                }

                document.body.appendChild(form);
                form.submit();
            }
        });
    </script>

?>
</html>
