<?php
require("core/basic.php");
require("core/construct.php");
require("core/functions.php");
require_once(__DIR__."/util/utils.php");

header('Cache-Control: no-store, no-cache, must-revalidate');
header('Cache-Control: post-check=0, pre-check=0', false);
header('Pragma: no-cache');


//TODO セッション情報チェック処理

$GET = filterGet();
$POST = filterPost();

if ($GET['m']) {
    $mes = GetMsgDecode($GET['m']);
}
$msg_stt = (isset($GET['err'])) ? "danger" : "success";
$message_tag = ($mes != '') ? '<div class="alert alert-' . $msg_stt . '" role="alert">' . $mes . '</div>' : '';
$cognito_flag = (!empty($_ENV["USE_COGNITO"]) && $_ENV["USE_COGNITO"] == 1) ? true : false;
$session_form = '<script>$("#Wrap").css("visibility", "visible");</script>';
if ($cognito_flag) {
    if (empty($_SERVER["HTTP_REFERER"])) {
        $session_form = '
            <form action="logincheck_cognito.php" method="post">
                <input type="text" name="current_session" value="current_session" />
                <button type="submit" id="session_check" />
            </form>
            <script>
                window.addEventListener("load", () => {
                    $("#session_check").click();
                });
            </script>
        ';
    }
    $_SERVER["HTTP_REFERER"] = "";
}
$action = ($cognito_flag) ? "logincheck_cognito.php" : "logincheck.php";

include(PARTS_PATH . "header_nologin.php");
?>

<body>
    <div id="Wrap" style="visibility: hidden;">
        <div class="container-fluid login-wrap">

            <div class="container">

                <div class="row">
                    <div id="Login" class="col-12 col-lg-6 offset-lg-3">
                        <div id="LoginFormIcon" class="svg-wrap">
                            <svg class="img-fluid wh75px mb10">
                                <use xlink:href="./asset/img/key.svg#Key"></use>
                            </svg>
                            <p>管理画面　ログイン</p>
                        </div>
                        <form action="<?= $action ?>" method="POST">

                            <?= $message_tag ?>
                            <input type="hidden" name="csrf_token" value="<?php echo h($_SESSION['csrf_token'], ENT_QUOTES, "UTF-8") ?>">
                            <div class="form-group">
                                <input class="form-control" type="text" id="admin_id" name="admin_id" placeholder="管理者ログインID" />
                            </div>

                            <div class="form-group">
                                <input class="form-control" type="password" id="password" name="password" placeholder="パスワード" />
                            </div>

                            <div class="">
                                <button type="submit" class="btn btn-primary admin w100">ログイン</button>
                            </div>

                        </form>
                    </div>
                    <div style="visibility: hidden;"><?= $session_form ?></div>
                    <!--
                        <div id="RemindPass" class="col-12 col-lg-6 offset-lg-3">
                            <a href="">パスワードを忘れてしまった方はこちら</a>
                        </div> -->

                </div>
            </div>
        </div>
        <? include(PARTS_PATH . '/footer_nologin.php'); ?>
    </div>
</body>
<!-- /container -->

<!-- jQuery -->
<script src="<?= ASSET_JS ?>jquery.js"></script>

</html>
<? $log->info("Initial display.",array('file' => __FILE__, 'display' => 'ログイン')); ?>