<?php
// error_log(var_export("logincheck.php\n", true), 3, "./log.txt");
session_start();
require("core/construct.php");
require("core/functions.php");

require_once(__DIR__."/util/utils.php");

require_once(AD_MDL_PATH . "model.php");
$adMDL = new admModel($sdb, $link);

$GET = filterGet();
$POST = filterPost();

// Cognitoを使用する場合
if (!empty($_ENV["USE_COGNITO"]) && $_ENV["USE_COGNITO"] == 1) {
    try {
        if (empty($POST['cognito:groups'])) {
            throw new Exception('ユーザーが存在しません。');
        }

        $admin_id = "";
        $groups = $POST['cognito:groups'];
        foreach ($groups as $group) {
            $split_group = explode(":", $group, 2);
            if ($split_group[0] === "super-app") {
                $admin_id = $split_group[1];
                break;
            }
        }

        // ログイン処理
        $a_row = $adMDL->AdminLogin($admin_id);
        if (!$a_row) {
            throw new Exception('ユーザーが存在しません。');
        }

        session_start();
        session_regenerate_id();

        $_SESSION['admin']['admin_id'] = $a_row['admin_id'];
        $_SESSION['admin']['authorize'] = $a_row['authorize'];
        $_SESSION['admin']['name'] = $a_row['name'];
        $_SESSION['admin']['tenant_id'] = $a_row['tenant_id'];

        $ll = new Datetime();
        $prm = [
            'admin_id' => $a_row['admin_id'],
            'login_count' => (int)++$a_row['login_count'],
            'last_login' => $ll->format("Y-m-d H:i:s"),
        ];
        $up_ret = $adMDL->AdminLoginSuccess($prm);

        $ret = [
            'state' => 'success',
        ];

        $log->info("Login successfully.",array('file' => __FILE__, 'userId' => $a_row['admin_id']));
        header('Content-Type: application/json; charset=utf-8', true);
        echo json_encode($ret);
        exit;
    } catch (Exception $e) {
        $ret = [
            'state' => 'error',
            'msg' => $e->getMessage(),
        ];

        $admin_id = "";
        $groups = $POST['cognito:groups'];
        foreach ($groups as $group) {
            $split_group = explode(":", $group, 2);
            if ($split_group[0] === "super-app") {
                $admin_id = $split_group[1];
                break;
            }
        }
        $log->info($e);
        $log->info("Login failed.",array('file' => __FILE__, 'userId' => $admin_id, 'message' => $e->getMessage()));
        header('Content-Type: application/json; charset=utf-8', true);
        echo json_encode($ret);
        exit;
    }
}

// Cognitoを使用しない場合
try {
    if (empty($POST['admin_id']) || empty($POST['password'])) {
        throw new Exception('ログインIDとパスワードを入力してください。');
    }

    // ログイン処理
    $a_row = $adMDL->AdminLogin($POST['admin_id']);
    if (!$a_row) {
        throw new Exception('ユーザーが存在しません。');
    }

    // パスワードチェック
    $ret = password_verify($POST['password'], $a_row['pass']);
    if (!$ret) {
        $aleuc_prm = [
            'admin_id' => $a_row['admin_id'],
            'error_count' => (int)++$a_row['error_count'],
        ];

        $aleuc_ret = $adMDL->AdminLoginErrorUpdateCount($aleuc_prm);
        throw new Exception('入力されたパスワードに誤りがあります。');
    } else {

        //ロック中のアカウントかどうか確認

        //             if((int)$a_row['status'] == ACCOUNT_STATUS_LOCK) throw new Exception('このユーザーはロックされています。');

        //             //TODO エラー回数超過チェック（必要であれば）
        //             if((int)$u_row['error_count'] >= LOGIN_ERROR_LIMIT){
        //                 $leus_prm = [
        //                     'user_id' => $u_row['user_id'],
        //                     'status' => 0,
        //                 ];

        //                 $leus_ret = $adMDL->LoginErrorUpdateStatus($leus_prm);
        //                 throw new Exception('ログインエラー回数が制限を超えたため、アカウントがロックされています。');
        //             }
    }

    session_start();
    session_regenerate_id();

    $_SESSION['admin']['admin_id'] = $a_row['admin_id'];
    $_SESSION['admin']['authorize'] = $a_row['authorize'];
    $_SESSION['admin']['name'] = $a_row['name'];
    $_SESSION['admin']['tenant_id'] = $a_row['tenant_id'];

    $ll = new Datetime();
    $prm = [
        'admin_id' => $a_row['admin_id'],
        'login_count' => (int)++$a_row['login_count'],
        'last_login' => $ll->format("Y-m-d H:i:s"),
    ];
    $up_ret = $adMDL->AdminLoginSuccess($prm);

    if ($up_ret) $normal_result = True;
    //     }

    //     //自動ログイン
    //     if (!empty($cookie_token) ) {
    //         $achk_ret = $adMDL->CheckAutoLogin($cookie_token);
    //         if($achk_ret){

    //             session_start();
    //             session_regenerate_id();

    //             $_SESSION['login']['user_id'] = $achk_ret['user_id'];
    //             $_SESSION['login']['name'] = $achk_ret['name'];
    //             $_SESSION['login']['tenant_id'] = $achk_ret['tenant_id'];

    //             $auto_result = true;
    //             $id = $_SESSION['login']['user_id']; // 後続の処理のため格納
    //         }
    //     }


    //     //トークン生成処理
    //     if (($normal_result && $auto == true) || $auto_result) {
    //         //トークンの作成
    //         $token = get_token();
    //         //トークンの登録
    //         $t = new Datetime();
    //         $prm = [
    //             'user_id' => $_SESSION['admin']['user_id'],
    //             'token' => $token,
    //             'registrated_time' => $t->format("Y-m-d H:i:s"),
    //         ];
    //         $ins_ret = $MDL->RegistAutoLoginToken($prm);
    //         //自動ログインのトークンを２週間の有効期限でCookieにセット
    //         setcookie("cookie_token", $token, time()+60*60*24*14, "/"); // secure, httponly


    // //         if ($auto_result) {
    // //             //古いトークンの削除
    // //             $del_prm = [
    // //                 'token' => $cookie_token
    // //             ];
    // //             $del_ret = $MDL->DeleteAutoLoginToken($del_prm);
    // // //             delete_old_token($cookie_token, $pdo);
    // //         }

    // リダイレクト
    $log->info("Login successfully.",array('file' => __FILE__, 'userId' => $a_row['admin_id']));
    header('Location: top.php');
    exit;

    // //     } else if ($normal_result) {
    // //         // リダイレクト
    // //         header( 'Location: top.php');
    // //         exit;
    //     } else {
    //         // リダイレクト
    //         header("HTTP/1.1 301 Moved Permanently");
    //         header("Location: login.php");
    //         exit;
    //     }
} catch (Exception $e) {
    $mes = GetMsgEncode($e->getMessage());
    $log->info($e);
    $log->info("Login failed.",array('file' => __FILE__, 'userId' => $POST['admin_id'], 'message' => $e->getMessage()));
    header('Location: login.php?m=' . $mes . '&err');
    exit;
}
