<?php
require("core/construct.php");
require("core/functions.php");

require_once(__DIR__."/util/utils.php");

$GET = filterGet();
$POST = filterPost();

$request_method = $_SERVER["REQUEST_METHOD"];

if ($request_method == "POST") {
    $func = "loginCheck()";
    try {
        // error_log(var_export($POST, true), 3, "./log.txt");
        if (!empty($POST['current_session']) && $POST['current_session'] == "current_session") {
            $func = "sessionCheck()";
        } else {
            if (empty($POST['admin_id']) || empty($POST['password'])) {
                throw new Exception('ログインIDとパスワードを入力してください。');
            }
            $admin_id = $POST['admin_id'];
            $password = $POST['password'];
        }
    } catch (Exception $e) {
        $mes = GetMsgEncode($e->getMessage());
        header('Location: login.php?m=' . $mes . '&err');
        exit;
    }
} else {
    header('Location: login.php');
    exit;
}
?>


<body>
    <div style="display: none;">
        <button type="button" id="cognito" onclick="<?= $func ?>"> </button>
    </div>
</body>


<script src="<?= ASSET_JS ?>jquery-3.6.0.min.js"></script>
<script src="<?= ASSET_JS ?>aws-sdk-2.6.9.min.js"></script>
<script src="<?= ASSET_JS ?>aws-cognito-sdk.min.js"></script>
<script src="<?= ASSET_JS ?>amazon-cognito-identity.min.js"></script>
<script>
    const sessionCheck = () => {
        // Cognitoの設定
        const storage = new AmazonCognitoIdentity.CookieStorage({
            domain: "<?= $_ENV['SHARE_DOMAIN'] ?>",
        });
        const userPool = new AmazonCognitoIdentity.CognitoUserPool({
            UserPoolId: "<?= $_ENV['USER_POOL_ID'] ?>",
            ClientId: "<?= $_ENV['APP_CLIENT_ID'] ?>",
            Storage: storage,
        });
        AWS.config.region = "<?= $_ENV['REGION'] ?>";

        // セッションチェック(セッション有りなら自動ログイン)
        const currentUser = userPool.getCurrentUser();
        if (currentUser) {
            currentUser.getSession((err, session) => {
                if (!err && session && session.accessToken) {
                    $.ajax({
                        url: "logincheck.php",
                        type: "POST",
                        data: session.accessToken.payload,
                    }).done(result => {
                        if (result.state === "success") {
                            location.href = "top.php";
                        } else {
                            currentUser.signOut();
                            location.href = "login.php";
                        }
                    });
                } else {
                    location.href = "login.php";
                }
            });
        } else {
            location.href = "login.php";
        }
    }

    const loginCheck = () => {
        // Cognitoの設定
        const storage = new AmazonCognitoIdentity.CookieStorage({
            domain: "<?= $_ENV['SHARE_DOMAIN'] ?>",
        });
        const userPool = new AmazonCognitoIdentity.CognitoUserPool({
            UserPoolId: "<?= $_ENV['USER_POOL_ID'] ?>",
            ClientId: "<?= $_ENV['APP_CLIENT_ID'] ?>",
            Storage: storage,
        });
        AWS.config.region = "<?= $_ENV['REGION'] ?>";

        const cognitoUser = new AmazonCognitoIdentity.CognitoUser({
            Username: "<?= $admin_id ?>",
            Pool: userPool,
            Storage: storage,
        });

        const authenticationDetails = new AmazonCognitoIdentity.AuthenticationDetails({
            Username: "<?= $admin_id ?>",
            Password: "<?= $password ?>"
        });

        // 認証処理
        cognitoUser.authenticateUser(authenticationDetails, {
            onSuccess: result => {
                const token = result.accessToken.payload;
                $.ajax({
                    url: "logincheck.php",
                    type: "POST",
                    data: token,
                }).done(result => {
                    if (result.state === "success") {
                        location.href = "top.php";
                    } else {
                        cognitoUser.signOut();
                        const message = "ログインIDまたはパスワードが不正です。";
                        const encoded_base64 = btoa(
                            [...new TextEncoder().encode(message)]
                            .map((b) => String.fromCharCode(b)).join("")
                        );
                        const encoded = encodeURIComponent(encoded_base64);
                        location.href = "login.php?m=" + encoded + "&err";
                    }
                });
            },
            onFailure: err => {
                const message = "ログインIDまたはパスワードが不正です。";
                const encoded_base64 = btoa(
                    [...new TextEncoder().encode(message)]
                    .map((b) => String.fromCharCode(b)).join("")
                );
                const encoded = encodeURIComponent(encoded_base64);
                location.href = "login.php?m=" + encoded + "&err";
            }
        });
    }

    window.addEventListener("load", function() {
        $("#cognito").click();
    });
</script>
