<?php
session_start();
require("core/construct.php");
require("core/functions.php");

// require_once(AD_MDL_PATH . "model.php");
// $adMDL = new admModel($sdb, $link);
// $csrf_token = $_POST['csrf_token'];
// $cookie_token = $_COOKIE['cookie_token'];

require_once(__DIR__."/util/utils.php");

$cognito_flag = (!empty($_ENV["USE_COGNITO"]) && $_ENV["USE_COGNITO"] == 1) ? true : false;
$region = $_ENV["REGION"];
$user_pool_id = $_ENV["USER_POOL_ID"];
$app_client_id = $_ENV["APP_CLIENT_ID"];
$share_domain = $_ENV["SHARE_DOMAIN"];

$GET = filterGet();
$mes = "";
if ($GET['m']) {
    $mes = GetMsgDecode($GET['m']);
}
?>

<script src="<?= ASSET_JS ?>jquery-3.6.0.min.js"></script>
<script src="<?= ASSET_JS ?>aws-sdk-2.6.9.min.js"></script>
<script src="<?= ASSET_JS ?>aws-cognito-sdk.min.js"></script>
<script src="<?= ASSET_JS ?>amazon-cognito-identity.min.js"></script>
<script>
    const redirectLogin = (message = "", isError = false) => {
        if (!message || message === "") {
            location.href = "login.php?";
        }
        const encoded_base64 = btoa(
            [...new TextEncoder().encode(message)]
            .map((b) => String.fromCharCode(b)).join("")
        );
        const encoded = encodeURIComponent(encoded_base64);
        const status = (isError) ? "&err" : "";
        location.href = "login.php?m=" + encoded + status;
    }

    const sessionLogout = () => {
        {
            // Cognitoの設定
            const storage = new AmazonCognitoIdentity.CookieStorage({
                domain: "<?= $share_domain ?>",
            });
            const userPool = new AmazonCognitoIdentity.CognitoUserPool({
                UserPoolId: "<?= $user_pool_id ?>",
                ClientId: "<?= $app_client_id ?>",
                Storage: storage,
            });
            AWS.config.region = "<?= $region ?>";

            // セッションチェック
            const currentUser = userPool.getCurrentUser();
            if (currentUser) {
                currentUser.signOut();
                if ("<?= $mes ?>" == "") {
                    redirectLogin();
                } else {
                    redirectLogin("<?= $mes ?>", true);
                }
            } else {
                const message = "セッション期限が切れました。";
                redirectLogin(message, true);
            }
        }
    }
</script>

<?php
try {
    ini_set('session.use_only_cookies', 1);
    ini_set('session.use_cookies', 1);
    ini_set('session.use_trans_sid', 0);
    setcookie("PHPSESSID", '', time() - 1800, '/');
    $user_id = $_SESSION['admin']['admin_id'];
    $_SESSION['admin'] = [];
    session_destroy();
    //     $prm = [
    //         'token' => $cookie_token
    //     ];
    //     // DBとの接続
    //     $del_ret = $MDL->DeleteAutoLoginToken($prm);


    //     //Cookie のトークンを削除
    // //     setCookie("cookie_token", '', -1, "/", null, TRUE, TRUE); // secure, httponly
    //     setCookie("cookie_token", '', -1, "/"); // secure, httponly
    // リダイレクト
    if ($cognito_flag) {
        echo '<script>', 'sessionLogout();', '</script>';
        exit;
    }
    $log->info("Logout successfully.",array('file' => __FILE__, 'userId' => $user_id));
    header('Location: login.php');
    exit;
} catch (PDOException $e) {
    $log->error($e);
    $log->error("Logout failed.",array('file' => __FILE__, 'userId' => $_SESSION['admin']['admin_id'], 'message' => $e->getMessage()));
    die($e->getMessage());
}
?>
