<?

require_once 'database.php';

class admModel{
    private $DB;
    private $Link;
    public function __construct($DB, $Link){
        $this->DB = $DB;
        $this->Link = $Link;
    }

    /**
     * 管理者ログインチェック
     * AdminLogin
     */
    public function AdminLogin($aid) {
        try {
            global $log;

            $sql = sprintf("SELECT * FROM `AdminTbl` WHERE `admin_id` = '%s'",
                $this->model_sql_esc($aid));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $row = mysqli_fetch_assoc( $result );
            //             $count = mysqli_num_rows($result);

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from AdminTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'AdminTbl', 'parameter' => $aid, 'message' => $e->getMessage()));
        }

        return $row;
    }


    /**
     * ログイン失敗時　一定数以上ログインエラー
     * 入力項目をユーザーIDからメールアドレスへ変更
     */
    public function AdminLoginErrorUpdateStatus($prm) {
        try {
            global $log;

            $sql = sprintf("UPDATE `AdminTbl` SET `status` = %d WHERE `admin_id` = '%s'",
                $this->model_sql_esc($prm['status']),
                $this->model_sql_esc($prm['admin_id']));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to update login error info.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'AdminTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }

    /**
     * ログイン失敗時、エラーカウント増加
     */
    public function AdminLoginErrorUpdateCount($prm) {
        try {
            global $log;
            $sql = sprintf("UPDATE `AdminTbl` SET `error_count` = %d WHERE `admin_id` = '%s'",
                $this->model_sql_esc($prm['error_count']),
                $this->model_sql_esc($prm['admin_id']));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to update login error info.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'AdminTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * ログイン成功時
     */
    public function AdminLoginSuccess($prm) {
        try {
            global $log;
            $sql = sprintf("UPDATE `AdminTbl` SET `error_count`=0, `login_count`=%d, `last_login`='%s' WHERE `admin_id`='%s'",
                $this->model_sql_esc($prm['login_count']),
                $this->model_sql_esc($prm['last_login']),
                $this->model_sql_esc($prm['admin_id']));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to update login info.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'AdminTbl', 'parameter' => $prm, 'parameter' => [$prm['login_count'], $prm['last_login'], $prm['admin_id']], 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * ユーザー一覧取得
     */
    public function GetUserList() {
        try {
            global $log;

            $sql = "SELECT *  FROM `UserTbl`";
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from UserTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserTbl', 'message' => $e->getMessage()));
        }

        return $rows;
    }

    /**
     * テナント毎のユーザー一覧取得
     */
    public function GetUserListByTenantID($tid) {
        try {
            global $log;

            $sql = sprintf("SELECT * FROM `UserTbl` WHERE `tenant_id` = '%s'",
                $this->model_sql_esc($tid));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from UserTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserTbl', 'parameter' => $tid, 'message' => $e->getMessage()));
        }

        return $rows;
    }

    /**
     * テナントリスト毎のユーザー一覧取得
     */
    public function GetUserListByTenantIDList($tenant_id) {
        try {
            global $log;
            if ($tenant_id) {
                $whereIds = "WHERE TT.id IN ('".implode("', '", $tenant_id)."')";
            } else {
                $whereIds = "";
            }

            $sql = "SELECT UT.user_id AS user_id, UT.name AS name, TT.id AS tenant_id, TT.name AS tenant_name FROM UserTbl AS UT INNER JOIN TenantTbl AS TT ON UT.tenant_id = TT.id {$whereIds} ";
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from UserTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserTbl', 'parameter' => $tenant_id, 'message' => $e->getMessage()));
        }

        return $rows;
    }

    /**
     * ユーザー情報取得（ユーザーID）
     */
    public function GetUserInfo($uid) {
        try {
            global $log;

            $sql = sprintf("SELECT UT.*, TT.`name` AS `tenant_name` FROM `UserTbl` UT INNER JOIN `TenantTbl` TT
                ON UT.`tenant_id` = TT.`id` WHERE UT.`user_id` = '%s'",
                $this->model_sql_esc($uid));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $row = mysqli_fetch_assoc( $result );
            //             $count = mysqli_num_rows($result);

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from UserTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserTbl', 'parameter' => $uid, 'message' => $e->getMessage()));
        }

        return $row;
    }


    /**
     * GetUserInfoByNum
     * ユーザー情報取得（番号）
     */
    public function GetUserInfoByNum($num) {
        try {
            global $log;

            $sql = sprintf("SELECT *  FROM `UserTbl` WHERE `num` = %d",
                $this->model_sql_esc($num));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $row = mysqli_fetch_assoc( $result );
            //             $count = mysqli_num_rows($result);

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from UserTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserTbl', 'parameter' => $num, 'message' => $e->getMessage()));
        }

        return $row;
    }


    /**
     * CheckUserData
     * ユーザーデータ登録チェック
     */
    public function CheckUserData($uid) {
        try {
            global $log;

            $sql = sprintf("SELECT *  FROM `UserTbl` WHERE `user_id` = '%s'",
                $this->model_sql_esc($uid));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $row = mysqli_fetch_assoc( $result );
            //             $count = mysqli_num_rows($result);

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from UserTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserTbl', 'parameter' => $uid, 'message' => $e->getMessage()));
        }

        return $row;
    }


    /**
     * CheckUUIDDuplicate
     * UUIDの重複確認
     */
    public function CheckUUIDDuplicate($uuid){
        try {
            global $log;

            $sql = sprintf("SELECT * FROM `UserTbl` WHERE `uuid` = '%s'",
                $this->model_sql_esc($uuid));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $row = mysqli_fetch_assoc( $result );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from UserTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserTbl', 'parameter' => $uuid, 'message' => $e->getMessage()));
        }

        return $row;
    }

/**
     * CheckUserTagId
     * ユーザーデータ登録チェック
     */
    public function CheckUserTagId($tag_id, $user_id = null) {
        try {
            global $log;
            $sql = sprintf("SELECT * FROM `UserTbl` WHERE `tag_id` = '%s' AND `user_id` != '%s'",
                $this->model_sql_esc($tag_id),
                $this->model_sql_esc($user_id));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $row = mysqli_fetch_assoc( $result );
                // $count = mysqli_num_rows($result);

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from UserTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserTbl', 'parameter' => [$tag_id, $user_id], 'message' => $e->getMessage()));
        }

        return $row;
    }

    /**
     * テナント一覧取得
     */
    public function GetTenantList() {
        try {
            global $log;

            $sql = "SELECT * FROM `TenantTbl`";
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from TenantTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'TenantTbl', 'message' => $e->getMessage()));
        }

        return $rows;
    }


    /**
     * テナント情報取得
     * @テナントID
     */
    public function GetTenantData($tid) {
        try {
            global $log;

            $sql = sprintf("SELECT *  FROM `TenantTbl` WHERE `id` = '%s'",
                $this->model_sql_esc($tid));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $row = mysqli_fetch_assoc( $result );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from TenantTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'TenantTbl', 'parameter' => $tid, 'message' => $e->getMessage()));
        }

        return $row;
    }


    /**
     * テナント情報取得
     * @テナント名
     */
    public function GetTenantDataByName($tname) {
        try {
            global $log;

            $sql = sprintf("SELECT *  FROM `TenantTbl` WHERE `name` = '%s'",
                $this->model_sql_esc($tname));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $row = mysqli_fetch_assoc( $result );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from TenantTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'TenantTbl', 'parameter' => $tname, 'message' => $e->getMessage()));
        }

        return $row;
    }


    /**
     * エリア一覧取得
     */
    public function GetFieldList() {
        try {
            global $log;

            $sql = "SELECT * FROM `FieldTbl`";
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from FieldTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'FieldTbl', 'message' => $e->getMessage()));
        }

        return $rows;
    }


    /**
     * InsertUserData
     * ユーザー情報登録
     */
    public function InsertUserData($prm) {
        try {
            global $log;
            $sql = sprintf("INSERT INTO `UserTbl` (`num`, `user_id`, `tenant_id`, `uuid`, `user_number`, `name`, `department`, `organization`, `device_authorize`, `pass`, `last_login`, `login_count`, `error_count`, `status`) VALUES (NULL, '%s', '%s', '%s', %d, '%s', '%s', '%s', '%s', '%s', '%s', 0, 0, 1)",
                $this->model_sql_esc($prm['user_id']),
                $this->model_sql_esc($prm['tenant_id']),
                $this->model_sql_esc($prm['uuid']),
                $this->model_sql_esc($prm['user_number']),
                $this->model_sql_esc($prm['name']),
                $this->model_sql_esc($prm['department']),
                $this->model_sql_esc($prm['organization']),
                $this->model_sql_esc($prm['device_authorize']),
                $this->model_sql_esc($prm['pass']),
                $this->model_sql_esc($prm['last_login']));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed register user information.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * 共用リンクウィジェットリスト取得
     * GetWidgetListForMultiType
     */
    public function GetWidgetListForMultiType($type_arr){
        try {
            global $log;
            $val = [];
            foreach($type_arr as $taK => $taV){
                $val[] = "'".$this->model_sql_esc($taV)."'";
            }

            $sql = "SELECT * FROM `WidgetTbl` WHERE `widget_type` IN (".implode(',',$val).")";
            $result = mysqli_query( $this->Link, $sql ) or sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from WidgetTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'WidgetTbl', 'parameter' => $val, 'message' => $e->getMessage()));
        }

        return $rows;
    }


    /**
     * GetWidgetDataByID
     * 共用リンクウィジェットデータ取得（ID）
     */
    public function GetWidgetDataByID($id){
        try {
            global $log;

            $sql = sprintf("SELECT * FROM `WidgetTbl` WHERE `widget_id` = '%s'", $id);
            $result = mysqli_query( $this->Link, $sql ) or sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $row = mysqli_fetch_assoc( $result );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from WidgetTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'WidgetTbl', 'parameter' => $id, 'message' => $e->getMessage()));
        }

        return $row;
    }


    /**
     * GetWidgetDataByNum
     * 共用リンクウィジェットデータ取得（番号）
     */
    public function GetWidgetDataByNum($num){
        try {
            global $log;

            $sql = sprintf("SELECT * FROM `WidgetTbl` WHERE `num` = %d", $num);
            $result = mysqli_query( $this->Link, $sql ) or sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $row = mysqli_fetch_assoc( $result );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from WidgetTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'WidgetTbl', 'parameter' => $num, 'message' => $e->getMessage()));
        }

        return $row;
    }


    /**
     * InsertWidgetData
     * ウィジェット情報登録
     */
    public function InsertWidgetData($prm) {
        try {
            global $log;
            $sql = sprintf("INSERT INTO `WidgetTbl` (`num`, `widget_id`, `sub_widget`, `widget_type`, `widget_name`, `widget_info`, `registrated_time`) VALUES (NULL, '%s', %d, '%s', '%s', '%s', '%s')",
                $this->model_sql_esc($prm['widget_id']),
                $this->model_sql_esc($prm['sub_widget']),
                $this->model_sql_esc($prm['widget_type']),
                $this->model_sql_esc($prm['widget_name']),
                $this->model_sql_esc($prm['widget_info']),
                $this->model_sql_esc($prm['registrated_time']));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed register widget information.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'WidgetTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }






    /**
     * DeleteWidgetData
     * ウィジェット情報削除
     */
    public function DeleteWidgetData($wid) {
        try {
            global $log;
            $sql = sprintf("DELETE FROM `WidgetTbl` WHERE `widget_id` = '%s'",
                $this->model_sql_esc($wid));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to delete widget data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'WidgetTbl', 'delete_target' => $wid, 'message' => $e->getMessage()));
        }

        return $result;
    }

    /**
     * DeleteWidgetDataByNum
     * ウィジェット情報削除（番号）
     */
    public function DeleteWidgetDataByNum($num) {
        try {
            global $log;
            $sql = sprintf("DELETE FROM `WidgetTbl` WHERE `num` = %d",
                $this->model_sql_esc($num));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to delete widget data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'WidgetTbl', 'delete_target' => $num, 'message' => $e->getMessage()));
        }

        return $result;
    }




    /**
     * GetWidgetSettingList
     * ウィジェット設定情報リスト
     */
    public function GetWidgetSettingList(){
        try {
            global $log;

            $sql = "SELECT * FROM `WidgetSetting`";
            $result = mysqli_query( $this->Link, $sql ) or sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from WidgetSetting.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'WidgetSetting', 'message' => $e->getMessage()));
        }

        return $rows;
    }


    /**
     * GetWidgetSettingByID
     * ウィジェット設定情報取得（ウィジェットID）
     */
    public function GetWidgetSettingByID($id){
        try {
            global $log;

            $sql = sprintf("SELECT * FROM `WidgetSetting` WHERE `widget_id` = '%s'", $id);
            $result = mysqli_query( $this->Link, $sql ) or sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $row = mysqli_fetch_assoc( $result );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from WidgetSetting.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'WidgetSetting', 'parameter' => $id, 'message' => $e->getMessage()));
        }

        return $row;
    }




    /**
     * InsertWidgetSetting
     * ウィジェット情報登録
     */
    public function InsertWidgetSetting($prm) {
        try {
            global $log;
            $sql = sprintf("INSERT INTO `WidgetSetting` (`num`, `widget_id`, `setting_json`) VALUES (NULL, '%s', '%s')",
                $this->model_sql_esc($prm['widget_id']),
                $this->model_sql_esc($prm['setting_json']));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed register widget data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'WidgetSetting', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }



    /**
     * UpdateAPISettingData
     * ウィジェット設定情報更新
     */
    public function UpdateWidgetSetting($prm) {
        try {
            global $log;
            $sql = sprintf("UPDATE `WidgetSetting` SET `setting_json`='%s' WHERE `widget_id` = '%s'",
                $this->model_sql_esc($prm['setting_json']),
                $this->model_sql_esc($prm['widget_id']));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to update widget setting information.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'WidgetSetting', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * UpdateWidgetSettingViewStatusByID
     * ウィジェット設定情報（表示設定）更新（ウィジェットID、ステータス）
     */
    public function UpdateWidgetSettingViewStatusByID($wid, $stt) {
        try {
            global $log;
            $sql = sprintf("UPDATE `WidgetSetting` SET `setting_json` = JSON_SET(`setting_json`, '$.widget_viewset', '%s') WHERE `widget_id` = '%s'",
                $this->model_sql_esc($stt),
                $this->model_sql_esc($wid));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to update widget setting information.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'WidgetSetting', 'parameter' => [$wid, $stt], 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * DeleteWidgetSettingById
     * ウィジェット情報削除（ウィジェットID）
     */
    public function DeleteWidgetSettingById($id) {
        try {
            global $log;
            $sql = sprintf("DELETE FROM `WidgetSetting` WHERE `widget_id` = '%s'",
                $this->model_sql_esc($id));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to delete widget data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'WidgetSetting', 'delete_target' => $id, 'message' => $e->getMessage()));
        }

        return $result;
    }



    /**
     * InsertCSVMultiUserData
     * ユーザー一括登録
     */
    public function InsertCSVMultiUserData($data) {
        try {
            global $log;
            $key = [
                'num',
                'user_id',
                'tenant_id',
                'uuid',
                'name',
                'user_number',
                'department',
                'organization',
                'device_authorize',
                'pass',
                'last_login',
                'error_count',
                'login_count',
                'status',
            ];
            //             $key = array('num','company_id','tenant_id','company_class','company_name','company_zip','company_addr','company_tel','company_url','company_state');
            foreach($data as $k => $v){
                $device_auth = str_replace('，', ',', $v['device_authorize']);//全角カンマを半角カンマに変換
                if(is_null($v['num'])){

                    //TODO　ユーザーアカウント登録処理
                    $value[] = sprintf("(NULL, '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', %d, %d, %d)",
                        $this->model_sql_esc($v['user_id']),
                        $this->model_sql_esc($v['tenant_id']),
                        $this->model_sql_esc($v['uuid']),
                        $this->model_sql_esc($v['name']),
                        $this->model_sql_esc($v['user_number']),
                        $this->model_sql_esc($v['department']),
                        $this->model_sql_esc($v['organization']),
                        $this->model_sql_esc($device_auth),
                        $this->model_sql_esc($v['pass']),
                        $this->model_sql_esc($v['last_login']),
                        $this->model_sql_esc($v['error_count']),
                        $this->model_sql_esc($v['login_count']),
                        $this->model_sql_esc($v['status'])
                        );

                }else{
                    // ユーザーアカウントアップデート処理
                    $value[] = sprintf("(%d, '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', %d, %d, %d)",
                        $this->model_sql_esc($v['num']),
                        $this->model_sql_esc($v['user_id']),
                        $this->model_sql_esc($v['tenant_id']),
                        $this->model_sql_esc($v['uuid']),
                        $this->model_sql_esc($v['name']),
                        $this->model_sql_esc($v['user_number']),
                        $this->model_sql_esc($v['department']),
                        $this->model_sql_esc($v['organization']),
                        $this->model_sql_esc($device_auth),
                        $this->model_sql_esc($v['pass']),
                        $this->model_sql_esc($v['last_login']),
                        $this->model_sql_esc($v['error_count']),
                        $this->model_sql_esc($v['login_count']),
                        $this->model_sql_esc($v['status'])
                        );
                }
            }
            $value = implode(',',$value);
            $sql = "INSERT INTO `UserTbl` (".implode(',',$key).")";
            $sql .= " VALUES ".$value." ON DUPLICATE KEY UPDATE ";

            $in_arr = array();
            foreach($key as $k => $v){
                $in_arr[] = $v." = VALUES(".$v.")";
            }
            $sql .= implode(',',$in_arr);
            $sql .= ";";

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed register user information.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserTbl', 'parameter' => $data, 'message' => $e->getMessage()));exit;
        }

        return $result;
    }


    /**
     * InsertCSVMultiAreaData
     * エリア一括登録
     */
    public function InsertCSVMultiAreaData($data) {
        try {
            global $log;
            $key = [
                'num',
                'field_id',
                'tenant_id',
                'field_name',
                'belong_device',
                'x_pos',
                'y_pos',
                'width',
                'height',
                'status',
                'last-update',
            ];

            foreach($data as $k => $v){

                if(is_null($v['num'])){

                    //TODO　ユーザーアカウント登録処理
                    $value[] = sprintf("(NULL, '%s', '%s', '%s', '%s', %d, %d, %d, %d, %d, '%s')",
                        $this->model_sql_esc($v['field_id']),
                        $this->model_sql_esc($v['tenant_id']),
                        $this->model_sql_esc($v['field_name']),
                        $this->model_sql_esc($v['belong_device']),
                        $this->model_sql_esc($v['x_pos']),
                        $this->model_sql_esc($v['y_pos']),
                        $this->model_sql_esc($v['width']),
                        $this->model_sql_esc($v['height']),
                        $this->model_sql_esc($v['status']),
                        $this->model_sql_esc($v['last-update'])
                        );


                }else{
                    // ユーザーアカウントアップデート処理
                    $value[] = sprintf("(%d, '%s', '%s', '%s', '%s', %d, %d, %d, %d, %d, '%s')",
                        $this->model_sql_esc($v['num']),
                        $this->model_sql_esc($v['field_id']),
                        $this->model_sql_esc($v['tenant_id']),
                        $this->model_sql_esc($v['field_name']),
                        $this->model_sql_esc($v['belong_device']),
                        $this->model_sql_esc($v['x_pos']),
                        $this->model_sql_esc($v['y_pos']),
                        $this->model_sql_esc($v['width']),
                        $this->model_sql_esc($v['height']),
                        $this->model_sql_esc($v['status']),
                        $this->model_sql_esc($v['last-update'])
                        );
                }
            }
            $value = implode(',',$value);
            $sql = "INSERT INTO `FieldTbl` (`".implode('`,`',$key)."`)";
            $sql .= " VALUES ".$value." ON DUPLICATE KEY UPDATE ";

            $in_arr = array();
            foreach($key as $k => $v){
                $in_arr[] = "`".$v."` = VALUES(`".$v."`)";
            }
            $sql .= implode(',',$in_arr);
            $sql .= ";";

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed register area information.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'FieldTbl', 'parameter' => $data, 'message' => $e->getMessage()));exit;
        }

        return $result;
    }


    /**
     * ユーザー情報更新
     */
    public function UpdateUserData($prm) {
        try {
            global $log;
            $sql = sprintf("UPDATE `UserTbl` SET `name`='%s', `user_number`=%d, `uuid`='%s', `department`='%s', `organization`='%s', `tenant_id`='%s', `device_authorize`='%s' WHERE `num`= %d",
                $this->model_sql_esc($prm['name']),
                $this->model_sql_esc($prm['user_number']),
                $this->model_sql_esc($prm['uuid']),
                $this->model_sql_esc($prm['department']),
                $this->model_sql_esc($prm['organization']),
                $this->model_sql_esc($prm['tenant_id']),
                $this->model_sql_esc($prm['device_authorize']),
                $this->model_sql_esc($prm['num']));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to update user information.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * ユーザー情報更新（パスワード更新）
     */
    public function UpdateUserDataChangePass($prm) {
        try {
            global $log;
            $sql = sprintf("UPDATE `UserTbl` SET `name`='%s', `user_number`=%d, `uuid`='%s', `department`='%s', `organization`='%s', `tenant_id`='%s', `device_authorize`='%s', `pass`='%s' WHERE `num`= %d",
                $this->model_sql_esc($prm['name']),
                $this->model_sql_esc($prm['user_number']),
                $this->model_sql_esc($prm['uuid']),
                $this->model_sql_esc($prm['department']),
                $this->model_sql_esc($prm['organization']),
                $this->model_sql_esc($prm['tenant_id']),
                $this->model_sql_esc($prm['device_authorize']),
                $this->model_sql_esc($prm['pass']),
                $this->model_sql_esc($prm['num']));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to update user information.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * UpdateWidgetData
     * ウィジェット情報更新
     */
    public function UpdateWidgetData($prm) {
        try {
            global $log;
            $sql = sprintf("UPDATE `WidgetTbl` SET `sub_widget`=%d, `widget_name`='%s', `widget_info`='%s', `registrated_time`='%s' WHERE `widget_id`='%s'",
                $this->model_sql_esc($prm['sub_widget']),
                $this->model_sql_esc($prm['widget_name']),
                $this->model_sql_esc($prm['widget_info']),
                $this->model_sql_esc($prm['registrated_time']),
                $this->model_sql_esc($prm['widget_id']));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to update widget information.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'WidgetTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }



    /**
     * DeleteUserData
     * ユーザー情報削除
     */
    public function DeleteUserData($num) {
        try {
            global $log;
            $sql = sprintf("DELETE FROM `UserTbl` WHERE `num` = %d",
                $this->model_sql_esc($num));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to delete user data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserTbl', 'delete_target' => $num, 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * InsertTenantData
     * テナント情報登録
     */
    public function InsertTenantData($prm) {
        try {
            global $log;
            $sql = sprintf("INSERT INTO `TenantTbl` (`num`, `id`, `name`, `addr`, `lat`, `lon`, `status`) VALUES (NULL, '%s', '%s', '%s', %f, %f, 1)",
                $this->model_sql_esc($prm['id']),
                $this->model_sql_esc($prm['name']),
                $this->model_sql_esc($prm['addr']),
                $this->model_sql_esc($prm['lat']),
                $this->model_sql_esc($prm['lon']));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to update tenant data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'TenantTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * UpdateTenantData
     * テナント情報更新
     */
    public function UpdateTenantData($prm) {
        try {
            global $log;
            $sql = sprintf("UPDATE `TenantTbl` SET `name`='%s', `addr`='%s', `lat`= %f, `lon`= %f WHERE `id`='%s'",
                $this->model_sql_esc($prm['name']),
                $this->model_sql_esc($prm['addr']),
                $this->model_sql_esc($prm['lat']),
                $this->model_sql_esc($prm['lon']),
                $this->model_sql_esc($prm['id']));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to update tenant data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'TenantTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }



    /**
     * DeleteTenantData
     * テナント情報削除
     */
    public function DeleteTenantData($tid) {
        try {
            global $log;
            $sql = sprintf("DELETE FROM `TenantTbl` WHERE `id` = '%s'",
                $this->model_sql_esc($tid));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to delete tenant data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'TenantTbl', 'delete_target' => $tid, 'message' => $e->getMessage()));
        }

        return $result;
    }



    /**
     * InsertFieldData
     * エリア情報登録
     */
    public function InsertFieldData($prm) {
        try {
            global $log;
            $sql = sprintf("INSERT INTO `FieldTbl` (`num`, `field_id`, `tenant_id`, `field_name`, `belong_device`, `x_pos`, `y_pos`, `width`, `height`, `status`, `last-update`) VALUES (NULL, '%s', '%s', '%s', '%s', %f, %f, %f, %f, 1, '%s')",
                $this->model_sql_esc($prm['field_id']),
                $this->model_sql_esc($prm['tenant_id']),
                $this->model_sql_esc($prm['field_name']),
                $this->model_sql_esc($prm['belong_device']),
                $this->model_sql_esc($prm['x_pos']),
                $this->model_sql_esc($prm['y_pos']),
                $this->model_sql_esc($prm['width']),
                $this->model_sql_esc($prm['height']),
                $this->model_sql_esc($prm['last-update']));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed register area information.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'FieldTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * UpdateFieldData
     * エリア情報更新
     */
    public function UpdateFieldData($prm) {
        try {
            global $log;
            $sql = sprintf("UPDATE `FieldTbl` SET `tenant_id`='%s', `field_name`='%s', `belong_device`='%s', `x_pos`= %f, `y_pos`= %f, `width`= %f, `height`= %f, `last-update`='%s' WHERE `field_id`='%s'",
                $this->model_sql_esc($prm['tenant_id']),
                $this->model_sql_esc($prm['field_name']),
                $this->model_sql_esc($prm['belong_device']),
                $this->model_sql_esc($prm['x_pos']),
                $this->model_sql_esc($prm['y_pos']),
                $this->model_sql_esc($prm['width']),
                $this->model_sql_esc($prm['height']),
                $this->model_sql_esc($prm['last-update']),
                $this->model_sql_esc($prm['field_id']));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to update field data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'FieldTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }



    /**
     * GetFieldData
     * テナント情報取得
     * @エリアID
     */
    public function GetFieldData($fid) {
        try {
            global $log;

            $sql = sprintf("SELECT * FROM `FieldTbl` WHERE `field_id` = '%s'",
                $this->model_sql_esc($fid));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $row = mysqli_fetch_assoc( $result );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from FieldTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'FieldTbl', 'parameter' => $fid, 'message' => $e->getMessage()));
        }

        return $row;
    }


    /**
     * GetFieldDataForTenantIDs
     * テナント情報取得
     * @エリアID
     */
    public function GetFieldDataForTenantIDs($tid) {
        try {
            global $log;

            $sql = sprintf("SELECT * FROM `FieldTbl` WHERE `tenant_id` = '%s'",
                $this->model_sql_esc($tid));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from FieldTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'FieldTbl', 'parameter' => $tid, 'message' => $e->getMessage()));
        }

        return $rows;
    }


    /**
     * DeleteFieldData
     * エリア情報削除
     */
    public function DeleteFieldData($fid) {
        try {
            global $log;
            $sql = sprintf("DELETE FROM `FieldTbl` WHERE `field_id` = '%s'",
                $this->model_sql_esc($fid));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to delete field data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'FieldTbl', 'delete_target' => $fid, 'message' => $e->getMessage()));
        }

        return $result;
    }




    /**
     * テナント毎のウィジェット設定一覧取得
     */
    public function GetTenantWidgetSettingList() {
        try {
            global $log;

            $sql = "SELECT * FROM `TenantWidgetControl`";
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from TenantWidgetControl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'TenantWidgetControl', 'message' => $e->getMessage()));
        }

        return $rows;
    }


    /**
     * GetTenantWidgetSettingListForTenantID
     * テナントIDを指定してウィジェット設定データを取得
     * @テナントID
     */
    public function GetTenantWidgetSettingListForTenantID($tid) {
        try {
            global $log;

            $sql = sprintf("SELECT * FROM `TenantWidgetControl` WHERE `tenant_id` = '%s'",
                $this->model_sql_esc($tid));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $row = mysqli_fetch_assoc( $result );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from TenantWidgetControl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'TenantWidgetControl', 'parameter' => $tid, 'message' => $e->getMessage()));
        }

        return $row;
    }


    /**
     * InsertTenantWidgetSettingData
     * テナント別ウィジェット情報更新
     */
    public function InsertTenantWidgetSettingData($prm) {
        try {
            global $log;
            $sql = sprintf("INSERT INTO `TenantWidgetControl` (`tenant_id`, `flag_json`, `last-update`) VALUES ('%s', '%s', '%s')",
                $this->model_sql_esc($prm['tenant_id']),
                $this->model_sql_esc($prm['flag_json']),
                $this->model_sql_esc($prm['last-update']));
//             var_dump($sql);exit;
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed register tenant widget setting data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'TenantWidgetControl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * UpdateTenantWidgetSettingData
     * テナント別ウィジェット情報更新
     */
    public function UpdateTenantWidgetSettingData($prm) {
        try {
            global $log;
            $sql = sprintf("UPDATE `TenantWidgetControl` SET `tenant_id`='%s', `flag_json`='%s', `last-update`='%s' WHERE `num` = %d",
                $this->model_sql_esc($prm['tenant_id']),
                $this->model_sql_esc($prm['flag_json']),
                $this->model_sql_esc($prm['last-update']),
                $this->model_sql_esc($prm['num']));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to update tenant widget setting data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'TenantWidgetControl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * UpdateTenantWidgetSettingDataForWidgetUse
     * テナントウィジェット設定情報（表示ウィジェット）更新（テナントID、表示ウィジェット設定）
     */
    public function UpdateTenantWidgetSettingDataForWidgetUse($tid, $flag_json) {
        try {
            global $log;
            $sql = sprintf("UPDATE `TenantWidgetControl` SET `flag_json` = '%s' WHERE `tenant_id` = '%s'",
                $this->model_sql_esc($flag_json),
                $this->model_sql_esc($tid));
//             $sql = sprintf("UPDATE `TenantWidgetControl` SET `flag_json` = JSON_SET(`flag_json`, '$.widget_use', '%s') WHERE `tenant_id` = '%s'",
//                 $widget_use,
//                 $this->model_sql_esc($tid));
//             var_dump($sql);exit;

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to update tenant widget setting data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'TenantWidgetControl', 'parameter' => [$tid, $flag_json], 'message' => $e->getMessage()));
        }

        return $result;
    }



    /**
     * API設定一覧取得
     * GetAPISettingList
     */
    public function GetAPISettingList() {
        try {
            global $log;
            $sql = "SELECT * FROM `APISettingTbl`";
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'], $sql, mysqli_error($this->Link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from APISettingTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'APISettingTbl', 'message' => $e->getMessage()));exit;
        }

        return $rows;
    }


    /**
     * API設定データ取得
     * GetAPISettingData
     */
    public function GetAPISettingData($id) {
        try {
            global $log;
            $sql = sprintf("SELECT * FROM `APISettingTbl` WHERE `tenant_id` = '%s'",
            $this->model_sql_esc($id));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'], $sql, mysqli_error($this->Link));
            $row = mysqli_fetch_assoc( $result );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from APISettingTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'APISettingTbl', 'parameter' => $id, 'message' => $e->getMessage()));exit;
        }

        return $row;
    }


    /**
     * InsertAPISettingData
     * テナント別API設定情報登録
     */
    public function InsertAPISettingData($prm) {
        try {
            global $log;
            $sql = sprintf("INSERT INTO `APISettingTbl` (`tenant_id`, `domein`, `key_grant_type`, `username`, `key_password`, `key_clientid`, `secret_key`, `status`) VALUES ('%s', '%s', '%s', '%s', '%s', '%s', '%s', 1)",
                $this->model_sql_esc($prm['tenant_id']),
                $this->model_sql_esc($prm['domein']),
                $this->model_sql_esc($prm['key_grant_type']),
                $this->model_sql_esc($prm['username']),
                $this->model_sql_esc($prm['key_password']),
                $this->model_sql_esc($prm['key_clientid']),
                $this->model_sql_esc($prm['secret_key']));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed register API setting data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'APISettingTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * UpdateAPISettingData
     * テナント別API設定情報更新
     */
    public function UpdateAPISettingData($prm) {
        try {
            global $log;
            $sql = sprintf("UPDATE `APISettingTbl` SET `domein`='%s', `key_grant_type`='%s', `username`='%s', `key_password`='%s', `key_clientid`='%s', `secret_key`='%s' WHERE `tenant_id` = '%s'",
                $this->model_sql_esc($prm['domein']),
                $this->model_sql_esc($prm['key_grant_type']),
                $this->model_sql_esc($prm['username']),
                $this->model_sql_esc($prm['key_password']),
                $this->model_sql_esc($prm['key_clientid']),
                $this->model_sql_esc($prm['secret_key']),
                $this->model_sql_esc($prm['tenant_id']));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to update API setting data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'APISettingTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * DeleteAPISettingData
     * テナント別API設定情報削除
     */
    public function DeleteAPISettingData($tid) {
        try {
            global $log;
            $sql = sprintf("DELETE FROM `APISettingTbl` WHERE `tenant_id` = '%s'",
                $this->model_sql_esc($tid));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to delete API setting data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'APISettingTbl', 'delete_target' => $tid, 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * cron周期設定情報取得
     * CronCycle
     */
    public function CronCycle() {
        try {
            global $log;
            $sql = "SELECT * FROM `CronCycle` WHERE `num` = 1";

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'], $sql, mysqli_error($this->Link));
            $row = mysqli_fetch_assoc( $result );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from CronCycle.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'CronCycle', 'parameter' => 1, 'message' => $e->getMessage()));exit;
        }

        return $row;
    }


    /**
     * InsertFileDataForPreUpload
     * ファイル情報登録（仮登録）
     */
    public function InsertFileDataForPreUpload($prm) {
        try {
            global $log;
            $sql = sprintf("INSERT INTO `FileTbl` (`num`, `id`, `file_data`, `type`, `status`) VALUES (NULL, '%s', '%s', '%s', 0)",
                $this->model_sql_esc($prm['id']),
                $this->model_sql_esc($prm['file_data']),
                $this->model_sql_esc($prm['type']));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed register file data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'FileTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }



    /**
     * UpdateFileDataStatusByIDForUpload
     * ファイルステータス更新
     */
    public function UpdateFileDataStatusByIDForUpload($id) {
        try {
            global $log;
            $sql = sprintf("UPDATE `FileTbl` SET `status`=1 WHERE `id` = '%s'",
                $this->model_sql_esc($id));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to update file data status.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'FileTbl', 'parameter' => $id, 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * DeleteFileDataForPreUpload
     * 仮登録ファイル情報削除
     */
    public function DeleteFileDataForPreUpload($id, $type) {
        try {
            global $log;
            $sql = sprintf("DELETE FROM `FileTbl` WHERE `status` = 0 AND `type` = '%s' AND `id` != '%s'",
                $this->model_sql_esc($type),
                $this->model_sql_esc($id));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to delete file data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'FileTbl', 'delete_target' => [$id, $type], 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * GetFileDataForUpload
     * 仮登録データ選択
     */
    public function GetFileDataForUpload($id, $type) {
        try {
            global $log;
            $sql = sprintf("SELECT * FROM `FileTbl` WHERE `id` = '%s' AND `type` = '%s'",
                $this->model_sql_esc($id),
                $this->model_sql_esc($type));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'], $sql, mysqli_error($this->Link));
            $row = mysqli_fetch_assoc( $result );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from FileTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'FileTbl', 'parameter' => [$id, $type], 'message' => $e->getMessage()));exit;
        }

        return $row;
    }


    /**
     * ShowFullColumnsByTable
     * テーブル情報取得
     */
    public function ShowFullColumnsByTable($table) {
        try {
            global $log;
            $sql = sprintf("SHOW FULL COLUMNS FROM `%s`", $this->model_sql_esc($table));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get table information.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => $table, 'message' => $e->getMessage()));
        }

        return $rows;
    }


    /**
     * GetFullDataByTable
     * テーブル全カラム取得
     */
    public function GetFullDataByTable($table) {
        try {
            global $log;
            $sql = sprintf("SELECT * FROM %s", $this->model_sql_esc($table));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get all columns.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => $table, 'message' => $e->getMessage()));
        }

        return $rows;
    }


    /**
     * InsertNotificationData
     * お知らせ情報登録
     */
    public function InsertNotificationData($prm){
        try {
            global $log;
            $sql = sprintf("INSERT INTO `NotificationTbl` (`id`, `tenant_id`, `user_id`, `title`, `description`, `datetime`, `deletetime`)VALUES (NULL, '%s', '%s', '%s', '%s', '%s', '%s')",
                $this->model_sql_esc($prm['tenant_id']),
                $this->model_sql_esc($prm['user_id']),
                $this->model_sql_esc($prm['title']),
                $this->model_sql_esc($prm['description']),
                $this->model_sql_esc($prm['datetime']),
                $this->model_sql_esc($prm['deletetime']));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed register notification information.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'NotificationTbl', 'parameter' => $prm, 'message' => $e->getMessage()));

        }

        return $result;
    }


    /**
     * UpdateNotificationData
     * お知らせ情報更新
     */
    public function UpdateNotificationData($prm) {
        try {
            global $log;
            $sql = sprintf("UPDATE `NotificationTbl` SET `title`='%s', `description`='%s', `datetime`='%s', `deletetime`='%s' WHERE `user_id`='%d'",
                $this->model_sql_esc($prm['title']),
                $this->model_sql_esc($prm['description']),
                $this->model_sql_esc($prm['datetime']),
                $this->model_sql_esc($prm['deletetime']));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from NotificationTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'NotificationTbl', 'parameter' => $prm, 'message' => $e->getMessage()));

        }

        return $result;
    }


    /**
     * DeleteNotificationDataById
     * お知らせ情報削除（ID）
     */
    public function DeleteNotificationDataById($id) {
        try {
            global $log;
            $sql = sprintf("DELETE FROM `NotificationTbl` WHERE `id` = %d",
                $this->model_sql_esc($id));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to delete notification data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'NotificationTbl', 'delete_target' => $id, 'message' => $e->getMessage()));

        }

        return $result;
    }


    /**
     * DeleteNotificationDataByDatetime
     * お知らせ情報削除（削除日を過ぎたデータを削除）
     */
    public function DeleteNotificationDataByDatetime($datetime) {
        try {
            global $log;
            $sql = sprintf("DELETE FROM `NotificationTbl` WHERE `deletetime` < '%s'",
                $this->model_sql_esc($datetime));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to delete notification data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'NotificationTbl', 'delete_target' => $datetime, 'message' => $e->getMessage()));

        }

        return $result;
    }


    /**
     * お知らせ情報取得
     */
    public function GetNotificationList() {
        try {
            global $log;

            $sql = "SELECT * FROM `NotificationTbl`";
            $result = mysqli_query( $this->Link, $sql ) or sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from NotificationTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'NotificationTbl', 'message' => $e->getMessage()));

        }

        return $rows;
    }


    /**
     * お知らせ情報取得(テナントIDのリスト)
     */
    public function GetNotificationTenantIDList($tenant_id_arr){
        try {
            global $log;
            $val = [];
            foreach($tenant_id_arr as $tiK => $tiV){
                $val[] = "'".$this->model_sql_esc($tiK)."'";
            }

            $sql = "SELECT * FROM `NotificationTbl` WHERE `tenant_id` IN (".implode(',',$val).")";
            $result = mysqli_query( $this->Link, $sql ) or sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from NotificationTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'NotificationTbl', 'parameter' => $val, 'message' => $e->getMessage()));

        }
        return $rows;
    }


        /**
     * DeleteNotificationDataByDatetime
     * ナンバープレート情報削除（削除日を過ぎたデータを削除）
     */
    public function DeleteNumberPlateNotificationDataByDatetime($datetime) {
        try {
            global $log;
            $sql = sprintf("DELETE FROM `NumberPlateNotificationTbl` WHERE `deletetime` < '%s'",
                $this->model_sql_esc($datetime));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to delete number plate notification data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'NumberPlateNotificationTbl', 'delete_target' => $datetime, 'message' => $e->getMessage()));
        }

        return $result;
    }

    private function model_sql_esc($str){
        return mysqli_real_escape_string($this->Link, $str);
    }

    public function sql_error($f,$sql,$code){
        global $log;
        $body = "SQLエラーが発生しました。\n発生したPHP=".$f."\nSQL=".$sql.$code;
        echo $body;
        $log->error($body, array('file' => __FILE__));
        exit;
    }
}
?>
