<?
/**
 * お知らせ情報管理画面
 */
require("core/construct.php");

require(CORE_PATH."basic.php");
require(CORE_PATH."functions.php");
require(CORE_PATH."session_check.php");
require(CORE_PATH."authorize.php");

require(CORE_PATH."validation.php");
$VAL = new formValidation();

require_once(AD_MDL_PATH."model.php");
$adMDL = new admModel($sdb, $link);

require_once(SN_MDL_PATH."model.php");
$sgMDL = new sngModel($sdb, $link);

require_once(SP_MDL_PATH."model.php");
$sapMDL = new sappModel($sdb, $link);

require_once(__DIR__."/util/utils.php");

// ユーザーリスト取得
$u_row = $adMDL->GetUserList();
if($u_row){
    foreach($u_row as $uK => $uV){

        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
            if($uV['tenant_id'] !== $_SESSION['admin']['tenant_id']){
                continue;
            }
        }
        $UserList[$uV['user_id']] = $uV['name'];
    }
}

// 権限に付随したテナントリスト取得
$TenantNameList = [];
$t_row = $adMDL->GetTenantList();
if($t_row){
    foreach($t_row as $tK => $tV){
        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
            if($tV['id'] != $_SESSION['admin']['tenant_id']){
                continue;
            }
        }
        $TenantNameList[$tV['id']] = $tV['name'];
    }
}

// お知らせリスト
$NotificationList = [];

// 権限によるお知らせリスト取得
if ($TenantNameList){
    $n_row = $adMDL->GetNotificationTenantIDList($TenantNameList);
    foreach($n_row as $nK => $nV){
        $NotificationList[] = $nV;
    }
}

$page = "notification.php";
$GET = filterGet();
$POST = filterPost();

$isRegist = False;

$login_user = $_SESSION['admin']['admin_id'];

try{
    if(isset($GET['m']))
    {
        $mes = GetMsgDecode($GET['m']);
    }
    if(isset($_GET['c']))
    {
        $t = new Datetime();
        switch($_GET['c']){
            case 'n':
                $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'お知らせ情報登録フォーム'));
                $isRegist = True;
                break;
            
            case 'regist':

                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }

                // お知らせ情報登録
                $t = new Datetime();
                foreach($POST['user_table'] as $dadV){
                $id = explode(":", $dadV);
                $tenant_id = $id[0];
                $user_id = $id[1];
                $Notification_list = [
                    'user_id' => $user_id,
                    'tenant_id' => $tenant_id,
                    'title' => $POST['title'],
                    'description' => $POST['description'],
                    'datetime' => $t->format("Y-m-d H:i:s"),
                    'deletetime' => $POST['deleteday']." ".$POST['deletetime'],
                ];
                $result = $adMDL->InsertNotificationData($Notification_list);
                }
                if(!$result) throw new Exception("お知らせ情報の登録に失敗しました。");

                $log->info("Successful notification registration.",array('file' => __FILE__, 'userId' => $login_user, 'data' => $Notification_list));
                $mes = GetMsgEncode("お知らせ情報の登録に成功しました。");
                header( 'Location: ' . $page.'?m='.$mes);
                exit;
                break;

            case 'd':
                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }
                if(!isset($POST['id'])) throw new Exception("IDが指定されていません。");
                $delete_id = $POST['id'];
                $del_ret = $adMDL->DeleteNotificationDataById($delete_id);
                if(!$del_ret) throw new Exception("お知らせ情報の削除に失敗しました。");

                $log->info("Successful notification delete.",array('file' => __FILE__, 'userId' => $login_user, 'deleteId' => $delete_id));
                $mes = GetMsgEncode("お知らせ情報を削除しました。");
                header( 'Location: ' . $page.'?m='.$mes);
                exit;
                break;
        }
    } else {
        $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'お知らせ情報一覧'));
    }
}catch(Exception $e){
    $mes = GetMsgEncode($e->getMessage());
    // 確認
    $log->info($e);
    $log->info("Failed to notification operation.", array('file' => __FILE__, 'userId' => $login_user, 'message' => $e->getMessage()));
    header( 'Location: ' . $page.'?m='.$mes.'&err');
    exit;
}

$msg_stt = (isset($GET['err']))? "danger" : "success";
$message_tag = ($mes != '')?'<div class="alert alert-'.$msg_stt.'" role="alert">'.$mes.'</div>':'';

$required_tag = '<span class="badge badge-danger">必須</span>';
$page_title = "管理画面　お知らせ情報管理";

$onetime_token = createToken();

include(PARTS_PATH."header.php");


?>
    <!-- Tempus Dominus CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.0/css/tempusdominus-bootstrap-4.min.css" />
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.14.0/css/all.min.css" integrity="sha512-1PKOgIY59xJ8Co8+NE6FZ+LOAZKjy+KY8iq0G4B3CyeY6wYHN3yt9PW0XpSriVlkMXe40PTKnXrLnZ9+fkDaog==" crossorigin="anonymous" />
    <!-- 削除日時時計マーク非表示,お知らせ情報詳細の内容の高さ300pxで固定 -->
    <link rel="stylesheet" href="asset/css/custom.css" />

    <body>
        <div id="Wrap">
        <? include(PARTS_PATH.'header-nav.php'); ?>
            <div class="wrapper">
                <? include(PARTS_PATH.'sidemenu.php'); ?>
                <main class="">
                    <div class="container grid">
                        <nav class="page-header">
                            <div class="container-fluid">
                                <div class="navbar-wrapper">
                                    <h2><span class="svg-wrap mr10"><svg class="img-fluid"><use xlink:href="./asset/img/setting.svg#Setting"></use></svg></span>お知らせ情報管理</h2>
                                </div>
                            </div>
                        </nav>
                        <?=$message_tag ?>
                        <?php if($isRegist): ?>
                        <section id="SectionNotificationRegist" class="page-contents">
                            <div><h3>お知らせ情報登録フォーム</h3></div>
                            <div class="card-wrapper">
                                <form id="FormNotificationRegist" name="FormNotificationRegist" action="<?=$page ?>?c=regist" method="POST">
                                    <input type="hidden" name="one_time_token" value="<?=$onetime_token?>"/>
                                    <div class="form-group row">
                                        <div class="col-3">タイトル<?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="title" id="RegistTitle" placeholder="タイトル" value="" required/>
                                        <div class="d-inline-block col-4">タイトルを入力してください。（50文字まで）</div>
                                    </div>
                                    <hr />
                                    <div class="form-group row">
                                        <div class="col-3">内容<?=$required_tag ?></div>
                                        <textarea name="description" id="RegistDescription" cols="30" rows="6" class="form-control col-5" placeholder="内容" required></textarea>
                                        <div class="d-inline-block col-4">内容を入力してください。（2000文字まで）</div>
                                    </div>
                                    <hr />
                                    <div class="form-group row">
                                        <div class="col-3">削除日時<?=$required_tag ?></div>
                                        <input class="form-control col-3" type="text" name="deleteday" id="datepicker" placeholder="削除日時" value="<?=h(date("Y-m-d", mktime(0,0,0,date('n'),date('j')+7,date('Y')))) ?>" required/>
                                        <input class="form-control col icon-del" type="time" name="deletetime" id="timePicker" class="form-control form-control-sm datetimepicker-input" placeholder="通知削除時間" data-target="#timePicker" value="00:00" required/>
                                        <div class="input-group-append" data-target="#timePicker" data-toggle="datetimepicker">
                                        <div class="input-group-text"><i class="fa fa-clock"></i></div>
                                        </div>
                                        <div class="d-inline-block col-4">お知らせ情報を削除する日時を入力してください。</div>
                                    </div>
                                    <hr />
                                    <div class="form-group row">
                                        <div class="col-3">テナント名<?=$required_tag ?></div>
                                        <div class="col-5">
                                            <div class="table-wrapper">
                                                <div class="row">
                                                    <div class="col-12 mt10">
                                                        <button id="TenantAllCheckBtn" class="tenant btn btn-sm btn-light btn-outline-secondary" type="button">すべて選択</button>
                                                        <button id="TenantAllUnCheckBtn" class="tenant btn btn-sm btn-light btn-outline-secondary" type="button">すべて選択解除</button>
                                                    </div>
                                                </div>
                                                <table id="NotificationTenantListTable" class="table">
                                                    <thead class="thead-dark">
                                                        <tr>
                                                            <th class="th_chk" scope="col">チェック</th>
                                                            <th class="th_tname" scope="col">テナント名</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php foreach($TenantNameList as $tiK => $tiv): ?>
                                                        <?php
                                                            $TenantWidgetID = $adMDL->GetTenantDataByName($tiv);
                                                            $TenantWidgetInfo = $adMDL->GetTenantWidgetSettingListForTenantID($TenantWidgetID['id']);
                                                            $json = json_decode($TenantWidgetInfo['flag_json'], TRUE);
                                                            $checked = (in_array("NotificationWidget", $json['widget_use']))?true:false;
                                                        ?> 
                                                        <?php if($checked): ?>
                                                        <tr>
                                                            <td>
                                                                <div class="form-check form-check-inline">
                                                                <input class="form-check-input" type="checkbox" name="TenantList" id="TenantList_<?php echo $tiK ?>" value="<?php echo $tiK ?>">
                                                                </div>
                                                            </td>
                                                            <td><?php echo $tiv ?></td>
                                                        </tr>
                                                        <?php endif; ?>
                                                    <?php endforeach; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                        <div class="d-inline-block col-4">テナント名を選択してください。（複数選択可）</div>
                                    </div>
                                    <hr />
                                    <div class="form-group row">
                                        <div class="col-3">ユーザー名<?=$required_tag ?></div>
                                        <div class="col-5">
                                            <div id="AjaxNotificationWrap">
                                                <div class="table-wrapper">
                                                    <div class="row">
                                                        <div class="col-12 mt10">
                                                            <button id="UserAllCheckBtn" class="user btn btn-sm btn-light btn-outline-secondary" type="button">すべて選択</button>
                                                            <button id="UserAllUnCheckBtn" class="user btn btn-sm btn-light btn-outline-secondary" type="button">すべて選択解除</button>
                                                        </div>
                                                    </div>
                                                    <table id="NotificationUserListTable" class="table">
                                                        <thead class="thead-dark">
                                                            <tr>
                                                                <th class="th_chk" scope="col">チェック</th>
                                                                <th class="th_tname" scope="col">テナント名</th>
                                                                <th class="th_yid" scope="col">ユーザーID</th>
                                                                <th class="th_yname" scope="col">ユーザー名</th>
                                                                <th hidden class="th_tid" scope="col">テナントID</th>
                                                            </tr>
                                                        </thead>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="d-inline-block col-4">ユーザー名を選択してください。（複数選択可）</div>
                                    </div>
                                    <hr />
                                    <div class="tcenter">
                                        <button type="submit" class="btn btn-primary" id="NotificationRegist">登録</button>
                                        <a href="<?=$page ?>" class="btn btn-default btn-outline-dark">キャンセル</a>
                                    </div>
                                </form>
                            </div>
                        </section>
                        <?php else: ?>
                        <section id="NotificationManage" class="page-contents">
                            <div><h3>お知らせ情報一覧</h3></div>
                            <div class="card-wrapper">
                                <div class="adduser-wrapper">
                                    <a href="<?=$page ?>?c=n" class="btn btn-primary btn-sm">お知らせ情報登録</a>
                                </div>
                                <div class="table-wrapper">
                                    <table id="NotificationListTable" class="table">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th class="th_num" scope="col">#</th>
                                                <th class="th_notificationtitle" scope="col">タイトル</th>
                                                <th class="th_notificationcontent" scope="col">内容</th>
                                                <th class="th_notificationdeletedate" scope="col">削除日時</th>
                                                <th nowrap class="th_tenantname" scope="col">テナント名</th>
                                                <th class="th_control" scope="col">操作</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <?php foreach($NotificationList as $wlK => $wlV):
                                        ?>
                                            <tr>
                                                <td><?=h($wlV['id']) ?></td>
                                                <td><?=h($wlV['title']) ?></td>
                                                <?php
                                                $description = $wlV['description'];
                                                // 内容が100文字以上で3点リーダーを表示
                                                if (mb_strlen(h($wlV['description'])) > 100) {
                                                    $description = mb_substr($description, 0, 100);
                                                    $description = $description.'...';
                                                }
                                                ?>
                                                <td class="description" id="description" style="word-break: break-all;"><?=$description ?></td>
                                                <td><?=h($wlV['deletetime']) ?></td>
                                                <td><?=h($TenantNameList[$wlV['tenant_id']]) ?></td>
                                                <td nowrap>
                                                    <button class="btn btn-sm btn-info" data-toggle="modal" data-target="#modal-notificationdetail" data-title="<?=$wlV['title']?>" data-description="<?=$wlV['description']?>" 
                                                    data-deletetime="<?=$wlV['deletetime']?>" data-tenantname="<?=$TenantNameList[$wlV['tenant_id']]?>" data-userid="<?=$wlV['user_id']?>" 
                                                    data-username="<?=$UserList[$wlV['user_id']]?>">詳細</button>
                                                    <button class="btn btn-sm btn-danger" data-toggle="modal" data-target="#modal-notificationdelete" data-whatever="<?=$wlV['title']?>" data-delid="<?=$wlV['id']?>">削除</button>
                                                </td>
                                            </tr>
                                        <?php endforeach;?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </section>
                        <?php endif; ?>
                    </div>
                </main>
            </div>
        <? //include(PARTS_PATH.'footer.php'); ?>
        </div>
    </body>
    <!-- /container -->


    <!-- モーダル　お知らせ情報削除 -->
    <div class="modal fade" id="modal-notificationdelete" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-label">お知らせ情報削除</h4>
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>このお知らせ情報を削除しますか？</p>
                    <form id="user_delete" action="<?=$page?>?c=d" method="post">
                        <input type="hidden" name="one_time_token" value="<?=$onetime_token ?>"/>
                        <div class="form-group">
                            <label for="#DeleteNotificationTitle" class="form-control-label">タイトル:</label>
                            <input type="text" class="form-control" id="DeleteNotificationTitle" name="title" readonly="readonly" required>
                            <input type="hidden" id="DeleteNotificationID" name="id">
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-danger">削除する</button>
                            <button type="cancel" class="btn btn-default btn-outline-dark" data-dismiss="modal">中止</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- モーダル　お知らせ情報詳細表示 -->
    <div class="modal fade" id="modal-notificationdetail" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-label">お知らせ情報詳細</h4>
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="one_time_token" value="<?=$onetime_token ?>"/>
                    <div class="form-group">
                        <label for="#DetailNotificationTitle" class="form-control-label">タイトル:</label>
                        <input type="text" class="form-control" id="DetailNotificationTitle" name="title" readonly="readonly" required>
                        <label for="#DetailNotificationDescription" class="form-control-label">内容:</label>
                        <textarea type="text" class="form-control" id="DetailNotificationDescription" name="description" readonly="readonly" required></textarea>
                        <label for="#DetailNotificationDeletetime" class="form-control-label">削除日時:</label>
                        <input type="text" class="form-control" id="DetailNotificationDeletetime" name="deletetime" readonly="readonly" required>
                        <label for="#DetailNotificationTenantname" class="form-control-label">テナント名:</label>
                        <input type="text" class="form-control" id="DetailNotificationTenantname" name="tenantname" readonly="readonly" required>
                        <label for="#DetailNotificationUserid" class="form-control-label">ユーザーID:</label>
                        <input type="text" class="form-control" id="DetailNotificationUserid" name="userid" readonly="readonly" required>
                        <label for="#DetailNotificationUsername" class="form-control-label">ユーザー名:</label>
                        <input type="text" class="form-control" id="DetailNotificationUsername" name="username" readonly="readonly" required>
                    </div>
                    <div class="modal-footer">
                        <button type="cancel" class="btn btn-outline-dark" data-dismiss="modal">閉じる</button>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- Datepicker -->
    <link rel="stylesheet" type="text/css" href="<?=ASSET_PATH ?>bootstrap-datepicker-1.9.0-dist/css/bootstrap-datepicker3.css">
    <script src="<?=ASSET_PATH ?>bootstrap-datepicker-1.9.0-dist/js/bootstrap-datepicker.min.js"></script>
    <script src="<?=ASSET_PATH ?>bootstrap-datepicker-1.9.0-dist/locales/bootstrap-datepicker.ja.min.js"></script>

    <!-- Tempus Dominus Script -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.27.0/moment.min.js" integrity="sha512-rmZcZsyhe0/MAjquhTgiUcb4d9knaFc7b5xAfju483gbEXTkeJRUMIPk6s3ySZMYUHEcjKbjLjyddGWMrNEvZg==" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.27.0/locale/ja.min.js" integrity="sha512-rElveAU5iG1CzHqi7KbG1T4DQIUCqhitISZ9nqJ2Z4TP0z4Aba64xYhwcBhHQMddRq27/OKbzEFZLOJarNStLg==" crossorigin="anonymous"></script>
    <!-- Moment.js -->
    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.0.0/js/tempusdominus-bootstrap-4.min.js"></script>

    <script>
        $(function(){
            $('#datepicker').datepicker({
                language: "ja",
                format: 'yyyy-mm-dd',
                todayHighlight: true,  // デフォルト
                orientation: 'bottom',
                startDate: '0d'
            });
            $('#timePicker').datetimepicker({
                locale: 'ja',
                format: 'HH:mm'
            });
        });
    </script>
    <script src="<?=ASSET_JS ?>notification.js"></script>
