<?
/**
 * ナンバープレート情報管理画面
 */
require_once(__DIR__."/util/utils.php");
require("core/construct.php");

require(CORE_PATH."basic.php");
require(CORE_PATH."functions.php");
require(CORE_PATH."session_check.php");
require(CORE_PATH."authorize.php");
require_once(SIGNAGE_ROOT."api.php");

require(CORE_PATH."validation.php");
$VAL = new formValidation();

require_once(AD_MDL_PATH."model.php");
$adMDL = new admModel($sdb, $link);

require_once(SN_MDL_PATH."model.php");
$sgMDL = new sngModel($sdb, $link);

require_once(SP_MDL_PATH."model.php");
$sapMDL = new sappModel($sdb, $link);

$tenant_id = $_SESSION['admin']['tenant_id'];

// 権限に付随したユーザーリストとUUIDリスト取得
$u_row = $adMDL->GetUserList();
if($u_row){
    foreach($u_row as $uK => $uV){

        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
            if($uV['tenant_id'] !== $_SESSION['admin']['tenant_id']){
                continue;
            }
        }
        $UserList[$uV['user_id']] = $uV['name'];
        $UuidList[$uV['uuid']] = [
            'username' => $uV['name'],
            'tenantid' => $uV['tenant_id'],
        ];
        $UuidList[$uV['user_id']] = $uV['uuid'];
    }
}

// 権限に付随したテナントリスト取得
$TenantNameList = [];
$t_row = $adMDL->GetTenantList();
if($t_row){
    foreach($t_row as $tK => $tV){
        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
            if($tV['id'] != $_SESSION['admin']['tenant_id']){
                continue;
            }
        }
        $TenantNameList[$tV['id']] = $tV['name'];
    }
}

// DX-Coreからサイト名取得
try{
    $API = new Api($tenant_id);
    $res_site = $API->GetTenantName();
    $sitename = $res_site->Data->{'General.SiteList'}[0];
}catch(Exception $e){
    var_dump('GetTenantName:NG'.$e->getMessage());
}

// DX-Coreから車両入館設定情報取得
$mailaddress = "";
$AND = "&";
$mail_address_key = "mail_address=";
foreach($u_row as $uK => $uV){
    if($UuidList[$uV['user_id']] != ""){
        $mailaddress .= $mail_address_key.$UuidList[$uV['user_id']].$AND;
    }
}
$mailaddress = substr($mailaddress, 0, -1);
try{
    if($mailaddress){
        $res_numberplate = $API->GetNumberPlateList($sitename, $mailaddress);
        $NumberplateList = $res_numberplate->Data;
    }
}catch(Exception $e){
    var_dump('GetNumberPlate:NG '.$e->getMessage());
}

$page = "numberplate.php";
$GET = filterGet();
$POST = filterPost();

$isEdit = False;
$isRegist = False;
$isCamera = False;

$login_user = $_SESSION['admin']['admin_id'];

try{
    if(isset($GET['m']))
    {
        $mes = GetMsgDecode($GET['m']);
    }
    if(isset($_GET['c']))
    {
        $t = new Datetime();
        switch($_GET['c']){
            case 'n':
                $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'ナンバープレート情報登録フォーム'));
                $isRegist = True;
                break;

            case 'regist':

                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }

                // ナンバープレート情報登録
                $t = new Datetime();
                $log_data = array();

                foreach($POST['user_table'] as $dadV){
                $numberplate_prm = [
                    'mail_address' => $dadV,
                    'number' => (int)$POST['number'],
                    'vip' => 0,
                    'datetime' => $t->format("Y-m-d H:i:s"),
                ];
                $numberplate_data = [
                    "Data"=>[$numberplate_prm]
                ];

                $result = $API->RegistNumberPlateList($sitename, $numberplate_data);

                $temp = $numberplate_prm;
                $temp['mail_address'] = '******';
                $log_data[] = $temp;
                }

                if(!$result) throw new Exception("ナンバープレート情報の登録に失敗しました。");

                $log->info("Successful number plate registration.",array('file' => __FILE__, 'userId' => $login_user, 'data' => $log_data));
                $mes = GetMsgEncode("ナンバープレート情報の登録に成功しました。");
                header( 'Location: ' . $page.'?m='.$mes);
                exit;
                break;

            case 'camera':
                $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'カメラ情報一覧'));
                $isCamera = True;
                break;

            case 'd':
                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }
                if(!isset($POST['id'])) throw new Exception("IDが指定されていません。");
                $delete_id = $POST['id'];
                $del_ret = $API->DeleteNumberPlateList($sitename, $delete_id);
                if(!$del_ret) throw new Exception("ナンバープレート情報の削除に失敗しました。");

                $log->info("Successful number plate delete.",array('file' => __FILE__, 'userId' => $login_user, 'deleteId' => $delete_id));
                $mes = GetMsgEncode("ナンバープレート情報を削除しました。");
                header( 'Location: ' . $page.'?m='.$mes);
                exit;
                break;
        }
    } else {
        $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'ナンバープレート情報一覧'));
    }
}catch(Exception $e){
    $mes = GetMsgEncode($e->getMessage());
    // 確認
    $log->info($e);
    $log->info("Failed to number plate operation.", array('file' => __FILE__, 'userId' => $login_user, 'message' => $e->getMessage()));
    header( 'Location: ' . $page.'?m='.$mes.'&err');
    exit;
}

$msg_stt = (isset($GET['err']))? "danger" : "success";
$message_tag = ($mes != '')?'<div class="alert alert-'.$msg_stt.'" role="alert">'.$mes.'</div>':'';

$required_tag = '<span class="badge badge-danger">必須</span>';
$page_title = "管理画面　ナンバープレート情報管理";

$onetime_token = createToken();

include(PARTS_PATH."header.php");


?>
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.14.0/css/all.min.css" integrity="sha512-1PKOgIY59xJ8Co8+NE6FZ+LOAZKjy+KY8iq0G4B3CyeY6wYHN3yt9PW0XpSriVlkMXe40PTKnXrLnZ9+fkDaog==" crossorigin="anonymous" />

    <link rel="stylesheet" href="asset/css/custom.css" />

    <body>
        <div id="Wrap">
        <? include(PARTS_PATH.'header-nav.php'); ?>
            <div class="wrapper">
                <? include(PARTS_PATH.'sidemenu.php'); ?>
                <main class="">
                    <div class="container grid">
                        <nav class="page-header">
                            <div class="container-fluid">
                                <div class="navbar-wrapper">
                                    <h2><span class="svg-wrap mr10"><svg class="img-fluid"><use xlink:href="./asset/img/numberplatedetection.svg#numberplatedetection"></use></svg></span>ナンバープレート情報管理</h2>
                                </div>
                            </div>
                        </nav>
                        <?=$message_tag ?>

                        <?php if($isRegist): ?>
                            <section id="SectionNumberplateRegist" class="page-contents">
                            <div><h3>ナンバープレート情報登録フォーム</h3></div>
                            <div class="card-wrapper">
                                <form id="FormNumberplateRegist" name="FormNumberplateRegist" action="<?=$page ?>?c=regist" method="POST">
                                    <input type="hidden" name="one_time_token" value="<?=$onetime_token?>"/>
                                    <div class="form-group row">
                                        <div class="col-3">ナンバープレート<?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="number" id="RegistNumber" placeholder="ナンバープレート" value="" maxlength="4" required/>
                                            <div class="d-inline-block col-4">
                                                ナンバープレートを入力してください。<br>例)1223<br>※･･23の場合は0023と入力してください。
                                            </div>
                                    </div>
                                    <hr />
                                    <div class="form-group row">
                                        <div class="col-3">テナント名<?=$required_tag ?></div>
                                        <div class="col-5">
                                            <div class="table-wrapper">
                                                <div class="row">
                                                    <div class="col-12 mt10">
                                                        <button id="TenantAllCheckBtn" class="tenant btn btn-sm btn-light btn-outline-secondary" type="button">すべて選択</button>
                                                        <button id="TenantAllUnCheckBtn" class="tenant btn btn-sm btn-light btn-outline-secondary" type="button">すべて選択解除</button>
                                                    </div>
                                                </div>
                                                <table id="NumberplateTenantListTable" class="table">
                                                    <thead class="thead-dark">
                                                        <tr>
                                                            <th class="th_chk" scope="col">チェック</th>
                                                            <th class="th_tname" scope="col">テナント名</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                    <?php foreach($TenantNameList as $tiK => $tiv): ?>
                                                        <?php
                                                            $TenantWidgetID = $adMDL->GetTenantDataByName($tiv);
                                                            $TenantWidgetInfo = $adMDL->GetTenantWidgetSettingListForTenantID($TenantWidgetID['id']);
                                                            $json = json_decode($TenantWidgetInfo['flag_json'], TRUE);
                                                            $checked = (in_array("NumberPlateDetectionWidget", $json['widget_use']))?true:false;
                                                        ?> 
                                                        <?php if($checked): ?>
                                                        <tr>
                                                            <td>
                                                                <div class="form-check form-check-inline">
                                                                <input class="form-check-input" type="checkbox" name="TenantList" id="TenantList_<?php echo $tiK ?>" value="<?php echo $tiK ?>">
                                                                </div>
                                                            </td>
                                                            <td><?php echo $tiv ?></td>
                                                        </tr>
                                                        <?php endif; ?>
                                                    <?php endforeach; ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                        <div class="d-inline-block col-4">テナント名を選択してください。（複数選択可）</div>
                                    </div>
                                    <hr />
                                    <div class="form-group row">
                                        <div class="col-3">ユーザー名<?=$required_tag ?></div>
                                        <div class="col-5">
                                            <div id="AjaxNumberplateWrap">
                                                <div class="table-wrapper">
                                                    <div class="row">
                                                        <div class="col-12 mt10">
                                                            <button id="UserAllCheckBtn" class="user btn btn-sm btn-light btn-outline-secondary" type="button">すべて選択</button>
                                                            <button id="UserAllUnCheckBtn" class="user btn btn-sm btn-light btn-outline-secondary" type="button">すべて選択解除</button>
                                                        </div>
                                                    </div>
                                                    <table id="NumberplateUserListTable" class="table">
                                                        <thead class="thead-dark">
                                                            <tr>
                                                                <th class="th_chk" scope="col">チェック</th>
                                                                <th class="th_tname" scope="col">テナント名</th>
                                                                <th class="th_yid" scope="col">ユーザーID</th>
                                                                <th class="th_yname" scope="col">ユーザー名</th>
                                                                <th hidden class="th_tid" scope="col">テナントID</th>
                                                            </tr>
                                                        </thead>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="d-inline-block col-4">ユーザー名を選択してください。（複数選択可）</div>
                                    </div>
                                    <hr />
                                    <div class="tcenter">
                                        <button type="submit" class="btn btn-primary" id="NumberplateRegist">登録</button>
                                        <a href="<?=$page ?>" class="btn btn-default btn-outline-dark">キャンセル</a>
                                    </div>
                                </form>
                            </div>
                        </section>

                        <?php elseif($isCamera): ?>
                        <section id="NumberplateManage" class="page-contents">
                            <div><h3>カメラ情報一覧</h3></div>
                            <link rel="icon" href="/asset/img/android-touch-icon.png" sizes="192x192"/>
                            <div class="card-wrapper">
                                <div class="adduser-wrapper">
                                </div>
                                <div class="table-wrapper">
                                    <table id="NumberplateCameraListTable" class="table">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th class="th_id" scope="col">#</th>
                                                <th class="th_did" scope="col">デバイスID</th>
                                                <th nowrap class="th_dyid" scope="col">デバイスユニークID</th>
                                                <th class="th_tid" scope="col">テナントID</th>
                                                <th class="th_aid" scope="col">エリアID</th>
                                                <th class="th_dname" scope="col">デバイス名</th>
                                                <th nowrap class="th_cimage" scope="col">カメラ画角</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td style="vertical-align:middle">1</td>
                                                <td style="vertical-align:middle">53</td>
                                                <td style="vertical-align:middle">CMR53</td>
                                                <td style="vertical-align:middle">mebks</td>
                                                <td style="vertical-align:middle">共用部</td>
                                                <td style="vertical-align:middle">ブリーゼウェイ1</td>
                                                <td><img src="./asset/img/NPcamera.jpg" width="400px" height="224px"></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="tcenter">
                                    <a href="<?=$page ?>" class="btn btn-default btn-outline-dark">閉じる</a>
                                </div>
                            </div>
                        </section>

                        <?php else: ?>
                        <section id="NumberplateManage" class="page-contents">
                            <div><h3>ナンバープレート情報一覧</h3></div>
                            <div class="card-wrapper">
                                <div class="adduser-wrapper">
                                    <a href="<?=$page ?>?c=n" class="btn btn-primary btn-sm">新規登録</a>

                                    <form class="d-inline" action="parts/csv_output.php" method="POST">
                                        <input type="hidden" name="file_name" value=<?php echo $_SESSION['admin']['tenant_id'] ?>/>
                                        <input type="hidden" name="tbl_name" value="NumberPlateTbl"/>
                                        <button type="submit" class="btn btn-success btn-sm">ログ出力</button>
                                    </form>
                                    </form>
                                    <a href="<?=$page ?>?c=camera" class="btn btn-secondary btn-sm">カメラ情報</a>
                                </div>
                                <div class="table-wrapper">
                                    <table id="NumberplateListTable" class="table">
                                        <thead class="thead-dark">
                                            <tr>
                                                <th class="th_id" scope="col">#</th>
                                                <th class="th_numberplate" scope="col">ナンバープレート</th>
                                                <th class="th_uid" scope="col">ユーザー名</th>
                                                <th class="th_tid" scope="col">テナント名</th>
                                                <th class="th_registdatetime" scope="col">登録日時</th>
                                                <th class="th_control" scope="col">操作</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <?php foreach($NumberplateList as $wlK => $wlV):
                                        ?>
                                            <tr>
                                                <td><?=h($wlV->id) ?></td>
                                                <td><?=h($wlV->number) ?></td>
                                                <td><?=h($UuidList[$wlV->mail_address]['username']) ?></td>
                                                <td><?=h($TenantNameList[$UuidList[$wlV->mail_address]['tenantid']]) ?></td>
                                                <?php $date = $wlV->datetime?>
                                                <td><?=h(date('Y-m-d H:i:s', strtotime($date))) ?></td>
                                                <td nowrap>
                                                <button class="btn btn-sm btn-danger" data-toggle="modal" data-target="#modal-numberplatedelete" data-delnumber="<?=$wlV->number?>" 
                                                data-deluser="<?=$UuidList[$wlV->mail_address]['username']?>" data-delid="<?=$wlV->id?>">削除</button>
                                                </td>
                                            </tr>
                                        <?php endforeach;?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </section>
                        <?php endif; ?>
                    </div>
                </main>
            </div>
        <? //include(PARTS_PATH.'footer.php'); ?>
        </div>
    </body>
    <!-- /container -->


    <!-- モーダル　ナンバープレート情報削除 -->
    <div class="modal fade" id="modal-numberplatedelete" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-label">ナンバープレート情報削除</h4>
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>このナンバープレート情報を削除しますか？</p>
                    <form id="user_delete" action="<?=$page?>?c=d" method="post">
                        <input type="hidden" name="one_time_token" value="<?=$onetime_token ?>"/>
                        <div class="form-group">
                            <label for="#DeleteNumberplate" class="form-control-label">ナンバープレート:</label>
                            <input type="text" class="form-control" id="DeleteNumberplate" name="title" readonly="readonly" required>
                            <input type="hidden" id="DeleteNumberplateID" name="id">
                            <p></p>
                            <label for="#DeleteNumberplateUser" class="form-control-label">ユーザー名:</label>
                            <input type="text" class="form-control" id="DeleteNumberplateUser" name="user" readonly="readonly" required>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-danger">削除する</button>
                            <button type="cancel" class="btn btn-default btn-outline-dark" data-dismiss="modal">中止</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="<?=ASSET_JS ?>numberplate.js"></script>
