<?
/**
 * エリア一括登録確認画面
 */
require("../core/construct.php");

// require(CORE_PATH."basic.php");
require(CORE_PATH."functions.php");

require(CORE_PATH."session_check.php");
require(CORE_PATH."authorize.php");

require_once(AD_MDL_PATH."model.php");
$adMDL = new admModel($sdb, $link);

require_once(SN_MDL_PATH."model.php");
$sgMDL = new sngModel($sdb, $link);

require_once("../util/utils.php");

$login_user = $_SESSION['admin']['admin_id'];

try{

    if(!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest') {
        throw new Exception('not ajax');
    }
//     $referer = $_SERVER['HTTP_REFERER'];
//     $parse = parse_url($referer);
//     $back_url = str_replace('?'.$parse['query'],'',$referer);


    $targetFolder = 'admin/tmp'; //アップロード先フォルダを指定します。
    $readDataLimit = 100; //読み込みデータ限界
    $filename = 'area_list';


    require(CORE_PATH."csv_input.php");


    $tableheaders = [];
    $tableheaders = [
        '#',
        'エリアID',
        'テナントID',
        'エリア名',
        'エリア所属デバイス',
        'X座標',
        'Y座標',
        'エリア横幅',
        'エリア縦幅',
        'ステータス',
        '最終更新',
        '登録種別',
    ];

    $ErrDom = "";
    //一覧リストを整形
    $dom = "";
    $dom .= '<table id="CSVConfirmTable" class="table"><thead class="thead-dark"><tr>';
    $dom .= '<th>'.implode('</th><th>',$tableheaders).'</th>';
    $dom .= '</tr></thead><tbody>';

    if(!empty($csv_arr)){
        foreach($csv_arr as $csvK => $csvV){
            $dom .= '<tr>';
            $stt = ($csvV['stt'] == "update")?"上書き":"新規登録";
            $dom .= '<td>'.$csvV['num'].'</td>';
            $dom .= '<td>'.$csvV['field_id'].'</td>';
            $dom .= '<td>'.$csvV['tenant_id'].'</td>';
            $dom .= '<td>'.$csvV['field_name'].'</td>';
            $dom .= '<td>'.$csvV['belong_device'].'</td>';
            $dom .= '<td>'.$csvV['x_pos'].'</td>';
            $dom .= '<td>'.$csvV['y_pos'].'</td>';
            $dom .= '<td>'.$csvV['width'].'</td>';
            $dom .= '<td>'.$csvV['height'].'</td>';
            $dom .= '<td>'.$csvV['status'].'</td>';
            $dom .= '<td>'.$csvV['last-update'].'</td>';
            $dom .= '<td>'.$stt.'</td>';
            $dom .= '</tr>';
        }
    }
    $dom .= '</tbody></table>';


    if($err_list){
        $ErrDom .= "<div class=\"text-danger\">";
        $ErrDom .= implode('<br/>',$err_list);
        $ErrDom .= "</div>";
        $log->info("CSV bulk loading failed.",array('file' => __FILE__, 'userId' => $login_user, 'message' => $err_list));
    }

    $dom.=$ErrDom;


    $ret = [
        'html' => $dom,
        'count' => count($csv_arr),
        'state' => 'success',
    ];

    header('Content-Type: application/json; charset=utf-8', true);
    // $ret = array(1 => );
    echo json_encode($ret);


}catch(Exception $e){

    $ret = [
        'state' => 'failed',
        'msg' => $e->getMessage(),
    ];

    $log->info("CSV bulk loading failed.",array('file' => __FILE__, 'userId' => $login_user, 'message' => $e->getMessage()));
    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
}

?>