<?php
require_once("../util/utils.php");
require("../core/construct.php");
require(ADMIN_ROOT."core/functions.php");

require(CORE_PATH."session_check.php");
require(CORE_PATH."authorize.php");


try {
    $GET = filterGet();
    $POST = filterPost();

    $file_name = $POST['file_name'];
    $tbl_name = $POST['tbl_name'];
    $dtype = (isset($POST['dtype']))?$POST['dtype']:NULL;

    switch($tbl_name){
        case 'UserTbl':
            csv_output_usertbl($file_name, $tbl_name, $sdb, $link, $log);
            break;
        case 'DeviceTbl':
            csv_output_devicetbl($file_name, $tbl_name, $dtype, $sdb, $link, $log);
            break;
        case 'FieldTbl':
            csv_output_fieldtbl($file_name, $tbl_name, $sdb, $link, $log);
            break;
        case 'NumberPlateTbl':
            csv_output_numberplatetbl($file_name, $sdb, $link, $log);
            break;
        default:
            echo "パラメータが設定されていません。";
            break;
    }
    exit;
} catch (Exception $e) {
    $log->info($e);
    $log->info("Failed to csv output.", array('file' => __FILE__, 'userId' => $_SESSION['admin']['admin_id'], 'message' => $e->getMessage()));
}


function csv_output_usertbl($file_name, $tbl_name, $sdb, $link, $log){

    require(ADMIN_ROOT."model/model.php");
    $admMDL = new admModel($sdb, $link);

    require(SIGNAGE_ROOT."model/model.php");
    $sngMDL = new sngModel($sdb, $link);


    $t = new Datetime();
    $fname = 'Content-Disposition: attachment; filename='.$file_name.'_'.$t->format('YmdHis').'.csv';
    header("Content-Type: application/octet-stream");
    header($fname);

    #####################################
    # 一行目を出力
    #####################################

    $i = 0;
    $Csv = "";
    $csv_header = [
        '番号',
        'ユーザーID',
        'ユーザー名',
        '社員番号',
        '登録テナント',
        'UUID',
        '役職',
        '所属組織',
        '操作可能デバイス',
        'パスワード',
        'ステータス',
    ];

//     $row = $model->ShowFullColumnsByTable($tbl_name);
//     if($row)
//     {
//         foreach($row as $K => $V){
//             $head = ($V['Comment'] != "")? $V['Comment']: $V['Field'];
//             $csv_header[] = mb_convert_encoding($head,"SJIS-win","auto");
//         }

//     }
//     $TenantNameList = [];
//     $t_row = $admMDL->GetTenantList();
//     if($t_row){
//         foreach($t_row as $tK => $tV){
//             $TenantNameList[$tV['id']] = $tV['name'];
//         }
//     }


    $csv_header = array_map('csv_encode', $csv_header);
    $Csv .= implode(",",$csv_header);
    $Csv .= "\n";

    $data_row = $admMDL->GetFullDataByTable($tbl_name);
    if($data_row)
    {
        foreach($data_row as $dK => $data){
            if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
                if($data['tenant_id'] != $_SESSION['admin']['tenant_id']){
                    continue;
                }
            }
            $Csv .= csv_encode($data['num']).",";
            $Csv .= $data['user_id'].",";
            $Csv .= ($data['name'] === '' || $data['name'] == NULL)?",":csv_encode($data['name']).",";
            $Csv .= ($data['user_number'] === '' || $data['user_number'] == NULL)?",":csv_encode($data['user_number']).",";
            $Csv .= $data['tenant_id'].",";
            $Csv .= ($data['uuid'] === '' || $data['uuid'] == NULL)?",":csv_encode($data['uuid']).",";
            $Csv .= ($data['department'] === '' || $data['department'] == NULL)?",":csv_encode($data['department']).",";
            $Csv .= ($data['organization'] === '' || $data['organization'] == NULL)?",":csv_encode($data['organization']).",";
            $Csv .= ($data['device_authorize '] === '' || $data['device_authorize'] == NULL)?",":csv_encode($data['device_authorize']).",";
//             $Csv .= $data['pass'].",";
            $Csv .= ",";

            $Csv .= csv_encode($data['status']).",";


            $Csv .= "\n";
        }
    }
    $log->info("Successful CSV output of user list.",array('file' => __FILE__, 'userId' => $_SESSION['admin']['admin_id']));
    echo $Csv;
    exit;
}


function csv_output_devicetbl($file_name, $tbl_name, $type, $sdb, $link, $log){
    require(ADMIN_ROOT."model/model.php");
    $admMDL = new admModel($sdb, $link);

    require(SIGNAGE_ROOT."model/model.php");
    $sngMDL = new sngModel($sdb, $link);


    $t = new Datetime();
    $fname = 'Content-Disposition: attachment; filename='.$file_name.'_'.$type.'_'.$t->format('YmdHis').'.csv';
    header("Content-Type: application/octet-stream");
    header($fname);

    #####################################
    # 一行目を出力
    #####################################

    $i = 0;
    $Csv = "";
    $csv_header = [
        '番号',
        'デバイスID',
        'デバイスユニークID',
        'デバイス表示番号',
        '登録テナント',
        'エリアID',
        'デバイス名',
        'x座標',
        'y座標',
        'デバイス種別',
        'ステータス',
    ];


    $TenantNameList = [];
    $t_row = $admMDL->GetTenantList();
    if($t_row){
        foreach($t_row as $tK => $tV){
            $TenantNameList[$tV['id']] = $tV['name'];
        }
    }

//     $DeviceList = [];
//     $d_row = $sngMDL->GetDeviceTblForDeviceType($type);
//     if($d_row){
//         foreach($d_row as $dK => $dV){
//             $DeviceList[$dV['du_id']] = $dV['name'];
//         }
//     }

    $csv_header = array_map('csv_encode', $csv_header);
    $Csv .= implode(",",$csv_header);
    $Csv .= "\n";

    $data_row = $sngMDL->GetFullDataByTable($tbl_name);

    if($data_row)
    {
        foreach($data_row as $dK => $data){
            if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
                if($data['tenant_id'] != $_SESSION['admin']['tenant_id']){
                    continue;
                }
            }
            //TODO 種別による絞込みを実行
            if($type !== $data['type']) continue;
            $Csv .= csv_encode($data['num']).",";
            $Csv .= csv_encode($data['device_id']).",";
            $Csv .= csv_encode($data['du_id']).",";
            $Csv .= csv_encode($data['device_num']).",";
            $Csv .= csv_encode($data['tenant_id']).",";
            $Csv .= csv_encode($data['field_id']).",";
            $Csv .= ($data['name'] === '' || $data['name'] == NULL)?",":csv_encode($data['name']).",";
            $Csv .= csv_encode($data['x_pos']).",";
            $Csv .= csv_encode($data['y_pos']).",";
            $Csv .= csv_encode($data['type']).",";
            $Csv .= csv_encode($data['status']).",";


            $Csv .= "\n";
        }
    }
    $log->info("Successful CSV output of device list.",array('file' => __FILE__, 'userId' => $_SESSION['admin']['admin_id']));
    echo $Csv;
    exit;
}




function csv_output_fieldtbl($file_name, $tbl_name, $sdb, $link, $log){
    require(ADMIN_ROOT."model/model.php");
    $admMDL = new admModel($sdb, $link);

    require(SIGNAGE_ROOT."model/model.php");
    $sngMDL = new sngModel($sdb, $link);


    $t = new Datetime();
    $fname = 'Content-Disposition: attachment; filename='.$file_name.'_'.$t->format('YmdHis').'.csv';
    header("Content-Type: application/octet-stream");
    header($fname);

    #####################################
    # 一行目を出力
    #####################################

    $i = 0;
    $Csv = "";
    $csv_header = [
        '番号',
        'エリアID',
        '登録テナント',
        'エリア名',
        'エリア所属デバイス',
        'X座標',
        'Y座標',
        'エリア横幅',
        'エリア縦幅',
        'ステータス',
        '最終更新',
    ];


    //     $row = $model->ShowFullColumnsByTable($tbl_name);
    //     if($row)
        //     {
        //         foreach($row as $K => $V){
        //             $head = ($V['Comment'] != "")? $V['Comment']: $V['Field'];
        //             $csv_header[] = mb_convert_encoding($head,"SJIS-win","auto");
        //         }

        //     }
//     $TenantNameList = [];
//     $t_row = $admMDL->GetTenantList();
//     if($t_row){
//         foreach($t_row as $tK => $tV){
//             $TenantNameList[$tV['id']] = $tV['name'];
//         }
//     }


    $csv_header = array_map('csv_encode', $csv_header);
    $Csv .= implode(",",$csv_header);
    $Csv .= "\n";

    $data_row = $admMDL->GetFullDataByTable($tbl_name);
    if($data_row)
    {
        foreach($data_row as $dK => $data){
            if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
                if($data['tenant_id'] != $_SESSION['admin']['tenant_id']){
                    continue;
                }
            }
            $Csv .= csv_encode($data['num']).",";
            $Csv .= csv_encode($data['field_id']).",";
            $Csv .= csv_encode($data['tenant_id']).",";
            $Csv .= ($data['field_name'] === '' || $data['field_name'] == NULL)?",":csv_encode($data['field_name']).",";
            $Csv .= csv_encode($data['belong_device']).",";
            $Csv .= csv_encode($data['x_pos']).",";
            $Csv .= csv_encode($data['y_pos']).",";
            $Csv .= csv_encode($data['width']).",";
            $Csv .= csv_encode($data['height']).",";
            $Csv .= csv_encode($data['status']).",";
            $Csv .= csv_encode($data['last-update']).",";


            $Csv .= "\n";
        }
    }
    $log->info("Successful CSV output of area list.",array('file' => __FILE__, 'userId' => $_SESSION['admin']['admin_id']));
    echo $Csv;
    exit;
}

function csv_output_numberplatetbl($file_name, $sdb, $link, $log){
    require(ADMIN_ROOT."model/model.php");
    $admMDL = new admModel($sdb, $link);

    require(SIGNAGE_ROOT."api.php");

    $t = new Datetime();
    $fname = 'Content-Disposition: attachment; filename='.$file_name.'_'.$t->format('Ymd').'.csv';
    header("Content-Type: application/octet-stream");
    header($fname);

    #####################################
    # ヘッダーを出力
    #####################################
    $Csv = "";
    $csv_header = [
        '検出日時',
        'ナンバープレート',
        '車種',
        'ユーザー名',
        'テナント名',
    ];

    $csv_header = array_map('csv_encode', $csv_header);
    $Csv .= implode(",",$csv_header);
    $Csv .= "\n";

    $data_row = $admMDL->GetUserList();
    if($data_row){
        foreach($data_row as $dK => $data){
            if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
                if($data['tenant_id'] != $_SESSION['admin']['tenant_id']){
                    continue;
                }
            }
            if($data["uuid"]){
                $uuid_list[] = $data["uuid"];
            }
            $UuidList[$data['uuid']] = [
                'username' => $data['name'],
                'tenantid' => $data['tenant_id'],
            ];
        }
    }

    // 権限に付随したテナントリスト取得
    $TenantNameList = [];
    $t_row = $admMDL->GetTenantList();
    if($t_row){
        foreach($t_row as $tK => $tV){
            if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
                if($tV['id'] != $_SESSION['admin']['tenant_id']){
                    continue;
                }
            }
            $TenantNameList[$tV['id']] = $tV['name'];
        }
    }

    // DX-Coreからサイト名取得
    try{
        $API = new Api($_SESSION['admin']['tenant_id']);
        $res_site = $API->GetTenantName();
        $sitename = $res_site->Data->{'General.SiteList'}[0];
    }catch(Exception $e){
        var_dump('GetSiteName:NG'.$e->getMessage());
    }

    $prm = [
        "Data"=> [
            "day_count"=> 7, //本日より何日前まで出力するか.
            "mail_address"=> $uuid_list
        ]
    ];

    // DX-Coreから過去のナンバープレート検出情報取得
    try{
        $res_numberplate_info = $API->GetNumberPlateInfoList($sitename, $prm);
    }catch(Exception $e){
        var_dump('GetNumberPlateInfo:NG'.$e->getMessage());
    }

    if($res_numberplate_info){
        foreach($res_numberplate_info as $nrK => $dx_data){
            $Csv .= $dx_data->np_datetime.",";
            $Csv .= $dx_data->number.",";
            switch($dx_data->car_type){
                case 1:
                    $car_type_jp = '普通　貨物自動車';
                case 2:
                    $car_type_jp = '普通　乗合自動車';
                    break;
                case 3:
                    $car_type_jp = '普通　乗用自動車';
                    break;
                case 4:
                    $car_type_jp = '小型　貨物自動車';
                    break;
                case 5:
                    $car_type_jp = '小型　乗合・乗用自動車';
                    break;
                case 6:
                    $car_type_jp = '特殊用途';
                    break;
                case 7:
                    $car_type_jp = '大型特殊';
                    break;
                case 8:
                    $car_type_jp = '建設機械';
                    break;
                case 9:
                    $car_type_jp = '軽自動車　二輪自動車';
                    break;
                case 10:
                    $car_type_jp = '軽自動車　三輪自動車、被牽引自動車';
                    break;
                case 11:
                    $car_type_jp = '軽自動車　四輪貨物';
                    break;
                case 12:
                    $car_type_jp = '軽自動車　四輪貨物';
                    break;
                case 13:
                    $car_type_jp = '軽自動車　特殊用途自動車';
                    break;
                default :
                    $car_type_jp = '-';
                    break;
                }
            $Csv .= csv_encode($car_type_jp).",";
            $Csv .= csv_encode($UuidList[$dx_data->mail_address]['username']).",";
            $Csv .= csv_encode($TenantNameList[$UuidList[$dx_data->mail_address]['tenantid']]).",";
            $Csv .= "\n";
        }
    }
    $log->info("Successful CSV output of number plate list.",array('file' => __FILE__, 'userId' => $_SESSION['admin']['admin_id']));
    echo $Csv;
    exit;
}

function csv_encode($data){
    $data = str_replace(",", '，', $data);
    $data = str_replace(array("\r\n", "\r", "\n"), '', $data);
    $enc =  mb_convert_encoding($data,"SJIS-win","auto");
    return $enc;
}

?>