<?php
/**
 * サイドメニュー
 */

$sidemenu_arr = [
    [
        'type' => 'tenant',
        'url' => 'tenant.php',
        'icon' => './asset/img/marker.svg#Marker',
        'name' => 'テナント情報管理',
        'author' => [
            ACCOUNT_AUTHOR_OWNER,
            ACCOUNT_AUTHOR_BUILDING
        ],
        'sub' => [],
    ],
    [
        'type' => 'api',
        'url' => 'api.php',
        'icon' => './asset/img/marker.svg#Marker',
        'name' => 'API管理',
        'author' => [
            ACCOUNT_AUTHOR_OWNER
        ],
        'sub' => [],
    ],
    [
        'type' => 'field',
        'url' => 'field.php',
        'icon' => './asset/img/building.svg#Building',
        'name' => 'エリア情報管理',
        'author' => [
            ACCOUNT_AUTHOR_OWNER,
            ACCOUNT_AUTHOR_BUILDING
        ],
        'sub' => [],
    ],
    [
        'type' => 'device',
        'url' => '',
        'icon' => './asset/img/setting.svg#Setting',
        'name' => 'デバイス情報管理',
        'author' => [
            ACCOUNT_AUTHOR_OWNER,
            ACCOUNT_AUTHOR_BUILDING,
            ACCOUNT_AUTHOR_TENANT
        ],
        'sub' => [
            [
                'type' => DEVICE_TYPE_CAMERA,
                'url' => 'device_camera.php',
                'name' => 'カメラ',
                'author' => [
                    ACCOUNT_AUTHOR_OWNER,
                    ACCOUNT_AUTHOR_BUILDING,
                    ACCOUNT_AUTHOR_TENANT
                ],
            ],
            [
                'type' => DEVICE_TYPE_LIGHT,
                'url' => 'device_light.php',
                'name' => '照明',
                'author' => [
                    ACCOUNT_AUTHOR_OWNER,
                    ACCOUNT_AUTHOR_BUILDING,
                    ACCOUNT_AUTHOR_TENANT
                ],
            ],
            // [
            //     'type' => DEVICE_TYPE_AIRCON_DCU,
            //     'url' => 'device_dcu.php',
            //     'name' => '空調（DCU）',
            //     'author' => [
            //         ACCOUNT_AUTHOR_OWNER,
            //         ACCOUNT_AUTHOR_BUILDING,
            //         ACCOUNT_AUTHOR_TENANT
            //     ],
            // ],
            // [
            //     'type' => DEVICE_TYPE_AIRCON_FCU,
            //     'url' => 'device_fcu.php',
            //     'name' => '空調（FCU）',
            //     'author' => [
            //         ACCOUNT_AUTHOR_OWNER,
            //         ACCOUNT_AUTHOR_BUILDING,
            //         ACCOUNT_AUTHOR_TENANT
            //     ],
            // ],
            [
                'type' => DEVICE_TYPE_AIRCON_AHU,
                'url' => 'device_ahu.php',
                'name' => '空調（AHU）',
                'author' => [
                    ACCOUNT_AUTHOR_OWNER,
                    ACCOUNT_AUTHOR_BUILDING,
                    ACCOUNT_AUTHOR_TENANT
                ],
            ],
            // [
            //     'type' => DEVICE_TYPE_AIRCON_OHU,
            //     'url' => 'device_ohu.php',
            //     'name' => '空調（OHU）',
            //     'author' => [
            //         ACCOUNT_AUTHOR_OWNER,
            //         ACCOUNT_AUTHOR_BUILDING,
            //         ACCOUNT_AUTHOR_TENANT
            //     ],
            // ],
            // [
            //     'type' => DEVICE_TYPE_TOILET,
            //     'url' => 'device_toilet.php',
            //     'name' => 'トイレ',
            //     'author' => [
            //         ACCOUNT_AUTHOR_OWNER,
            //         ACCOUNT_AUTHOR_BUILDING,
            //         ACCOUNT_AUTHOR_TENANT
            //     ],
            // ],
            [
                'type' => DEVICE_TYPE_AIRCON_BULK_FCU,
                'url' => 'device_bulk_fcu.php',
                'name' => '一括操作',
                'author' => [
                    ACCOUNT_AUTHOR_OWNER,
                    ACCOUNT_AUTHOR_BUILDING,
                    ACCOUNT_AUTHOR_TENANT
                ],
            ],
        ],
    ],
    [
        'type' => 'user',
        'url' => 'user.php',
        'icon' => './asset/img/user.svg#User',
        'name' => 'ユーザー情報管理',
        'author' => [
            ACCOUNT_AUTHOR_OWNER,
            ACCOUNT_AUTHOR_BUILDING,
            ACCOUNT_AUTHOR_TENANT
        ],
        'sub' => [],
    ],
    [
        'type' => 'widget',
        'url' => 'widget.php',
        'icon' => './asset/img/setting.svg#Setting',
        'name' => 'ウィジェット情報管理',
        'author' => [
            ACCOUNT_AUTHOR_OWNER
        ],
        'sub' => [],
    ],
    [
        'type' => 'notification',
        'url' => 'notification.php',
        'icon' => './asset/img/setting.svg#Setting',
        'name' => 'お知らせ情報管理',
        'author' => [
            ACCOUNT_AUTHOR_OWNER,
            ACCOUNT_AUTHOR_BUILDING,
            ACCOUNT_AUTHOR_TENANT

        ],
        'sub' => [],
    ],
    [
        'type' => 'numberplate',
        'url' => 'numberplate.php',
        'icon' => './asset/img/numberplatedetection.svg#numberplatedetection',
        'name' => 'ナンバープレート情報管理',
        'author' => [
            ACCOUNT_AUTHOR_OWNER,
            ACCOUNT_AUTHOR_BUILDING,
            ACCOUNT_AUTHOR_TENANT

        ],
        'sub' => [],
    ],
    [
        'type' => 'link',
        'url' => 'link_cms.php',
        'icon' => './asset/img/setting.svg#Setting',
        'name' => '共有リンク管理',
        'author' => [
            ACCOUNT_AUTHOR_OWNER,
//             ACCOUNT_AUTHOR_BUILDING
        ],
        'sub' => [],
    ],
//     [
//         'type' => 'log',
//         'url' => 'log_modal.php',
// //        'url' => 'log.php',
//         'icon' => './asset/img/setting.svg#Setting',
//         'name' => '入退室ログ',
//         'author' => [
//             ACCOUNT_AUTHOR_OWNER,
//             ACCOUNT_AUTHOR_BUILDING,
//             ACCOUNT_AUTHOR_TENANT
//         ],
//         'sub' => [],
//     ],
];

?>

<!-- /.navbar-header --><!-- /.Side Menu -->
<div id="Sidebar" class="sidebar" role="navigation">
<div class="logo">
    <img class="img-fluid" src="<?=ASSET_IMG."tatemono_os_logo.png" ?>" alt="建物OSロゴ" />
</div>
<div id="accordionExample" class="sidebar-nav navbar-collapse">
    <ul class="nav" id="side-menu">
    <?php foreach($sidemenu_arr as $smK => $smV): ?>
        <?php if(CheckAuthorize($Authorize, $smV['author'])): ?>
            <?php if(!empty($smV['sub'])): ?>
                <li class="" id="headingOne">
                    <a class="nav-link " data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne" href=""><span class="svg-wrap mr10"><svg class="img-fluid"><use xlink:href="<?php echo $smV['icon'] ?>"></use></svg></span><?php echo $smV['name'] ?></a>
                    <div class="collapse" id="collapseOne" aria-labelledby="headingOne" data-parent="#accordionExample">
                        <ul >
                        <?php foreach($smV['sub'] as $subK => $subV): ?>
                            <?php if(CheckAuthorize($Authorize, $subV['author'])): ?>
                                <li class=""><a class="nav-link" href="<?php echo $subV['url'] ?>"><span class="svg-wrap mr10"><svg class="img-fluid"><use xlink:href="<?php echo $subV['icon'] ?>"></use></svg></span><?php echo $subV['name'] ?></a></li>
                            <?php endif; ?>
                        <?php endforeach; ?>
                        </ul>
                    </div>
                    </li>
            <?php else: ?>
            <li><a class="nav-link" href="<?php echo $smV['url'] ?>"><span class="svg-wrap mr10"><svg class="img-fluid"><use xlink:href="<?php echo $smV['icon'] ?>"></use></svg></span><?php echo $smV['name'] ?></a></li>
            <?php endif; ?>
        <?php endif; ?>
    <?php endforeach; ?>
        <li><a class="nav-link" href="logout.php"><span class="svg-wrap mr10"><svg class="img-fluid"><use xlink:href="./asset/img/logout.svg#Logout"></use></svg></span>ログアウト</a></li>
    </ul>
</div>
</div>
