<?
/**
 * テナント管理画面
 */
require("core/construct.php");

require(CORE_PATH."basic.php");
require(CORE_PATH."functions.php");
require(CORE_PATH."session_check.php");
require(CORE_PATH."authorize.php");
require_once(__DIR__."/util/utils.php");

require_once(AD_MDL_PATH."model.php");
$adMDL = new admModel($sdb, $link);

require_once(SN_MDL_PATH."model.php");
$sgMDL = new sngModel($sdb, $link);

require_once(SP_MDL_PATH."model.php");
$sapMDL = new sappModel($sdb, $link);

$TenantList = $adMDL->GetTenantList();

$login_user = $_SESSION['admin']['admin_id'];

$page = "tenant.php";

$GET = filterGet();
$POST = filterPost();

$isEdit = False;
$isRegist = False;

try{


    if(isset($GET['m']))
    {
        $mes = GetMsgDecode($GET['m']);
    }

    if(isset($_GET['c']))
    {

        //ワンタイムトークンチェック
        if(isset($POST['one_time_token'])){
//              if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
        }

        switch($_GET['c'])
        {
            case 'n':

                $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'テナント情報登録フォーム'));
                $isRegist = True;
                break;

            case 'regist':


                if(trim($POST['id']) === "") throw new Exception("テナントIDを入力してください。");
                if(preg_match('/^[0-9a-zA-Z\-_]{1,32}$/', $POST['id']) == 0) throw new Exception("テナントIDは32文字以内の半角英数字で入力してください。");

                if(trim($POST['name']) === "") throw new Exception("テナント名を入力してください。");
                if(mb_strlen($POST['name']) > 128) throw new Exception("テナント名は128文字以内です。");

                if(trim($POST['addr']) === "") throw new Exception("テナント住所を入力してください。");
                if(mb_strlen($POST['addr']) > 1000) throw new Exception("テナント住所は1000文字以内です。");

                if(trim($POST['lat']) === "") throw new Exception("緯度を入力してください。");
                if(trim($POST['lon']) === "") throw new Exception("経度を入力してください。");

                if(preg_match('/^(\+|-)?(?:90(?:(?:\.0{1,6})?)|(?:[0-9]|[1-8][0-9])(?:(?:\.[0-9]{1,6})?))$/', $POST['lat']) == 0) throw new Exception("正しい緯度を入力してください。");
                if(preg_match('/^(\+|-)?(?:180(?:(?:\.0{1,6})?)|(?:[0-9]|[1-9][0-9]|1[0-7][0-9])(?:(?:\.[0-9]{1,6})?))$/', $POST['lon']) == 0) throw new Exception("正しい経度を入力してください。");


                $prm = [
                    'id' => $POST['id'],
                    'name' => $POST['name'],
                    'addr' => $POST['addr'],
                    'lat' => $POST['lat'],
                    'lon' => $POST['lon'],
                ];

                $ins_ret = $adMDL->InsertTenantData($prm);
                if(!$ins_ret) throw new Exception("テナント情報の登録が失敗しました。");

                $mes = GetMsgEncode("テナント情報を登録しました。");
                $log_data = $prm;
                $log_data['addr'] = '******';
                $log_data['lat'] = '******';
                $log_data['lon'] = '******';
                $log->info("Successful tenant registration.",array('file' => __FILE__, 'userId' => $login_user, 'data' => $log_data));
                header( 'Location: ' . $page.'?m='.$mes);
                exit;

                break;

            case 'e':
                if(!isset($GET['id'])) throw new Exception("テナントIDが指定されていません。");

                $edit_id = $GET['id'];

                $TenantInfo = $adMDL->GetTenantData($edit_id);
                if(!$TenantInfo) throw new Exception("指定されたテナントは存在しません。");

                $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'テナント情報編集フォーム', 'editId' => $edit_id));
                $isEdit = True;
                break;

            case 'edit':


                if(!isset($GET['id'])) throw new Exception("テナントIDが指定されていません。");

                $edit_id = $GET['id'];

                $TenantInfo = $adMDL->GetTenantData($edit_id);
                if(!$TenantInfo) throw new Exception("指定されたテナントは存在しません。");

                if(trim($POST['name']) === "") throw new Exception("テナント名を入力してください。");
                if(mb_strlen($POST['name']) > 128) throw new Exception("テナント名は128文字以内です。");

                if(trim($POST['addr']) === "") throw new Exception("テナント住所を入力してください。");
                if(mb_strlen($POST['addr']) > 1000) throw new Exception("テナント住所は1000文字以内です。");

                if(trim($POST['lat']) === "") throw new Exception("緯度を入力してください。");
                if(trim($POST['lon']) === "") throw new Exception("経度を入力してください。");

                if(preg_match('/^(\+|-)?(?:90(?:(?:\.0{1,6})?)|(?:[0-9]|[1-8][0-9])(?:(?:\.[0-9]{1,6})?))$/', $POST['lat']) == 0) throw new Exception("正しい緯度を入力してください。");
                if(preg_match('/^(\+|-)?(?:180(?:(?:\.0{1,6})?)|(?:[0-9]|[1-9][0-9]|1[0-7][0-9])(?:(?:\.[0-9]{1,6})?))$/', $POST['lon']) == 0) throw new Exception("正しい経度を入力してください。");



                $prm = [
                    'id' => $edit_id,
                    'name' => $POST['name'],
                    'addr' => $POST['addr'],
                    'lat' => $POST['lat'],
                    'lon' => $POST['lon'],
                ];

                $up_ret = $adMDL->UpdateTenantData($prm);
                if(!$up_ret) throw new Exception("テナント情報の更新が失敗しました。");

                $mes = GetMsgEncode("テナント情報を更新しました。");
                $log_data = $prm;
                $log_data['addr'] = '******';
                $log_data['lat'] = '******';
                $log_data['lon'] = '******';
                $log->info("Successful tenant update.",array('file' => __FILE__, 'userId' => $login_user, 'data' => $log_data));
                header( 'Location: ' . $page.'?m='.$mes);
                exit;

                break;

            case 'wdt_e':
                if(!isset($GET['id'])) throw new Exception("テナントIDが指定されていません。");

                $edit_id = $GET['id'];

                $TenantInfo = $adMDL->GetTenantData($edit_id);
                if(!$TenantInfo) throw new Exception("指定されたテナントは存在しません。");

                $WidgetList = [];
                $WidgetSettingList = [];
                $wgt_row = $sapMDL->GetWidgetList();
                if($wgt_row){
                    foreach($wgt_row as $wgtK => $wgtV){
                        if(in_array($wgtV['widget_type'],[WIDGET_TYPE_LINK_1, WIDGET_TYPE_LINK_2, WIDGET_TYPE_LINK_3, WIDGET_TYPE_LINK_4])) continue;

                        $WidgetList[$wgtV['widget_id']] = $wgtV;

                        $init_json = file_get_contents(__DIR__."/../super_appli/widget/{$wgtV['widget_id']}/init_setting.json");


                        if($init_json)$WidgetSettingList[$wgtV['widget_id']] = json_decode($init_json,TRUE);
                    }
                }

                $FieldList = [];
                $fld_row = $adMDL->GetFieldList();
                if($fld_row){
                    foreach($fld_row as $fldK => $fldV){
                        $FieldList[$fldV['tenant_id']][] = $fldV;
                    }
                }

                $TenantWidgetInfo = $adMDL->GetTenantWidgetSettingListForTenantID($edit_id);
                $json = json_decode($TenantWidgetInfo['flag_json'], TRUE);
//                 pre($json['widget_use']);

                $isWidgetEdit = True;
                $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'テナントウィジェット設定フォーム', 'editId' => $edit_id));
                break;

            case 'wdt_edit':

                if(!isset($GET['id'])) throw new Exception("テナントIDが指定されていません。");

                $edit_id = $GET['id'];

                $TenantInfo = $adMDL->GetTenantData($edit_id);
                if(!$TenantInfo) throw new Exception("指定されたテナントは存在しません。");

                $tenant_id = $TenantInfo['id'];

                $json = [];
                //ウィジェット使用エリア設定
                $json['field_list'] = $POST['field_list'];

                //ウィジェット有効化設定
                if(count($POST['widget_use']) == 0) throw new Exception("ウィジェットは必ず一つ有効にしてください。");

                //ウィジェット表示設定
                foreach($POST['widget_use'] as $wdtId => $wuV){
                    $json['widget_use'][] = $wdtId;
                }

                $LinkWidgetIDList = [];
                $w_row = $adMDL->GetWidgetListForMultiType([WIDGET_TYPE_LINK_1, WIDGET_TYPE_LINK_2]);
                if($w_row){
                    foreach($w_row as $wlK => $wlV){
                        $LinkWidgetIDList[] = $wlV['widget_id'];
                    }
                }

                $tw_row = $adMDL->GetTenantWidgetSettingListForTenantID($tenant_id);
                $t_json = json_decode($tw_row['flag_json'], TRUE);
                $widget_setting = $t_json['widget_use'];

                foreach($widget_setting as $wsK => $wsV){
                    if(in_array($wsV, $LinkWidgetIDList)){
                        if(!in_array($wsV, $json['widget_use'])) $json['widget_use'][] = $wsV;
                    }
                }


                if(isset($POST['widget_setting'])){
                    $json['widget_setting'] = $POST['widget_setting'];
                }


                $tw_row= $adMDL->GetTenantWidgetSettingListForTenantID($edit_id);

                $t = new Datetime();
                if($tw_row){
                    //上書き
                    $num = $POST['num'];
                    $prm = [
                        'tenant_id' => $tenant_id,
                        'flag_json' => json_encode($json),
                        'last-update' => $t->format('Y-m-d H:i:s'),
                        'num' => $num,
                    ];
                    $up_ret = $adMDL->UpdateTenantWidgetSettingData($prm);
                    if(!$up_ret) throw new Exception("テナント別ウィジェット設定情報の更新が失敗しました。");
                    $mes = GetMsgEncode("テナント別ウィジェット設定情報を更新しました。");
                    $log->info("Successful tenant widget settings update.",array('file' => __FILE__, 'userId' => $login_user, 'data' => $prm));

                }else{
                    //新規登録
                    $prm = [
                        'tenant_id' => $tenant_id,
                        'flag_json' => json_encode($json),
                        'last-update' => $t->format('Y-m-d H:i:s'),
                    ];
                    $ins_ret = $adMDL->InsertTenantWidgetSettingData($prm);
                    if(!$ins_ret) throw new Exception("テナント別ウィジェット設定情報の更新が失敗しました。");
                    $mes = GetMsgEncode("テナント別ウィジェット設定情報を登録しました。");
                    $log->info("Successful tenant widget settings registration.",array('file' => __FILE__, 'userId' => $login_user, 'data' => $prm));
                }


                header( 'Location: ' . $page.'?m='.$mes);
                exit;
                break;

            case 'd':

                if(!isset($POST['id'])) throw new Exception("テナントIDが指定されていません。");

                $delete_id = $POST['id'];

                $del_ret = $adMDL->DeleteTenantData($delete_id);
                if(!$del_ret) throw new Exception("テナント情報の削除に失敗しました。");

                $mes = GetMsgEncode("テナント情報を削除しました。");
                $log->info("Successful tenant delete.",array('file' => __FILE__, 'userId' => $login_user, 'deleteId' => $delete_id));
                header( 'Location: ' . $page.'?m='.$mes);
                exit;

                break;
        }
    } else {
        $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'テナント一覧リスト'));
    }
}catch(Exception $e){
    $mes = GetMsgEncode($e->getMessage());
    // 確認
    $log->info($e);
    $log->info("Failed to tenant operation.", array('file' => __FILE__, 'userId' => $login_user, 'message' => $e->getMessage()));
    header( 'Location: ' . $page.'?m='.$mes.'&err');
    exit;
}

// var_dump($DeviceList);

$msg_stt = (isset($GET['err']))? "danger" : "success";
$message_tag = ($mes != '')?'<div class="alert alert-'.$msg_stt.'" role="alert">'.$mes.'</div>':'';

$required_tag = '<span class="badge badge-danger">必須</span>';
$page_title = "管理画面　テナント情報管理";

$onetime_token = createToken();

include(PARTS_PATH."header.php");


?>
    <body>
        <div id="Wrap">

        <? include(PARTS_PATH.'header-nav.php'); ?>
        	<div class="wrapper">

        		<? include(PARTS_PATH.'sidemenu.php'); ?>
        		<main class="">

            	    <div class="container grid">

						<nav class="page-header">
							<div class="container-fluid">
								<div class="navbar-wrapper">
									<h2><span class="svg-wrap mr10"><svg class="img-fluid"><use xlink:href="./asset/img/marker.svg#Marker"></use></svg></span>テナント情報管理</h2>
								</div>
							</div>
						</nav>

						<?=$message_tag ?>


						<?php if($isEdit): ?>

						<section id="EditTenant" class="page-contents">
							<div><h3>テナント情報編集フォーム</h3></div>
                            <div class="card-wrapper">
                                <form action="<?=$page ?>?c=edit&id=<?=h($edit_id) ?>" method="POST">
									<input type="hidden" name="one_time_token" value="<?=$onetime_token?>"/>
    								<div class="form-group row">
    									<div class="col-3">テナントID</div>
    									<div class="col-5"><?=h($TenantInfo['id']) ?></div>
                                        <div class="d-inline-block col-4"></div>
                                    </div>

                                    <hr />
    								<div class="form-group row">
    									<div class="col-3">テナント名 <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="name" id="Name" placeholder="テナントの名前" value="<?=h($TenantInfo['name']) ?>" required/>
                                        <div class="d-inline-block col-4">テナント名を入力してください。</div>
                                    </div>

                                    <hr />

    								<div class="form-group row">
    									<div class="col-3">テナントの住所<?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="addr" id="Addr" placeholder="テナントの住所" value="<?=h($TenantInfo['addr']) ?>" required/>
                                        <div class="d-inline-block col-4">住所を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
    									<div class="col-3">テナントの緯度 <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="number" step="0.000001" name="lat" id="Lat" placeholder="0" value="<?=h($TenantInfo['lat']) ?>" required/>
                                        <div class="d-inline-block col-4">テナントの緯度を入力してください。</div>
                                    </div>

                                    <hr />

    								<div class="form-group row">
    									<div class="col-3">テナントの経度 <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="number" step="0.000001" name="lon" id="Lon" placeholder="0" value="<?=h($TenantInfo['lon']) ?>" required/>
                                        <div class="d-inline-block col-4">テナントの経度を入力してください。</div>
                                    </div>


                                    <hr />

                                    <div class="tcenter">
                                    	<button type="submit" class="btn btn-primary">更新</button>
                                    	<a href="<?=$page ?>" class="btn btn-default btn-outline-dark">キャンセル</a>
                                    </div>

                                </form>
                            </div>
						</section>


						<?php elseif($isRegist): ?>


						<section id="RegistUser" class="page-contents">
							<div><h3>テナント情報登録フォーム</h3></div>
                            <div class="card-wrapper">
                                <form action="<?=$page ?>?c=regist" method="POST">
									<input type="hidden" name="one_time_token" value="<?=$onetime_token?>"/>

    								<div class="form-group row">
    									<div class="col-3">テナントID <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="id" id="TenantID" placeholder="テナントID" value="" required/>
                                        <div class="d-inline-block col-4">テナントIDを入力してください。</div>
                                    </div>

                                    <hr />
    								<div class="form-group row">
    									<div class="col-3">テナント名 <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="name" id="Name" placeholder="テナントの名前" value="" required/>
                                        <div class="d-inline-block col-4">テナント名を入力してください。</div>
                                    </div>

                                    <hr />

    								<div class="form-group row">
    									<div class="col-3">テナントの住所<?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="addr" id="Addr" placeholder="テナントの住所" value="" required/>
                                        <div class="d-inline-block col-4">住所を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
    									<div class="col-3">テナントの緯度 <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="number" step="0.000001" name="lat" id="Lat" placeholder="0" value="" required/>
                                        <div class="d-inline-block col-4">テナントの緯度を入力してください。</div>
                                    </div>

                                    <hr />

    								<div class="form-group row">
    									<div class="col-3">テナントの経度 <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="number" step="0.000001" name="lon" id="Lon" placeholder="0" value="" required/>
                                        <div class="d-inline-block col-4">テナントの経度を入力してください。</div>
                                    </div>


                                    <hr />

                                    <div class="tcenter">
                                    	<button type="submit" class="btn btn-primary">登録</button>
                                    	<a href="<?=$page ?>" class="btn btn-default btn-outline-dark">キャンセル</a>
                                    </div>

                                </form>
                            </div>
						</section>

						<?php elseif($isWidgetEdit): ?>


						<section id="EditTenant" class="page-contents">
							<div><h3>テナントウィジェット設定フォーム</h3></div>
                            <div class="card-wrapper">
                                <form action="<?=$page ?>?c=wdt_edit&id=<?=h($edit_id) ?>" method="POST">
									<input type="hidden" name="one_time_token" value="<?=$onetime_token?>"/>
									<input type="hidden" name="num" value="<?=$TenantWidgetInfo['num']?>"/>
    								<div class="form-group row">
    									<div class="col-3">テナントID</div>
    									<div class="col-5"><?=h($TenantInfo['id']) ?></div>
                                        <div class="d-inline-block col-4"></div>
                                    </div>

                                    <hr />
    								<div class="form-group row">
    									<div class="col-3">ウィジェット設定 <?=$required_tag ?></div>
    									<div class="col-9">
    										<table id="TenantWidgetListTable" class="table" width="100%">
    											<thead class="thead-dark">
        											<tr>
        												<th>ウィジェットID</th>
        												<th>使用エリア</th>
        												<th>ウィジェット使用フラグ</th>
        												<th>ウィジェット詳細設定</th>
        											</tr>
    											</thead>
    											<tbody>
    												<?php if($WidgetList): ?>
        												<?php foreach($WidgetList as $wdtK => $wdtV): ?>
    														<tr>
        													<td><?=h($wdtV['widget_id']) ?></td>
        													<td>
        														<select name="field_list[<?=$wdtV['widget_id'] ?>]" id="FieldList_<?=$wdtK ?>" class="form-control">
        															<option class="init_list" value="">未設定</option>
                    												<?php foreach($FieldList[$TenantInfo['id']] as $fldK => $fldV):
                    												$selected = ($fldV['field_id'] == $json['field_list'][$wdtV['widget_id']])?"selected":"";
                    												?>
                														<option value="<?=h($fldV['field_id']) ?>" <?=$selected ?>><?=h($fldV['field_name']) ?></option>
                    												<?php endforeach; ?>
        														</select>
        													</td>
        													<td>
        													<?php
        													$checked = (in_array($wdtV['widget_id'], $json['widget_use']))?"checked":"";

        													?>
        														<div class="toggle-switch wh50px">
            														<input class="toggle-input" type="checkbox" name="widget_use[<?=$wdtV['widget_id'] ?>]" id="WidgetUse_<?=$wdtK ?>" <?=$checked ?>/>
            														<label for="WidgetUse_<?=$wdtK ?>" class="toggle-label"></label>
        														</div>
        													</td>
        													<td>
        													<?php

        													if(isset($json['widget_setting'][$wdtV['widget_id']])){
        													    echo CreateFormParts($wdtV['widget_id'], $json['widget_setting'][$wdtV['widget_id']]);
        													}else{
        													    if(isset($WidgetSettingList[$wdtV['widget_id']])){
        													        echo CreateFormParts($wdtV['widget_id'], $WidgetSettingList[$wdtV['widget_id']]);
        													    }
        													}

        													?>
        													</td>
    														</tr>
        												<?php endforeach; ?>
    												<?php else: ?>
    												<tr>
    													<td>
    														登録されているウィジェットがありません。
    													</td>
    												</tr>
    												<?php endif; ?>
    											</tbody>
    										</table>
    									</div>
                                    </div>


                                    <hr />

                                    <div class="tcenter">
                                    	<button type="submit" class="btn btn-primary">更新</button>
                                    	<a href="<?=$page ?>" class="btn btn-default btn-outline-dark">キャンセル</a>
                                    </div>

                                </form>
                            </div>
						</section>

						<?php else: ?>

						<section id="TenantManage" class="page-contents">
							<div><h3>テナント一覧リスト</h3></div>
							<div class="card-wrapper">
								<div class="adduser-wrapper　">
									<a href="<?=$page ?>?c=n" class="btn btn-primary btn-sm">新規テナント登録</a>
								</div>
    							<div class="table-wrapper">
    								<table id="TenantListTable" class="table">
    									<thead class="thead-dark">
        									<tr>
        										<th class="th_num" scope="col">#</th>
        										<th class="th_tenantid" scope="col">テナントID</th>
        										<th class="th_tenantname" scope="col">テナント名</th>
        										<th class="th_addr" scope="col">住所</th>
        										<th class="th_lat" scope="col">緯度</th>
        										<th class="th_lon" scope="col">経度</th>
        										<th class="th_widget" scope="col">ウィジェット設定</th>
        										<th class="th_status" scope="col">ステータス</th>
        										<th class="th_control" scope="col">操作</th>
        									</tr>
    									</thead>
    									<tbody>
    									<?php foreach($TenantList as $tlK => $tlV):
    									switch($tlV['status']){
    									    case ACCOUNT_STATUS_LOCK:
    									        $status = "ロック";
    									        break;
    									    case ACCOUNT_STATUS_OK:
    									        $status = "通常";
    									        break;
    									}
    									?>
                                            <tr>
                                            	<td><?=h($tlV['num']) ?></td>
                                            	<td><?=h($tlV['id']) ?></td>
                                            	<td><?=h($tlV['name']) ?></td>
                                            	<td><?=h($tlV['addr']) ?></td>
                                            	<td><?=h($tlV['lat']) ?></td>
                                            	<td><?=h($tlV['lon']) ?></td>
                                            	<td>
                                            		<a href="<?=$page ?>?c=wdt_e&id=<?=h($tlV['id']) ?>" class="btn btn-sm btn-primary">ウィジェット設定</a>
                                        		</td>
                                            	<td><?=$status ?></td>
                                            	<td>
                                            		<a href="<?=$page ?>?c=e&id=<?=h($tlV['id']) ?>" class="btn btn-sm btn-primary">編集</a>
                                            		<button class="btn btn-sm btn-danger" data-toggle="modal" data-target="#modal-tenantdelete" data-whatever="<?=$tlV['id']?>">削除</button>
                                            	</td>
                                            </tr>
                                        <?php endforeach;?>
    									</tbody>
    								</table>
    							</div>
							</div>

						</section>

						<?php endif; ?>
                    </div>
        		</main>
            </div>
		<? //include(PARTS_PATH.'footer.php'); ?>
        </div>
	</body>
    <!-- /container -->


    <!-- モーダル　テナント情報削除 -->
    <div class="modal fade" id="modal-tenantdelete" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-label">テナント情報削除</h4>
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>このテナント情報を削除しますか？</p>
                    <form id="user_delete" action="<?=$page?>?c=d" method="post">
                        <input type="hidden" name="one_time_token" value="<?=$onetime_token ?>"/>
                        <div class="form-group">
                            <label for="recipient-name" class="form-control-label">テナントID:</label>
                            <input type="text" class="form-control" id="DeleteTenantID" name="id" readonly="readonly" required>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-danger">削除する</button>
                            <button type="cancel" class="btn btn-default btn-outline-dark" data-dismiss="modal">中止</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <script>
        $(function(){

            $('#modal-tenantdelete').on('show.bs.modal', function(event) {
                var recipient = $(event.relatedTarget).data('whatever');
                $(this).find('.modal-body #DeleteTenantID').val(recipient);
            });


            // datatableの設定を変更
            $("#TenantListTable").DataTable({
            	searching: false,
            	info: false,
            	lengthChange: false,
            	columnDefs: [
            		  { "targets": 0, "width": '5%'},
            		  { "targets": 1, "width": '10%'},
            		  { "targets": 2, "width": '13%'},
            		  { "targets": 3, "width": '26%'},
            		  { "targets": 4, "width": '12%'},
            		  { "targets": 5, "width": '12%'},
            		  { "targets": 6, "width": '14%'},
            		  { "targets": 7, "width": '18%',"orderable": false},
            		],
            });

            // datatableの設定を変更
            $("#TenantWidgetListTable").DataTable({
//                 scrollY: 400,
            	searching: false,
            	info: false,
            	paging: false,
            	lengthChange: false,
            	ordering: false,
            	columnDefs: [
            		  { "targets": 0, "width": '12%'},
            		  { "targets": 1, "width": '30%'},
            		  { "targets": 2, "width": '15%'},
            		  { "targets": 3, "width": '43%'},
            		],
            });
        });
    </script>

</html>

<?php
function CreateFormParts($wid, $json_arr){
    $dom = "";
    foreach($json_arr as $jk => $json){

        switch($json['type']){
            case 'input':
                $dom .= "<div class=\"form-group\"><input type=\"hidden\" name=\"widget_setting[{$wid}][{$jk}][type]\" value=\"input\"/><input type=\"hidden\" name=\"widget_setting[{$wid}][{$jk}][label]\" value=\"{$json['label']}\"/><label for=\"\">{$json['label']}<input class=\"form-control\" type=\"text\" name=\"widget_setting[{$wid}][{$jk}][value]\" value=\"{$json['value']}\" placeholder=\"値を入力\"/></label></div>";
                break;
        }
    }
    return $dom;
}
?>