<?
/**
 * ユーザー管理画面
 */
require("core/construct.php");

require(CORE_PATH."basic.php");
require(CORE_PATH."functions.php");
require(CORE_PATH."session_check.php");
require(CORE_PATH."authorize.php");

require(CORE_PATH."validation.php");
$VAL = new formValidation();

require_once(AD_MDL_PATH."model.php");
$adMDL = new admModel($sdb, $link);

require_once(SN_MDL_PATH."model.php");
$sgMDL = new sngModel($sdb, $link);

require_once(__DIR__."/util/utils.php");

// ユーザーリスト取得
$u_row = $adMDL->GetUserList();
if($u_row){
    foreach($u_row as $uK => $uV){

        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
            if($uV['tenant_id'] !== $_SESSION['admin']['tenant_id']){
                continue;
            }
        }
        $UserList[] = $uV;
    }
}
$TenantNameList = [];
$t_row = $adMDL->GetTenantList();
if($t_row){
    foreach($t_row as $tK => $tV){
        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
            if($tV['id'] != $_SESSION['admin']['tenant_id']){
                continue;
            }
        }
        $TenantNameList[$tV['id']] = $tV['name'];
    }
}
//TODO 権限上位の管理者はすべてのデバイスを登録可能とするか？
$DeviceList = [];
$DeviceTypeList = [];
$d_row = $sgMDL->GetDeviceTbl();
if($d_row){
    foreach($d_row as $dK => $dV){
        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
            if($dV['tenant_id'] !== $_SESSION['admin']['tenant_id']){
                continue;
            }
        }
        $DeviceList[$dV['du_id']]['name'] = $dV['name'];
        $DeviceList[$dV['du_id']]['id'] = $dV['device_id'];
        $DeviceList[$dV['du_id']]['f_id'] = $dV['field_id'];
        $DeviceList[$dV['du_id']]['type'] = $dV['type'];
        if(!in_array($dV['type'], $DeviceTypeList)) $DeviceTypeList[] = $dV['type'];
    }
}

$page = "user.php";

$GET = filterGet();
$POST = filterPost();

$isEdit = False;
$isRegist = False;
$isCSVRegist = False;

$login_user = $_SESSION['admin']['admin_id'];

try{


    if(isset($GET['m']))
    {
        $mes = GetMsgDecode($GET['m']);
    }

    if(isset($_GET['c']))
    {


        switch($_GET['c'])
        {
            case 'n':
                $TenantList = [];
                $t_row = $adMDL->GetTenantList();
                if($t_row){
                    foreach($t_row as $tK => $tV){
                        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
                            if($tV['id'] != $_SESSION['admin']['tenant_id']){
                                continue;
                            }
                        }
                        $TenantList[] = $tV;
                    }
                }


                //                 $DeviceTypeList = GetDeviceTypeList();

                $DeviceList_user = [];
                //                 $d_row = $sgMDL->GetDeviceTblByTenantID($_SESSION['admin']['tenant_id']);
                $d_row = $sgMDL->GetDeviceTbl();
                if($d_row){
                    foreach($d_row as $dK => $dV){
                        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
                            if($dV['tenant_id'] !== $_SESSION['admin']['tenant_id']){
                                continue;
                            }
                        }
                        $DeviceList_user[$dV['du_id']]['name'] = $dV['name'];
                        $DeviceList_user[$dV['du_id']]['id'] = $dV['device_id'];
                        $DeviceList_user[$dV['du_id']]['f_id'] = $dV['field_id'];
                        $DeviceList_user[$dV['du_id']]['type'] = $dV['type'];
                        $DeviceList_user[$dV['du_id']]['t_id'] = $dV['tenant_id'];
                    }
                }

                $FieldList = [];
                $f_row = $adMDL->GetFieldList();
                if($f_row){
                    foreach($f_row as $fK => $fV){
                        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
                            if($fV['tenant_id'] != $_SESSION['admin']['tenant_id']){
                                continue;
                            }
                        }
                        $FieldList[] = $fV['field_id'];
                    }
                }

                $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'ユーザー情報登録フォーム'));
                $isRegist = True;
                break;

            case 'regist':

                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }

                try{
                    $VAL->UserID($POST['user_id'], 32, TRUE);

                    //ユーザーID重複チェック
                    $UserInfo = $adMDL->GetUserInfo($POST['user_id']);
                    if($UserInfo) throw new Exception("入力されたユーザーIDは既に存在するため使用できません。");

                    $VAL->UserNum($POST['user_number'], 10);
                    $VAL->UserName($POST['name'], 48, TRUE);
                    $VAL->UUID($POST['uuid'], 256);
                    //                         //TODO uuid重複チェック

                    $VAL->Organize($POST['organization'], 512);
                    $VAL->Department($POST['department'], 512);

                    //テナントチェック
                    $TenantInfo = $adMDL->GetTenantData($POST['tenant_id']);
                    if(!$TenantInfo) throw new Exception("指定されたテナントは存在しません。");

                    if(trim($POST['password']) === "") throw new Exception("ログインパスワードを入力してください。");

                    if(mb_strlen($POST['password']) < 8) throw new Exception("ログインパスワードは8文字以上入力してください。");
                    if(strcmp($POST['password'],$POST['confpass']) !== 0) throw new Exception("ログインパスワードが一致しません。");

                    
                    //デバイス操作権限の確認
                    $device_auth = [];
                    $chkdList = [];
                    $chk_d_row = $sgMDL->GetDeviceTblByTenantID($POST['tenant_id']);
                    if($chk_d_row){
                        foreach($chk_d_row as $chkdV){
                            $chkdList[] = $chkdV['du_id'];
                        }
                    }
                    if(!empty($POST['device_authorize'])){
                        foreach($POST['device_authorize'] as $dadV){
                            if(in_array($dadV, $chkdList))$device_auth[] = $dadV;
                        }
                    }
                    
                    
                    $options = [ 'cost' => 8, 'salt' =>  $user_magic_code];
                    $setpass = password_hash($POST['password'], PASSWORD_DEFAULT);
                    $t = new Datetime();

                    $prm = [
                        'user_id' => $POST['user_id'],
                        'tenant_id' => $POST['tenant_id'],
                        'user_number' => $POST['user_number'],
                        'uuid' => $POST['uuid'],
                        'name' => $POST['name'],
                        'department' => $POST['department'],
                        'organization' => $POST['organization'],
                        'device_authorize' => (isset($POST['device_authorize']))?implode(",", $device_auth):"",
                        'pass' => $setpass,
                        'last_login' => $t->format("Y-m-d H:i:s"),
                    ];

                    $ins_ret = $adMDL->InsertUserData($prm);
                    if(!$ins_ret) throw new Exception("ユーザー情報の登録が失敗しました。");

                    $log_data = $prm;
                    $log_data['user_number'] = '******';
                    $log_data['uuid'] = '******';
                    $log_data['name'] = '******';
                    $log_data['department'] = '******';
                    $log_data['organization'] = '******';
                    $log_data['pass'] = '******';
                    $log->info("Successful user registration.",array('file' => __FILE__, 'userId' => $login_user, 'data' => $log_data));
                    $mes = GetMsgEncode("ユーザー情報を登録しました。");
                    header( 'Location: ' . $page.'?m='.$mes);
                    exit;

                }catch(Exception $e){
                    $mes = GetMsgEncode($e->getMessage());
                    $log->info($e);
                    $log->info("Failed to user operation.", array('file' => __FILE__, 'userId' => $login_user, 'message' => $e->getMessage()));
                    header( 'Location: ' . $page.'?c=n&m='.$mes.'&err');
                    exit;
                }


                break;

            case 'csv':
                //                 $TenantList = $adMDL->GetTenantList();
                $TenantList = [];
                $t_row = $adMDL->GetTenantList();
                if($t_row){
                    foreach($t_row as $tK => $tV){
                        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
                            if($tV['id'] != $_SESSION['admin']['tenant_id']){
                                continue;
                            }
                        }
                        $TenantList[] = $tV;
                    }
                }
                //                 $DeviceTypeList = GetDeviceTypeList();
                $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'CSV一括登録フォーム'));
                $isCSVRegist = True;
                break;

            case 'csv_regist':
                //                 var_dump($POST, $_FILES);
                $targetFolder = 'admin/tmp'; //アップロード先フォルダを指定します。
                $readDataLimit = 100; //読み込みデータ限界
                $filename = 'user_list';

                require(CORE_PATH."csv_input.php");

                $data = $csv_arr;

                $ins_ret = $adMDL->InsertCSVMultiUserData($data);
                if(!$ins_ret) throw new Exception("ユーザーの一括登録に失敗しました。");

                $log_data = array();
                foreach($data as $dk => $dv) {
                    $dv['user_number'] = '******';
                    $dv['uuid'] = '******';
                    $dv['name'] = '******';
                    $dv['department'] = '******';
                    $dv['organization'] = '******';
                    $dv['pass'] = '******';

                    $log_data[] = $dv;
                }
                $log->info("Successful CSV bulk registration.",array('file' => __FILE__, 'userId' => $login_user, 'data' => $log_data));
                $mes = GetMsgEncode("ユーザーの一括登録が完了しました。");
                header( 'Location: ' . $page.'?m='.$mes);
                exit;

                break;


            case 'e':
                if(!isset($GET['id'])) throw new Exception("ユーザーIDが指定されていません。");

                $edit_id = $GET['id'];

                $UserInfo = $adMDL->GetUserInfoByNum($edit_id);
                if(!$UserInfo) throw new Exception("指定されたユーザーは存在しません。");


                $DeviceList_user = [];
                $d_row = $sgMDL->GetDeviceTblByTenantID($UserInfo['tenant_id']);

                if($d_row){
                    foreach($d_row as $dK => $dV){
                        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
                            if($dV['tenant_id'] !== $_SESSION['admin']['tenant_id']){
                                continue;
                            }
                        }
                        $DeviceList_user[$dV['du_id']]['name'] = $dV['name'];
                        $DeviceList_user[$dV['du_id']]['id'] = $dV['device_id'];
                        $DeviceList_user[$dV['du_id']]['f_id'] = $dV['field_id'];
                        $DeviceList_user[$dV['du_id']]['type'] = $dV['type'];
                        $DeviceList_user[$dV['du_id']]['t_id'] = $dV['tenant_id'];
                    }
                }

                $FieldList = [];
                $f_row = $adMDL->GetFieldDataForTenantIDs($UserInfo['tenant_id']);
                if($f_row){
                    foreach($f_row as $fK => $fV){
                        $FieldList[] = $fV['field_id'];
                    }
                }

                $isEdit = True;

                $TenantList = [];
                $t_row = $adMDL->GetTenantList();
                if($t_row){
                    foreach($t_row as $tK => $tV){
                        if($_SESSION['admin']['authorize'] != ACCOUNT_AUTHOR_OWNER){
                            if($tV['id'] != $_SESSION['admin']['tenant_id']){
                                continue;
                            }
                        }
                        $TenantList[] = $tV;
                    }
                }

                $DeviceAuth = explode(',', $UserInfo['device_authorize']);

                //                 $DeviceTypeList = GetDeviceTypeList();

                $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'ユーザー情報編集フォーム', 'editId' => $edit_id));
                break;

            case 'edit':
                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }

                if(!isset($GET['id'])) throw new Exception("ユーザーIDが指定されていません。");

                $edit_id = $GET['id'];

                $UserInfo = $adMDL->GetUserInfoByNum($edit_id);
                if(!$UserInfo) throw new Exception("指定されたユーザーは存在しません。");

                try{
//                     $VAL->UserID($POST['user_id'], 10, TRUE);


                    $VAL->UserNum($POST['user_number'], 10);
                    $VAL->UserName($POST['name'], 48, TRUE);
                    $VAL->UUID($POST['uuid'], 256);
                    //                         //TODO uuid重複チェック

                    $VAL->Organize($POST['organization'], 512);
                    $VAL->Department($POST['department'], 512);

//                     if(trim($POST['name']) === "") throw new Exception("ユーザー名を入力してください。");
//                     if(mb_strlen($POST['name']) > 48) throw new Exception("ユーザー名は48文字以内です。");

//                     //                 if(trim($POST['uuid']) === "") throw new Exception("UUIDを入力してください。");
//                     if(trim($POST['uuid']) !== ""){

//                         if(mb_strlen($POST['uuid']) > 256) throw new Exception("UUIDは256文字以内です。");

//                     }

                    //テナントチェック
                    $TenantInfo = $adMDL->GetTenantData($POST['tenant_id']);
                    if(!$TenantInfo) throw new Exception("指定されたテナントは存在しません。");

                    
                    //デバイス操作権限の確認
                    $device_auth = [];
                    $chkdList = [];
                    $chk_d_row = $sgMDL->GetDeviceTblByTenantID($POST['tenant_id']);
                    if($chk_d_row){
                        foreach($chk_d_row as $chkdV){
                            $chkdList[] = $chkdV['du_id'];
                        }
                    }
                    if(!empty($POST['device_authorize'])){
                        foreach($POST['device_authorize'] as $dadV){
                            if(in_array($dadV, $chkdList))$device_auth[] = $dadV;
                        }
                    }
                    

                    if(trim($POST['password']) !== ""){
                        if(mb_strlen($POST['password']) < 8) throw new Exception("ログインパスワードは8文字以上入力してください。");
                        if(strcmp($POST['password'],$POST['confpass']) !== 0) throw new Exception("ログインパスワードが一致しません。");

                        $options = [ 'cost' => 8, 'salt' =>  $user_magic_code];
                        $setpass = password_hash($POST['password'], PASSWORD_DEFAULT);

                        $prm = [
                            'num' => $edit_id,
                            'user_number' => $POST['user_number'],
                            'name' => $POST['name'],
                            'uuid' => $POST['uuid'],
                            'pass' => $setpass,
                            'department' => $POST['department'],
                            'organization' => $POST['organization'],
                            'tenant_id' => $POST['tenant_id'],
                            'device_authorize' => (!empty($device_auth))?implode(",", $device_auth):"",
                        ];
                        $up_ret = $adMDL->UpdateUserDataChangePass($prm);
                        if(!$up_ret) throw new Exception("ユーザー情報の更新が失敗しました。");

                    }else{

                        $prm = [
                            'num' => $edit_id,
                            'user_number' => $POST['user_number'],
                            'name' => $POST['name'],
                            'uuid' => $POST['uuid'],
                            'department' => $POST['department'],
                            'organization' => $POST['organization'],
                            'tenant_id' => $POST['tenant_id'],
                            'device_authorize' => (!empty($device_auth))?implode(",", $device_auth):"",
                        ];

                        $up_ret = $adMDL->UpdateUserData($prm);
                        if(!$up_ret) throw new Exception("ユーザー情報の更新が失敗しました。");
                    }

                }catch(Exception $e){    
                    $log->info($e);
                    $log->info("Failed to user operation.", array('file' => __FILE__, 'userId' => $login_user, 'message' => $e->getMessage()));
                    header( 'Location: ' . $page.'?c=e&id='.$edit_id.'&m='.$mes.'&err');
                    exit;
                }
                
                $log_data = $prm;
                if ($log_data['pass']) {
                    $log_data['pass'] = '******';
                }
                $log_data['user_number'] = '******';
                $log_data['uuid'] = '******';
                $log_data['name'] = '******';
                $log_data['department'] = '******';
                $log_data['organization'] = '******';
                $log->info("Successful user update.",array('file' => __FILE__, 'userId' => $login_user, 'data' => $log_data));
                $mes = GetMsgEncode("ユーザー情報を更新しました。");
                header( 'Location: ' . $page.'?m='.$mes);
                exit;

                break;

            case 'd':
                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }

                if(!isset($POST['num'])) throw new Exception("ユーザー番号が指定されていません。");


                $delete_num = $POST['num'];


                $UserInfo = $adMDL->GetUserInfoByNum($delete_num);
                if(!$UserInfo) throw new Exception("指定されたユーザーは存在しません。");

                $del_ret = $adMDL->DeleteUserData($delete_num);
                if(!$del_ret) throw new Exception("ユーザー情報の削除に失敗しました。");

                $log->info("Successful user delete.",array('file' => __FILE__, 'userId' => $login_user, 'deleteNum' => $delete_num));
                $mes = GetMsgEncode("ユーザー情報を削除しました。");
                header( 'Location: ' . $page.'?m='.$mes);
                exit;

                break;
        }
    } else {
        $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'ユーザー一覧リスト'));
    }
}catch(Exception $e){
    $mes = GetMsgEncode($e->getMessage());
    // 確認
    $log->info($e);
    $log->info("Failed to user operation.", array('file' => __FILE__, 'userId' => $login_user, 'message' => $e->getMessage()));
    header( 'Location: ' . $page.'?m='.$mes.'&err');
    exit;
}


$msg_stt = (isset($GET['err']))? "danger" : "success";
$message_tag = ($mes != '')?'<div class="alert alert-'.$msg_stt.'" role="alert">'.$mes.'</div>':'';

$required_tag = '<span class="badge badge-danger">必須</span>';
$page_title = "管理画面　ユーザー情報管理";

$onetime_token = createToken();

include(PARTS_PATH."header.php");


?>
    <body>
        <div id="Wrap">

        <? include(PARTS_PATH.'header-nav.php'); ?>
        	<div class="wrapper">

        		<? include(PARTS_PATH.'sidemenu.php'); ?>
        		<main class="">

            	    <div class="container grid">

						<nav class="page-header">
							<div class="container-fluid">
								<div class="navbar-wrapper">
									<h2><span class="svg-wrap mr10"><svg class="img-fluid"><use xlink:href="./asset/img/user.svg#User"></use></svg></span>ユーザー情報管理</h2>
								</div>
							</div>
						</nav>

						<div class="alert-wrap"><?=$message_tag ?></div>



						<?php if($isEdit): ?>

						<section id="EditUser" class="page-contents">
							<div><h3>ユーザー情報編集フォーム</h3></div>
                            <div class="card-wrapper">
                                <form id="FormUserEdit" action="<?=$page ?>?c=edit&id=<?=h($edit_id) ?>" method="POST">
									<input type="hidden" name="one_time_token" value="<?=$onetime_token?>"/>


    								<div class="form-group row">
    									<div class="col-3">ユーザーID</div>
    									<div class="col-5"><?=h($UserInfo['user_id']) ?></div>
                                        <div class="d-inline-block col-4">ユーザーID</div>
                                    </div>

                                    <hr />

    								<div class="form-group row">
    									<div class="col-3">社員番号</div>
                                        <input class="form-control col-5" type="number" name="user_number" id="UserNum" placeholder="社員番号" value="<?=h($UserInfo['user_number']) ?>"/>
                                        <div class="d-inline-block col-4">社員番号を入力してください。（半角数字10桁まで）</div>
                                    </div>

                                    <hr />

    								<div class="form-group row">
    									<div class="col-3">ユーザー名 <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="name" id="Name" placeholder="ユーザー名" value="<?=h($UserInfo['name']) ?>" required/>
                                        <div class="d-inline-block col-4">ユーザー名を入力してください。（48文字まで）</div>
                                    </div>

                                    <hr />

    								<div class="form-group row">
    									<div class="col-3">UUID</div>
                                        <input class="form-control col-5" type="text" name="uuid" id="UUID" placeholder="UUID" value="<?=h($UserInfo['uuid']) ?>"/>
                                        <div class="d-inline-block col-4">UUIDを入力してください。（メールアドレス形式）</div>
                                    </div>

                                    <hr />
    								<div class="form-group row">
    									<div class="col-3">所属組織</div>
                                        <input class="form-control col-5" type="text" name="organization" id="Organization" placeholder="所属組織" value="<?=h($UserInfo['organization']) ?>" maxlength="512"/>
                                        <div class="d-inline-block col-4">所属組織を入力してください。</div>
                                    </div>

                                    <hr />
    								<div class="form-group row">
    									<div class="col-3">役職</div>
                                        <input class="form-control col-5" type="text" name="department" id="Department" placeholder="役職" value="<?=h($UserInfo['department']) ?>" maxlength="512"/>
                                        <div class="d-inline-block col-4">役職を入力してください。</div>
                                    </div>

                                    <hr />
    								<div class="form-group row">
    									<div class="col-3">ログインパスワード</div>
                                        <input class="form-control col-5" type="password" name="password" id="Password" placeholder="ログインパスワード" value="" maxlength="100"/>
                                        <div class="d-inline-block col-4">変更を希望する場合、ログインパスワードを入力してください。</div>
                                    </div>

                                    <hr />
    								<div class="form-group row">
    									<div class="col-3">ログインパスワード（確認）</div>
                                        <input class="form-control col-5" type="password" name="confpass" id="Confpass" placeholder="ログインパスワード（確認）" value="" maxlength="100"/>
                                        <div class="d-inline-block col-4">変更を希望する場合、確認のため、ログインパスワードを入力してください。</div>
                                    </div>

                                    <hr />

    								<div class="form-group row">
    									<div class="col-3">登録テナント <?=$required_tag ?></div>

										<div class="col-5">
										<?php if($TenantList): ?>
    									<select name="tenant_id" id="TenantID" class="form-control">
    										<option value="">テナントを選択してください。</option>
											<?php foreach($TenantList as $tlK => $tlV):
											$selected = ($UserInfo['tenant_id'] == $tlV['id'])?"selected":"";
											?>
												<option value="<?=h($tlV['id']) ?>" <?=$selected ?>><?=h($tlV['name']) ?></option>
											<?php endforeach; ?>
    									</select>
										<?php else: ?>

										※テナントが登録されていません

										<?php endif; ?>
										</div>

                                        <div class="d-inline-block col-4">ユーザーを登録するテナントを選択してください。</div>
									</div>

                                    <hr />


    								<div class="form-group row">
    									<div class="col-3">デバイス操作権限</div>

    									<div class="col-5">

                                        	<div id="AjaxDevicetableWrap" data-tid="<?=$_SESSION['admin']['tenant_id'] ?>">
                                        	
    											<div class="table-wrapper">
    
                                                	<div class="row">
    
    												<?php if(False): ?>
                                                      	<div class="col-6">
                                                    		エリア絞り込み：
                                                        	<select name="" id="selectArea" class="form-control">
                                                        		<option value="">未指定</option>
                                                        		<?php if(!empty($FieldList)): ?>
                                                            		<?php foreach($FieldList as $fK => $fV): ?>
                                                            		<option value="<?php echo $fV ?>"><?php echo $fV ?></option>
                                                            		<?php endforeach; ?>
                                                        		<?php endif; ?>
                                                        	</select>
                                                    	</div>
                                                    	<div class="col-6">
                                                    		デバイスタイプ絞り込み：
                                                        	<select name="" id="selectType" class="form-control">
                                                        		<option value="">未指定</option>
                                                        		<?php if(!empty($DeviceTypeList)): ?>
                                                                	<?php foreach($DeviceTypeList as $dtV): ?>
                                                                		<option value="<?php echo $dtV ?>"><?php echo $dtV ?></option>
                                                                	<?php endforeach; ?>
                                                        		<?php endif; ?>
                                                        	</select>
                                                    	</div>
    
    												<?php endif; ?>
    												
                                                    	<div class="col-12 mt10">
                                                    		<button id="AllCheckBtn" class="btn btn-sm btn-light btn-outline-secondary" type="button">すべて選択</button>
                                                    		<button id="AllUnCheckBtn" class="btn btn-sm btn-light btn-outline-secondary" type="button">すべて選択解除</button>
                                                    	</div>
                                                	</div>
                    								<table id="DeviceAuthorizeListTable" class="table">
                    									<thead class="thead-dark">
                        									<tr>
                        										<th class="th_chk" scope="col">チェック</th>
                        										<th class="th_dname" scope="col">デバイス名</th>
                        										<th class="th_flr" scope="col">エリア</th>
                        										<th class="th_dtype" scope="col">デバイス種別</th>
                        										<th class="th_tenant" scope="col">テナント</th>
                        									</tr>
                    									</thead>
                    									<tbody>
                    									<?php foreach($DeviceList_user as $dvc_id => $dvc_data):
    
                    									$d_checked = (in_array($dvc_id, $DeviceAuth))?"checked":"";?>
                                                            <tr>
                                                            	<td>
                        											<div class="form-check form-check-inline">
                            											<input class="form-check-input" type="checkbox" name="device_authorize[]" id="DeviceAuth_<?php echo $dvc_id ?>" value="<?php echo $dvc_id ?>" <?=$d_checked ?>>
                                                                    </div>
    															</td>
                                                            	<td><label class="form-check-label" for="DeviceAuth_<?php echo $dvc_id ?>"><?php echo $dvc_data['name'] ?></label></td>
    															<td><?php echo $dvc_data['f_id'] ?></td>
    															<td><?php echo $dvc_data['type'] ?></td>
    															<td><?php echo $dvc_data['t_id'] ?></td>
                                                            </tr>
                                                            <?php endforeach; ?>
                    									</tbody>
                    								</table>
                    							</div>
										</div>


    									</div>

                                        <div class="d-inline-block col-4">ユーザーが操作可能とするデバイスを選択してください。（複数選択可）</div>
									</div>

                                    <hr />

                                    <div class="tcenter">
                                    	<button type="submit" class="btn btn-primary">更新</button>
                                    	<a href="<?=$page ?>" class="btn btn-default btn-outline-dark">キャンセル</a>
                                    </div>

                                </form>
                            </div>
						</section>


						<?php elseif($isRegist): ?>


						<section id="RegistUser" class="page-contents">
							<div><h3>ユーザー情報登録フォーム</h3></div>
                            <div class="card-wrapper">
                                <form id="FormUserRegist" action="<?=$page ?>?c=regist" method="POST">
									<input type="hidden" name="one_time_token" value="<?=$onetime_token?>"/>


    								<div class="form-group row">
    									<div class="col-3">ユーザーID <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="user_id" id="UserID" placeholder="ユーザーID" value="" required/>
                                        <div class="d-inline-block col-4">ユーザーIDを入力してください。（記号あり「-_」半角英数字のみ32文字まで）</div>
                                    </div>

                                    <hr />

    								<div class="form-group row">
    									<div class="col-3">社員番号</div>
                                        <input class="form-control col-5" type="number" name="user_number" id="UserNum" placeholder="社員番号" value=""/>
                                        <div class="d-inline-block col-4">社員番号を入力してください。（半角数字10桁まで）</div>
                                    </div>

                                    <hr />

    								<div class="form-group row">
    									<div class="col-3">ユーザー名 <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="name" id="Name" placeholder="ユーザー名" value="" required/>
                                        <div class="d-inline-block col-4">ユーザー名を入力してください。（48文字まで）</div>
                                    </div>

                                    <hr />

    								<div class="form-group row">
    									<div class="col-3">UUID</div>
                                        <input class="form-control col-5" type="text" name="uuid" id="UUID" placeholder="UUID" value=""/>
                                        <div class="d-inline-block col-4">UUIDを入力してください。（メールアドレス形式）</div>
                                    </div>

                                    <hr />
    								<div class="form-group row">
    									<div class="col-3">所属組織</div>
                                        <input class="form-control col-5" type="text" name="organization" id="Organization" placeholder="所属組織" value="" maxlength="512"/>
                                        <div class="d-inline-block col-4">所属組織を入力してください。</div>
                                    </div>

                                    <hr />
    								<div class="form-group row">
    									<div class="col-3">役職</div>
                                        <input class="form-control col-5" type="text" name="department" id="Department" placeholder="役職" value="" maxlength="512"/>
                                        <div class="d-inline-block col-4">役職を入力してください。</div>
                                    </div>

                                    <hr />
    								<div class="form-group row">
    									<div class="col-3">ログインパスワード <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="password" name="password" id="Password" placeholder="ログインパスワード" value="" maxlength="100" required/>
                                        <div class="d-inline-block col-4">ログインパスワードを入力してください。</div>
                                    </div>

                                    <hr />
    								<div class="form-group row">
    									<div class="col-3">ログインパスワード（確認） <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="password" name="confpass" id="Confpass" placeholder="ログインパスワード（確認）" value="" maxlength="100" required/>
                                        <div class="d-inline-block col-4">確認のため、ログインパスワードを入力してください。</div>
                                    </div>

                                    <hr />

    								<div class="form-group row">
    									<div class="col-3">登録テナント <?=$required_tag ?></div>

										<div class="col-5">
										<?php if($TenantList): ?>
    									<select name="tenant_id" id="TenantID" class="form-control">
    										<option value="">テナントを選択してください。</option>
											<?php foreach($TenantList as $tlK => $tlV):　?>
												<option value="<?=h($tlV['id']) ?>"><?=h($tlV['name']) ?></option>
											<?php endforeach; ?>
    									</select>
										<?php else: ?>

										※テナントが登録されていません

										<?php endif; ?>
										</div>

                                        <div class="d-inline-block col-4">ユーザーを登録するテナントを選択してください。</div>
									</div>

                                    <hr />


    								<div class="form-group row">
    									<div class="col-3">デバイス操作権限</div>

    									<div class="col-5">
                                        	<div id="AjaxDevicetableWrap" data-tid="<?=$_SESSION['admin']['tenant_id'] ?>">


                                                    <div class="table-wrapper">
        												<div class="row">
        												<?php if(False): ?>
                                                        	<div class="col-6">
                                                        		エリア絞り込み：
                                                            	<select name="" id="selectArea" class="form-control">
                                                       				<?php if(!empty($FieldList)): ?>
                                                                		<option value="">未指定</option>
                                                                		<?php foreach($FieldList as $fK => $fV): ?>
                                                                		<option value="<?php echo $fV ?>"><?php echo $fV ?></option>
                                                                		<?php endforeach; ?>
                                                            		<?php endif; ?>
                                                            	</select>
                                                        	</div>
                                                        	<div class="col-6">
        
                                                        		デバイスタイプ絞り込み：
                                                            	<select name="" id="selectType" class="form-control">
                                                            		<option value="">未指定</option>
                                                            		<?php if(!empty($DeviceTypeList)): ?>
                                                                    	<?php foreach($DeviceTypeList as $dtV): ?>
                                                                    		<option value="<?php echo $dtV ?>"><?php echo $dtV ?></option>
                                                                    	<?php endforeach; ?>
                                                            		<?php endif; ?>
                                                            	</select>
                                                        	</div>
                                                        	<?php endif; ?>
                                                        	<div class="col-12 mt10">
                                                        		<button id="AllCheckBtn" class="btn btn-sm btn-light btn-outline-secondary" type="button">すべて選択</button>
                                                        		<button id="AllUnCheckBtn" class="btn btn-sm btn-light btn-outline-secondary" type="button">すべて選択解除</button>
                                                        	</div>
                                                    	</div>
                        								<table id="DeviceAuthorizeListTable" class="table">
                        									<thead class="thead-dark">
                            									<tr>
                            										<th class="th_chk" scope="col">チェック</th>
                            										<th class="th_dname" scope="col">デバイス名</th>
                            										<th class="th_flr" scope="col">エリア</th>
                            										<th class="th_dtype" scope="col">デバイス種別</th>
                            										<th class="th_tenant" scope="col">テナント</th>
                            									</tr>
                        									</thead>
                        									<tbody>
                        									<?php foreach($DeviceList_user as $dvc_id => $dvc_data): ?>
                                                                <tr>
                                                                	<td>
                            											<div class="form-check form-check-inline">
                                											<input class="form-check-input" type="checkbox" name="device_authorize[]" id="DeviceAuth_<?php echo $dvc_id ?>" value="<?php echo $dvc_id ?>">
                                                                        </div>
        															</td>
                                                                	<td><label class="form-check-label" for="DeviceAuth_<?php echo $dvc_id ?>"><?php echo $dvc_data['name'] ?></label></td>
        															<td><?php echo $dvc_data['f_id'] ?></td>
        															<td><?php echo $dvc_data['type'] ?></td>
        															<td><?php echo $dvc_data['t_id'] ?></td>
                                                                </tr>
                                                                <?php endforeach; ?>
                        									</tbody>
                        								</table>
                        							</div>


    										</div>
    									</div>

                                        <div class="d-inline-block col-4">ユーザーが操作可能とするデバイスを選択してください。（複数選択可）</div>
									</div>

                                    <hr />

                                    <div class="tcenter">
                                    	<button type="submit" class="btn btn-primary">登録</button>
                                    	<a href="<?=$page ?>" class="btn btn-default btn-outline-dark">キャンセル</a>
                                    </div>

                                </form>
                            </div>
						</section>


						<?php elseif($isCSVRegist): ?>


						<section id="CSVRegistUser" class="page-contents">
							<div><h3>CSV一括登録フォーム</h3></div>
                            <div class="card-wrapper">

								<div class="form-group">

    								<form id="CSVRegistConfirmForm" action="<?=$page ?>?c=csv_regist" method="POST" enctype="multipart/form-data" class="clearfix">
    									<input type="hidden" name="one_time_token" value="<?=$onetime_token?>" />

        									<div class="">
        										<div class="clearfix">CSVアップロード <i class="fa fa-file" aria-hidden="true"></i>
        											<div class="row mlr0">

            											<label class="col-7 plr0 d-block mt10" for="InputFile">
            												<input type="file" name="user_list" id="InputCSVUser"/>
            											</label>
            											<div class="col-5">
                    										<button id="csvUploadConfBtn" class="btn btn-primary" type="button">
                    											CSV内容を確認する
                    										</button>
            											</div>

        											</div>
        										</div>

        										<small class="">※一括登録できる最大データ件数は100件です</small>
        									</div>


                                    	<hr />

                                		<div id="CSVConfirmTableWrap" class="d-none">
                                		</div>

                                		<div id="CSVConfirmFailedMsg" class="d-none">
                                			<div class="alert alert-danger" role="alert"></div>
                                		</div>

    									<div class="tcenter">
    										<button id="csvUploadSubmitBtn" class="btn btn-primary" type="submit" disabled>
    											CSVを登録する
    										</button>
    										<a href="<?=$page ?>" class="btn btn-default btn-outline-dark">キャンセル</a>
    									</div>
    								</form>
								</div>

                            </div>
						</section>

						<?php else: ?>

						<section id="UserManage" class="page-contents">
							<div><h3>ユーザー一覧リスト</h3></div>
							<div class="card-wrapper">
								<div class="adduser-wrapper">
									<a href="<?=$page ?>?c=n" class="btn btn-primary btn-sm">新規ユーザー登録</a>
									<a href="<?=$page ?>?c=csv" class="btn btn-info btn-sm">CSV一括登録</a>
									<form class="d-inline" action="parts/csv_output.php" method="POST">
										<input type="hidden" name="file_name" value="ユーザーリスト"/>
										<input type="hidden" name="tbl_name" value="UserTbl"/>
										<button type="submit" class="btn btn-success btn-sm">ユーザー一覧CSV出力</button>
									</form>
								</div>
    							<div class="table-wrapper">
    								<table id="UserListTable" class="table">
    									<thead class="thead-dark">
        									<tr>
        										<th class="th_num" scope="col">#</th>
        										<th class="th_userid" scope="col">ユーザーID</th>
        										<th class="th_username" scope="col">ユーザー名</th>
        										<th class="th_tenentid" scope="col">登録テナント</th>
        										<th class="th_uuid" scope="col">UUID</th>
        										<th class="th_deviceauth" scope="col">操作可能デバイス</th>
        										<th class="th_status" scope="col">ステータス</th>
        										<th class="th_control" scope="col">操作</th>
        									</tr>
    									</thead>
    									<tbody>
    									<?php foreach($UserList as $ulK => $ulV):
    									switch($ulV['status']){
    									    case ACCOUNT_STATUS_LOCK:
    									        $status = "ロック";
    									        break;
    									    case ACCOUNT_STATUS_OK:
    									        $status = "通常";
    									        break;
    									}
    									?>
                                            <tr>
                                            	<td><?=h($ulV['num']) ?></td>
                                            	<td><?=h($ulV['user_id']) ?></td>
                                            	<td><?=h($ulV['name']) ?></td>
                                            	<td><?=$TenantNameList[$ulV['tenant_id']] ?></td>
                                            	<td><?=h($ulV['uuid']) ?></td>
                                            	<td>
                                                	<div style="overflow-y: scroll; max-height: 300px; height: auto;">
                                                	<?
                                                	if($ulV['device_authorize'] != ""){
                                                	    $de_auth = explode(",", $ulV['device_authorize']);
                                                	    foreach($de_auth as $daK => $daV){
                                                	        if($daK != 0) echo ",";
                                                	        echo $DeviceList[$daV]['name'];
                                                	    }
                                                	}
                                                	?>
                                                	</div>
                                            	</td>
                                            	<td><?=$status ?></td>
                                            	<td>
                                            		<a href="user.php?c=e&id=<?=h($ulV['num']) ?>" class="btn btn-sm btn-primary">編集</a>
                                            		<button class="btn btn-sm btn-danger" data-toggle="modal" data-target="#modal-userdelete" data-whatever="<?=$ulV['user_id']?>" data-delnum="<?=$ulV['num']?>">削除</button>
                                            	</td>
                                            </tr>
                                        <?php endforeach;?>
    									</tbody>
    								</table>
    							</div>
							</div>

						</section>

						<?php endif; ?>
                    </div>
        		</main>
            </div>
		<? //include(PARTS_PATH.'footer.php'); ?>
        </div>
	</body>
    <!-- /container -->


    <!-- モーダル ユーザー情報削除 -->
    <div class="modal fade" id="modal-userdelete" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-label">ユーザー情報削除</h4>
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>このユーザー情報を削除しますか？</p>
                    <form id="user_delete" action="<?=$page?>?c=d" method="post">
                        <input type="hidden" name="one_time_token" value="<?=$onetime_token?>"/>

                        <div class="form-group">
                            <label for="DeleteUserID" class="form-control-label">ユーザーID:</label>
                            <input type="text" class="form-control" id="DeleteUserID" name="user_id" readonly="readonly" required>
                            <input type="hidden" id="DeleteUserNum" name="num">
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-danger">削除する</button>
                            <button type="cancel" class="btn btn-default btn-outline-dark" data-dismiss="modal">中止</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <script src="<?=ASSET_JS ?>user.js"></script>

</html>