<?php
/**
 * スーパーアプリ管理者サイト向けユーティリティ
 */
require_once __DIR__ . '/../../vendor/autoload.php';
require_once __DIR__ . '/../../config/config.php';

use Monolog\Logger;
use Monolog\Handler\StreamHandler;
use Monolog\Processor\ProcessIdProcessor;
use Monolog\Processor\UidProcessor;
use Monolog\Processor\WebProcessor;

// Loggerに関する設定
$_ENV['LOG_LEVEL'] = Logger::INFO;
if (in_array($_ENV['LOG_LEVEL'], array('debug', 'Debug', 'DEBUG'))) {
    $_ENV['LOG_LEVEL'] = Logger::DEBUG;
}
if (in_array($_ENV['LOG_LEVEL'], array('info', 'Info', 'INFO'))) {
    $_ENV['LOG_LEVEL'] = Logger::INFO;
}
if (in_array($_ENV['LOG_LEVEL'], array('notice', 'Notice', 'NOTICE'))) {
    $_ENV['LOG_LEVEL'] = Logger::NOTICE;
}
if (in_array($_ENV['LOG_LEVEL'], array('warning', 'Warning', 'WARNING'))) {
    $_ENV['LOG_LEVEL'] = Logger::WARNING;
}
if (in_array($_ENV['LOG_LEVEL'], array('error', 'Error', 'ERROR'))) {
    $_ENV['LOG_LEVEL'] = Logger::ERROR;
}
if (in_array($_ENV['LOG_LEVEL'], array('critical', 'Critical', 'CRITICAL'))) {
    $_ENV['LOG_LEVEL'] = Logger::CRITICAL;
}
if (in_array($_ENV['LOG_LEVEL'], array('alert', 'Alert', 'ALERT'))) {
    $_ENV['LOG_LEVEL'] = Logger::ALERT;
}
if (in_array($_ENV['LOG_LEVEL'], array('emergency', 'Emergency', 'EMERGENCY'))) {
    $_ENV['LOG_LEVEL'] = Logger::EMERGENCY;
}

date_default_timezone_set($_ENV["LOG_TIMEZONE"]);
if (!isset($log)) {
    $log = new Logger('Admin');
    $log->pushHandler(new StreamHandler($_ENV['LOG_DIR'] . "/admin.log", $_ENV['LOG_LEVEL']));
    $log->pushProcessor(new ProcessIdProcessor());
    $log->pushProcessor(new UidProcessor());
    $log->pushProcessor(new WebProcessor());
}
?>
