<?
/**
 * ウィジェット管理画面
 */
require("core/construct.php");

require(CORE_PATH."basic.php");
require(CORE_PATH."functions.php");
require(CORE_PATH."session_check.php");
require(CORE_PATH."authorize.php");

require_once(AD_MDL_PATH."model.php");
$adMDL = new admModel($sdb, $link);

require_once(SN_MDL_PATH."model.php");
$sgMDL = new sngModel($sdb, $link);

require_once(SP_MDL_PATH."model.php");
$sapMDL = new sappModel($sdb, $link);

require_once(__DIR__."/util/utils.php");

// ウィジェットリスト
$WidgetList = [];
//ウィジェットタイプ判定
$w_row = $sapMDL->GetWidgetList();
foreach($w_row as $waK => $waV){
    if(in_array($waV['widget_type'],[WIDGET_TYPE_LINK_1, WIDGET_TYPE_LINK_2, WIDGET_TYPE_LINK_3, WIDGET_TYPE_LINK_4])) continue;
    $WidgetList[] = $waV;
}

$page = "widget.php";

$GET = filterGet();
$POST = filterPost();

$isEdit = False;
$isRegist = False;

$login_user = $_SESSION['admin']['admin_id'];

try{


    if(isset($GET['m']))
    {
        $mes = GetMsgDecode($GET['m']);
    }

    if(isset($_GET['c']))
    {
        $t = new Datetime();

        switch($_GET['c'])
        {
            case 'n':

                $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'ウィジェット情報登録フォーム'));
                $isRegist = True;
                break;

            case 'regist':

                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }

                if(trim($POST['widget_id']) === "") throw new Exception("ウィジェットIDを入力してください。");
                if(preg_match('/^[0-9a-zA-Z\-_]{1,256}$/', $POST['widget_id']) == 0) throw new Exception("ウィジェットIDは32文字以内の半角英数字で入力してください。");

                if(trim($POST['widget_name']) === "") throw new Exception("ウィジェット名を入力してください。");
                if(mb_strlen($POST['widget_name']) > 256) throw new Exception("ウィジェット名は256文字以内です。");

                if(trim($POST['widget_info']) === "") throw new Exception("ウィジェット説明を入力してください。");
                if(mb_strlen($POST['widget_info']) > 512) throw new Exception("ウィジェット説明は512文字以内です。");

                $is_subwidget = (isset($POST['sub_widget']))?1:0;

                $prm = [
                    'widget_id' => $POST['widget_id'],
                    'widget_name' => $POST['widget_name'],
                    'widget_type' => '',
                    'widget_info' => $POST['widget_info'],
                    'sub_widget' => $is_subwidget,
                    'registrated_time' => $t->format("Y-m-d H:i:s"),
                ];

                $ins_ret = $adMDL->InsertWidgetData($prm);
                if(!$ins_ret) throw new Exception("ウィジェット情報の登録が失敗しました。");

                $log->info("Successful widget registration.",array('file' => __FILE__, 'userId' => $login_user, 'data' => $prm));
                $mes = GetMsgEncode("ウィジェット情報を登録しました。");
                header( 'Location: ' . $page.'?m='.$mes);
                exit;

                break;

            case 'e':
                if(!isset($GET['id'])) throw new Exception("ウィジェットIDが指定されていません。");

                $edit_id = $GET['id'];

                $WidgetInfo = $sapMDL->GetWidgetDataForID($edit_id);
                if(!$WidgetInfo) throw new Exception("指定されたウィジェットは存在しません。");

                $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'ウィジェット情報編集フォーム', 'editId' => $edit_id));
                $isEdit = True;
                break;

            case 'edit':

                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }

                if(!isset($GET['id'])) throw new Exception("ウィジェットIDが指定されていません。");

                $edit_id = $GET['id'];

                $WidgetInfo = $sapMDL->GetWidgetDataForID($edit_id);
                if(!$WidgetInfo) throw new Exception("指定されたウィジェットは存在しません。");

                if(trim($POST['widget_name']) === "") throw new Exception("ウィジェット名を入力してください。");
                if(mb_strlen($POST['widget_name']) > 256) throw new Exception("ウィジェット名は256文字以内です。");

                if(trim($POST['widget_info']) === "") throw new Exception("ウィジェット説明を入力してください。");
                if(mb_strlen($POST['widget_info']) > 512) throw new Exception("ウィジェット説明は512文字以内です。");

                $is_subwidget = (isset($POST['sub_widget']))?1:0;

                $prm = [
                    'widget_id' => $edit_id,
                    'widget_name' => $POST['widget_name'],
                    'widget_info' => $POST['widget_info'],
                    'sub_widget' => $is_subwidget,
                    'registrated_time' => $t->format("Y-m-d H:i:s"),
                ];

                $up_ret = $adMDL->UpdateWidgetData($prm);
                if(!$up_ret) throw new Exception("ウィジェット情報の更新が失敗しました。");

                $log->info("Successful widget update.",array('file' => __FILE__, 'userId' => $login_user, 'data' => $prm));
                $mes = GetMsgEncode("ウィジェット情報を更新しました。");
                header( 'Location: ' . $page.'?m='.$mes);
                exit;

                break;

            case 'd':
                //ワンタイムトークンチェック
                if(isset($POST['one_time_token'])){
                    if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
                }

                if(!isset($POST['widget_id'])) throw new Exception("ウィジェットIDが指定されていません。");

                $delete_id = $POST['widget_id'];

                $del_ret = $adMDL->DeleteWidgetData($delete_id);
                if(!$del_ret) throw new Exception("ウィジェット情報の削除に失敗しました。");

                $log->info("Successful widget delete.",array('file' => __FILE__, 'userId' => $login_user, 'deleteId' => $delete_id));
                $mes = GetMsgEncode("ウィジェット情報を削除しました。");
                header( 'Location: ' . $page.'?m='.$mes);
                exit;

                break;
        }
    } else {
        $log->info("Initial display.",array('file' => __FILE__, 'userId' => $login_user, 'display' => 'ウィジェット一覧リスト'));
    }
}catch(Exception $e){
    $mes = GetMsgEncode($e->getMessage());
    // 確認
    $log->info($e);
    $log->info("Failed to widget operation.", array('file' => __FILE__, 'userId' => $login_user, 'message' => $e->getMessage()));
    header( 'Location: ' . $page.'?m='.$mes.'&err');
    exit;
}

// var_dump($DeviceList);

$msg_stt = (isset($GET['err']))? "danger" : "success";
$message_tag = ($mes != '')?'<div class="alert alert-'.$msg_stt.'" role="alert">'.$mes.'</div>':'';

$required_tag = '<span class="badge badge-danger">必須</span>';
$page_title = "管理画面　ウィジェット情報管理";

$onetime_token = createToken();

include(PARTS_PATH."header.php");


?>
    <body>
        <div id="Wrap">

        <? include(PARTS_PATH.'header-nav.php'); ?>
        	<div class="wrapper">

        		<? include(PARTS_PATH.'sidemenu.php'); ?>
        		<main class="">

            	    <div class="container grid">

						<nav class="page-header">
							<div class="container-fluid">
								<div class="navbar-wrapper">
									<h2><span class="svg-wrap mr10"><svg class="img-fluid"><use xlink:href="./asset/img/setting.svg#Setting"></use></svg></span>ウィジェット情報管理</h2>
								</div>
							</div>
						</nav>

						<?=$message_tag ?>


						<?php if($isEdit): ?>

						<section id="EditWidget" class="page-contents">
							<div><h3>ウィジェット情報編集フォーム</h3></div>
                            <div class="card-wrapper">
                                <form action="<?=$page ?>?c=edit&id=<?=h($edit_id) ?>" method="POST">
									<input type="hidden" name="one_time_token" value="<?=$onetime_token?>"/>
    								<div class="form-group row">
    									<div class="col-3">ウィジェットID</div>
    									<div class="col-5"><?=h($WidgetInfo['widget_id']) ?></div>
                                        <div class="d-inline-block col-4"></div>
                                    </div>

                                    <hr />

    								<div class="form-group row">
    									<div class="col-3">ウィジェット名 <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="widget_name" id="Name" placeholder="ウィジェットの名前" value="<?=h($WidgetInfo['widget_name']) ?>" required/>
                                        <div class="d-inline-block col-4">ウィジェット名を入力してください。</div>
                                    </div>

                                    <hr />

    								<div class="form-group row">
    									<div class="col-3">ウィジェット情報 <?=$required_tag ?></div>
    									<textarea id="WidgetInfo" name="widget_info" id="" cols="30" rows="6" class="form-control col-5" placeholder="ウィジェットの情報" required><?=h($WidgetInfo['widget_info']) ?></textarea>
                                        <div class="d-inline-block col-4">ウィジェット情報を入力してください。</div>
                                    </div>

                                    <hr />

                                    <div class="form-group row">
    									<div class="col-3">サブウィジェット判定</div>

    									<div class="col-5">
<?
$d_checked = ($WidgetInfo['sub_widget'] == '1')?"checked":"";
?>
    										<div class="form-check form-check-inline">
    											<input class="form-check-input" type="checkbox" name="sub_widget" id="SubWidget" value="" <?=$d_checked ?>>
    											<label class="form-check-label" for="SubWidget">有効にする</label>
                                            </div>
    									</div>

                                        <div class="d-inline-block col-4">サブウィジェットである場合はチェックボックスを有効にしてください。</div>
                                    </div>

                                    <hr />

                                    <div class="tcenter">
                                    	<button type="submit" class="btn btn-primary">更新</button>
                                    	<a href="<?=$page ?>" class="btn btn-default btn-outline-dark">キャンセル</a>
                                    </div>

                                </form>
                            </div>
						</section>


						<?php elseif($isRegist): ?>


						<section id="RegistUser" class="page-contents">
							<div><h3>ウィジェット情報登録フォーム</h3></div>
                            <div class="card-wrapper">
                                <form action="<?=$page ?>?c=regist" method="POST">
									<input type="hidden" name="one_time_token" value="<?=$onetime_token?>"/>

    								<div class="form-group row">
    									<div class="col-3">ウィジェットID <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="widget_id" id="WidgetID" placeholder="ウィジェットID" value="" required/>
                                        <div class="d-inline-block col-4">ウィジェットIDを入力してください。</div>
                                    </div>

                                    <hr />
    								<div class="form-group row">
    									<div class="col-3">ウィジェット名 <?=$required_tag ?></div>
                                        <input class="form-control col-5" type="text" name="widget_name" id="Name" placeholder="ウィジェットの名前" value="" required/>
                                        <div class="d-inline-block col-4">ウィジェット名を入力してください。</div>
                                    </div>

                                    <hr />

    								<div class="form-group row">
    									<div class="col-3">ウィジェット情報 <?=$required_tag ?></div>
    									<textarea id="WidgetInfo" name="widget_info" id="" cols="30" rows="6" class="form-control col-5" placeholder="ウィジェットの情報" required></textarea>
                                        <div class="d-inline-block col-4">ウィジェット情報を入力してください。</div>
                                    </div>

                                    <hr />

    								<div class="form-group row">
    									<div class="col-3">サブウィジェット判定</div>

    									<div class="col-5">
											<div class="form-check form-check-inline">
    											<input class="form-check-input" type="checkbox" name="sub_widget" id="SubWidget" value="" >
    											<label class="form-check-label" for="SubWidget">有効にする</label>
                                            </div>
    									</div>

                                        <div class="d-inline-block col-4">サブウィジェットである場合はチェックボックスを有効にしてください。</div>
                                    </div>

                                    <hr />

                                    <div class="tcenter">
                                    	<button type="submit" class="btn btn-primary">登録</button>
                                    	<a href="<?=$page ?>" class="btn btn-default btn-outline-dark">キャンセル</a>
                                    </div>

                                </form>
                            </div>
						</section>

						<?php else: ?>

						<section id="WidgetManage" class="page-contents">
							<div><h3>ウィジェット一覧リスト</h3></div>
							<div class="card-wrapper">
								<div class="adduser-wrapper　">
									<a href="<?=$page ?>?c=n" class="btn btn-primary btn-sm">ウィジェット情報登録</a>
								</div>
    							<div class="table-wrapper">
    								<table id="WidgetListTable" class="table" style="width:100%;">
    									<thead class="thead-dark">
        									<tr>
        										<th class="th_num" scope="col">#</th>
        										<th class="th_widgetid" scope="col">ウィジェットID</th>
        										<th class="th_widgetname" scope="col">ウィジェット名</th>
        										<th class="th_registtime" scope="col">登録日時</th>
        										<th class="th_subwidget" scope="col">サブウィジェット</th>
        										<th class="th_control" scope="col">操作</th>
        									</tr>
    									</thead>
    									<tbody>
    									<?php foreach($WidgetList as $wlK => $wlV):

    									$is_sub = ($wlV['sub_widget'] == '1')?"サブウィジェット":"";

    									?>
                                            <tr>
                                            	<td><?=h($wlV['num']) ?></td>
                                            	<td><?=h($wlV['widget_id']) ?></td>
                                            	<td><?=h($wlV['widget_name']) ?></td>
                                            	<td><?=h($wlV['registrated_time']) ?></td>
                                            	<td><?=h($is_sub) ?></td>
                                            	<td>
                                            		<a href="<?=$page ?>?c=e&id=<?=h($wlV['widget_id']) ?>" class="btn btn-sm btn-primary">編集</a>
                                            		<button class="btn btn-sm btn-danger" data-toggle="modal" data-target="#modal-widgetdelete" data-whatever="<?=$wlV['widget_id']?>">削除</button>
                                            	</td>
                                            </tr>
                                        <?php endforeach;?>
    									</tbody>
    								</table>
    							</div>
							</div>

						</section>

						<?php endif; ?>
                    </div>
        		</main>
            </div>
		<? //include(PARTS_PATH.'footer.php'); ?>
        </div>
	</body>
    <!-- /container -->


    <!-- モーダル　ウィジェット情報削除 -->
    <div class="modal fade" id="modal-widgetdelete" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-label">ウィジェット情報削除</h4>
                    <button type="button" class="close" data-dismiss="modal">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <p>このウィジェット情報を削除しますか？</p>
                    <form id="user_delete" action="<?=$page?>?c=d" method="post">
                        <input type="hidden" name="one_time_token" value="<?=$onetime_token ?>"/>
                        <div class="form-group">
                            <label for="recipient-name" class="form-control-label">ウィジェットID:</label>
                            <input type="text" class="form-control" id="DeleteWidgetID" name="widget_id" readonly="readonly" required>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-danger">削除する</button>
                            <button type="cancel" class="btn btn-default btn-outline-dark" data-dismiss="modal">中止</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <script>
        $(function(){

            $('#modal-widgetdelete').on('show.bs.modal', function(event) {
                var recipient = $(event.relatedTarget).data('whatever');
                $(this).find('.modal-body #DeleteWidgetID').val(recipient);
            });


            // datatableの設定を変更
            $("#WidgetListTable").DataTable({
            	searching: false,
            	info: false,
            	lengthChange: false,
            	columnDefs: [
            		  { "targets": 0, "width": '5%'},
            		  { "targets": 1, "width": '23%'},
            		  { "targets": 2, "width": '23%'},
            		  { "targets": 3, "width": '20%'},
            		  { "targets": 4, "width": '14%'},
            		  { "targets": 5, "width": '15%',"orderable": false},
            		],
            });
        });
    </script>

</html>