<?

require_once(__DIR__ . '/../admin/core/construct.php');
require_once(__DIR__ . '/../admin/model/database.php');
require_once( __DIR__ . '/../admin/model/model.php');
require_once(__DIR__ . '/../super_appli/util/utils.php');

//定数
define('API_ERRORCODE_UNSET_TENANTID', 10000);
define('API_ERRORCODE_CONNECT_FAILED', 10001);
define('API_ERRORCODE_NOCONNECT', 10002);

define('API_ERRORCODE_FAILED_APISETTING', 10003);
define('API_ERRORCODE_FAILED_NORESOURCE', 10004);

define('AD_MDL_PATH', ADMIN_ROOT.'model'.DS);



class Api{

    private $Token;
    private $TokenExpire;
    private $AccessPost;
    private $ErrCode;
    private $Domein;

    public function __construct($tid){
        $this->ErrCode = [
            400 => 'パラメータエラー',
            401 => '認証エラー',
            403 => '権限エラー',
            404 => 'URL不正',
            500 => '予期しないエラー',
            503 => 'デバイス応答なし',
        ];
        try{
            if(is_null($tid)) throw new Exception("Tenant ID is not set.", API_ERRORCODE_UNSET_TENANTID);
            $this->SetAPIAccessPost($tid);
            $this->GetAPIToken();
        }catch(Exception $e){
            throw new Exception($e->getMessage(), $e->getCode());
        }
    }

    public function SetAPIAccessPost($tid){
        try{
            require AD_MDL_PATH.'database.php';
            $admMDL = new admModel($sdb, $link);
            $accesspost = $admMDL->GetAPISettingData($tid);
            if(!$accesspost) throw new Exception("Failed to read API setting information.", API_ERRORCODE_FAILED_APISETTING);
            $this->AccessPost = [
                "grant_type"=> $accesspost['key_grant_type'],
                "username"=> $accesspost['username'],
                "password"=> $accesspost['key_password'],
                "client_id"=> $accesspost['key_clientid'],
                "client_secret"=> $accesspost['secret_key'],
            ];
            $this->Domein = $accesspost['domein'];
        }catch(Exception $e){
            throw new Exception($e->getMessage(), $e->getCode());
        }
    }

    /**
     * 認証用アクセストークン作成
     */
    public function GetAPIToken() {
        global $log;
        try {
            $ch= curl_init();
            $q = http_build_query($this->AccessPost);
            curl_setopt_array($ch, [
                CURLOPT_URL => 'https://'.$this->Domein.'/api/public/generate-token',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_SSL_VERIFYHOST => 0,
                CURLOPT_PROXY_SSL_VERIFYPEER => false,
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => $q,
                CURLOPT_HTTPHEADER => [
                    "Content-Type: application/x-www-form-urlencoded",
                ],
            ]);

            $log->info('Starting get API token.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'request_method' => 'POST', 'request_url' => 'https://'.$this->Domein.'/api/public/generate-token', '$url_encode' => $this->AccessPost));
            $res = curl_exec($ch);
            $raw = json_decode($res);
            $err = curl_error($ch);
            $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            if (!empty($err)) throw new Exception("cURL Error #:" . $err, API_ERRORCODE_CONNECT_FAILED);

            curl_close($ch);

            $errmsg = "";
            if($status != 200){
                $errmsg = $this->ErrCode[$status];
                throw new Exception("cURL Error #:".$errmsg, API_ERRORCODE_NOCONNECT);
            }
            if(isset($raw->error)) {
                throw new Exception("API Error #:" . $raw->error_description, API_ERRORCODE_CONNECT_FAILED);
            }
            $t = new Datetime();
            $raw = json_decode($res);
            $log->info('Successful get API token.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'request_method' => 'POST', 'request_url' => 'https://'.$this->Domein.'/api/public/generate-token', 'response' => $raw));
            $this->Token = $raw->access_token;
            $this->TokenExpire = $t->modify("+ ".$raw->expires_in."second")->getTimestamp();
        } catch (Exception $e) {
            $log->error($e);
            $log->error('Failed to get API token', array('file' => ''.$e->getFile().' on line '.$e->getLine().''));
            throw new Exception("【".$e->getCode()."】".$e->getMessage());
        }
    }

    /**
     * テナント名取得
     */
    public function GetTenantName() {
        global $log;
        try {
            $ch= curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => 'https://'.$this->Domein.'/api/public/v1/general/sitenames',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_SSL_VERIFYHOST => 0,
                CURLOPT_PROXY_SSL_VERIFYPEER => false,
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => [
                    "Authorization: Bearer ".$this->Token,
                ],
            ]);

            $log->info('Starting get tenant name.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'request_method' => 'GET', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/general/sitenames'));
            $response = curl_exec($ch);
            $raw = json_decode($response);
            $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $err = curl_error($ch);
            curl_close($ch);

            if(isset($raw->error)) throw new Exception("cURL Error #:".$raw->error_description, API_ERRORCODE_FAILED_APISETTING);
            if (!empty($err)) throw new Exception("cURL Error #:" . $err, API_ERRORCODE_CONNECT_FAILED);

            $errmsg = "";
            if($status != 200){
                $errmsg = $this->ErrCode[$status];
                throw new Exception("cURL Error #:".$errmsg, API_ERRORCODE_NOCONNECT);
            }
            $log->info('Successful get tenant name.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'request_method' => 'GET', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/general/sitenames', 'response' => $raw));
            return json_decode($response);
        } catch (Exception $e) {
            $log->error($e);
            $log->error('Failed to get tenant name', array('file' => ''.$e->getFile().' on line '.$e->getLine().''));
            throw new Exception("【".$e->getCode()."】".$e->getMessage());
        }
    }

    /**
     * デバイス名（タイプ）の確認方法
     */
    public function GetDeviceType($sitename) {
        global $log;
        try {
            if(empty($sitename)) throw new Exception("Not Set Sitename.");

            $ch= curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename.'/devicetypes',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_SSL_VERIFYHOST => 0,
                CURLOPT_PROXY_SSL_VERIFYPEER => false,
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => [
                    "Authorization: Bearer ".$this->Token,
                ],
            ]);

            $log->info('Starting get device type.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'request_method' => 'GET', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename.'/devicetypes'));
            $response = curl_exec($ch);
            $raw = json_decode($response);
            $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $err = curl_error($ch);
            curl_close($ch);

            if(isset($raw->error)) throw new Exception("cURL Error #:".$raw->error, API_ERRORCODE_FAILED_APISETTING);
            if (!empty($err)) throw new Exception("cURL Error #:" . $err, API_ERRORCODE_CONNECT_FAILED);

            $errmsg = "";
            if($status != 200){
                $errmsg = $this->ErrCode[$status];
                throw new Exception("cURL Error #:".$errmsg, API_ERRORCODE_NOCONNECT);
            }
            $log->info('Successful get device type.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'request_method' => 'GET', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename.'/devicetypes', 'response' => $raw));
            return json_decode($response);
        } catch (Exception $e) {
            $log->error($e);
            $log->error('Failed to get device type', array('file' => ''.$e->getFile().' on line '.$e->getLine().''));
            throw new Exception("【".$e->getCode()."】".$e->getMessage());
        }
    }

    /**
     * デバイスリストを取得
     */
    public function GetDeviceList($sitename, $devicename) {
        global $log;
        try {
            if(empty($sitename) || empty($devicename)) throw new Exception("Not Set Parameter.");
            $devicename = $this->CheckDevicename($devicename);

            $ch= curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename."/".$devicename."/devices",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_SSL_VERIFYHOST => 0,
                CURLOPT_PROXY_SSL_VERIFYPEER => false,
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 60,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => [
                    "Authorization: Bearer ".$this->Token,
                ],
            ]);

            $log->info('Starting get device list.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'device_type' => $devicename, 'request_method' => 'GET', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename.'/'.$devicename.'/devices'));
            $response = curl_exec($ch);
            $raw = json_decode($response);
            $err = curl_error($ch);
            $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            if(isset($raw->error)) throw new Exception("cURL Error #:".$raw->error_description, API_ERRORCODE_FAILED_APISETTING);
            if (!empty($err)) throw new Exception("cURL Error #:" . $err, API_ERRORCODE_CONNECT_FAILED);

            $errmsg = "";
            if($status != 200){
                $errmsg = $this->ErrCode[$status];
                throw new Exception("cURL Error #:".$errmsg, API_ERRORCODE_NOCONNECT);
            }
            $log->info('Successful get device list.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'device_type' => $devicename, 'request_method' => 'GET', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename.'/'.$devicename.'/devices', 'response' => $raw));
            return json_decode($response);
        } catch (Exception $e) {
            $log->error($e);
            $log->error('Failed to get device list', array('file' => ''.$e->getFile().' on line '.$e->getLine().''));
            throw new Exception("【".$e->getCode()."】".$e->getMessage());
        }
    }

    /**
     * デバイスの対応機能を取得
     */
    public function GetDeviceFunc($sitename, $devicename, $id) {
        global $log;
        try {
            if(empty($sitename) || empty($devicename) || empty($id)) throw new Exception("Not Set Parameter.");
            $devicename = $this->CheckDevicename($devicename);

            $ch= curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename."/".$devicename."/devices/".$id."/functions",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_SSL_VERIFYHOST => 0,
                CURLOPT_PROXY_SSL_VERIFYPEER => false,
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => [
                    "Authorization: Bearer ".$this->Token,
                ],
            ]);

            $log->info('Starting get device function.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'device_type' => $devicename, 'device_id' => $id, 'request_method' => 'GET', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename.'/'.$devicename.'/devices/'.$id.'/functions'));
            $response = curl_exec($ch);
            $raw = json_decode($response);
            $err = curl_error($ch);
            $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);
            if(isset($raw->error)) throw new Exception("cURL Error #:".$raw->error_description, API_ERRORCODE_FAILED_APISETTING);
            if (!empty($err)) throw new Exception("cURL Error #:" . $err, API_ERRORCODE_CONNECT_FAILED);

            $errmsg = "";
            if($status != 200){
                $errmsg = $this->ErrCode[$status];
                throw new Exception("cURL Error #:".$errmsg, API_ERRORCODE_NOCONNECT);
            }
            $log->info('Successful get device function.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'device_type' => $devicename, 'device_id' => $id, 'request_method' => 'GET', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename.'/'.$devicename.'/devices/'.$id.'/functions', 'response' => $raw));
            return json_decode($response);
        } catch (Exception $e) {
            $log->error($e);
            $log->error('Failed to get device function', array('file' => ''.$e->getFile().' on line '.$e->getLine().''));
            throw new Exception("【".$e->getCode()."】".$e->getMessage());
        }
    }

    /**
     * GetDeviceStatus
     * 特定デバイスの情報を取得
     */
    public function GetDeviceStatus($sitename, $devicename, $id) {
        global $log;
        try {
            if(empty($sitename) || empty($devicename) || empty($id)) throw new Exception("Not Set Parameter.");
            $devicename = $this->CheckDevicename($devicename);
            $ch= curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename."/".$devicename."/devices/".$id."/status",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_SSL_VERIFYHOST => 0,
                CURLOPT_PROXY_SSL_VERIFYPEER => false,
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => [
                    "Authorization: Bearer ".$this->Token,
                ],
            ]);

            $log->info('Starting get device status.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'device_type' => $devicename, 'device_id' => $id, 'request_method' => 'GET', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename."/".$devicename."/devices/".$id."/status"));
            $response = curl_exec($ch);
            $raw = json_decode($response);
            $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);

            $err = curl_error($ch);
            curl_close($ch);

            if(isset($raw->error)){
                $desc = (isset($raw->error_description))?$raw->error_description:"";
                $errmsg = $raw->error.$desc;
                throw new Exception("cURL Error #:".$errmsg, API_ERRORCODE_FAILED_APISETTING);
            }
            if (!empty($err)) throw new Exception("cURL Error #:" . $err, API_ERRORCODE_CONNECT_FAILED);
            $errmsg = "";
            $log->info('Successful get device status.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'device_type' => $devicename, 'device_id' => $id, 'request_method' => 'GET', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename."/".$devicename."/devices/".$id."/status", 'response' => $raw));
            return json_decode($response);
        } catch (Exception $e) {
            $log->error($e);
            $log->error('Failed to get device status', array('file' => ''.$e->getFile().' on line '.$e->getLine().''));
            throw new Exception("【".$e->getCode()."】".$e->getMessage());
        }
    }

    /**
     * GetManyDeviceStatus
     * 複数デバイスの情報を取得
     */
    public function GetManyDeviceStatus($sitename, $devicename, $idlist) {
        global $log;
        try {

            if(empty($sitename) || empty($devicename) || empty($idlist)) throw new Exception("Not Set Parameter.");
            $devicename = $this->CheckDevicename($devicename);

            $reqdata = $this->SetRequestManyDeviceData($idlist);
            if(!$reqdata) throw new Exception("Failed Parameter.");

            $ch= curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename."/".$devicename."/devices/list/status",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_SSL_VERIFYHOST => 0,
                CURLOPT_PROXY_SSL_VERIFYPEER => false,
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_POSTFIELDS => $reqdata,
                CURLOPT_HTTPHEADER => [
                    "Authorization: Bearer ".$this->Token,
                ],
            ]);

            $log->info('Starting get many device function.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'device_type' => $devicename, 'device_id' => $idlist, 'request_method' => 'GET', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename."/".$devicename."/devices/list/status"));
            $response = curl_exec($ch);
            $raw = json_decode($response);
            $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $err = curl_error($ch);
            curl_close($ch);
            if(isset($raw->error)){
                $errmsg = $raw->error.$raw->error_description;
                throw new Exception("cURL Error #:".$errmsg, API_ERRORCODE_FAILED_APISETTING);
            }
            if (!empty($err)) throw new Exception("cURL Error #:" . $err, API_ERRORCODE_CONNECT_FAILED);

            $errmsg = "";
            if($status != 200){
                $errmsg = $this->ErrCode[$status];
                throw new Exception("cURL Error #:".$errmsg, API_ERRORCODE_NOCONNECT);
            }
            $log->info('Successful get many device function.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'device_type' => $devicename, 'device_id' => $idlist, 'request_method' => 'GET', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename."/".$devicename."/devices/list/status", 'response' => $raw));
            return json_decode($response);
        } catch (Exception $e) {
            $log->error($e);
            $log->error('Failed to get many device function', array('file' => ''.$e->getFile().' on line '.$e->getLine().''));
            throw new Exception("【".$e->getCode()."】".$e->getMessage());
        }
    }

    /**
     * デバイスの情報を変更
     */
    public function PutDeviceStatus($sitename, $devicename, $id, $prm) {
        global $log;
        try {
            if(empty($sitename) || empty($devicename) || empty($id) || empty($prm)) throw new Exception("Not Set Parameter.");
            $devicename = $this->CheckDevicename($devicename);

            $ch= curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename."/".$devicename."/devices/".$id."/status",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_SSL_VERIFYHOST => 0,
                CURLOPT_PROXY_SSL_VERIFYPEER => false,
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_CUSTOMREQUEST => "PUT",
                CURLOPT_POSTFIELDS => json_encode($prm),
                CURLOPT_HTTPHEADER => [
                    'Content-Type: application/json',
                    'Authorization: Bearer '.$this->Token,
                ],
            ]);

            $log->info('Starting put device status.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'device_type' => $devicename, 'device_id' => $id, 'parameter' => $prm, 'request_method' => 'PUT', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename."/".$devicename."/devices/".$id."/status"));
            $response = curl_exec($ch);
            $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $err = curl_error($ch);
            curl_close($ch);

            if (!empty($err)) throw new Exception("cURL Error #:" . $err, API_ERRORCODE_CONNECT_FAILED);
            $errmsg = "";
            if($status != 200){
                $errmsg = $this->ErrCode[$status];
                throw new Exception("cURL Error #:".$errmsg);
            }
            $log->info('Successful put device status.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'device_type' => $devicename, 'device_id' => $id, 'parameter' => $prm, 'request_method' => 'PUT', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename."/".$devicename."/devices/".$id."/status", 'response' => json_decode($response)));
            return json_decode($response);
        } catch (Exception $e) {
            $log->error($e);
            $log->error('Failed to put device status', array('file' => ''.$e->getFile().' on line '.$e->getLine().''));
            throw new Exception("【".$e->getCode()."】".$e->getMessage());
        }
    }

    /**
     * SetRequestManyDeviceData
     * 複数端末情報要求データの作成
     *
     */
    private function SetRequestManyDeviceData($arr){
        $ret = [];
        if(!is_array($arr)) return false;
        foreach($arr as $K => $V){
            $ret['Data'][] = ['Device.Info.Id' => $V];
        }
        $jsondata = json_encode($ret);
        return $jsondata;
    }

    /**
     * CheckDevicename
     * 第3者API送信用devicetypeチェック
     *
     * devicetypeがスーパーアプリの内部用だった場合に、
     * I/Fで定義されているdevicetypeに変換して返す。
     *
     * @access private
     * @param string $type
     *          デバイスタイプ
     * @return string $devicetype
     *          I/Fで定義されているデバイスタイプ
     */
    private function CheckDevicename($type){
        if($type == DEVICE_TYPE_AIRCON_BULK_FCU) return DEVICE_TYPE_AIRCON_FCU;
        return $type;
    }

    /**
     * GetEntryExitLog
     * 入退室ログ取得
     *
     * システム管理者／テナント管理者の管理サイト　入退室ログから呼ばれる。
     *　DX-CoreオンプレにAPIを発行し戻りjsonを返す。
     *
     * @access public
     * @param
     *      $sitename
     *      $tenant_id
     *      $log_start_date　：　取得対象日付
     * @return string $response
     *          DX-Coreオンプレからの返り値を返す
     */
    public function GetEntryExitLog($sitename, $tenant_id, $log_start_date) {
        global $log;
        try {
            if(empty($sitename) || empty($tenant_id) || empty($log_start_date)) throw new Exception("Not Set Parameter.");
            set_time_limit(0);

            $ch= curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => 'https://'.$this->Domein.'/api/public/v1/information/'.$sitename.'/his_history/'.$tenant_id.'?date='.$log_start_date,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_SSL_VERIFYHOST => 0,
                CURLOPT_PROXY_SSL_VERIFYPEER => false,
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 300,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => [
                    "Authorization: Bearer ".$this->Token,
                ],
            ]);

            $log->info('Starting get entry exit login.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'target date' => $log_start_date, 'request_method' => 'GET', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/information/'.$sitename.'/his_history/'.$tenant_id.'?date='.$log_start_date));
            $response = curl_exec($ch);
            $raw = json_decode($response,false);
            $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $err = curl_error($ch);
            curl_close($ch);

            if(isset($raw->error)){
                $desc = (isset($raw->error_description))?$raw->error_description:"";
                $errmsg = $raw->error.$desc;
                throw new Exception("Error from DX-Core #:".$errmsg, API_ERRORCODE_FAILED_APISETTING);
            }
            if (!empty($err)) throw new Exception("cURL Error #:" . $err, API_ERRORCODE_CONNECT_FAILED);
            $errmsg = "";
            $log->info('Successful get entry exit login.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'target date' => $log_start_date, 'request_method' => 'GET', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/information/'.$sitename.'/his_history/'.$tenant_id.'?date='.$log_start_date, 'response' => $raw));
            return $raw;
        } catch (Exception $e) {
            $log->error($e);
            $log->error('Failed to get entry exit login', array('file' => ''.$e->getFile().' on line '.$e->getLine().''));
            throw new Exception("【".$e->getCode()."】".$e->getMessage());
        }
    }

    /**
     * 指定したUnixtimeよりも後の通知用ナンバープレート情報を取得
     */
    public function GetNotificationNumberPlateListUnixtime($sitename, $unixtime){
        global $log;
        try {
            if(empty($sitename)) throw new Exception("Not Set Parameter.");

            $ch= curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => 'https://'.$this->Domein.'/api/public/v1/notification_number_plate/'.$sitename.'/morethan/?unixtime='.$unixtime.'',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_SSL_VERIFYHOST => 0,
                CURLOPT_PROXY_SSL_VERIFYPEER => false,
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 60,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => [
                    "Authorization: Bearer ".$this->Token,
                ],
            ]);

            $log->info('Starting get notification number plate list information.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'unixtime' => $unixtime, 'request_method' => 'GET', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/notification_number_plate/'.$sitename.'/morethan/?unixtime='.$unixtime.''));
            $response = curl_exec($ch);
            $raw = json_decode($response);
            $err = curl_error($ch);
            $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            if(isset($raw->error)) throw new Exception("cURL Error #:".$raw->error_description, API_ERRORCODE_FAILED_APISETTING);
            if (!empty($err)) throw new Exception("cURL Error #:" . $err, API_ERRORCODE_CONNECT_FAILED);

            $errmsg = "";
            if($status != 200){
                $errmsg = $this->ErrCode[$status];
                throw new Exception("cURL Error #:".$errmsg, API_ERRORCODE_NOCONNECT);
            }
            $log->info('Successful get notification number plate list information.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'unixtime' => $unixtime, 'request_method' => 'GET', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/notification_number_plate/'.$sitename.'/morethan/?unixtime='.$unixtime.'', 'response' => $raw));
            return json_decode($response);
        } catch (Exception $e) {
            $log->error($e);
            $log->error('Failed to get notification number plate list information', array('file' => ''.$e->getFile().' on line '.$e->getLine().''));
            throw new Exception("【".$e->getCode()."】".$e->getMessage());
        }
    }

    /**
     * 車両入館設定一覧を取得
     */
    public function GetNumberPlateList($sitename, $mailaddress){
        global $log;
        try {
            if(empty($sitename)) throw new Exception("Not Set Parameter.");

            $ch= curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => 'https://'.$this->Domein.'/api/public/v1/car_admission/'.$sitename.'/settings/?'.$mailaddress,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_SSL_VERIFYHOST => 0,
                CURLOPT_PROXY_SSL_VERIFYPEER => false,
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 60,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => [
                    "Authorization: Bearer ".$this->Token,
                ],
            ]);

            $log->info('Starting get number plate list.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'mailaddress' => $mailaddress, 'request_method' => 'GET', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/car_admission/'.$sitename.'/settings/?'.$mailaddress));
            $response = curl_exec($ch);
            $raw = json_decode($response);
            $err = curl_error($ch);
            $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            if(isset($raw->error)) throw new Exception("cURL Error #:".$raw->error_description, API_ERRORCODE_FAILED_APISETTING);
            if (!empty($err)) throw new Exception("cURL Error #:" . $err, API_ERRORCODE_CONNECT_FAILED);

            $errmsg = "";
            if($status != 200){
                $errmsg = $this->ErrCode[$status];
                throw new Exception("cURL Error #:".$errmsg, API_ERRORCODE_NOCONNECT);
            }
            $log->info('Successful get number plate list.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'mailaddress' => $mailaddress, 'request_method' => 'GET', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/car_admission/'.$sitename.'/settings/?'.$mailaddress, 'response' => $raw));
            return json_decode($response);
        } catch (Exception $e) {
            $log->error($e);
            $log->error('Failed to get number plate list', array('file' => ''.$e->getFile().' on line '.$e->getLine().''));
            throw new Exception("【".$e->getCode()."】".$e->getMessage());
        }
    }

    /**
     * 車両入館設定を登録
     */
    public function RegistNumberPlateList($sitename, $prm){
        global $log;
        try {
            if(empty($sitename)) throw new Exception("Not Set Parameter.");
            $prm = json_encode($prm);

            $ch= curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => 'https://'.$this->Domein.'/api/public/v1/car_admission/'.$sitename.'/register',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_SSL_VERIFYHOST => 0,
                CURLOPT_PROXY_SSL_VERIFYPEER => false,
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 60,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => $prm,
                CURLOPT_HTTPHEADER => [
                    'Content-Type: application/json',
                    "Authorization: Bearer ".$this->Token,
                ],
            ]);

            $log->info('Start registration of vehicle entry settings.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'parameter' => $prm, 'request_method' => 'POST', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/car_admission/'.$sitename.'/register'));
            $response = curl_exec($ch);
            $raw = json_decode($response);
            $err = curl_error($ch);
            $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            if(isset($raw->error)) throw new Exception("cURL Error #:".$raw->error_description, API_ERRORCODE_FAILED_APISETTING);
            if (!empty($err)) throw new Exception("cURL Error #:" . $err, API_ERRORCODE_CONNECT_FAILED);

            $errmsg = "";
            if($status != 200){
                $errmsg = $this->ErrCode[$status];
                throw new Exception("cURL Error #:".$errmsg, API_ERRORCODE_NOCONNECT);
            }
            $log->info('Successful registration of vehicle entry settings.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'parameter' => $prm, 'request_method' => 'POST', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/car_admission/'.$sitename.'/register', 'response' => $raw));
            return json_decode($response);
        } catch (Exception $e) {
            $log->error($e);
            $log->error('Failed to registration of vehicle entry settings', array('file' => ''.$e->getFile().' on line '.$e->getLine().''));
            throw new Exception("【".$e->getCode()."】".$e->getMessage());
        }
    }

    /**
     * 車両入館設定を1件削除
     */
    public function DeleteNumberPlateList($sitename, $delete_id){
        global $log;
        try {
            if(empty($sitename) || empty($delete_id)) throw new Exception("Not Set Parameter.");
            $delete_id = (String)$delete_id;

            $ch= curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => 'https://'.$this->Domein.'/api/public/v1/car_admission/'.$sitename.'/settings/delete/'.$delete_id,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_SSL_VERIFYHOST => 0,
                CURLOPT_PROXY_SSL_VERIFYPEER => false,
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 60,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_HTTPHEADER => [
                    "Authorization: Bearer ".$this->Token,
                ],
            ]);

            $log->info('Start deleting vehicle entry settings.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'delete_id' => $delete_id, 'request_method' => 'POST', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/car_admission/'.$sitename.'/settings/delete/'.$delete_id));
            $response = curl_exec($ch);
            $raw = json_decode($response);
            $err = curl_error($ch);
            $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            if(isset($raw->error)) throw new Exception("cURL Error #:".$raw->error_description, API_ERRORCODE_FAILED_APISETTING);
            if (!empty($err)) throw new Exception("cURL Error #:" . $err, API_ERRORCODE_CONNECT_FAILED);

            $errmsg = "";
            if($status != 200){
                $errmsg = $this->ErrCode[$status];
                throw new Exception("cURL Error #:".$errmsg, API_ERRORCODE_NOCONNECT);
            }
            $log->info('Successful deleted vehicle entry settings.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'delete_id' => $delete_id, 'request_method' => 'POST', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/car_admission/'.$sitename.'/settings/delete/'.$delete_id, 'response' => $raw));
            return json_decode($response);
        } catch (Exception $e) {
            $log->error($e);
            $log->error('Failed to deleting vehicle entry settings', array('file' => ''.$e->getFile().' on line '.$e->getLine().''));
            throw new Exception("【".$e->getCode()."】".$e->getMessage());
        }
    }

    /**
     * ナンバープレート検知情報一覧を取得
     */
    public function GetNumberPlateInfoList($sitename, $prm){
        global $log;
        try {
            if(empty($sitename)) throw new Exception("Not Set Parameter.");

            $ch= curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => 'https://'.$this->Domein.'/api/public/v1/car_admission/'.$sitename.'/number_plate/info',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_SSL_VERIFYHOST => 0,
                CURLOPT_PROXY_SSL_VERIFYPEER => false,
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 60,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => json_encode($prm),
                CURLOPT_HTTPHEADER => [
                    'Content-Type: application/json',
                    "Authorization: Bearer ".$this->Token,
                ],
            ]);

            $log->info('Starting get number plate info list.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'parameter' => $prm, 'request_method' => 'POST', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/car_admission/'.$sitename.'/number_plate/info'));
            $response = curl_exec($ch);
            $raw = json_decode($response);
            $err = curl_error($ch);
            $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            if(isset($raw->error)) throw new Exception("cURL Error #:".$raw->error_description, API_ERRORCODE_FAILED_APISETTING);
            if (!empty($err)) throw new Exception("cURL Error #:" . $err, API_ERRORCODE_CONNECT_FAILED);

            $errmsg = "";
            if($status != 200){
                $errmsg = $this->ErrCode[$status];
                throw new Exception("cURL Error #:".$errmsg, API_ERRORCODE_NOCONNECT);
            }
            $log->info('Successful get number plate info list.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'parameter' => $prm, 'request_method' => 'POST', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/car_admission/'.$sitename.'/number_plate/info', 'response' => $raw));
            return json_decode($response);
        } catch (Exception $e) {
            $log->error($e);
            $log->error('Failed to get number plate info list', array('file' => ''.$e->getFile().' on line '.$e->getLine().''));
            throw new Exception("【".$e->getCode()."】".$e->getMessage());
        }
    }

    /**
     * デバイスステータスリストを取得
     */
    public function GetDeviceStatusList($sitename, $devicename) {
        global $log;
        try {
            if(empty($sitename) || empty($devicename)) throw new Exception("Not Set Parameter.");
            $ch= curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename.'/'.$devicename.'/devices/all/status',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_SSL_VERIFYHOST => 0,
                CURLOPT_PROXY_SSL_VERIFYPEER => false,
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 60,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => [
                    "Authorization: Bearer ".$this->Token,
                ],
            ]);

            $log->info('Starting get device status list.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'device_type' => $devicename, 'request_method' => 'GET', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename.'/'.$devicename.'/devices/all/status'));
            $response = curl_exec($ch);
            $raw = json_decode($response);
            $err = curl_error($ch);
            $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            if(isset($raw->error)) throw new Exception("cURL Error #:".$raw->error_description, API_ERRORCODE_FAILED_APISETTING);
            if (!empty($err)) throw new Exception("cURL Error #:" . $err, API_ERRORCODE_CONNECT_FAILED);

            $errmsg = "";
            if($status != 200){
                $errmsg = $this->ErrCode[$status];
                throw new Exception("cURL Error #:".$errmsg, API_ERRORCODE_NOCONNECT);
            }
            $log->info('Successful get device status list.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'device_type' => $devicename, 'request_method' => 'GET', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename.'/'.$devicename.'/devices/all/status', 'response' => $raw));
            return json_decode($response);
        } catch (Exception $e) {
            $log->error($e);
            $log->error('Failed to get device status list', array('file' => ''.$e->getFile().' on line '.$e->getLine().''));
            throw new Exception("【".$e->getCode()."】".$e->getMessage());
        }
    }

    /**
     * デバイスタイプを取得
     */
    public function GetDevicetypeList($sitename) {
        global $log;
        try {
            if(empty($sitename)) throw new Exception("Not Set Parameter.");

            $ch= curl_init();
            curl_setopt_array($ch, [
                CURLOPT_URL => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename.'/devicetypes',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_SSL_VERIFYHOST => 0,
                CURLOPT_PROXY_SSL_VERIFYPEER => false,
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 60,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => [
                    "Authorization: Bearer ".$this->Token,
                ],
            ]);

            $log->info('Starting get device type list.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'request_method' => 'GET', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename.'/devicetypes'));
            $response = curl_exec($ch);
            $raw = json_decode($response);
            $err = curl_error($ch);
            $status = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            curl_close($ch);

            if(isset($raw->error)) throw new Exception("cURL Error #:".$raw->error_description, API_ERRORCODE_FAILED_APISETTING);
            if (!empty($err)) throw new Exception("cURL Error #:" . $err, API_ERRORCODE_CONNECT_FAILED);

            $errmsg = "";
            if($status != 200){
                $errmsg = $this->ErrCode[$status];
                throw new Exception("cURL Error #:".$errmsg, API_ERRORCODE_NOCONNECT);
            }
            $log->info('Successful get device type list.', array('file' => __FILE__, "user_id" => $_SESSION['login']['user_id'], 'request_method' => 'GET', 'request_url' => 'https://'.$this->Domein.'/api/public/v1/device_control/'.$sitename.'/devicetypes', 'response' => $raw));
            return json_decode($response);
        } catch (Exception $e) {
            $log->error($e);
            $log->error('Failed to get device type list', array('file' => ''.$e->getFile().' on line '.$e->getLine().''));
            throw new Exception("【".$e->getCode()."】".$e->getMessage());
        }
    }
}
