<?

require_once 'database.php';

class sngModel{
    private $DB;
    private $Link;
    public function __construct($DB, $Link){
        $this->DB = $DB;
        $this->Link = $Link;
    }



    /**
     * テナント一覧取得
     */
    public function GetTenantList() {
        try {
            global $log;

            $sql = "SELECT * FROM `TenantTbl`";
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from TenantTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'TenantTbl', 'message' => $e->getMessage()));
        }

        return $rows;
    }



    /**
     * デバイス一覧取得
     */
    public function GetDeviceTbl() {
        try {
            global $log;

            $sql = "SELECT * FROM `DeviceTbl`";
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from DeviceTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'TenantTbl', 'message' => $e->getMessage()));
        }

        return $rows;
    }


    /**
     * デバイス一覧取得（デバイスタイプ指定）
     */
    public function GetDeviceTblForDeviceType($dtype) {
        try {
            global $log;

            $sql = sprintf("SELECT * FROM `DeviceTbl` WHERE `type` = '%s'",
                $this->model_sql_esc($dtype));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from DeviceTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'DeviceTbl', 'parameter' => $dtype, 'message' => $e->getMessage()));
        }

        return $rows;
    }




    /**
     * デバイスID情報取得（テナントID）
     * GetDeviceTblByTenantID
     */
    public function GetDeviceTblByTenantID($tid) {
        try {
            global $log;

            $sql = sprintf("SELECT * FROM `DeviceTbl` WHERE `tenant_id` = '%s'",
                $this->model_sql_esc($tid));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from DeviceTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'DeviceTbl', 'parameter' => $tid, 'message' => $e->getMessage()));
        }

        return $rows;
    }

    /**
     * 捜査権限のあるデバイスID情報取得（テナントID）
     * GetDeviceTblByTenantIDControlable
     */
    public function GetDeviceTblByTenantIDControlable($tid, array $authlist) {
        try {
            global $log;
            $auth = "'".implode("','", $authlist)."'";
            if($auth == "") throw new Exception("デバイスの操作権限がありません。");
            $sql = sprintf("SELECT * FROM `DeviceTbl` WHERE `tenant_id` = '%s' AND `du_id` IN (%s)",
                $this->model_sql_esc($tid),
                $auth);

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from DeviceTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'DeviceTbl', 'parameter' => [$tid, $auth], 'message' => $e->getMessage()));
        }

        return $rows;
    }


    /**
     * デバイスID情報取得（エリアID）
     * GetDeviceTblByFieldID
     */
    public function GetDeviceTblByFieldID($fid) {
        try {
            global $log;

            $sql = sprintf("SELECT * FROM `DeviceTbl` WHERE `field_id` = '%s'",
                $this->model_sql_esc($fid));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from DeviceTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'DeviceTbl', 'parameter' => $fid, 'message' => $e->getMessage()));
        }

        return $rows;
    }


    /**
     * 操作権限のあるデバイスID情報取得（エリアID）
     * GetDeviceTblByFieldIDControlable
     */
    public function GetDeviceTblByFieldIDControlable($fid, array $authlist) {
        try {
            global $log;
            $auth = "'".implode("','", $authlist)."'";
            if($auth == "") throw new Exception("デバイスの操作権限がありません。");
            $sql = sprintf("SELECT * FROM `DeviceTbl` WHERE `field_id` = '%s' AND `du_id` IN (%s)",
                $this->model_sql_esc($fid),
                $auth);
//             var_dump($sql);
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from DeviceTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'DeviceTbl', 'parameter' => [$fid, $auth], 'message' => $e->getMessage()));
        }

        return $rows;
    }




    /**
     * デバイスID情報取得
     * GetDeviceTblByDeviceID
     */
    public function GetDeviceTblByDeviceID($did) {
        try {
            global $log;

            $sql = sprintf("SELECT * FROM `DeviceTbl` WHERE `device_id` = '%s'",
                $this->model_sql_esc($did));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $row = mysqli_fetch_assoc( $result );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from DeviceTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'DeviceTbl', 'parameter' => $did, 'message' => $e->getMessage()));
        }

        return $row;
    }


    /**
     * デバイス情報取得（デバイスユニークID）
     * GetDeviceTblByDeviceUniqID
     */
    public function GetDeviceTblByDeviceUniqID($duid) {
        try {
            global $log;

            $sql = sprintf("SELECT * FROM `DeviceTbl` WHERE `du_id` = '%s'",
                $this->model_sql_esc($duid));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $row = mysqli_fetch_assoc( $result );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from DeviceTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'DeviceTbl', 'parameter' => $duid, 'message' => $e->getMessage()));
        }

        return $row;
    }


    /**
     * デバイスID情報取得（カンマ区切り複数ID）
     * GetDeviceListByManyDeviceID
     * $dids　カンマ区切りID
     */
    public function GetDeviceListByManyDeviceID($dids) {
        try {
            global $log;

            $sql = sprintf("SELECT * FROM `DeviceTbl` WHERE `device_id` IN (%s)",
                $this->model_sql_esc($dids));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from DeviceTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'DeviceTbl', 'parameter' => $dids, 'message' => $e->getMessage()));
        }

        return $rows;
    }



    /**
     * InsertDeviceData
     * デバイス情報登録
     */
    public function InsertDeviceData($prm) {
        try {
            global $log;
            $d_num = ($prm['device_num'] != "")? "'".$this->model_sql_esc($prm['device_num'])."'" :'NULL';
            $sql = sprintf("INSERT INTO `DeviceTbl` (`num`, `device_id`,`du_id`, `device_num`, `tenant_id`, `field_id`, `name`, `x_pos`,`y_pos`, `type`, `status`) VALUES (NULL, '%s', '%s', ".$d_num.", '%s', '%s', '%s', %f, %f, '%s', 1)",
                $this->model_sql_esc($prm['device_id']),
                $this->model_sql_esc($prm['du_id']),
                $this->model_sql_esc($prm['tenant_id']),
                $this->model_sql_esc($prm['field_id']),
                $this->model_sql_esc($prm['name']),
                $this->model_sql_esc($prm['x_pos']),
                $this->model_sql_esc($prm['y_pos']),
                $this->model_sql_esc($prm['type']));


            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed register device data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'DeviceTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }



    /**
     * InsertCSVMultiDeviceData
     * デバイス一括登録
     */
    public function InsertCSVMultiDeviceData($data) {
        try {
            global $log;
            $key = [
                'num',
                'device_id',
                'du_id',
                'device_num',
                'tenant_id',
                'field_id',
                'name',
                'x_pos',
                'y_pos',
                'type',
                'status',
            ];
            //             $key = array('num','company_id','tenant_id','company_class','company_name','company_zip','company_addr','company_tel','company_url','company_state');
            foreach($data as $k => $v){

                if(is_null($v['num'])){

                    //TODO　ユーザーアカウント登録処理
                    $value[] = sprintf("(NULL, '%s', '%s', %d, '%s', '%s', '%s', %d, %d, '%s', %d)",
                        $this->model_sql_esc($v['device_id']),
                        $this->model_sql_esc($v['du_id']),
                        $this->model_sql_esc($v['device_num']),
                        $this->model_sql_esc($v['tenant_id']),
                        $this->model_sql_esc($v['field_id']),
                        $this->model_sql_esc($v['name']),
                        $this->model_sql_esc($v['x_pos']),
                        $this->model_sql_esc($v['y_pos']),
                        $this->model_sql_esc($v['type']),
                        $this->model_sql_esc($v['status'])
                        );


                }else{
                    // ユーザーアカウントアップデート処理
                    $value[] = sprintf("(%d, '%s', '%s', %d, '%s', '%s', '%s', %d, %d, '%s', %d)",
                        $this->model_sql_esc($v['num']),
                        $this->model_sql_esc($v['device_id']),
                        $this->model_sql_esc($v['du_id']),
                        $this->model_sql_esc($v['device_num']),
                        $this->model_sql_esc($v['tenant_id']),
                        $this->model_sql_esc($v['field_id']),
                        $this->model_sql_esc($v['name']),
                        $this->model_sql_esc($v['x_pos']),
                        $this->model_sql_esc($v['y_pos']),
                        $this->model_sql_esc($v['type']),
                        $this->model_sql_esc($v['status'])
                        );
                }
            }
            $value = implode(',',$value);
            $sql = "INSERT INTO `DeviceTbl` (".implode(',',$key).")";
            $sql .= " VALUES ".$value." ON DUPLICATE KEY UPDATE ";

            $in_arr = array();
            foreach($key as $k => $v){
                $in_arr[] = $v." = VALUES(".$v.")";
            }
            $sql .= implode(',',$in_arr);
            $sql .= ";";

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed register device data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'DeviceTbl', 'parameter' => $data, 'message' => $e->getMessage()));exit;
        }

        return $result;
    }


    /**
     * UpdateDeviceData
     * ユーザー情報更新
     */
    public function UpdateDeviceData($prm) {
        try {
            global $log;
            $d_num = ($prm['device_num'] != "")? "'".$this->model_sql_esc($prm['device_num'])."'" :'NULL';

            $sql = sprintf("UPDATE `DeviceTbl` SET `device_num`=".$d_num.", `tenant_id`='%s', `field_id`= '%s', `name`='%s', `x_pos`=%f, `y_pos`=%f, `type`='%s' WHERE `du_id`='%s'",
                $this->model_sql_esc($prm['tenant_id']),
                $this->model_sql_esc($prm['field_id']),
                $this->model_sql_esc($prm['name']),
                $this->model_sql_esc($prm['x_pos']),
                $this->model_sql_esc($prm['y_pos']),
                $this->model_sql_esc($prm['type']),
                $this->model_sql_esc($prm['du_id']));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to update user information.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'DeviceTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }



    /**
     * DeleteDeviceData
     * デバイス情報削除
     */
    public function DeleteDeviceData($num) {
        try {
            global $log;
            $sql = sprintf("DELETE FROM `DeviceTbl` WHERE `num` = '%s'",
                $this->model_sql_esc($num));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to delete device information.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'DeviceTbl', 'delete_target' => $num, 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * ShowFullColumnsByTable
     * テーブル情報取得
     */
    public function ShowFullColumnsByTable($table) {
        try {
            global $log;
            $sql = sprintf("SHOW FULL COLUMNS FROM `%s`", $this->model_sql_esc($table));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get table information.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => $table, 'message' => $e->getMessage()));
        }

        return $rows;
    }

    /**
     * GetFullDataByTable
     * テーブル全カラム取得
     */
    public function GetFullDataByTable($table) {
        try {
            global $log;
            $sql = sprintf("SELECT * FROM %s", $this->model_sql_esc($table));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($this->Link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get all columns.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => $table, 'message' => $e->getMessage()));
        }

        return $rows;
    }


    private function model_sql_esc($str){
        return mysqli_real_escape_string($this->Link, $str);
    }

    public function sql_error($f,$sql,$code){
        global $log;
        $body = "SQLエラーが発生しました。\n発生したPHP=".$f."\nSQL=".$sql.$code;
        echo $body;
        $log->error($body, array('file' => __FILE__));
        exit;
    }
}
?>