<?
# .env読み込み
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__. "/../");
$dotenv->load();

    /**
    *--------------------------------------------------------------------------
    * Site Name
    *--------------------------------------------------------------------------
    *
    * This value is the name of the site used by the application.
    * This value is used when connecting to a generic site URL or DX-Core.
    *
    */
    if(!$_ENV["SITE_NAME"] || $_ENV["SITE_NAME"] ==""){
        $_ENV["SITE_NAME"] = "local";
    }
    /**
    *--------------------------------------------------------------------------
    * Log Dir
    *--------------------------------------------------------------------------
    *
    * This value is the directory to which log output is directed.
    *
    */
    if(!$_ENV["LOG_DIR"] || $_ENV["LOG_DIR"] ==""){
        $_ENV["LOG_DIR"] = "/var/log/super_app/";
    }

    /**
    *--------------------------------------------------------------------------
    * Log Level
    *--------------------------------------------------------------------------
    *
    * This value is the directory to which log output is directed.
    * This value consists of "DEBUG", "INFO", "WARNING" and "ERROR".
    *
    */
    if(!$_ENV["LOG_LEVEL"] || $_ENV["LOG_LEVEL"] ==""){
        $_ENV["LOG_LEVEL"] = "INFO";
    }

    /**
    *--------------------------------------------------------------------------
    * Log Timezone
    *--------------------------------------------------------------------------
    *
    * This value is the time zone for log output.
    *
    */
    if(!$_ENV["LOG_TIMEZONE"] || $_ENV["LOG_TIMEZONE"] ==""){
        $_ENV["LOG_TIMEZONE"] = "Asia/Tokyo";
    }

    /**
    *--------------------------------------------------------------------------
    * Use Cognito
    *--------------------------------------------------------------------------
    *
    * This value is whether or not the cognate is used when logging in to the application.
    * A value of 1 means enabled, a value of 0 means disabled.
    *
    */
    if(!$_ENV["USE_COGNITO"] || $_ENV["USE_COGNITO"] ==""){
        $_ENV["USE_COGNITO"] = 0;
    }

    /**
    *--------------------------------------------------------------------------
    * Region
    *--------------------------------------------------------------------------
    *
    * This value is the AWS region setting.
    * This value is used when the application logs in using Cognito.
    *
    */
    if(!$_ENV["REGION"] || $_ENV["REGION"] ==""){
        $_ENV["REGION"] = "ap-northeast-1";
    }

    /**
    *--------------------------------------------------------------------------
    * User Pool Id
    *--------------------------------------------------------------------------
    *
    * This value is the AWS USER POOL ID setting.
    * This value is used when the application logs in using Cognito.
    *
    */
    if(!$_ENV["USER_POOL_ID"] || $_ENV["USER_POOL_ID"] ==""){
        $_ENV["USER_POOL_ID"] = null;
    }

    /**
    *--------------------------------------------------------------------------
    * App Client Id
    *--------------------------------------------------------------------------
    *
    * This value is the AWS App Client Id setting.
    * This value is used when the application logs in using Cognito.
    *
    */
    if(!$_ENV["APP_CLIENT_ID"] || $_ENV["APP_CLIENT_ID"] ==""){
        $_ENV["APP_CLIENT_ID"] = null;
    }

    /**
    *--------------------------------------------------------------------------
    * Share Domain
    *--------------------------------------------------------------------------
    *
    * This value is the Share Domain setting.
    * This value is used when the application logs in using Cognito.
    *
    */
    if(!$_ENV["SHARE_DOMAIN"] || $_ENV["SHARE_DOMAIN"] ==""){
        $_ENV["SHARE_DOMAIN"] = null;
    }
?>
