<?php
require_once(__DIR__ . "/util/utils.php");
require( __DIR__."/../super_appli/core/construct.php");
require(ADMIN_ROOT."core/functions.php");
require_once(__DIR__ . "/cron_func.php");

try{
    $log->info('Starting cron.', array('file' => __FILE__, 'target' => ['News information', 'Device information', 'Weather information']));
//     ini_set('display_errors', 1);
//     error_reporting(E_ALL);

    require_once(SN_MDL_PATH."model.php");
    $MDL = new sngModel($sdb, $link);

    require_once(ADMIN_ROOT."model/model.php");
    $admMDL = new admModel($sdb, $link);

    require_once(SIGNAGE_ROOT."api.php");


    //cron更新周期の読込

    //初期化
    $cycle_news = 60;
    $cycle_weather = 360;
    $cycle_device = 60;

    $cc_row = $admMDL->CronCycle();
    if($cc_row){
        if(is_numeric($cc_row['cycle_news']*1)) $cycle_news = $cc_row['cycle_news'];
        if(is_numeric($cc_row['cycle_weather']*1)) $cycle_weather = $cc_row['cycle_weather'];
        if(is_numeric($cc_row['cycle_device']*1)) $cycle_device = $cc_row['cycle_device'];

    }

    //ニュースコンテンツ読込
    //ToDo iforce API利用回数制限がある為、コメントアウト
    //require_once(CORE_ROOT."../../cron/get_news.php");


    //天気予報取得時間チェック
    //テナントごとに天気予報が必要な場合は別ファイルに書き込ませる？
    $tn_row = $admMDL->GetTenantList();
    if($tn_row){
        foreach($tn_row as $tnK => $tnV){
            try{
                $log->info('Starting tenant cron.', array('file' => __FILE__, 'tenant' => $tnV));

                $tenant_id = $tnV['id'];


                //             $placeData = [
                //                 'prefecture' => 'tokyo',
                //                 'country' => 'jp',
                //                 'lat' => $tnV['lat'],
                //                 'lon' => $tnV['lon'],
                //             ];

                //             //現在の天気を取得
                //             $wt_ret = CheckContentsGetTime('weather_'.$tenant_id);

                //             if($wt_ret){
                //                 //ニュースコンテンツをAPIから取得
                //                 $weather_contents = GetWeatherContents($placeData);

                //                 //ニュースコンテンツバッファ書き込み
                //                 WriteWeatherDataForBuffer($tenant_id, $weather_contents);
                //             }


                //             //TODO 三時間ごとの天気を取得
                //             $w3t_ret = CheckContentsGetTime('weather3hour_'.$tenant_id);

                //             if($w3t_ret){
                //                 //ニュースコンテンツをAPIから取得
                //                 $threeweather_contents = GetThreeDayWeatherContents($placeData);
                //                 //ニュースコンテンツバッファ書き込み
                //                 WriteThreeWeatherDataForBuffer($tenant_id, $threeweather_contents);
                //             }


                //天気コンテンツ処理
                //ToDo iforce API利用回数制限がある為、コメントアウト
                //require(CORE_ROOT."../../cron/get_weather.php");


                //第三者APIよりデバイス情報を取得

                // デバイス処理
                require(__DIR__ . '/get_device.php');

                $log->info('Completed tenant cron.', array('file' => __FILE__, 'tenant' => $tnV));
            }catch(Exception $e){
                $log->error($e);
                $log->error('Failed tenant cron', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'message' => $msg));
            }
        }
    }

    $log->info('Completed cron.', array('file' => __FILE__, 'target' => ['News information', 'Device information', 'Weather information']));

    echo 'cron_ok ';
}catch(Exception $e){
    $et = new Datetime();
    $msg = $e->getMessage();
    $code = $e->getCode();
//     throw new Exception();
    var_dump($et->format("Y-m-d H:i:s")." ".$code.$msg.'\r\n');
    $log->error($e);
    $log->error('Failed cron', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'message' => $msg));
}

?>