<?php
/**
 * 削除日を過ぎたお知らせ情報削除
 */

require_once(__DIR__ . '/util/utils.php');
require_once(__DIR__ . '/../admin/core/construct.php');
require_once(__DIR__ . '/../admin/model/model.php');
$admMDL = new admModel($sdb, $link);

try{
    echo "cron_start","\n";

    //現在時刻取得
    $t = new Datetime();
    $now = $t->format('Y-m-d H:i:s');
    echo "$now","\n";

    $log->info('Starting deleted.', array('file' => __FILE__, 'data' => $now, 'target' => 'Notification information'));

    // お知らせ情報削除
    $admMDL->DeleteNotificationDataByDatetime($now);
    // ナンバープレート情報削除
    $admMDL->DeleteNumberPlateNotificationDataByDatetime($now);

    echo "cron_end","\n";
    $log->info('Completed deleted.', array('file' => __FILE__, 'data' => $now, 'target' => 'Notification information'));

}catch(Exception $e){
    // throw new Exception($e);
    $log->error($e);
    $log->error('Failed deleted.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'data' => $now, 'target' => 'Notification information', 'message' => $e->getMessage()));
}