<?php
/**
 * 設備リストウィジェットのデバイス情報取得
 */
require_once(__DIR__ . '/util/utils.php');
require_once(__DIR__.'/../admin/core/construct.php');
require_once(__DIR__.'/../api/api.php');
require_once(__DIR__.'/../super_appli/model/model.php');
require_once(__DIR__.'/../admin/model/model.php');

try {
    $log->info('Starting get facility device.', array('file' => __FILE__, 'target' => 'Facility list device information'));
    getFacilityDeviceType();
    getFacilityDevice($sdb, $link);
    $log->info('Completed get facility device.', array('file' => __FILE__, 'target' => 'Facility list device information'));
} catch(Exception $e) {
    $log->error($e);
    $log->error('Failed get facility device.', 
        array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 
        'target' => 'Facility list device information', 'message' => $e->getMessage()));
}

function getFacilityDevice($sdb, $link) {
    global $log;
    $sapMDL = new sappModel($sdb, $link);
    $API = new Api($_ENV["SITE_NAME"]);
    // テキストファイルからデバイスタイプ取得
    $file_name =  __DIR__.'/../contents/devicetype_'.$_ENV["SITE_NAME"].'.txt';
    $file_handle = fopen($file_name, 'r');
    $file_content = fread($file_handle, filesize($file_name));
    $text_split = preg_split('/^\d*_/', $file_content);
    fclose($file_handle);
    $json_data = json_decode($text_split[0], true);
    if(!$json_data["res_device_type"]) {
        throw new Exception("Failed to get device type.");
    }
    $json_count = count($json_data["res_device_type"]);
    for($json_counter = 0; $json_counter < $json_count; $json_counter++) {
        $device_name = $json_data["res_device_type"][$json_counter];
        // Dx-Coreからステータス情報取得
        try {
            $res_device_data = $API->GetDeviceStatusList($_ENV["SITE_NAME"], $device_name);
        } catch(Exception $e) {
            var_dump('GetDeviceStatusList:NG'.$e->getMessage());
        };
        if(!$res_device_data) {
            throw new Exception("Failed to get device information.");
        }
        $db_device_data = $sapMDL->GetFunctionDeviceType($device_name);
        if(!$db_device_data) {
            throw new Exception("Failed to get DB data.");
        }
        $db_device_data_list = [];
        if($db_device_data) {
            foreach($db_device_data as $db_device_data_key => $db_device_data_value) {
                // 例)ahu
                $db_device_data_list[$db_device_data_value['id']]['device_type'] = $db_device_data_value['device_type'];
                // 例)Device.Status.RunningControl
                $db_device_data_list[$db_device_data_value['id']]['device_function'] = $db_device_data_value['device_function'];
                // 例)運転状態
                $db_device_data_list[$db_device_data_value['id']]['description'] = $db_device_data_value['description'];
                // 例)℃
                $db_device_data_list[$db_device_data_value['id']]['unit'] = $db_device_data_value['unit'];
                // 例)checkbox
                $db_device_data_list[$db_device_data_value['id']]['value_type'] = $db_device_data_value['value_type'];
                // 例)JSON_OBJECT("0","OFF","1","ON")
                $db_device_data_list[$db_device_data_value['id']]['device_values'] = $db_device_data_value['device_values'];
                // 例)警報種別 0:軽警報 1:中警報 2:重警報
                $db_device_data_list[$db_device_data_value['id']]['alarm_type'] = $db_device_data_value['alarm_type'];
                $db_device_data_list[$db_device_data_value['id']]['step_value'] = $db_device_data_value['step_value'];
            };
        };
        if(empty($db_device_data_list)) {
            throw new Exception("Failed to get DB data.");
        }
        $api_data = array();
        $api_data['res_device_data'] = $res_device_data->{'Data'};
        $api_data['db_device_data_list'] = $db_device_data_list;
        $json = json_encode($api_data, JSON_UNESCAPED_UNICODE);
        $write_file_name = __DIR__.'/../contents/devicedata_'.$device_name.'_'.$_ENV["SITE_NAME"].'.txt';
        // ファイルが存在しなかったら作成
        if(!file_exists($write_file_name)) {
            touch($write_file_name);
        }
        // ファイルを開く（'w'は書き込みモード）
        $file_handle = fopen($write_file_name, 'w');
        // ファイルに書き込む
        fwrite($file_handle, print_r($json, true));
        // ファイルを閉じる
        fclose($file_handle);
        $log->info('Get device.', array('file' => __FILE__, 'device' => $device_name));
    };
}

function getFacilityDeviceType() {
    global $log;
    $API = new Api($_ENV["SITE_NAME"]);
    try{
        $res_device_type = $API->GetDevicetypeList($_ENV["SITE_NAME"]);
    }catch(Exception $e){
        $log->error($e);
        $log->error('Failed to get device type.', array('file' => __FILE__));
        var_dump('GetDevicetypeList:NG'.$e->getMessage());
    };
    if(!$res_device_type){
        throw new Exception("Failed to get device type.");
    }
    $api_data = array();
    $api_data['res_device_type'] = $res_device_type->Data->{'General.DeviceTypeList'};
    $json = json_encode($api_data);
    $file_name =  __DIR__.'/../contents/devicetype_'.$_ENV["SITE_NAME"].'.txt';
    // ファイルが存在しなかったら作成
    if(!file_exists($file_name)){
        touch ($file_name);
    }
    // ファイルを開く（'w'は書き込みモード）
    $file_handle = fopen($file_name, 'w');
    // ファイルに書き込む
    fwrite($file_handle, print_r($json, true));
    // ファイルを閉じる
    fclose($file_handle);
}

?>
