<?php
/**
 * ニュースコンテンツ取得
 */
require_once(__DIR__ . '/util/utils.php');
require_once(__DIR__ . '/cron_func.php');

try{

    $log->info('Starting get_news process.', array('file' => __FILE__, 'target' => 'News information'));

    //ニュースコンテンツ取得時間チェック
    $nw_ret = CheckContentsGetTime('news');

    if($nw_ret){
        //ニュースコンテンツをAPIから取得
        $news_contents = GetNewsContents();
        if(!$news_contents) throw new Exception("Failed to get API.");

        //ニュースコンテンツバッファ書き込み
        WriteNewsContentsForBuffer($news_contents, $cycle_news);
    }
    $log->info('Successful get_news process.', array('file' => __FILE__, 'target' => 'News information'));
    echo 'news_ok ';
}catch(Exception $e){
    throw new Exception($e->getMessage());
}


?>
