<?php
/**
 * DX-Coreより取得したナンバープレートお知らせ情報をスーパーアプリのDBに登録.
 * cronにより1分1回起動する.
 */

require_once(__DIR__ . '/util/utils.php');
require_once(__DIR__ . '/../super_appli/core/construct.php');
require_once(__DIR__ . '/../admin/model/model.php');
require_once(__DIR__ . '/../api/api.php');
require_once(__DIR__ . '/../super_appli/model/model.php');

// DX-Coreからサイト名取得
try{
    $log->info('Starting get numberplate.', array('file' => __FILE__, 'target' => 'Numberplate notification information'));
    $sapMDL = new sappModel($sdb, $link);
    $API = new Api($_ENV["SITE_NAME"]);
    $res_site = $API->GetTenantName();
    $sitename = $res_site->Data->{'General.SiteList'}[0];

    // DX-CoreからNuberPlate通知情報取得
    $res_time = CheckNotificationNumberPlateTime();
    $time = (int) $res_time[1];
    // 初期値
    if(!$time){
        $time = 0;
    }
    $log->info($_ENV["SITE_NAME"]);
    $API = new Api($_ENV["SITE_NAME"]);
    $res_notification = $API->GetNotificationNumberPlateListUnixtime($sitename, $time);
    $numberplate_notification = $res_notification->Data;

    // ナンバープレートお知らせ情報登録
    if($numberplate_notification){
        foreach($numberplate_notification as $nn_data){
            $u_row = $sapMDL->GetUserEmailList($nn_data->{mail_address});
            if($u_row){
                foreach($u_row as $u_key => $u_val){
                    $six_hour_later = date("Y-m-d H:i:s",strtotime($nn_data->{datetime}. "+6 hour"));
                    $numberplate_prm = array(
                        "tenant_id" => $u_val["tenant_id"],
                        "user_id" =>  $u_val["user_id"],
                        "title" => "ナンバープレート検知",
                        "description" => 'ナンバープレート : '.$nn_data->{number},
                        "datetime" => $nn_data->{datetime},
                        "deletetime" => $six_hour_later,
                    );
                    $sapMDL->InsertNumberplateInfo($numberplate_prm);
                }
                SetNotificationNumberPlateTime($nn_data->{datetime});
            }
        }
    }
    $log->info('Completed get numberplate.', array('file' => __FILE__, 'target' => 'Facility list device information'));
}catch(Exception $e){
    $log->error($e);
    $log->error('Failed to get numberplate', array('file' => ''.$e->getFile().' on line '.$e->getLine().''));
}

function CheckNotificationNumberPlateTime(){
    $filename = '/var/www/html/cron/CheckNotificationNumberPlateUnixtime.txt';
    return file($filename);
}

function SetNotificationNumberPlateTime($datetime){
    $date = new DateTime($datetime);
    $unixtime = $date->format('U');
    $filename = '/var/www/html/cron/CheckNotificationNumberPlateUnixtime.txt';
    // ファイルを開く（'w'は書き込みモード）
    $fp = fopen($filename, 'w');
    // ファイルに書き込む
    $data = "notification_number_plate_unixtime\n$unixtime\n";
    fputs($fp, $data);
    // ファイルを閉じる
    fclose($fp);
    $log->info('Completed cron.', array('file' => __FILE__, 'target' => 'Numberplate notification information'));
}
?>
