<?php
/**
 * ニュースコンテンツ取得
 */
require_once(__DIR__ . '/util/utils.php');
require_once(__DIR__ . '/cron_func.php');

try{
    $log->info('Starting get_weather process.', array('file' => __FILE__, 'target' => 'Weather information'));


        $placeData = [
    //         'prefecture' => 'tokyo',
    //         'country' => 'jp',
            'lat' => $tnV['lat'],
            'lon' => $tnV['lon'],
        ];

    //現在の天気を取得
    $wt_ret = CheckContentsGetTime('weather_'.$tenant_id);

    if($wt_ret){
        //ニュースコンテンツをAPIから取得
        $weather_contents = GetWeatherContents($placeData);
        echo 'GetWeatherContents('.$tenant_id.')'."\n";
        //ニュースコンテンツバッファ書き込み
        WriteWeatherDataForBuffer($tenant_id, $weather_contents, $cycle_weather);
    }else{
        throw new Exception("Failed to get weather from API.");
    }


    //TODO 三時間ごとの天気を取得
    $w3t_ret = CheckContentsGetTime('weather3hour_'.$tenant_id);

    if($w3t_ret){
        //ニュースコンテンツをAPIから取得
        $threeweather_contents = GetThreeDayWeatherContents($placeData);
        echo 'GetThreeDayWeatherContents('.$tenant_id.')'."\n";
        //ニュースコンテンツバッファ書き込み
        WriteThreeWeatherDataForBuffer($tenant_id, $threeweather_contents, $cycle_weather);
    }else{
        throw new Exception("Failed to get weather from API.");
    }


    $log->info('Successful get_weather process.', array('file' => __FILE__, 'target' => 'Weather information'));
    echo 'weather_ok '."\n";

}catch(Exception $e){
    throw new Exception($e->getMessage());
}


?>
