<?

// 日付変換
// パラメータ 0:今日 1:明日 2:明後日
function date_henkan($d)
{
    if($d == 0)
    {
        $today = date("n/j");
        $youbi = date("w");
    }
    else
    {
        $d = '+'.$d.' day';
        $today = date("n/j",strtotime($d ));
        $youbi = date("w",strtotime($d ));
    }
    switch($youbi)
    {
        case 0: $today = $today.'(日)';
                break;
        case 1: $today = $today.'(月)';
                break;
        case 2: $today = $today.'(火)';
                break;
        case 3: $today = $today.'(水)';
                break;
        case 4: $today = $today.'(木)';
                break;
        case 5: $today = $today.'(金)';
                break;
        case 6: $today = $today.'(土)';
                break;
    }
    return($today);
}
function holiday_check($d)
{
    return TRUE;
}


function h($str){
    return htmlspecialchars($str);
}

function pre($mixed = null) {
    echo '<pre>';
    var_dump($mixed);
    echo '</pre>';
    return null;
}

function time_format_simple($time){
    //例：　24:00
    $hour = (int)floor($time / 100);
    $minute = (int)floor($time % 100);

    $ret = $hour.':'.sprintf('%02d', $minute);
    return $ret;
}

function DatetimeFormat($time, $day = null){
    if(is_null($day)){
        $d = new Datetime();
        $set_date = $d->format("Y/m/d");
//      $set_date = date('Ymd',time());
    }else{
        //Ymd
        $set_date = $day;
    }

    $t = intval($time);
    $t2 = $t % 100;
    $t1 = floor($t / 100);
    if($t2 === 0) $t3 = '00'; else $t3 = (string)$t2;
//  var_dump($set_date." ".$t1.":".$t3);exit;
    $tm = new Datetime($set_date." ".$t1.":".$t3);
    $rtn = $tm->format("Y/m/d G:i:s");
//  $rtn = date('G:i',strtotime($set_date.sprintf('%04d',$time)));
    return $rtn;
}

function getDatetimeTimestamp($time){
    $t = new Datetime($time);
    $rtn = $t->getTimestamp();
    return $rtn;
}


//one time tokenによる画面制御機構の作成
function createToken(){
    //セッションIDを取得
    $session_id = session_id();
    if($session_id == ""){
        return false;
    }
    //UNIX現在時刻を取得
    $time = time();
    //セッションIDとUNIX現在時刻を結合し、SHA1形式でハッシュ化し、ワンタイムトークン作成
    $token = sha1($session_id.$time);
    //セッションと返り値にワンタイムトークンを格納
    $_SESSION['one_time_token'] = $token;
    return $token;
}

//csrf tokenによる画面制御機構の作成
function createCsrfToken(){
    //セッションIDを取得
    $session_id = session_id();
    if($session_id == ""){
        return false;
    }
    //UNIX現在時刻を取得
    $time = time();
    //セッションIDとUNIX現在時刻を結合し、SHA1形式でハッシュ化し、ワンタイムトークン作成
    $token = sha1($session_id.$time);
    //セッションと返り値にワンタイムトークンを格納
    $_SESSION['csrf_token'] = $token;
    return $token;
}



function checkToken($token){
    //セッションにワンタイムトークンがあるかどうか確認
    if(!isset($_SESSION['one_time_token']))return false;
    $s_token = $_SESSION['one_time_token'];

    //ワンタイムトークンセッションを初期化&消去する
    $_SESSION['one_time_token'] = '';
    unset($_SESSION['one_time_token']);

    //$tokenの値とセッションのトークンの値が一致するかどうかを確認
    //一致したらTRUE、それ以外ならFALSEを返す
    return (strcmp($token,$s_token) === 0);
}

function checkCsrfToken($token){
    //セッションにワンタイムトークンがあるかどうか確認
    if(!isset($_SESSION['csrf_token']))return false;
    $s_token = $_SESSION['csrf_token'];

    //ワンタイムトークンセッションを初期化&消去する
    $_SESSION['csrf_token'] = '';
    unset($_SESSION['csrf_token']);

    //$tokenの値とセッションのトークンの値が一致するかどうかを確認
    //一致したらTRUE、それ以外ならFALSEを返す
    return (strcmp($token,$s_token) === 0);
}


function get_token() {
    $TOKEN_LENGTH = 16;//16*2=32桁
    $bytes = openssl_random_pseudo_bytes($TOKEN_LENGTH);
    return bin2hex($bytes);
}



function filterPost(){
    $POST = array();
    foreach($_POST as $pk => $pv){
        if(!is_array($pv)){
            $POST[$pk] = filter_input(INPUT_POST,$pk,FILTER_DEFAULT );
            //             $POST[$pk] = filter_input(INPUT_POST,$pk,FILTER_SANITIZE_SPECIAL_CHARS );
        }else{
            $POST[$pk] = filter_input(INPUT_POST,$pk,FILTER_DEFAULT ,FILTER_REQUIRE_ARRAY);
            //             $POST[$pk] = filter_input(INPUT_POST,$pk,FILTER_SANITIZE_SPECIAL_CHARS ,FILTER_REQUIRE_ARRAY);
        }
    }
    return $POST;
}

function filterGet(){
    $GET = array();
    foreach($_GET as $gk => $gv){
        if(!is_array($gv)){
            $GET[$gk] = filter_input(INPUT_GET,$gk,FILTER_DEFAULT);
            //             $GET[$gk] = filter_input(INPUT_GET,$gk,FILTER_SANITIZE_SPECIAL_CHARS);

        }else{
            $GET[$gk] = filter_input(INPUT_GET,$gk,FILTER_DEFAULT, FILTER_REQUIRE_ARRAY);
            //             $GET[$gk] = filter_input(INPUT_GET,$gk,FILTER_SANITIZE_SPECIAL_CHARS,FILTER_REQUIRE_ARRAY);
        }
    }
    return $GET;
}

function checkMailAddressMulti($txt){
    $flg = true;

    // 改行コード \r、\n、\r\n の3種を区別せず配列化
    $arr = preg_split("/\R/", $txt);
    // 各要素の空白除去
    array_walk_recursive($arr, 'trim');
    // 文字列長が0の要素を除去
    $arr = array_filter($arr, 'strlen');
    // インデックスを振り直す
    $arr = array_merge($arr);

    foreach($arr as $aK => $aV){
        if(!validateMailAddress($aV)){
            $flg = false;
            break;
        }
    }

    return $flg;
}


function TrimNoticeMailList($txt){
    // 改行コード \r、\n、\r\n の3種を区別せず配列化
    $arr = preg_split("/\R/", $txt);
    // 各要素の空白除去
    array_walk_recursive($arr, 'trim');
    // 文字列長が0の要素を除去
    $arr = array_filter($arr, 'strlen');
    // インデックスを振り直す
    $arr = array_merge($arr);
    return $arr;
}


function validateMailAddress($mail){
    $pattern = "/^[a-zA-Z0-9.!#$%&'*+\/=?^_`{|}~-]+@[a-zA-Z0-9-]+(?:\.[a-zA-Z0-9-]+)*$/";
    return preg_match($pattern, $mail );
}


function func_multisort($arr, $tkey, $sort){


    // foreachで1つずつ値を取り出す
    foreach ($arr as $key => $value) {
        $id[$key] = $value[$tkey];
    }

    // array_multisortで'id'の列を昇順に並び替える
    array_multisort($id, $sort, $arr);

    return $arr;
}

function getHashMaxKey($hash,$keyName){
    $maxNumber = 0;
    $maxKey = 0;
    for ($i = 0, $len = count($hash); $i < $len; $i++) {
        if (!$hash[$i][$keyName]) continue;

        if ($hash[$i][$keyName] > $maxNumber) {
            $maxNumber = $hash[$i][$keyName];
            $maxKey = $i;
        }
    }
    return $maxKey;
}

function getHashKey($hash, $keyName, $value){

    $getKey = False;
    for ($i = 0, $len = count($hash); $i < $len; $i++) {
        if (!$hash[$i][$keyName]) continue;
//         var_dump($hash[$i][$keyName], '---', $value);
        if ($hash[$i][$keyName] === $value) {
            $getKey = $i;
        }
    }
    return $getKey;
}

function getHashKeyForeach($hash, $keyName, $value){

    $getKey = False;
    foreach($hash as $hK => $hV){

        if (!$hV[$keyName]) continue;
        if ($hV[$keyName] === $value) {
            $getKey = $hK;
        }
    }
    return $getKey;
}

function GetWeatherForID($id){
    $weather = "none";
    switch(true){
        case preg_match('/^(800)$/', $id):
            $weather = 'sunny';
            break;
        case preg_match('/^(80)[1-9]{1}$/', $id):
            $weather = 'cloudy';
            break;
        case preg_match('/^(3)[0-9]{2}$/', $id):
        case preg_match('/^(7)[0-9]{2}$/', $id):
            //$weather = 'misty';
            $weather = 'cloudy';
            break;
        case preg_match('/^(6)[0-9]{2}$/', $id):
            $weather = 'snowy';
            break;
        case preg_match('/^(5)[0-9]{2}$/', $id):
        case preg_match('/^(2)[0-9]{2}$/', $id):
            $weather = 'rainy';
            break;
    }
    return $weather;
}

function GetMsgEncode($msg){
    return urlencode(base64_encode($msg));
}

function GetMsgEncodeNotUrlEnc($msg){
    return base64_encode($msg);
}
function GetMsgDecode($encmsg){
    return base64_decode($encmsg);
}

function GetDeviceTypeListForName(){
    $list = [
        DEVICE_TYPE_CAMERA => 'カメラ',
        DEVICE_TYPE_LIGHT => '照明',
        DEVICE_TYPE_AIRCON_DCU => 'DCU',
        DEVICE_TYPE_AIRCON_AHU => 'AHU',
        DEVICE_TYPE_AIRCON_FCU => 'FCU',
        DEVICE_TYPE_AIRCON_OHU => 'OHU',
    ];
    return $list;
}


function generateCode($length = 4)
{
    $max = pow(10, $length) - 1;                    // コードの最大値算出
    $rand = random_int(0, $max);                    // 乱数生成
    $code = sprintf('%0'. $length. 'd', $rand);     // 乱数の頭0埋め

    return $code;
}

function sendGmail($client, $info) {
    $data = "";
    $data .= "From:".$info['from_addr']."\n";
    $data .= "To:".$info['email']."\n";
    $subject = mb_convert_encoding( $info['subject'], "JIS", "UTF-8" );
    $subject = "Subject: =?ISO-2022-JP?B?" . base64_encode($subject) . "?=";
    $data .= $subject."\n";
    $data .= "\n"; // ヘッダーと本文を区切る空行
    $data .= $info['body'];
    try {
        $data = GetMsgEncodeNotUrlEnc($data); //base64エンコード
        $service = new Google_Service_Gmail($client);
        $msg = new Google_Service_Gmail_Message();
        $msg->setRaw($data);
        $result = $service->users_messages->send('me', $msg);

    } catch (Exception $e) {
        $Err = json_decode($e->getMessage());

        http_response_code($Err->error->code);
        $result = $Err;
    }
    return $result;
}

function base64url_encode($data) {
    return rtrim(strtr(base64_encode($data), '+/', '-_'), '=');
}

function base64url_decode($data) {
    return base64_decode(str_pad(strtr($data, '-_', '+/'), strlen($data) % 4, '=', STR_PAD_RIGHT));
}

/**
* HalexAPI(DX-Core経由)から取得した天気コードから天気種別を判別.
*
* @param int $code 天気コード
* @return string 天気情報
*/
function GetHalexWeatherForCode($code){
    $weather = "none";
    switch(true){
        case preg_match('/^(1)[0-9]{2}$/', $code):
            $weather = 'sunny';
            break;
        case preg_match('/^(2)[0-9]{2}$/', $code):
            $weather = 'cloudy';
            break;
        case preg_match('/^(4)[0-5][0-9]$/', $code):
            $weather = 'snowy';
            break;
        case preg_match('/^(3)[4,6-7][0-9]$/', $code):
            $weather = 'snowy';
            break;
        case preg_match('/^(3)[0-2,5][0-9]$/', $code):
            $weather = 'rainy';
            break;
        case preg_match('/^(5)[0]{2}$/', $code):
            $weather = 'snowy';
            break;
        }
    return $weather;
}
?>
