<?
require_once(__DIR__."/../util/utils.php");

// JavaScriptの実行を許可する対象
$header_param_arr['default-src'] = array(
    '\'self\'',
    '\'unsafe-inline\'',
    '*.googleapis.com',
    '*.shimz.co.jp',
    '*.fontawesome.com',
    '*.bootstrapcdn.com',
    '*.datatables.net',
    '*.cloudflare.com',
    'maps.google.com',
    'maps.gstatic.com',
    'fonts.gstatic.com',
    'community-open-weather-map.p.rapidapi.com',
);
$header_param_arr['script-src'] = array(
    '\'self\'',
    '\'unsafe-inline\'',
    'ajax.googleapis.com',
    'code.jquery.com',
    'maxcdn.bootstrapcdn.com',
    'use.fontawesome.com',
    'cdnjs.cloudflare.com',
    'cdn.datatables.net',
    'maps.google.com',
    'maps.googleapis.com',
    'maps.gstatic.com',
    'csi.gstatic.com',
    'cdn.rawgit.com',
    'community-open-weather-map.p.rapidapi.com',
);
$header_param_arr['img-src'] = array(
    '\'self\'',
    '\'unsafe-inline\'',
    'csi.gstatic.com',
    'maps.gstatic.com',
    'maps.google.com',
    'maps.googleapis.com',
    'cdn.datatables.net',
    'community-open-weather-map.p.rapidapi.com',
    'data:',
);

$set_headers = "";
$hcount = count($header_param_arr);
$hi = 1;
foreach ($header_param_arr as $hK => $hV) {
    $set_headers .= $hK." ".implode(' ',$hV);
    if($hi < $hcount)$set_headers .= "; ";
    ++$hi;
}

header("Content-Security-Policy: ".$set_headers);


// XSS攻撃を検知させる（検知したら実行させない）。
header("X-XSS-Protection: 1; mode=block");

// IEにコンテンツの内容を解析させない（ファイルの内容からファイルの種類を決定させない）。
header("X-Content-Type-Options: nosniff");

// IEでダウンロードしたファイルを直接開かせない。
header("X-Download-Options: noopen");

// このページを iframe に埋め込ませない
header("X-Frame-Options: SAMEORIGIN");

$secure = '';
if ($_SERVER['HTTPS'] != '') { // HTTPSアクセスの場合
  // このサイトへのアクセスを HTTPS に制限する
    header("Strict-Transport-Security: max-age=31536000; includeSubDomains");
    $secure = TRUE;
}

header("Cache-Control: no-cache");
header("Pragma: no-cache");

/* セッション確認 */

$lifetime = time()+0;
$path = '/';
$domain = '';
$httponly = TRUE;
$sc = session_set_cookie_params($lifetime,$path,$domain,$secure,$httponly);

session_start();
session_regenerate_id();
// session_cache_limiter('private');
// $sc = setcookie(session_name(),session_id(),time()+$lifetime, "/", "", "", TRUE);

$flag = 0;

if(!isset($_SESSION['login']['user_id'])){ $flag++;}
if(!isset($_SESSION['login']['name'])){ $flag++;}
if(!isset($_SESSION['login']['tenant_id'])){ $flag++;}
if(!isset($_SESSION['login']['build'])){ $flag++;}
// if(!isset($_SESSION['auth_code'])) { $flag++;}
// if(!isset($_SESSION['login_count'])){ $flag++;}

// $ini = parse_ini_file(SRC_DB_INIPATH.'parse_ini_file.ini',FALSE);
// $magic_code = $ini['user_magic_code'];
// $auth = md5( $magic_code . $_SESSION['user_id'] );

// if(strcmp($auth,$_SESSION['auth_code']) !== 0){ $flag++;}


if($flag != 0){
    if(1 < $flag){
        $mes = GetMsgEncode('セッション期限が切れました。');
    }

    $_SESSION['login'] = array();
    session_destroy();
    $log->info("Session timeout.", array('file' => __FILE__, 'message' => 'セッション期限が切れました。'));
    header( 'Location: login.php?m='.$mes.'&err&tid='.$_ENV["SITE_NAME"].'' );
    exit;
}

?>
