<?php

require("core/construct.php");
require("core/functions.php");

require_once("model/model.php");
$MDL = new sappModel($sdb, $link);

$POST = filterPost();

try{
    if(!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest') {
        // Ajaxではない
        $ret = [
            'state' => 'error',
            'msg' => 'not ajax',
        ];
        throw new Exception('not ajax');

    }

    $w_setting = $POST['w_setting'];
    //TODO ウィジェット設定の中身のエスケープ処理が必須


    $u_id = $POST['u_id'];
    if(is_null($w_setting) || is_null($u_id)){
        // 必須パラメータ不足
        throw new Exception('invalid parameter');
    }


    $t = new Datetime();
    $prm = [
        'user_id' => $u_id,
        'flag_json' => json_encode($w_setting),
        'last-update' => $t->format("Y-m-d H:i:s")
    ];


    //ウィジェット管理テーブルを更新
    $uw_row = $MDL->GetUserWidgetControl($u_id);

    if($uw_row){
        //上書き
        $up_ret = $MDL->UpdateUserWidgetControl($prm);
        if(!$up_ret) throw new Exception('failed upload data');
    }else{
        //新規登録
        $ins_ret = $MDL->InsertUserWidgetControl($prm);
        if(!$ins_ret) throw new Exception('failed regist data');
    }



    $ret = [
        'state' => 'success',
    ];

    header('Content-Type: application/json; charset=utf-8', true);
    // $ret = array(1 => );
    echo json_encode($ret);

}catch( Exception $e){

    $ret = [
        'state' => 'error',
        'msg' => $e->getMessage(),
    ];

    header('Content-Type: application/json; charset=utf-8', true);
    echo json_encode($ret);
}

?>