<?

require("core/basic.php");
require("core/construct.php");
require("core/functions.php");

require_once(MDL_PATH."model.php");
$sapMDL = new sappModel($sdb, $link);

require_once(__DIR__."/util/utils.php");

// セッション初期化

session_destroy();
$_SESSION['login'] = array();
session_start();

$GET = filterGet();
$POST = filterPost();

createCsrfToken();

//TODO テナント判定
$isLogin = True;
if($GET['tid']){

    //TODO ビル存在チェック
    $build = $GET['tid'];//TODO メブクス豊洲のみ許容
    if($build !== $_ENV["SITE_NAME"]){
        header("HTTP/1.1 404 Not Found");
        exit;
    }

    //TODO 自動ログイン処理
    //トークンがセットされていたらリダイレクト
    if (isset($_COOKIE['cookie_token'])) {
        header("HTTP/1.1 301 Moved Permanently");
        header("Location: logincheck.php?tid=".$build);
        exit;
    }

}else{
    $isLogin = False;
}

if($GET['m']){
    $mes = GetMsgDecode($GET['m']);
}


$msg_stt = (isset($GET['err']))? "danger" : "success";
$message_tag = ($mes != '')?'<div class="alert alert-'.$msg_stt.'" role="alert">'.$mes.'</div>':'';

$page_title = "ログイン";
include(PARTS_PATH."header_nologin.php");
?>
    <body>
        <? if($isLogin): ?>
            <style>
            body{
                background: url('<?=ASSET_IMG ?>/build/<?=$build ?>/background.png');
                background-attachment: fixed;
                background-size: cover;
                background-position: center center;
            }
            .btn.btn-primary.tenant_color{
                background: #09729c;
                border: none;
            }
            </style>
        <? endif; ?>
        <div id="Wrap">
            <div class="container-fluid login-wrap" >

                <div class="container">

                    <div class="row">
                    <? if($isLogin): ?>
                        <div id="Login" class="col-12 col-sm-6 offset-sm-3">
                            <div id="LoginFormIcon" class="svg-wrap">
                                <svg class="img-fluid wh75px mb10">
                                    <use xlink:href="./asset/img/key.svg#Key"></use>
                                </svg>
                                <p>ログイン</p>
                            </div>
                            <form action="logincheck.php?tid=<?=$build ?>" method="POST">
                                <?=$message_tag ?>
                                <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($_SESSION['csrf_token'], ENT_QUOTES, "UTF-8") ?>">
                                <div class="form-group">
                                    <input class="form-control" type="text" name="login_id" id="" placeholder="ログインID"/>
                                </div>

                                <div class="form-group">
                                    <input class="form-control" type="password" name="password" id="" placeholder="パスワード"/>
                                </div>

                                <div class="form-group form-check">
                                    <label for="AutoLoginCheck">
                                        <input type="checkbox" class="form-check-input" id="AutoLoginCheck" name="auto_login">
                                        <small>次回からログインID、パスワードの入力を省略する</small>
                                    </label>

                                </div>


                                <div class="">

                                    <button type="submit" class="btn btn-primary tenant_color w100">ログイン</button>
                                </div>

                            </form>
                        </div>
                        <div id="RemindPass" class="col-12 col-lg-6 offset-lg-3">
                            <a data-toggle="modal" data-target="#modal-passwordremain">パスワードを忘れてしまった方はこちら</a>
                        </div>

                    <? else: ?>
                        <div id="NotSetTenant">
                            <div class="notset-tenannt-inner">
                                ビル専用のURLよりアクセスしてください。
                            </div>
                        </div>
                    <? endif; ?>


                    </div>
                </div>
            </div>
        <? include(PARTS_PATH.'/footer_nologin.php'); ?>
        </div>
    </body>
    <!-- /container -->


<!-- Modal -->
<div class="modal fade menu_setting" id="modal-passwordremain" tabindex="-1" role="dialog" aria-labelledby="exampleModalLongTitle" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLongTitle">パスワードを忘れてしまった場合</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <div class="wh20px svg-wrap" style="color: #000;">
                        <span aria-hidden="true" class="svg-wrap">
                            <svg class="img-fluid" style="height: 20px;">
                                <use xlink:href="./asset/img/return.svg#Return"></use>
                            </svg>
                        </span>
                    </div>
                </button>
        </div>
        <div class="modal-body">
            <div class="password-remain-wrap">

                <div class="alert alert-success alert-sm" role="alert">パスワードを忘れてしまった場合は、下記フォームにユーザーIDとパスワード再発行申請メールを送信するメールアドレスを入力してください。</div>
                <form action="./password_sendmail.php?tid=<?=$build ?>" method="POST">

                    <div class="form-group">
    <!--                    <label for="">ユーザーID</label> -->
                        <input type="text" name="user_id" class="form-control" placeholder="ユーザーID" required/>
                    </div>

                    <div class="form-group">
    <!--                    <label for="">認証用メールアドレス</label> -->
                        <input type="text" name="email" class="form-control" placeholder="認証用メールアドレス" required/>
                    </div>
                    <div class="mt30">
                        <button class="btn btn-primary w100">送信する</button>
                    </div>
                </form>
            </div>

        </div>
        </div>
    </div>
</div>

    <!-- jQuery -->
    <script src="<?=ASSET_JS ?>jquery.js"></script>

</html>

<?

//初期画面描画完了ログ
$log->info('Initial display.',
    array(
        'file' => __FILE__,
        'display' => 'Login'
    )
);

?>