<?php
//パラメーター取得

session_start();
require("core/construct.php");
require("core/functions.php");
require("util/utils.php");

require_once(MDL_PATH."model.php");
$MDL = new sappModel($sdb, $link);

$GET = filterGet();
$POST = filterPost();

$cookie_token = $_COOKIE['cookie_token'];
$auto = ($POST['auto_login'] == 'on')?TRUE:FALSE;
$csrf_token = $POST['csrf_token'];

//CSRF チェック
if (empty($cookie_token) && $csrf_token != $_SESSION['csrf_token']) {
    $_SESSION = array();
    session_destroy();
    session_start();

    // リダイレクト
    header("HTTP/1.1 301 Moved Permanently");
    header("Location: login.php?tid=".$GET['tid']);
    exit;
}
//ログイン判定フラグ
$normal_result = False;
$auto_result = False;

try {

    //簡易ログイン
    if (empty($cookie_token)) {

        if(empty($POST['login_id']) || empty($POST['password'])) throw new Exception('ログインIDとパスワードを入力してください。');

        //         $options = [ 'cost' => 8, 'salt' =>  $user_magic_code];
        //         $setpass = password_hash($POST['password'], PASSWORD_DEFAULT);
        // ログイン処理

        //         $t_row = $MDL->GetTenantData($POST['tenant_id']);
        //         if(!$t_row) throw new Exception('テナントが存在しません。');

        //TODO テナントが一致していればログイン
        $u_row = $MDL->Login($POST['login_id']);
        if(!$u_row) throw new Exception('ユーザーが存在しません。');


        //パスワードチェック
        $ret = password_verify($POST['password'], $u_row['pass']);
        if(!$ret){
            $leuc_prm = [
                'user_id' => $u_row['user_id'],
                'error_count' => (int)++$u_row['error_count'],
            ];

            $leuc_ret = $MDL->LoginErrorUpdateCount($leuc_prm);
            throw new Exception('入力されたパスワードに誤りがあります。');
        }else{

            //ロック中のアカウントかどうか確認
            if((int)$u_row['status'] == ACCOUNT_STATUS_LOCK) throw new Exception('このユーザーはロックされています。');

            //TODO エラー回数超過チェック（必要であれば）
            if((int)$u_row['error_count'] >= LOGIN_ERROR_LIMIT){
                $leus_prm = [
                    'user_id' => $u_row['user_id'],
                    'status' => 0,
                ];

                $leus_ret = $MDL->LoginErrorUpdateStatus($leus_prm);
                throw new Exception('ログインエラー回数が制限を超えたため、アカウントがロックされています。');
            }
        }


        session_start();
        session_regenerate_id();

        $_SESSION['login']['user_id'] = $u_row['user_id'];
        $_SESSION['login']['name'] = $u_row['name'];
        $_SESSION['login']['tenant_id'] = $u_row['tenant_id'];
        $_SESSION['login']['build'] = $GET['tid'];

        //ウィジェット利用状態
        $uw_row = $MDL->GetUserWidgetControl($u_row['user_id']);
        if($uw_row){
            $_SESSION['login']['widget'] = json_decode($uw_row['flag_json']);
        }else{
            $wd_row = $MDL->GetWidgetList();
            if($wd_row){
                $widget = [];
                foreach($wd_row as $wdK => $wdV){
                    $widget[$wdK+1] = [
                        'num' => $wdV['num'],
                        'flag' => '1',
                    ];
                }
            }
            $_SESSION['login']['widget'] = $widget;
        }

        $ll = new Datetime();
        $prm = [
            'user_id' => $u_row['user_id'],
            'login_count' => (int)++$u_row['login_count'],
            'last_login' => $ll->format("Y-m-d H:i:s"),
        ];
        $up_ret = $MDL->LoginSuccess($prm);

        //ログイン成功時ログ
        $log->info('Login successfully.',
            array(
                'file' => __FILE__,
                'userId' => $u_row['user_id']
            )
        ); 

        if($up_ret) $normal_result = TRUE;
    }

    //自動ログイン
    if (!empty($cookie_token) ) {
        $achk_ret = $MDL->CheckAutoLogin($cookie_token);
        if($achk_ret){

            session_start();
            session_regenerate_id();

            //ユーザー情報取得
            $u_row = $MDL->GetUserInfo($achk_ret['user_id']);
            if(!$u_row) throw new Exception('ユーザーが存在しません。');

            $_SESSION['login']['user_id'] = $u_row['user_id'];
            $_SESSION['login']['name'] = $u_row['name'];
            $_SESSION['login']['tenant_id'] = $u_row['tenant_id'];
            $_SESSION['login']['build'] = $GET['tid'];

            $auto_result = TRUE;
            $id = $_SESSION['login']['user_id']; // 後続の処理のため格納
        }
    }


    //トークン生成処理
    if (($normal_result && $auto == true) || $auto_result) {
        //トークンの作成
        $token = get_token();
        //トークンの登録
        $t = new Datetime();
        $prm = [
            'user_id' => $_SESSION['login']['user_id'],
            'token' => $token,
            'registrated_time' => $t->format("Y-m-d H:i:s"),
        ];
        $ins_ret = $MDL->RegistAutoLoginToken($prm);
        //         register_token($id, $token, $pdo);
        //自動ログインのトークンを２週間の有効期限でCookieにセット

//         setcookie("cookie_token", $token, time()+60*60*24*14, "/"); // secure, httponly
//         $ck_ret = setcookie("cookie_token", $token, time()+60*60*24*14, "/", "", "", TRUE); // secure, httponly
        $ck_ret = setcookie("cookie_token", $token, time()+60*60*24*14, "/", "", "", TRUE); // secure, httponly
//         var_dump($_COOKIE['cookie_token']);exit;
        if(!$ck_ret || !isset($_COOKIE['cookie_token'])) throw new Exception('自動ログインが有効になりませんでした。');


        if ($auto_result) {
            //古いトークンの削除
            $del_prm = [
                'token' => $cookie_token
            ];
            $del_ret = $MDL->DeleteAutoLoginToken($del_prm);
            //             delete_old_token($cookie_token, $pdo);
        }

        // リダイレクト
        header( 'Location: top.php');
        exit;

    } else if ($normal_result) {
        // リダイレクト
        header( 'Location: top.php');
        exit;
    } else {
        // リダイレクト
        header("HTTP/1.1 301 Moved Permanently");
        header("Location: login.php?tid=".$GET['tid']);
        exit;
    }
} catch (Exception $e) {
    $mes = GetMsgEncode($e->getMessage());

    //ログイン失敗時ログ
    $log->info($e);
    $log->info('Login failed.',
        array(
            'file' => __FILE__,
            'userId' => $POST['login_id'],
            'message' => $e->getMessage()
        )
    );

    header( 'Location: login.php?m='.$mes.'&err&tid='.$GET['tid']);
    exit;
}
