<?

require_once 'database.php';

class sappModel{
    private $DB;
    private $Link;
    public function __construct($DB, $Link){
        $this->DB = $DB;
        $this->Link = $Link;
    }


    /**
     * ログインチェック
     * Login
     */
    public function Login($uid) {
        try {
            global $log;

            $sql = sprintf("SELECT * FROM `UserTbl` WHERE `user_id` = '%s'",
                $this->model_sql_esc($uid));
//             $sql = sprintf("SELECT * FROM `UserTbl` WHERE `user_id` = '%s' AND `tenant_id` = '%s'",
//                 $this->model_sql_esc($uid),
//                 $this->model_sql_esc($tid));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $row = mysqli_fetch_assoc( $result );
            //             $count = mysqli_num_rows($result);

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from UserTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserTbl', 'parameter' => $uid, 'message' => $e->getMessage()));
        }

        return $row;
    }


    /**
     * ログイン失敗時　一定数以上ログインエラー
     * 入力項目をユーザーIDからメールアドレスへ変更
     */
    public function LoginErrorUpdateStatus($prm) {
        try {
            global $log;

            $sql = sprintf("UPDATE `UserTbl` SET `status` = %d WHERE `user_id` = '%s'",
                $this->model_sql_esc($prm['status']),
                $this->model_sql_esc($prm['user_id']));

            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to update login error info.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }

    /**
     * ログイン失敗時、エラーカウント増加
     */
    public function LoginErrorUpdateCount($prm) {
        try {
            global $log;
            $sql = sprintf("UPDATE `UserTbl` SET `error_count` = %d WHERE `user_id` = '%s'",
                $this->model_sql_esc($prm['error_count']),
                $this->model_sql_esc($prm['user_id']));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to update login error info.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * ログイン成功時
     */
    public function LoginSuccess($prm) {
        try {
            global $log;
            $sql = sprintf("UPDATE `UserTbl` SET `error_count`=0, `login_count`=%d, `last_login`='%s' WHERE `user_id`='%s'",
                $this->model_sql_esc($prm['login_count']),
                $this->model_sql_esc($prm['last_login']),
                $this->model_sql_esc($prm['user_id']));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to update login info.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }



    /**
     * ユーザー一覧取得
     */
    public function GetUserList() {
        try {
            global $log;

            $sql = "SELECT *  FROM `UserTbl`";
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from UserTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserTbl', 'message' => $e->getMessage()));
        }

        return $rows;
    }

    /**
     * メールアドレスが一致するユーザー一覧取得
     */
    public function GetUserEmailList($email) {
        try {
            global $log;
            $sql = sprintf("SELECT * FROM `UserTbl` WHERE uuid = '%s'",
                $this->model_sql_esc($email));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );
        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from UserTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserTbl', 'parameter' => $email, 'message' => $e->getMessage()));
        }
        return $rows;
    }

    /**
     * ユーザー情報取得
     */
    public function GetUserInfo($uid) {
        try {
            global $log;

            $sql = sprintf("SELECT UT.*, TT.`name` AS `tenant_name` FROM `UserTbl` UT INNER JOIN `TenantTbl` TT
                ON UT.`tenant_id` = TT.`id` WHERE UT.`user_id` = '%s'",
                $this->model_sql_esc($uid));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $row = mysqli_fetch_assoc( $result );
            //             $count = mysqli_num_rows($result);

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from UserTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserTbl', 'parameter' => $uid, 'message' => $e->getMessage()));
        }

        return $row;
    }

    /**
     * ユーザー情報取得
     */
    public function CheckAutoLogin($c_token) {
        try {
            global $log;

            $sql = sprintf("SELECT *  FROM `AutoLoginTbl` WHERE `token` = '%s'",
                $this->model_sql_esc($c_token));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $row = mysqli_fetch_assoc( $result );
            //             $count = mysqli_num_rows($result);

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from AutoLoginTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'AutoLoginTbl', 'parameter' => $c_token, 'message' => $e->getMessage()));
        }

        return $row;
    }


    /**
     * ログイントークン登録
     */
    public function RegistAutoLoginToken($prm) {
        try {
            global $log;
            $sql = sprintf("INSERT INTO `AutoLoginTbl` (`num`, `user_id`, `token`, `registrated_time`) VALUES (NULL,'%s','%s','%s')",
                $this->model_sql_esc($prm['user_id']),
                $this->model_sql_esc($prm['token']),
                $this->model_sql_esc($prm['registrated_time']));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed register login token.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'AutoLoginTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * 過去トークン削除
     */
    public function DeleteAutoLoginToken($prm) {
        try {
            global $log;
            $sql = sprintf("DELETE FROM `AutoLoginTbl` WHERE `token` = '%s'",
                $this->model_sql_esc($prm['token']));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to delete auto login token.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'AutoLoginTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * ウィジェット情報取得
     */
    public function GetWidgetList() {
        try {
            global $log;

            $sql = "SELECT * FROM `WidgetTbl`";
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from WidgetTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'WidgetTbl', 'message' => $e->getMessage()));
        }

        return $rows;
    }


    /**
     * GetWidgetDataForID
     * ウィジェット利用情報取得（ユーザーID）
     */
    public function GetWidgetDataForID($w_id) {
        try {
            global $log;

            $sql = sprintf("SELECT * FROM `WidgetTbl` WHERE `widget_id` = '%s'",
                $this->model_sql_esc($w_id));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $row = mysqli_fetch_assoc( $result );
            //             $count = mysqli_num_rows($result);

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from WidgetTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'WidgetTbl', 'parameter' => $w_id, 'message' => $e->getMessage()));
        }

        return $row;
    }


    /**
     * ウィジェット利用情報取得
     */
    public function GetUserWidgetControl($u_id) {
        try {
            global $log;

            $sql = sprintf("SELECT *  FROM `UserWidgetControl` WHERE `user_id` = '%s'",
                $this->model_sql_esc($u_id));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $row = mysqli_fetch_assoc( $result );
            //             $count = mysqli_num_rows($result);

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from UserWidgetControl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserWidgetControl', 'parameter' => $u_id, 'message' => $e->getMessage()));
        }

        return $row;
    }


    /**
     * ウィジェット管理データ登録
     */
    public function InsertUserWidgetControl($prm) {
        try {
            global $log;
            $sql = sprintf("INSERT INTO `UserWidgetControl` (`num`, `user_id`, `flag_json`, `last-update`) VALUES (NULL,'%s','%s','%s')",
                $this->model_sql_esc($prm['user_id']),
                $this->model_sql_esc($prm['flag_json']),
                $this->model_sql_esc($prm['last-update']));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed register widget control data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserWidgetControl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * ウィジェット管理データ更新
     */
    public function UpdateUserWidgetControl($prm) {
        try {
            global $log;
            $sql = sprintf("UPDATE `UserWidgetControl` SET `flag_json` = '%s', `last-update` = '%s'  WHERE `user_id` = '%s'",
                $this->model_sql_esc($prm['flag_json']),
                $this->model_sql_esc($prm['last-update']),
                $this->model_sql_esc($prm['user_id']));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from UserWidgetControl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'AdminTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * ウィジェット設定削除
     */
    public function DeleteUserWidgetControl($uid) {
        try {
            global $log;
            $sql = sprintf("DELETE FROM `UserWidgetControl` WHERE `user_id` = '%s'",
                $this->model_sql_esc($uid));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to delete widget data.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserWidgetControl', 'parameter' => $uid, 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * テナント一覧取得
     */
    public function GetTenantList() {
        try {
            global $log;

            $sql = "SELECT *  FROM `TenantTbl`";
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from TenantTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'TenantTbl', 'message' => $e->getMessage()));
        }

        return $rows;
    }


    /**
     * テナント情報取得
     * @テナントID
     */
    public function GetTenantData($tid) {
        try {
            global $log;

            $sql = sprintf("SELECT *  FROM `TenantTbl` WHERE `id` = '%s'",
                $this->model_sql_esc($tid));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $row = mysqli_fetch_assoc( $result );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from TenantTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'TenantTbl', 'parameter' => $tid, 'message' => $e->getMessage()));
        }

        return $row;
    }


    /**
     * ユーザー情報パスワードデータ更新
     */
    public function UpdateLoginPassword($prm) {
        try {
            global $log;
            $sql = sprintf("UPDATE `UserTbl` SET `pass` = '%s' WHERE `user_id` = '%s'",
                $this->model_sql_esc($prm['password']),
                $this->model_sql_esc($prm['user_id']));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from UserTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'UserTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }

        return $result;
    }


    /**
     * 設備リストの必要な情報取得
     */
    public function GetDeviceFunctionTbl() {
        try {
            global $log;
            $sql = "SELECT * FROM `DeviceFunctionTbl` WHERE visibility = 1";
            // "SELECT * FROM `DeviceFunctionTbl` FOR JSON"
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );
            // $row = mysqli_fetch_assoc( $result );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from DeviceFunctionTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'DeviceFunctionTbl', 'message' => $e->getMessage()));
        }

        return $rows;
    }


    /**
     * 設備リストの必要な情報取得(重複削除)
     */
    public function GetOnlyFunctionTbl() {
        try {
            global $log;
            $sql = "SELECT DISTINCT device_function, device_type, value_type, description, device_values, step_value, visibility, unit FROM `DeviceFunctionTbl` WHERE visibility = 1";
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );
        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from DeviceFunctionTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'DeviceFunctionTbl', 'message' => $e->getMessage()));
        }

        return $rows;
    }


    /**
     * 設備リストの必要な情報取得(重複削除)
     */
    public function GetFunctionDeviceType($device_type) {
        try {
            global $log;
            $sql = sprintf("SELECT * FROM `DeviceFunctionTbl` WHERE device_type = '%s' AND visibility = 1",
            $this->model_sql_esc($device_type));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from DeviceFunctionTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'DeviceFunctionTbl', 'parameter' => $device_type, 'message' => $e->getMessage()));
        }
        return $rows;
    }


    /**
     * 警報リストの必要な情報取得
     */
    public function GetAlarmDeviceType($device_type) {
        try {
            global $log;
            $sql = sprintf("SELECT * FROM `DeviceFunctionTbl` WHERE alarm_type IS NOT NULL AND visibility = 1",
            $this->model_sql_esc($device_type));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from DeviceFunctionTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'DeviceFunctionTbl', 'parameter' => $device_type, 'message' => $e->getMessage()));
        }
        return $rows;
    }


    /**
     * 警報リスト情報取得
     */
    public function GetAlarmInfoDevice() {
        try {
            global $log;
            $sql = "SELECT * FROM `DeviceAlarmTbl`";
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );

        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from DeviceAlarmTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'DeviceAlarmTbl', 'message' => $e->getMessage()));
        }
        return $rows;
    }


    /**
     * お知らせ通知情報追加(ユーザーごと)
     * $prm = [
     *    'user_id' => 'mebks',
     *     'function' => 'ナンバープレート登録',
     *     'title' => 'ナンバープレート登録完了',
     *     'description' => '来訪者会社名:あいうえおカンパニー\n来訪者氏名:佐藤太郎\n車種:小型乗用車\n車両ナンバー:1842\n検知期間:3日\n備考:なし',
     *     'datetime' => '2022-07-28 14:59:56',
     * ];
     */
    public function InsertNotificationInfo($prm) {
        try {
            global $log;
            $sql = sprintf("INSERT INTO `NotificationTbl` (`id`, `user_id`, `title`, `description`, `datetime`,`daletetime`,`tenant_id`) VALUES (NULL,'%s','%s','%s','%s','%s','%s')",
                $this->model_sql_esc($prm['user_id']),
                $this->model_sql_esc($prm['title']),
                $this->model_sql_esc($prm['description']),
                $this->model_sql_esc($prm['datetime']),
                $this->model_sql_esc($prm['daletetime']),
                $this->model_sql_esc($prm['tenant_id']),);
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
    } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed register notification info.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'NotificationTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }
        return $result;
    }


    /**
     * お知らせ通知情報追加(全ユーザー)
     * idとuser_id以外を含んだ配列
     * $prm = [
     *     'function' => 'ナンバープレート登録',
     *     'title' => 'ナンバープレート登録完了',
     *     'description' => '来訪者会社名:あいうえおカンパニー\n来訪者氏名:佐藤太郎\n車種:小型乗用車\n車両ナンバー:1842\n検知期間:3日\n備考:なし',
     *     'datetime' => '2022-07-28 14:59:56',
     */
    public function InsertAllUserNotificationInfo($prm) {
        try {
            global $log;
            // UserListを取得
            $userlist = $this->GetUserList();
            foreach($userlist as $ulK => $ulV){
                $sql = sprintf("INSERT INTO `NotificationTbl` (`id`, `user_id`, `function`, `title`, `description`, `datetime`) VALUES (NULL,'%s','%s','%s','%s','%s')",
                    $this->model_sql_esc($ulV['user_id']),
                    $this->model_sql_esc($prm['function']),
                    $this->model_sql_esc($prm['title']),
                    $this->model_sql_esc($prm['description']),
                    $this->model_sql_esc($prm['datetime']));
                $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            }
    } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed register all user notification info.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'NotificationTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }
        return $result;
    }


    /**
     * お知らせ通知情報取得
     */
    public function GetNotificationInfo($user_id) {
        try {
            global $log;
            $sql = sprintf("SELECT * FROM `NotificationTbl` WHERE `user_id` = '%s'",
                $this->model_sql_esc($user_id));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );
        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from NotificationTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'NotificationTbl', 'parameter' => $user_id, 'message' => $e->getMessage()));
        }
        return $rows;
    }


    /**
     * お知らせ通知情報削除
     */
    public function DeleteNotificationInfo($id) {
        try {
            global $log;
            $sql = sprintf("DELETE FROM `NotificationTbl` WHERE `id` = '%s'",
                $this->model_sql_esc($id));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to delete notification info.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'NotificationTbl', 'parameter' => $id, 'message' => $e->getMessage()));
        }
        return $result;
    }


    /**
     * ナンバープレートのお知らせ情報取得
     */
    public function GetNumberplateInfo($user_id) {
        try {
            global $log;
            $sql = sprintf("SELECT * FROM `NumberPlateNotificationTbl` WHERE `user_id` = '%s'",
                $this->model_sql_esc($user_id));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
            $rows = mysqli_fetch_all( $result, MYSQLI_ASSOC );
        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to get information from NumberPlateNotificationTbl.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'NumberPlateNotificationTbl', 'parameter' => $user_id, 'message' => $e->getMessage()));
        }
        return $rows;
    }


    /**
     * ナンバープレートのお知らせ情報削除
     */
    public function DeleteNumberplateInfo($id) {
        try {
            global $log;
            $sql = sprintf("DELETE FROM `NumberPlateNotificationTbl` WHERE `id` = '%s'",
                $this->model_sql_esc($id));
            $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
        } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed to delete number plate info.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'NumberPlateNotificationTbl', 'parameter' => $id, 'message' => $e->getMessage()));
        }
        return $result;
    }


    /**
     * ナンバープレートのお知らせ情報登録
     */
    public function InsertNumberplateInfo($prm) {
        try {
            global $log;
            $sql = sprintf("INSERT INTO `NumberPlateNotificationTbl` (`id`, `tenant_id`, `user_id`, `title` , `description`, `datetime`, `deletetime`) VALUES (NULL, '%s', '%s', '%s', '%s', '%s', '%s')",
                $this->model_sql_esc($prm['tenant_id']),
                $this->model_sql_esc($prm['user_id']),
                $this->model_sql_esc($prm['title']),
                $this->model_sql_esc($prm['description']),
                $this->model_sql_esc($prm['datetime']),
                $this->model_sql_esc($prm['deletetime']));
                $result = mysqli_query( $this->Link, $sql ) or $this->sql_error($_SERVER['PHP_SELF'],$sql,mysqli_error($link));
    } catch (Exception $e) {
            var_dump($e->getMessage());
            $log->error($e);
            $log->error('Failed register number plate info.', array('file' => ''.$e->getFile().' on line '.$e->getLine().'', 'table' => 'NumberPlateNotificationTbl', 'parameter' => $prm, 'message' => $e->getMessage()));
        }
        return $result;
    }


    private function model_sql_esc($str){
        return mysqli_real_escape_string($this->Link, $str);
    }

    public function sql_error($f,$sql,$code){
        global $log;
        $body = "SQLエラーが発生しました。\n発生したPHP=".$f."\nSQL=".$sql.$code;
        echo $body;
        $log->error($body, array('file' => __FILE__));
        exit;
    }
}
?>
