<?

require("core/construct.php");
require(CORE_PATH."basic.php");
require(CORE_PATH."functions.php");
require(CORE_PATH."session_check.php");
require_once(__DIR__ ."util/utils.php");

require_once(MDL_PATH."model.php");
$sapMDL = new sappModel($sdb, $link);


$GET = filterGet();
$POST = filterPost();

$user_id = $_SESSION['login']['user_id'];


try{

    $log->info('Starting password change.',
        array(
            'file' => __FILE__,
            'user_id' => $user_id
        )
    );

    if(isset($POST['one_time_token'])){
        if(!checkToken($POST['one_time_token'])) throw new Exception("不正な操作が実行されました。");
    }

    //現在のパスワードと一致するかどうか
    if(trim($POST['old_pass']) === "") throw new Exception("旧パスワードを入力してください。");

    $u_row = $sapMDL->GetUserInfo($user_id);
    if(!$u_row) throw new Exception("指定されたユーザーは存在しません。");

    //旧パスワード一致チェック
    $ret = password_verify($POST['old_pass'], $u_row['pass']);
    if(!$ret) throw new Exception('旧パスワードが正しくありません。');

    if(trim($POST['new_pass']) === "") throw new Exception("設定するパスワードを入力してください。");
    if(strcmp($POST['new_pass'], $POST['conf_pass'])!= 0) throw new Exception("再入力されたパスワードが一致しません。");
    if(!preg_match('/^[a-zA-Z\\d\-\_]{8,20}$/', $POST['new_pass'])) throw new Exception("パスワードに使用できる文字は半角英数字（大文字小文字）と「-_」のみです。");


    $options = [ 'cost' => 8, 'salt' =>  $ini['user_magic_code']];
    $setpass = password_hash($POST['new_pass'], PASSWORD_DEFAULT);

    $prm = [
        'password' => $setpass,
        'user_id' => $user_id,
    ];

    // パスワード変更成功時ログ
    $log->info('Successful password change.',
        array(
            'file' => __FILE__,
            'user_id' => $user_id
        )
    );

    $up_ret = $sapMDL->UpdateLoginPassword($prm);
    if(!$up_ret) throw new Exception("パスワード再設定に失敗しました。");

    header( 'Location: top.php');
    exit;

}catch(Exception $e){
    $mes = GetMsgEncode($e->getMessage());

    // パスワード変更失敗時ログ
    $log->info($e);
    $log->info('Failed to password change.',
        array(
            'file' => __FILE__,
            'message' => $e->getMessage()
        )
    );

    header( 'Location: error.php?m='.$mes.'&tid='.$GET['tid']);
    exit;
}

?>