<?

require("core/construct.php");
require_once(__DIR__ ."util/utils.php");
require(CORE_PATH."basic.php");
require(CORE_PATH."functions.php");
require(CORE_PATH."session_check.php");
require_once(MDL_PATH."model.php");
$sapMDL = new sappModel($sdb, $link);


$GET = filterGet();
$POST = filterPost();

$user_id = $_SESSION['login']['user_id'];

if($GET['tid']){
    $build = $GET['tid'];
    $isLogin = True;
}else{
    $isLogin = False;
}

$log->info('Starting password reset reissue.',array('file' => __FILE__, 'user_id'=> $user_id));

try{
    if($GET['c']){
        switch($GET['c']){
            case 'reset':
                if(trim($POST['password']) === "") throw new Exception("設定するパスワードを入力してください。");
                if(strcmp($POST['password'], $POST['confpass'])!= 0) throw new Exception("再入力されたパスワードが一致しません。");

                $u_row = $sapMDL->GetUserInfo($user_id);
                if(!$u_row) throw new Exception("指定されたユーザーは存在しません。");

                $options = [ 'cost' => 8, 'salt' =>  $ini['user_magic_code']];
                $setpass = password_hash($POST['password'], PASSWORD_DEFAULT);

                $prm = [
                    'password' => $setpass,
                    'user_id' => $user_id,
                ];
                $up_ret = $sapMDL->UpdateLoginPassword($prm);
                if(!$up_ret) throw new Exception("パスワード再設定に失敗しました。");

                header( 'Location: top.php');
                exit;

                break;
        }
    }
}catch(Exception $e){
    $log->info($e);
    $log->info('Failed to password reset.', array('file' => __FILE__,'message' => $e->getMessage()));
    $mes = GetMsgEncode($e->getMessage());
    header( 'Location: password_reset.php?err&m='.$mes.'&tid='.$build);
    exit;
}

if($GET['m']){
    $mes = GetMsgDecode($GET['m']);
}
$page = "password_reset.php";

$msg_stt = (isset($GET['err']))? "danger" : "success";
$message_tag = ($mes != '')?'<div class="alert alert-'.$msg_stt.'" role="alert">'.$mes.'</div>':'';

$page_title = "パスワード再設定画面";

include(PARTS_PATH."header_nologin.php");
?>
    <body>
        <? if($isLogin): ?>
            <style>
            body{
                background: url('<?=ASSET_IMG ?>/tenant/<?=$build ?>/background.png');
                background-attachment: fixed;
                background-size: cover;
                background-position: center center;
            }
            </style>
        <? endif; ?>
        <div id="Wrap">
            <div class="container-fluid login-wrap" >
                <div class="container">
                    <div class="row">
                    <? if($isLogin): ?>
                        <div id="PasswordReset" class="col-12 col-lg-6 offset-lg-3">
                            <h3>パスワード再設定</h3>
                            <p>再設定するパスワードを入力してください。</p>
                            <?=$message_tag ?>
                            <form action="<?=$page ?>?c=reset&tid=<?=$build ?>" method="POST">

                            <input type="hidden" name="user_id" value="<?=$user_id ?>">

                            <div class="form-group">
                                <input class="form-control" type="password" name="password" id="" placeholder="設定するパスワード" required/>
                            </div>

                            <div class="form-group">
                                <input class="form-control" type="password" name="confpass" id="" placeholder="設定するパスワード（再入力）" required/>
                            </div>

                            <div class="">
                                <button type="submit" class="btn btn-primary tenant_color w100">パスワードを設定する</button>
                            </div>
                            </form>
                        </div>
                    <? else: ?>
                        <div id="NotSetTenant">
                            <div class="notset-tenannt-inner">
                                テナント専用のURLよりアクセスしてください。
                            </div>
                        </div>
                    <? endif; ?>
                    </div>
                </div>
            </div>
        <? include(PARTS_PATH.'/footer_nologin.php'); ?>
        </div>
    </body>
    <!-- /container -->


<!-- Modal -->
<div class="modal fade menu_setting" id="modal-passwordremain" tabindex="-1" role="dialog" aria-labelledby="exampleModalLongTitle" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">パスワードを忘れてしまった場合</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <div class="wh20px svg-wrap" style="color: #000;">
                        <span aria-hidden="true" class="svg-wrap">
                            <svg class="img-fluid" style="height: 20px;">
                                <use xlink:href="./asset/img/return.svg#Return"></use>
                            </svg>
                        </span>
                    </div>
                </button>
            </div>
            <div class="modal-body">
                <form action="./password_sendmail.php?tid=<?=$build ?>" method="POST">
                    <div class="form-group">
                        <label for="">ユーザーID</label>
                        <input type="text" name="user_id" class="form-control" placeholder="ユーザーID" />
                    </div>
                    <div>
                        <button class="btn btn-primary w100">送信する</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

    <!-- jQuery -->
    <script src="<?=ASSET_JS ?>jquery.js"></script>

</html>
<?
$log->info('Initial display.', array('file' => __FILE__, 'display' => 'Password Reset', 'user_id'=> $user_id));
?>
